/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_bn extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "\u099c\u09be\u09a8\u09c1\u09af\u09bc\u09be\u09b0\u09c0",
               "\u09ab\u09c7\u09ac\u09cd\u09b0\u09c1\u09af\u09bc\u09be\u09b0\u09c0",
               "\u09ae\u09be\u09b0\u09cd\u099a",
               "\u098f\u09aa\u09cd\u09b0\u09bf\u09b2",
               "\u09ae\u09c7",
               "\u099c\u09c1\u09a8",
               "\u099c\u09c1\u09b2\u09be\u0987",
               "\u0986\u0997\u09b8\u09cd\u099f",
               "\u09b8\u09c7\u09aa\u09cd\u099f\u09c7\u09ae\u09cd\u09ac\u09b0",
               "\u0985\u0995\u09cd\u099f\u09cb\u09ac\u09b0",
               "\u09a8\u09ad\u09c7\u09ae\u09cd\u09ac\u09b0",
               "\u09a1\u09bf\u09b8\u09c7\u09ae\u09cd\u09ac\u09b0",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "\u099c\u09be",
               "\u09ab\u09c7",
               "\u09ae\u09be",
               "\u098f",
               "\u09ae\u09c7",
               "\u099c\u09c1\u09a8",
               "\u099c\u09c1",
               "\u0986",
               "\u09b8\u09c7",
               "\u0985",
               "\u09a8",
               "\u09a1\u09bf",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "\u09b0\u09ac\u09bf\u09ac\u09be\u09b0",
               "\u09b8\u09cb\u09ae\u09ac\u09be\u09b0",
               "\u09ae\u0999\u09cd\u0997\u09b2\u09ac\u09be\u09b0",
               "\u09ac\u09c1\u09a7\u09ac\u09be\u09b0",
               "\u09ac\u09c3\u09b9\u09b8\u09cd\u09aa\u09a4\u09bf\u09ac\u09be\u09b0",
               "\u09b6\u09c1\u0995\u09cd\u09b0\u09ac\u09be\u09b0",
               "\u09b6\u09a8\u09bf\u09ac\u09be\u09b0",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "\u09b0\u09ac\u09bf",
               "\u09b8\u09cb\u09ae",
               "\u09ae\u0999\u09cd\u0997\u09b2",
               "\u09ac\u09c1\u09a7",
               "\u09ac\u09c3\u09b9\u09b8\u09cd\u09aa\u09a4\u09bf",
               "\u09b6\u09c1\u0995\u09cd\u09b0",
               "\u09b6\u09a8\u09bf",
            };
        final String[] metaValue_DayNarrows = new String[] {
               "\u09b0",
               "\u09b8\u09cb",
               "\u09ae",
               "\u09ac\u09c1",
               "\u09ac\u09c3",
               "\u09b6\u09c1",
               "\u09b6",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "\u09a4\u09cd\u09b0\u09c8\u09ae\u09be\u09b8\u09bf\u0995",
               "\u09a6\u09cd\u09ac\u09bf\u09a4\u09c0\u09af\u09bc \u09a4\u09cd\u09b0\u09c8\u09ae\u09be\u09b8\u09bf\u0995",
               "\u09a4\u09c3\u09a4\u09c0\u09af\u09bc \u09a4\u09cd\u09b0\u09c8\u09ae\u09be\u09b8\u09bf\u0995",
               "\u099a\u09a4\u09c1\u09b0\u09cd\u09a5 \u09a4\u09cd\u09b0\u09c8\u09ae\u09be\u09b8\u09bf\u0995",
            };
        final String[] metaValue_standalone_QuarterAbbreviations = new String[] {
               "Q1",
               "Q2",
               "Q3",
               "Q4",
            };
        final String[] metaValue_QuarterNarrows = new String[] {
               "\u09e7",
               "\u09e8",
               "\u09e9",
               "\u09ea",
            };
        final String[] metaValue_AmPmMarkers = new String[] {
               "\u09aa\u09c2\u09b0\u09cd\u09ac\u09be\u09b9\u09cd\u09a3",
               "\u0985\u09aa\u09b0\u09be\u09b9\u09cd\u09a3",
            };
        final String[] metaValue_long_Eras = new String[] {
               "\u0996\u09cd\u09b0\u09bf\u09b8\u09cd\u099f\u09aa\u09c2\u09b0\u09cd\u09ac",
               "\u0996\u09c3\u09b7\u09cd\u099f\u09be\u09ac\u09cd\u09a6",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "h:mm:ss a zzzz",
               "h:mm:ss a z",
               "h:mm:ss a",
               "h:mm a",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "EEEE, d MMMM, y G",
               "d MMMM, y G",
               "d MMM, y G",
               "d/M/y GGGGG",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "EEEE, d MMMM, y GGGG",
               "d MMMM, y GGGG",
               "d MMM, y GGGG",
               "d/M/y G",
            };
        final String[] metaValue_japanese_narrow_AmPmMarkers = new String[] {
               "AM",
               "PM",
            };
        final String[] metaValue_islamic_long_Eras = new String[] {
               "",
               "\u09af\u09c1\u0997",
            };
        final String metaValue_calendarname_gregorian = "\u0997\u09cd\u09b0\u09bf\u0997\u09cb\u09b0\u09bf\u09af\u09bc\u09be\u09a8 \u09ac\u09b0\u09cd\u09b7\u09aa\u099e\u09cd\u099c\u09c0";
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "field.year", "\u09ac\u099b\u09b0" },
            { "japanese.AmPmMarkers", metaValue_AmPmMarkers },
            { "AmPmMarkers", metaValue_AmPmMarkers },
            { "timezone.gmtFormat", "GMT {0}" },
            { "java.time.japanese.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "standalone.QuarterAbbreviations", metaValue_standalone_QuarterAbbreviations },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "calendarname.islamic-civil", "\u0987\u09b8\u09b2\u09be\u09ae\u09bf\u0995-\u09b8\u09bf\u09ad\u09bf\u09b2 \u09ac\u09b0\u09cd\u09b7\u09aa\u099e\u09cd\u099c\u09c0" },
            { "islamic.narrow.AmPmMarkers", metaValue_japanese_narrow_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "narrow.Eras", metaValue_long_Eras },
            { "DefaultNumberingSystem", "beng" },
            { "calendarname.japanese", "\u099c\u09be\u09aa\u09be\u09a8\u09bf \u09ac\u09b0\u09cd\u09b7\u09aa\u099e\u09cd\u099c\u09c0" },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "standalone.DayAbbreviations", metaValue_DayAbbreviations },
            { "roc.MonthAbbreviations", metaValue_MonthNames },
            { "beng.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u09e6",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "\u09b8\u0982\u0996\u09cd\u09af\u09be\u00a0\u09a8\u09be",
                }
            },
            { "long.Eras", metaValue_long_Eras },
            { "roc.QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.DayNames", metaValue_DayNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthNames },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns", metaValue_buddhist_DatePatterns },
            { "buddhist.DayNames", metaValue_DayNames },
            { "field.minute", "\u09ae\u09bf\u09a8\u09bf\u099f" },
            { "field.era", "\u09af\u09c1\u0997" },
            { "buddhist.AmPmMarkers", metaValue_AmPmMarkers },
            { "field.dayperiod", "AM/PM" },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.MonthNames",
                new String[] {
                    "\u09ae\u09b9\u09b0\u09b0\u09ae",
                    "\u09b8\u09ab\u09b0",
                    "\u09b0\u09ac\u09bf\u0989\u09b2 \u0986\u0989\u09af\u09bc\u09be\u09b2",
                    "\u09b0\u09ac\u09bf\u0989\u09b8 \u09b8\u09be\u09a8\u09bf",
                    "\u099c\u09ae\u09be\u09a6\u09bf\u0989\u09b2 \u0986\u0989\u09af\u09bc\u09be\u09b2",
                    "\u099c\u09ae\u09be\u09a6\u09bf\u0989\u09b8 \u09b8\u09be\u09a8\u09bf",
                    "\u09b0\u099c\u09ac",
                    "\u09b6\u09be\u2018\u09ac\u09be\u09a8",
                    "\u09b0\u09ae\u099c\u09be\u09a8",
                    "\u09b6\u09be\u0993\u09af\u09bc\u09be\u09b2",
                    "\u099c\u09cd\u09ac\u09bf\u09b2\u0995\u09a6",
                    "\u099c\u09cd\u09ac\u09bf\u09b2\u09b9\u099c\u09cd\u099c",
                    "",
                }
            },
            { "japanese.QuarterNarrows", metaValue_QuarterNarrows },
            { "calendarname.roc", "\u09ae\u09bf\u0999\u09cd\u0997\u09c1\u0993 \u09ac\u09b0\u09cd\u09b7\u09aa\u099e\u09cd\u099c\u09c0" },
            { "islamic.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.QuarterAbbreviations", metaValue_standalone_QuarterAbbreviations },
            { "islamic.Eras", metaValue_islamic_long_Eras },
            { "field.month", "\u09ae\u09be\u09b8" },
            { "field.second", "\u09b8\u09c7\u0995\u09c7\u09a8\u09cd\u09a1" },
            { "islamic.MonthNarrows",
                new String[] {
                    "\u09e7",
                    "\u09e8",
                    "\u09e9",
                    "\u09ea",
                    "\u09eb",
                    "\u09ec",
                    "\u09ed",
                    "\u09ee",
                    "\u09ef",
                    "\u09e7\u09e6",
                    "\u09e7\u09e7",
                    "\u09e7\u09e8",
                    "",
                }
            },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNarrows", metaValue_DayNarrows },
            { "NumberPatterns",
                new String[] {
                    "#,##,##0.###",
                    "#,##,##0.00\u00a4",
                    "#,##,##0%",
                }
            },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "calendarname.islamic", "\u0987\u09b8\u09b2\u09be\u09ae\u09bf\u0995 \u09ac\u09b0\u09cd\u09b7\u09aa\u099e\u09cd\u099c\u09c0" },
            { "japanese.narrow.AmPmMarkers", metaValue_japanese_narrow_AmPmMarkers },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "standalone.MonthAbbreviations", metaValue_MonthNames },
            { "buddhist.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.narrow.AmPmMarkers", metaValue_japanese_narrow_AmPmMarkers },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.QuarterAbbreviations", metaValue_standalone_QuarterAbbreviations },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "standalone.DayNarrows", metaValue_DayNarrows },
            { "islamic.AmPmMarkers", metaValue_AmPmMarkers },
            { "TimePatterns", metaValue_TimePatterns },
            { "islamic.DayNarrows", metaValue_DayNarrows },
            { "field.zone", "\u098f\u09b2\u09be\u0995\u09be" },
            { "japanese.QuarterAbbreviations", metaValue_standalone_QuarterAbbreviations },
            { "Eras", metaValue_long_Eras },
            { "roc.DayNames", metaValue_DayNames },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "QuarterNarrows", metaValue_QuarterNarrows },
            { "standalone.QuarterNarrows", metaValue_QuarterNarrows },
            { "java.time.islamic.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "field.weekday", "\u09b8\u09aa\u09cd\u09a4\u09be\u09b9\u09c7\u09b0 \u09a6\u09bf\u09a8" },
            { "japanese.MonthAbbreviations", metaValue_MonthNames },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.long.Eras", metaValue_islamic_long_Eras },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_standalone_QuarterAbbreviations },
            { "japanese.DayNames", metaValue_DayNames },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNames", metaValue_DayNames },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.MonthNames", metaValue_MonthNames },
            { "field.week", "\u09b8\u09aa\u09cd\u09a4\u09be\u09b9" },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.DayNarrows", metaValue_DayNarrows },
            { "roc.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "DatePatterns",
                new String[] {
                    "EEEE, d MMMM, y",
                    "d MMMM, y",
                    "d MMM, y",
                    "d/M/yy",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "MonthAbbreviations", metaValue_MonthNames },
            { "standalone.DayNames",
                new String[] {
                    "\u09b0\u09ac\u09bf\u09ac\u09be\u09b0",
                    "\u09b8\u09cb\u09ae\u09ac\u09be\u09b0",
                    "\u09ae\u0999\u09cd\u0997\u09b2\u09ac\u09be\u09b0",
                    "\u09ac\u09c1\u09a7\u09ac\u09be\u09b0",
                    "\u09ac\u09c3\u09b9\u09b7\u09cd\u09aa\u09a4\u09bf\u09ac\u09be\u09b0",
                    "\u09b6\u09c1\u0995\u09cd\u09b0\u09ac\u09be\u09b0",
                    "\u09b6\u09a8\u09bf\u09ac\u09be\u09b0",
                }
            },
            { "field.hour", "\u0998\u09a8\u09cd\u099f\u09be" },
            { "islamic.narrow.Eras", metaValue_islamic_long_Eras },
            { "calendarname.buddhist", "\u09ac\u09cc\u09a6\u09cd\u09a7 \u09ac\u09b0\u09cd\u09b7\u09aa\u099e\u09cd\u099c\u09c0" },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "buddhist.DayNarrows", metaValue_DayNarrows },
            { "japanese.DayNarrows", metaValue_DayNarrows },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
        };
        return data;
    }
}
