/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.presets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.graalvm.visualvm.core.ui.components.SectionSeparator;
import org.graalvm.visualvm.profiling.presets.ProfilerCPUSettings;
import org.graalvm.visualvm.profiling.presets.ProfilerJDBCSettings;
import org.graalvm.visualvm.profiling.presets.ProfilerMemorySettings;
import org.graalvm.visualvm.profiling.presets.ProfilerPreset;
import org.graalvm.visualvm.profiling.presets.ProfilerPresets;
import org.graalvm.visualvm.profiling.presets.ProfilingOptionsPanelController;
import org.graalvm.visualvm.profiling.presets.ProfilingOptionsSectionProvider;
import org.graalvm.visualvm.profiling.presets.SamplerCPUSettings;
import org.graalvm.visualvm.profiling.presets.SamplerMemorySettings;
import org.graalvm.visualvm.uisupport.UISupport;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class ProfilingOptionsPanel
extends JPanel {
    private final ProfilingOptionsPanelController controller;
    private final SamplerCPUSettings samplerCpuSettings;
    private final SamplerMemorySettings samplerMemorySettings;
    private final ProfilerCPUSettings profilerCpuSettings;
    private final ProfilerMemorySettings profilerMemorySettings;
    private final ProfilerJDBCSettings profilerJdbcSettings;
    private ProfilerPresets.PresetsModel listModel;
    private final ListDataListener listModelListener;
    private boolean internalChange;
    private boolean nameValid = true;
    private JPanel presetsPanel;
    private JList list;
    private JButton addButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private JTextField nameField;
    private JTextField targetField;

    ProfilingOptionsPanel(ProfilingOptionsPanelController controller) {
        this.controller = controller;
        Runnable validator = new Runnable(){

            @Override
            public void run() {
                ProfilerPreset preset = (ProfilerPreset)ProfilingOptionsPanel.this.list.getSelectedValue();
                if (preset == null) {
                    return;
                }
                preset.setValid(ProfilingOptionsPanel.this.samplerCpuSettings.valid() && ProfilingOptionsPanel.this.profilerCpuSettings.valid() && ProfilingOptionsPanel.this.samplerMemorySettings.valid() && ProfilingOptionsPanel.this.profilerMemorySettings.valid() && ProfilingOptionsPanel.this.profilerJdbcSettings.valid());
                ProfilingOptionsPanel.this.controller.changed();
            }
        };
        this.samplerCpuSettings = new SamplerCPUSettings(validator);
        this.samplerMemorySettings = new SamplerMemorySettings();
        this.profilerCpuSettings = new ProfilerCPUSettings(validator);
        this.profilerMemorySettings = new ProfilerMemorySettings(validator);
        this.profilerJdbcSettings = new ProfilerJDBCSettings();
        this.listModelListener = new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                ProfilingOptionsPanel.this.updateComponents();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ProfilingOptionsPanel.this.updateComponents();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        };
        this.initComponents();
    }

    private void updateComponents() {
        int selectedIndex;
        int n = selectedIndex = this.listModel.isEmpty() ? -1 : this.list.getSelectedIndex();
        if (selectedIndex == this.listModel.getSize()) {
            return;
        }
        this.removeButton.setEnabled(selectedIndex != -1);
        this.upButton.setEnabled(selectedIndex > 0);
        this.downButton.setEnabled(selectedIndex < this.listModel.getSize() - 1);
        this.refreshPreset(selectedIndex);
    }

    private String createPresetName() {
        HashSet<String> names = new HashSet<String>();
        Enumeration presetsE = this.listModel.elements();
        while (presetsE.hasMoreElements()) {
            names.add(presetsE.nextElement().toString());
        }
        int presetIndex = 1;
        String name = NbBundle.getMessage(ProfilingOptionsPanel.class, (String)"MSG_Preset") + " ";
        while (names.contains(name + presetIndex)) {
            ++presetIndex;
        }
        return name + presetIndex;
    }

    private void createPreset() {
        ProfilerPreset preset = new ProfilerPreset(this.createPresetName(), "");
        this.listModel.addPreset(preset);
        this.list.setSelectedIndex(this.listModel.getSize() - 1);
        this.preselectNameField();
    }

    private void preselectNameField() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfilingOptionsPanel.this.nameField.requestFocusInWindow();
                ProfilingOptionsPanel.this.nameField.selectAll();
            }
        });
    }

    private void deletePreset() {
        int selectedIndex = this.list.getSelectedIndex();
        this.listModel.removePreset(selectedIndex);
        if (this.listModel.getSize() > 0) {
            this.list.setSelectedIndex(selectedIndex == this.listModel.getSize() ? selectedIndex - 1 : selectedIndex);
        }
    }

    private void movePresetUp() {
        int selectedIndex = this.list.getSelectedIndex();
        this.listModel.movePresetUp(selectedIndex);
        this.list.setSelectedIndex(selectedIndex - 1);
    }

    private void movePresetDown() {
        int selectedIndex = this.list.getSelectedIndex();
        this.listModel.movePresetDown(selectedIndex);
        this.list.setSelectedIndex(selectedIndex + 1);
    }

    private void refreshPreset(int presetIndex) {
        ProfilerPreset preset = presetIndex == -1 ? new ProfilerPreset("", "") : (ProfilerPreset)this.listModel.get(presetIndex);
        this.internalChange = true;
        this.nameField.setText(preset.getName());
        this.targetField.setText(preset.getSelector());
        this.internalChange = false;
        this.samplerCpuSettings.setPreset(preset);
        this.samplerMemorySettings.setPreset(preset);
        this.profilerCpuSettings.setPreset(preset);
        this.profilerMemorySettings.setPreset(preset);
        this.profilerJdbcSettings.setPreset(preset);
        this.presetsPanel.setEnabled(presetIndex != -1);
    }

    private void updatePreset() {
        if (this.internalChange) {
            return;
        }
        ProfilerPreset preset = (ProfilerPreset)this.listModel.get(this.list.getSelectedIndex());
        preset.setName(this.nameField.getText());
        preset.setSelector(this.targetField.getText());
        this.nameValid = !this.nameField.getText().isEmpty();
        this.controller.changed();
    }

    private void initComponents() {
        int mar;
        final boolean nimbusLaF = UISupport.isNimbusLookAndFeel();
        this.setLayout(new GridBagLayout());
        SectionSeparator presetsSection = org.graalvm.visualvm.core.options.UISupport.createSectionSeparator((String)NbBundle.getMessage(ProfilingOptionsPanel.class, (String)"CAPTION_Presets"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        this.add((Component)presetsSection, c);
        JPanel listPanel = new JPanel(new BorderLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weighty = 0.5;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(3, 15, 3, 0);
        this.add((Component)listPanel, c);
        this.list = new JList();
        this.list.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                super.setSelectionInterval(index0, index1);
                ProfilingOptionsPanel.this.updateComponents();
            }

            @Override
            public void removeSelectionInterval(int i1, int i2) {
            }
        });
        this.list.setSelectionMode(0);
        final Dimension oneDim = new Dimension(1, 1);
        final JLabel noPresetsLabel = new JLabel(NbBundle.getMessage(ProfilingOptionsPanel.class, (String)"MSG_No_presets"), 0);
        noPresetsLabel.setEnabled(false);
        noPresetsLabel.setSize(noPresetsLabel.getPreferredSize());
        JScrollPane listScroll = new JScrollPane(this.list){

            @Override
            public Dimension getPreferredSize() {
                return oneDim;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            protected void paintChildren(Graphics g) {
                super.paintChildren(g);
                if (ProfilingOptionsPanel.this.listModel == null || ProfilingOptionsPanel.this.listModel.getSize() == 0) {
                    int x = (this.getWidth() - noPresetsLabel.getWidth()) / 2;
                    int y = (this.getHeight() - noPresetsLabel.getHeight()) / 2;
                    g.translate(x, y);
                    noPresetsLabel.paint(g);
                    g.translate(-x, -y);
                }
            }
        };
        listPanel.add((Component)listScroll, "Center");
        this.addButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilingOptionsPanel.this.createPreset();
            }
        };
        this.addButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiler/resources/add.png", (boolean)true)));
        this.addButton.setToolTipText(NbBundle.getMessage(ProfilingOptionsPanel.class, (String)"TOOLTIP_Create_preset"));
        Insets margin = this.addButton.getMargin();
        margin.left = mar = nimbusLaF ? 0 : 8;
        margin.right = mar;
        this.addButton.setMargin(margin);
        this.removeButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilingOptionsPanel.this.deletePreset();
            }
        };
        this.removeButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiler/resources/remove.png", (boolean)true)));
        this.removeButton.setToolTipText(NbBundle.getMessage(ProfilingOptionsPanel.class, (String)"TOOLTIP_Delete_preset"));
        this.removeButton.setMargin(margin);
        this.upButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilingOptionsPanel.this.movePresetUp();
            }
        };
        this.upButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiler/resources/up.png", (boolean)true)));
        this.upButton.setToolTipText(NbBundle.getMessage(ProfilingOptionsPanel.class, (String)"TOOLTIP_preset_up"));
        this.upButton.setMargin(margin);
        this.downButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ProfilingOptionsPanel.this.movePresetDown();
            }
        };
        this.downButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiler/resources/down.png", (boolean)true)));
        this.downButton.setToolTipText(NbBundle.getMessage(ProfilingOptionsPanel.class, (String)"TOOLTIP_preset_down"));
        this.downButton.setMargin(margin);
        JPanel controlsPanel = new JPanel(new GridLayout(1, 4, 5, 0)){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Component c : this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        };
        controlsPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        controlsPanel.add(this.addButton);
        controlsPanel.add(this.removeButton);
        controlsPanel.add(this.upButton);
        controlsPanel.add(this.downButton);
        listPanel.add((Component)controlsPanel, "South");
        JPanel headerPanel = new JPanel(new GridBagLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Component c : this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        };
        JLabel nameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)nameLabel, (String)NbBundle.getMessage(ProfilingOptionsPanel.class, (String)"LBL_Preset_name"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(3, 3, 3, 0);
        headerPanel.add((Component)nameLabel, c);
        this.nameField = new JTextField();
        nameLabel.setLabelFor(this.nameField);
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProfilingOptionsPanel.this.updatePreset();
                ProfilingOptionsPanel.this.listModel.fireItemChanged(ProfilingOptionsPanel.this.list.getSelectedIndex());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProfilingOptionsPanel.this.updatePreset();
                ProfilingOptionsPanel.this.listModel.fireItemChanged(ProfilingOptionsPanel.this.list.getSelectedIndex());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProfilingOptionsPanel.this.updatePreset();
                ProfilingOptionsPanel.this.listModel.fireItemChanged(ProfilingOptionsPanel.this.list.getSelectedIndex());
            }
        });
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(3, 5, 3, 0);
        headerPanel.add((Component)this.nameField, c);
        JLabel targetLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)targetLabel, (String)NbBundle.getMessage(ProfilingOptionsPanel.class, (String)"LBL_Preselect_for"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(3, 3, 13, 0);
        headerPanel.add((Component)targetLabel, c);
        final JLabel noTargetLabel = new JLabel(NbBundle.getMessage(ProfilingOptionsPanel.class, (String)"LBL_Optional_class"), 0);
        noTargetLabel.setEnabled(false);
        noTargetLabel.setSize(noTargetLabel.getPreferredSize());
        this.targetField = new JTextField(){

            @Override
            protected void paintChildren(Graphics g) {
                super.paintChildren(g);
                String text = this.getText();
                if (!this.isFocusOwner() && (text == null || text.isEmpty())) {
                    int x = nimbusLaF ? 6 : 2;
                    int y = (this.getHeight() - noTargetLabel.getHeight()) / 2;
                    g.translate(x, y);
                    noTargetLabel.paint(g);
                    g.translate(-x, -y);
                }
            }

            @Override
            protected void processFocusEvent(FocusEvent e) {
                super.processFocusEvent(e);
                this.repaint();
            }
        };
        targetLabel.setLabelFor(this.targetField);
        this.targetField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProfilingOptionsPanel.this.updatePreset();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProfilingOptionsPanel.this.updatePreset();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProfilingOptionsPanel.this.updatePreset();
            }
        });
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(3, 5, 13, 0);
        headerPanel.add((Component)this.targetField, c);
        JTabbedPane settingsPanel = new JTabbedPane(){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Component c : this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        };
        settingsPanel.addTab(NbBundle.getMessage(ProfilingOptionsPanel.class, (String)"LBL_Sampler_cpu"), new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiling/resources/sampler.png", (boolean)true)), this.samplerCpuSettings);
        settingsPanel.addTab(NbBundle.getMessage(ProfilingOptionsPanel.class, (String)"LBL_Sampler_memory"), new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiling/resources/sampler.png", (boolean)true)), this.samplerMemorySettings);
        settingsPanel.addTab(NbBundle.getMessage(ProfilingOptionsPanel.class, (String)"LBL_Profiler_cpu"), new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiling/resources/profiler.png", (boolean)true)), this.profilerCpuSettings);
        settingsPanel.addTab(NbBundle.getMessage(ProfilingOptionsPanel.class, (String)"LBL_Profiler_memory"), new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiling/resources/profiler.png", (boolean)true)), this.profilerMemorySettings);
        settingsPanel.addTab(NbBundle.getMessage(ProfilingOptionsPanel.class, (String)"LBL_Profiler_jdbc"), new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiling/resources/profiler.png", (boolean)true)), this.profilerJdbcSettings);
        this.presetsPanel = new JPanel(new BorderLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Component c : this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        };
        this.presetsPanel.add((Component)headerPanel, "North");
        this.presetsPanel.add((Component)settingsPanel, "Center");
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(3, 8, 3, 0);
        this.add((Component)this.presetsPanel, c);
        int gridy = 50;
        for (ProfilingOptionsSectionProvider provider : Lookup.getDefault().lookupAll(ProfilingOptionsSectionProvider.class)) {
            SectionSeparator section = org.graalvm.visualvm.core.options.UISupport.createSectionSeparator((String)provider.getSectionName());
            c = new GridBagConstraints();
            c.gridy = gridy++;
            c.gridwidth = 0;
            c.anchor = 18;
            c.fill = 2;
            c.insets = new Insets(15, 0, 5, 0);
            this.add((Component)section, c);
            c = new GridBagConstraints();
            c.gridy = gridy++;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(2, 15, 3, 0);
            this.add(provider.getSection(), c);
        }
    }

    void load() {
        this.listModel = ProfilerPresets.getInstance().getPresets();
        this.listModel.addListDataListener(this.listModelListener);
        this.list.setModel(this.listModel);
        int items = this.listModel.getSize();
        ProfilerPreset toCreate = ProfilerPresets.getInstance().presetToCreate();
        if (toCreate != null) {
            toCreate.setName(this.createPresetName());
            this.listModel.addElement(toCreate);
            this.list.setSelectedIndex(items);
        } else if (this.listModel.size() > 0) {
            ProfilerPreset select = ProfilerPresets.getInstance().presetToSelect();
            String toSelect = select == null ? null : select.getName();
            int indexToSelect = 0;
            if (toSelect != null) {
                for (int i = 0; i < items; ++i) {
                    ProfilerPreset preset = (ProfilerPreset)this.listModel.get(i);
                    if (!preset.getName().equals(toSelect)) continue;
                    indexToSelect = i;
                    break;
                }
            }
            this.list.setSelectedIndex(indexToSelect);
        }
        this.updateComponents();
        if (toCreate != null) {
            this.preselectNameField();
        }
    }

    void store() {
        ProfilerPresets.getInstance().savePresets(this.listModel);
        ProfilerPreset selected = (ProfilerPreset)this.list.getSelectedValue();
        ProfilerPresets.getInstance().optionsSubmitted(selected);
    }

    void closed() {
        if (this.listModel != null) {
            this.listModel.removeListDataListener(this.listModelListener);
        }
        this.list.setModel(new DefaultListModel());
    }

    boolean valid() {
        return this.nameValid;
    }
}

