/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.toolchain.launchers.linux;

import com.oracle.truffle.llvm.toolchain.launchers.common.Driver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class LinuxLinker
extends Driver {
    public static final String LLD = "ld.lld";

    private LinuxLinker() {
        super(LLD);
    }

    public static List<String> getLinkerFlags() {
        return Arrays.asList("--mllvm=-lto-embed-bitcode=all", "--lto-O0");
    }

    public static void link(String[] args) {
        new LinuxLinker().doLink(args);
    }

    private void doLink(String[] args) {
        ArrayList<String> sulongArgs = new ArrayList<String>();
        sulongArgs.add(this.exe);
        sulongArgs.add("-L" + this.getSulongHome().resolve("native").resolve("lib"));
        sulongArgs.addAll(LinuxLinker.getLinkerFlags());
        List<String> userArgs = Arrays.asList(args);
        boolean verbose = userArgs.contains("-v");
        this.runDriver(sulongArgs, userArgs, verbose, false, false);
    }
}

