/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.visualvm.lib.jfluid.heap.GCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.HprofGCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.HprofHeap;
import org.graalvm.visualvm.lib.jfluid.heap.JavaFrameHprofGCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.TagBounds;
import org.graalvm.visualvm.lib.jfluid.heap.ThreadObjectGCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.ThreadObjectHprofGCRoot;

class HprofGCRoots {
    final HprofHeap heap;
    private ThreadObjectHprofGCRoot lastThreadObjGC;
    private final Object lastThreadObjGCLock = new Object();
    private Map gcRoots;
    private final Object gcRootLock = new Object();
    private List gcRootsList;

    HprofGCRoots(HprofHeap h) {
        this.heap = h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection getGCRoots() {
        Object object = this.gcRootLock;
        synchronized (object) {
            if (this.gcRoots == null) {
                this.gcRoots = this.computeGCRootsFor(this.heap.getHeapTagBound(255));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(1)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(2)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(3)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(4)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(5)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(6)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(7)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(8)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(137)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(138)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(139)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(140)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(141)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(142)));
                ArrayList rootList = new ArrayList(this.gcRoots.values());
                Collections.sort(rootList, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        HprofGCRoot r1 = (HprofGCRoot)o1;
                        HprofGCRoot r2 = (HprofGCRoot)o2;
                        int kind = r1.getKind().compareTo(r2.getKind());
                        if (kind != 0) {
                            return kind;
                        }
                        return Long.compare(r1.getInstanceId(), r2.getInstanceId());
                    }
                });
                this.gcRootsList = Collections.unmodifiableList(rootList);
            }
            return this.gcRootsList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GCRoot getGCRoot(Long instanceId) {
        Object object = this.gcRootLock;
        synchronized (object) {
            if (this.gcRoots == null) {
                this.heap.getGCRoots();
            }
            return (GCRoot)this.gcRoots.get(instanceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadObjectGCRoot getThreadGCRoot(int threadSerialNumber) {
        Object object = this.lastThreadObjGCLock;
        synchronized (object) {
            if (this.lastThreadObjGC != null && threadSerialNumber == this.lastThreadObjGC.getThreadSerialNumber()) {
                return this.lastThreadObjGC;
            }
            for (Object gcRoot : this.heap.getGCRoots()) {
                ThreadObjectHprofGCRoot threadObjGC;
                if (!(gcRoot instanceof ThreadObjectHprofGCRoot) || threadSerialNumber != (threadObjGC = (ThreadObjectHprofGCRoot)gcRoot).getThreadSerialNumber()) continue;
                this.lastThreadObjGC = threadObjGC;
                return threadObjGC;
            }
            return null;
        }
    }

    private Map computeGCRootsFor(TagBounds tagBounds) {
        HashMap<Long, ThreadObjectHprofGCRoot> roots = new HashMap<Long, ThreadObjectHprofGCRoot>();
        if (tagBounds != null) {
            int rootTag = tagBounds.tag;
            long[] offset = new long[]{tagBounds.startOffset};
            while (offset[0] < tagBounds.endOffset) {
                long start = offset[0];
                if (this.heap.readDumpTag(offset) != rootTag) continue;
                HprofGCRoot root = rootTag == 8 ? new ThreadObjectHprofGCRoot(this, start) : (rootTag == 3 ? new JavaFrameHprofGCRoot(this, start) : new HprofGCRoot(this, start));
                roots.put(root.getInstanceId(), (ThreadObjectHprofGCRoot)root);
            }
        }
        return roots;
    }
}

