/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.library;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.generator.CodeTypeElementFactory;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationValue;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeParameterElement;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.library.ExportsGenerator;
import com.oracle.truffle.dsl.processor.library.ExportsLibrary;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.library.LibraryDefaultExportData;
import com.oracle.truffle.dsl.processor.library.LibraryMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class LibraryGenerator
extends CodeTypeElementFactory<LibraryData> {
    private static final String ACCEPTS = "accepts";
    private ProcessorContext context;
    private LibraryData model;
    private final Map<String, CodeVariableElement> libraryConstants = new LinkedHashMap<String, CodeVariableElement>();

    @Override
    public List<CodeTypeElement> create(ProcessorContext context1, LibraryData model1) {
        this.libraryConstants.clear();
        this.context = context1;
        this.model = model1;
        if (model1.hasErrors()) {
            return Collections.emptyList();
        }
        TypeElement libraryType = this.model.getTemplateType();
        TypeMirror libraryTypeMirror = libraryType.asType();
        CodeTypeMirror.DeclaredCodeTypeMirror baseType = new CodeTypeMirror.DeclaredCodeTypeMirror(this.context.getTypeElement(this.types.LibraryFactory), Arrays.asList(libraryTypeMirror));
        CodeTypeElement genClass = GeneratorUtils.createClass(this.model, null, ElementUtils.modifiers(Modifier.FINAL), LibraryGenerator.createGenTypeName(this.model), baseType);
        CodeTypeMirror.DeclaredCodeTypeMirror classLiteral = new CodeTypeMirror.DeclaredCodeTypeMirror(this.context.getTypeElement(Class.class), Arrays.asList(libraryTypeMirror));
        CodeExecutableElement loadLibraryClass = genClass.add(new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC), classLiteral, "lazyLibraryClass", new CodeVariableElement[0]));
        GeneratorUtils.mergeSupressWarnings(loadLibraryClass, "unchecked");
        CodeTreeBuilder builder = loadLibraryClass.createBuilder();
        builder.startTryBlock();
        builder.startStatement().string("return ");
        builder.cast(classLiteral);
        builder.startStaticCall(classLiteral, "forName").doubleQuote(ElementUtils.getClassQualifiedName(libraryType)).string("false").startGroup().typeLiteral(genClass.asType()).string(".getClassLoader()").end().end();
        builder.end();
        builder.end().startCatchBlock(this.context.getType(ClassNotFoundException.class), "e");
        builder.startThrow().startNew(this.context.getType(AssertionError.class)).string("e").end().end();
        builder.end();
        CodeVariableElement libraryClassLiteral = genClass.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), classLiteral, "LIBRARY_CLASS"));
        libraryClassLiteral.createInitBuilder().startStaticCall(loadLibraryClass).end();
        CodeExecutableElement staticsMethod = genClass.add(new CodeExecutableElement(ElementUtils.modifiers(Modifier.STATIC), null, "<cinit>", new CodeVariableElement[0]));
        CodeTreeBuilder statics = staticsMethod.createBuilder();
        ArrayList<MessageObjects> methods = new ArrayList<MessageObjects>();
        for (int messageIndex = 0; messageIndex < this.model.getMethods().size(); ++messageIndex) {
            LibraryMessage message = this.model.getMethods().get(messageIndex);
            if (message.hasErrors()) continue;
            MessageObjects objects = new MessageObjects(message, messageIndex);
            methods.add(objects);
        }
        CodeExecutableElement getDefault = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.LibraryFactory, "getDefaultClass"));
        getDefault.getModifiers().remove((Object)Modifier.ABSTRACT);
        getDefault.renameArguments("receiver");
        builder = getDefault.createBuilder();
        assert (this.model.getDefaultExports().size() > 0);
        boolean elseIf = false;
        int index = 0;
        for (LibraryDefaultExportData defaultExport : this.model.getDefaultExports()) {
            TypeMirror defaultProviderReceiverType = defaultExport.getReceiverType();
            int ifCount = 0;
            if (ElementUtils.typeEquals(defaultProviderReceiverType, this.context.getType(Object.class))) {
                if (elseIf) {
                    builder.startElseBlock();
                    ++ifCount;
                }
                assert (index == this.model.getDefaultExports().size() - 1);
            } else {
                elseIf = builder.startIf(elseIf);
                ++ifCount;
                builder.string("receiver").instanceOf(ElementUtils.boxType(this.context, defaultProviderReceiverType));
                builder.end().startBlock();
            }
            if (defaultExport.getImplType() == null) {
                TypeMirror[] defaultTypeMirrors = this.createDefaultImpl(genClass);
                statics.startStatement().startStaticCall(this.types.LibraryExport, "register");
                statics.staticReference(libraryClassLiteral).startNew(defaultTypeMirrors[1]).end().end();
                statics.end().end();
                builder.startReturn().typeLiteral(defaultTypeMirrors[0]).end();
            } else {
                builder.startReturn().typeLiteral(defaultExport.getImplType()).end();
            }
            builder.end(ifCount);
            ++index;
        }
        genClass.add(getDefault);
        CodeTypeElement messageClass = GeneratorUtils.createClass(this.model, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC), "MessageImpl", this.types.Message);
        messageClass.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.FINAL), this.context.getType(Integer.TYPE), "index"));
        CodeExecutableElement messageConstructor = new CodeExecutableElement(ElementUtils.modifiers(new Modifier[0]), null, messageClass.getSimpleName().toString(), new CodeVariableElement[0]);
        messageConstructor.addParameter(new CodeVariableElement(this.context.getType(String.class), "name"));
        messageConstructor.addParameter(new CodeVariableElement(this.context.getType(Integer.TYPE), "index"));
        messageConstructor.addParameter(new CodeVariableElement(this.context.getType(Class.class), "returnType"));
        messageConstructor.addParameter(new CodeVariableElement(this.context.getType(Class[].class), "parameters"));
        messageConstructor.setVarArgs(true);
        builder = messageConstructor.createBuilder();
        builder.startStatement().startSuperCall().staticReference(libraryClassLiteral).string("name").string("returnType").string("parameters").end().end();
        builder.statement("this.index = index");
        messageClass.add(messageConstructor);
        genClass.add(messageClass);
        CodeTypeElement proxyClass = GeneratorUtils.createClass(this.model, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), "Proxy", libraryTypeMirror);
        genClass.add(proxyClass);
        CodeVariableElement libField = proxyClass.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE), this.context.getTypes().ReflectionLibrary, "lib"));
        libField.addAnnotationMirror(new CodeAnnotationMirror(this.types.Node_Child));
        proxyClass.add(GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(new Modifier[0]), proxyClass));
        proxyClass.addOptional(this.createGenericCastMethod(this.model));
        for (MessageObjects message : methods) {
            if (message.model.getName().equals(ACCEPTS)) continue;
            message.messageField = genClass.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), this.types.Message, LibraryGenerator.createConstantName(message.model.getName())));
            builder = message.messageField.createInitBuilder();
            builder.startNew(messageClass.asType()).doubleQuote(message.model.getName()).string(String.valueOf(message.messageIndex));
            ExecutableElement method = message.model.getExecutable();
            builder.typeLiteral(method.getReturnType());
            for (int i = 0; i < method.getParameters().size(); ++i) {
                builder.typeLiteral(method.getParameters().get(i).asType());
            }
            builder.end();
        }
        CodeVariableElement instance = genClass.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), genClass.asType(), "INSTANCE"));
        builder = instance.createInitBuilder().startNew(genClass.asType()).end();
        statics.startStatement();
        statics.startStaticCall(this.types.LibraryFactory, "register");
        statics.staticReference(libraryClassLiteral).string(instance.getName()).end();
        statics.end().end();
        if (this.model.getAssertions() != null) {
            CodeExecutableElement createAssertions = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.LibraryFactory, "createAssertions"));
            createAssertions.getModifiers().remove((Object)Modifier.ABSTRACT);
            ((CodeVariableElement)createAssertions.getParameters().get(0)).setType(libraryTypeMirror);
            createAssertions.renameArguments("delegate");
            createAssertions.setReturnType(libraryTypeMirror);
            createAssertions.createBuilder().startReturn().startNew(this.model.getAssertions()).string("delegate").end().end();
            genClass.add(createAssertions);
        }
        CodeExecutableElement createProxy = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.LibraryFactory, "createProxy"));
        createProxy.getModifiers().remove((Object)Modifier.ABSTRACT);
        createProxy.renameArguments("library");
        createProxy.setReturnType(libraryTypeMirror);
        createProxy.createBuilder().startReturn().startNew(proxyClass.asType()).string("library").end().end();
        genClass.add(createProxy);
        for (MessageObjects message : methods) {
            CodeExecutableElement executeImpl = proxyClass.add(CodeExecutableElement.cloneNoAnnotations(message.model.getExecutable()));
            LibraryGenerator.removeAbstractModifiers(executeImpl);
            if (executeImpl.getReturnType().getKind() == TypeKind.TYPEVAR) {
                executeImpl.getAnnotationMirrors().add(this.createSuppressWarningsUnchecked());
            }
            executeImpl.renameArguments("receiver_");
            builder = executeImpl.createBuilder();
            boolean uncheckedCast = false;
            if (message.model.getName().equals(ACCEPTS)) {
                builder.startReturn().string("lib.accepts(receiver_)").end();
            } else {
                LibraryGenerator.injectReceiverType(executeImpl, 0, this.model.getSignatureReceiverType());
                builder.startTryBlock();
                builder.startReturn();
                if (ElementUtils.needsCastTo(this.context.getType(Object.class), executeImpl.getReturnType())) {
                    if (ElementUtils.hasGenericTypes(executeImpl.getReturnType())) {
                        uncheckedCast = true;
                    }
                    builder.cast(executeImpl.getReturnType());
                }
                builder.startCall("lib", "send").string("receiver_").field(null, message.messageField);
                for (VariableElement param : executeImpl.getParameters().subList(1, executeImpl.getParameters().size())) {
                    builder.string(param.getSimpleName().toString());
                }
                builder.end();
                builder.end();
                ArrayList<TypeMirror> exceptionTypes = new ArrayList<TypeMirror>(executeImpl.getThrownTypes());
                TypeMirror runtimeException = this.context.getType(RuntimeException.class);
                exceptionTypes.add(runtimeException);
                HashSet<TypeMirror> hashSet = new HashSet<TypeMirror>();
                block6: for (TypeMirror type1 : exceptionTypes) {
                    for (TypeMirror type2 : exceptionTypes) {
                        if (type1 == type2 || !ElementUtils.isAssignable(type1, type2)) continue;
                        hashSet.add(type1);
                        continue block6;
                    }
                }
                exceptionTypes.removeAll(hashSet);
                TypeMirror exceptionType = this.context.getType(Exception.class);
                boolean fallThrough = true;
                for (TypeMirror thrownType : exceptionTypes) {
                    if (!ElementUtils.isAssignable(exceptionType, thrownType)) continue;
                    fallThrough = false;
                    break;
                }
                builder.end().startCatchBlock(exceptionTypes.toArray(new TypeMirror[0]), "e_");
                builder.startThrow().string("e_").end();
                builder.end();
                if (fallThrough) {
                    builder.startCatchBlock(this.context.getType(Exception.class), "e_");
                    builder.tree(GeneratorUtils.createTransferToInterpreter());
                    builder.startThrow().startNew(this.context.getType(AssertionError.class)).string("e_").end().end();
                    builder.end();
                }
            }
            if (!uncheckedCast) continue;
            GeneratorUtils.mergeSupressWarnings(executeImpl, "unchecked");
        }
        genClass.add(this.createGenericDispatch(methods, messageClass));
        CodeTypeElement cachedToUncached = GeneratorUtils.createClass(this.model, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), "CachedToUncachedDispatch", libraryTypeMirror);
        CodeExecutableElement getCost = cachedToUncached.add(CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.Node, "getCost")));
        getCost.createBuilder().startReturn().staticReference(ElementUtils.findVariableElement(this.types.NodeCost, "MEGAMORPHIC")).end();
        for (MessageObjects message : methods) {
            CodeExecutableElement execute = cachedToUncached.add(CodeExecutableElement.cloneNoAnnotations(message.model.getExecutable()));
            execute.renameArguments("receiver_");
            LibraryGenerator.removeAbstractModifiers(execute);
            builder = execute.createBuilder();
            if (message.model.getName().equals(ACCEPTS)) {
                builder.returnTrue();
                continue;
            }
            execute.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.CompilerDirectives_TruffleBoundary));
            builder.startStatement().type(this.types.Node).string(" prev_ = ").startStaticCall(this.types.NodeUtil, "pushEncapsulatingNode").string("getParent()").end().end();
            builder.startTryBlock();
            builder.startReturn().startCall("INSTANCE.getUncached(receiver_)", execute.getSimpleName().toString());
            for (VariableElement variableElement : execute.getParameters()) {
                builder.string(variableElement.getSimpleName().toString());
            }
            builder.end().end();
            builder.end().startFinallyBlock();
            builder.startStatement().startStaticCall(this.types.NodeUtil, "popEncapsulatingNode").string("prev_").end().end();
            builder.end();
            ExportsGenerator.injectCachedAssertions(this.model, execute);
        }
        cachedToUncached.addOptional(this.createGenericCastMethod(this.model));
        genClass.add(cachedToUncached);
        CodeTypeElement uncachedDispatch = GeneratorUtils.createClass(this.model, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), "UncachedDispatch", libraryTypeMirror);
        getCost = uncachedDispatch.add(CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.Node, "getCost")));
        getCost.createBuilder().startReturn().staticReference(ElementUtils.findVariableElement(this.types.NodeCost, "MEGAMORPHIC")).end();
        for (MessageObjects message : methods) {
            CodeExecutableElement execute = uncachedDispatch.add(CodeExecutableElement.cloneNoAnnotations(message.model.getExecutable()));
            execute.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.CompilerDirectives_TruffleBoundary));
            execute.renameArguments("receiver_");
            LibraryGenerator.removeAbstractModifiers(execute);
            builder = execute.createBuilder();
            if (message.model.getName().equals(ACCEPTS)) {
                builder.returnTrue();
                continue;
            }
            builder.startReturn().startCall("INSTANCE.getUncached(receiver_)", execute.getSimpleName().toString());
            for (VariableElement var : execute.getParameters()) {
                builder.string(var.getSimpleName().toString());
            }
            builder.end().end();
        }
        uncachedDispatch.addOptional(this.createGenericCastMethod(this.model));
        CodeExecutableElement isAdoptable = uncachedDispatch.add(CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.Node, "isAdoptable")));
        isAdoptable.createBuilder().returnFalse();
        genClass.add(uncachedDispatch);
        CodeTypeElement cachedDispatch = GeneratorUtils.createClass(this.model, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.ABSTRACT, Modifier.STATIC), "CachedDispatch", libraryTypeMirror);
        CodeExecutableElement getLimit = cachedDispatch.add(new CodeExecutableElement(ElementUtils.modifiers(Modifier.ABSTRACT), this.context.getType(Integer.TYPE), "getLimit", new CodeVariableElement[0]));
        CodeVariableElement codeVariableElement = cachedDispatch.add(new CodeVariableElement(ElementUtils.modifiers(new Modifier[0]), libraryTypeMirror, "library"));
        codeVariableElement.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.Node_Child));
        CodeVariableElement nextField = cachedDispatch.add(new CodeVariableElement(ElementUtils.modifiers(new Modifier[0]), cachedDispatch.asType(), "next"));
        nextField.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.Node_Child));
        cachedDispatch.add(GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(new Modifier[0]), cachedDispatch));
        for (MessageObjects message : methods) {
            CodeExecutableElement execute = cachedDispatch.add(CodeExecutableElement.cloneNoAnnotations(message.model.getExecutable()));
            execute.renameArguments("receiver_");
            LibraryGenerator.removeAbstractModifiers(execute);
            builder = execute.createBuilder();
            if (message.model.getName().equals(ACCEPTS)) {
                builder.returnTrue();
                continue;
            }
            execute.getAnnotationMirrors().add(this.createExplodeLoop());
            builder.startDoBlock();
            builder.declaration(cachedDispatch.asType(), "current", "this");
            builder.startDoBlock();
            builder.declaration(libraryTypeMirror, "thisLibrary", "current.library");
            builder.startIf().string("thisLibrary != null && thisLibrary.accepts(receiver_)").end().startBlock();
            builder.startReturn().startCall("thisLibrary", execute.getSimpleName().toString());
            for (VariableElement var : execute.getParameters()) {
                builder.string(var.getSimpleName().toString());
            }
            builder.end().end();
            builder.end();
            builder.statement("current = current.next");
            builder.end().startDoWhile().string("current != null").end().end();
            builder.startStatement().startStaticCall(this.types.CompilerDirectives, "transferToInterpreterAndInvalidate").end().end();
            builder.statement("specialize(receiver_)");
            builder.end().startDoWhile().string("true").end();
            builder.end();
        }
        cachedDispatch.addOptional(this.createGenericCastMethod(this.model));
        CodeTypeElement cachedDispatchNext = GeneratorUtils.createClass(this.model, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), "CachedDispatchNext", cachedDispatch.asType());
        cachedDispatchNext.add(GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(new Modifier[0]), cachedDispatchNext));
        CodeExecutableElement getLimitNext = cachedDispatchNext.add(CodeExecutableElement.clone(getLimit));
        LibraryGenerator.removeAbstractModifiers(getLimitNext);
        builder = getLimitNext.createBuilder();
        builder.startThrow().startNew(this.context.getType(AssertionError.class)).end().end();
        genClass.add(cachedDispatchNext);
        DeclaredType nodeCost = this.types.NodeCost;
        getCost = cachedDispatchNext.add(CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.Node, "getCost")));
        getCost.createBuilder().startReturn().staticReference(ElementUtils.findVariableElement(nodeCost, "NONE")).end();
        CodeExecutableElement execute = cachedDispatch.add(new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), this.context.getType(Void.TYPE), "specialize", new CodeVariableElement[0]));
        execute.addParameter(new CodeVariableElement(this.model.getSignatureReceiverType(), "receiver_"));
        builder = execute.createBuilder();
        builder.declaration(cachedDispatch.asType(), "current", "this");
        builder.declaration(libraryTypeMirror, "thisLibrary", "current.library");
        builder.startIf().string("thisLibrary == null").end().startBlock();
        builder.statement("this.library = insert(INSTANCE.create(receiver_))");
        builder.end().startElseBlock();
        builder.declaration(this.context.getType(Lock.class), "lock", "getLock()");
        builder.statement("lock.lock()");
        builder.startTryBlock();
        builder.declaration("int", "count", "0");
        builder.startDoBlock();
        builder.declaration(libraryTypeMirror, "currentLibrary", "current.library");
        builder.startIf().string("currentLibrary != null && currentLibrary.accepts(receiver_)").end().startBlock();
        builder.returnStatement();
        builder.end();
        builder.statement("count++");
        builder.statement("current = current.next");
        builder.end().startDoWhile().string("current != null").end();
        builder.startIf().string("count >= getLimit()").end().startBlock();
        builder.startStatement().string("this.library = insert(").startNew(cachedToUncached.asType()).end().string(")").end();
        builder.statement("this.next = null");
        builder.end().startElseBlock();
        builder.startStatement().string("this.next = insert(");
        builder.startNew(cachedDispatchNext.asType()).string("INSTANCE.create(receiver_)").string("next").end();
        builder.string(")");
        builder.end();
        builder.end();
        builder.end();
        builder.end().startFinallyBlock();
        builder.statement("lock.unlock()");
        builder.end();
        builder.end();
        CodeTypeElement cachedDispatchFirst = GeneratorUtils.createClass(this.model, null, ElementUtils.modifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), "CachedDispatchFirst", cachedDispatch.asType());
        CodeVariableElement limit = cachedDispatchFirst.add(new CodeVariableElement(ElementUtils.modifiers(Modifier.PRIVATE, Modifier.FINAL), this.context.getType(Integer.TYPE), "limit_"));
        cachedDispatchFirst.add(GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(new Modifier[0]), cachedDispatchFirst));
        CodeExecutableElement getLimitFirst = cachedDispatchFirst.add(CodeExecutableElement.clone(getLimit));
        LibraryGenerator.removeAbstractModifiers(getLimitFirst);
        getLimitFirst.createBuilder().startReturn().string("this.", limit.getName()).end();
        genClass.add(cachedDispatchFirst);
        getCost = cachedDispatchFirst.add(CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.Node, "getCost")));
        builder = getCost.createBuilder();
        builder.startIf().string("this.library").instanceOf(cachedToUncached.asType()).end().startBlock();
        builder.startReturn().staticReference(ElementUtils.findVariableElement(nodeCost, "MEGAMORPHIC")).end();
        builder.end();
        builder.declaration(cachedDispatch.asType(), "current", "this");
        builder.statement("int count = 0");
        builder.startDoBlock();
        builder.startIf().string("current.library != null").end().startBlock();
        builder.statement("count++");
        builder.end();
        builder.statement("current = current.next");
        builder.end().startDoWhile().string("current != null").end().end();
        builder.startReturn().startStaticCall(nodeCost, "fromCount").string("count").end().end();
        genClass.add(cachedDispatch);
        CodeExecutableElement createCachedDispatch = CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.LibraryFactory, "createDispatchImpl"));
        createCachedDispatch.getModifiers().remove((Object)Modifier.ABSTRACT);
        createCachedDispatch.setReturnType(libraryTypeMirror);
        createCachedDispatch.renameArguments("limit");
        builder = createCachedDispatch.createBuilder();
        builder.startReturn().startNew(cachedDispatchFirst.asType()).string("null").string("null").string("limit").end().end();
        genClass.add(createCachedDispatch);
        CodeExecutableElement createUncachedDispatch = genClass.add(CodeExecutableElement.clone(ElementUtils.findExecutableElement(this.types.LibraryFactory, "createUncachedDispatch")));
        createUncachedDispatch.setReturnType(libraryTypeMirror);
        createUncachedDispatch.getModifiers().remove((Object)Modifier.ABSTRACT);
        createUncachedDispatch.createBuilder().startReturn().startNew(uncachedDispatch.asType()).end().end();
        CodeExecutableElement implConstructor = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PRIVATE), null, genClass.getSimpleName().toString(), new CodeVariableElement[0]);
        genClass.add(implConstructor);
        builder = implConstructor.createBuilder();
        builder.startStatement();
        builder.startSuperCall().staticReference(libraryClassLiteral);
        builder.startStaticCall(this.context.getType(Collections.class), "unmodifiableList");
        builder.startStaticCall(this.context.getType(Arrays.class), "asList");
        for (MessageObjects message : methods) {
            if (message.messageField == null) continue;
            builder.field(null, message.messageField);
        }
        builder.end().end();
        builder.end();
        builder.end();
        genClass.addAll(this.libraryConstants.values());
        return Arrays.asList(genClass);
    }

    private TypeMirror[] createDefaultImpl(CodeTypeElement genClass) {
        ExportsLibrary defaultExportsLibrary = this.model.getObjectExports();
        if (defaultExportsLibrary == null) {
            return null;
        }
        ExportsGenerator exportGenerator = new ExportsGenerator(this.libraryConstants);
        CodeTypeElement uncachedClass = exportGenerator.createUncached(defaultExportsLibrary);
        CodeTypeElement cacheClass = exportGenerator.createCached(defaultExportsLibrary);
        CodeTypeElement resolvedExports = exportGenerator.createResolvedExports(defaultExportsLibrary, "Default", cacheClass, uncachedClass);
        resolvedExports.add(cacheClass);
        resolvedExports.add(uncachedClass);
        genClass.add(resolvedExports);
        return new TypeMirror[]{defaultExportsLibrary.getTemplateType().asType(), resolvedExports.asType()};
    }

    private CodeAnnotationMirror createSuppressWarningsUnchecked() {
        CodeAnnotationMirror suppressWarnings = new CodeAnnotationMirror(this.context.getDeclaredType(SuppressWarnings.class));
        suppressWarnings.setElementValue(suppressWarnings.findExecutableElement("value"), new CodeAnnotationValue(Arrays.asList(new CodeAnnotationValue("unchecked"))));
        return suppressWarnings;
    }

    private CodeExecutableElement createGenericCastMethod(LibraryData library) {
        if (!library.isDynamicDispatch()) {
            return null;
        }
        CodeExecutableElement castMethod = CodeExecutableElement.cloneNoAnnotations(ElementUtils.findMethod(this.types.DynamicDispatchLibrary, "cast"));
        castMethod.getModifiers().remove((Object)Modifier.ABSTRACT);
        castMethod.renameArguments("receiver");
        CodeTreeBuilder builder = castMethod.createBuilder();
        builder.startReturn().string("receiver").end();
        return castMethod;
    }

    private static void injectReceiverType(CodeExecutableElement method, int receiverIndex, TypeMirror type) {
        if (type == null) {
            throw new AssertionError();
        }
        CodeVariableElement receiverParameter = (CodeVariableElement)method.getParameters().get(receiverIndex);
        Element foundParameter = null;
        int foundIndex = 0;
        if (receiverParameter.asType().getKind() == TypeKind.TYPEVAR) {
            for (TypeParameterElement typeParameter : method.getTypeParameters()) {
                if (ElementUtils.elementEquals(((TypeVariable)receiverParameter.asType()).asElement(), typeParameter)) {
                    foundParameter = typeParameter;
                    break;
                }
                ++foundIndex;
            }
        }
        if (foundParameter != null) {
            CodeTypeParameterElement newParameter = new CodeTypeParameterElement(foundParameter.getSimpleName(), new TypeMirror[0]);
            newParameter.getBounds().add(type);
            method.getTypeParameters().set(foundIndex, newParameter);
        } else {
            receiverParameter.setType(type);
        }
    }

    private static void removeAbstractModifiers(CodeExecutableElement uncachedImpl) {
        uncachedImpl.getModifiers().remove((Object)Modifier.ABSTRACT);
        uncachedImpl.getModifiers().remove((Object)Modifier.DEFAULT);
    }

    private static String createConstantName(String name) {
        StringBuilder newName = new StringBuilder();
        boolean wasLowerCase = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                if (wasLowerCase) {
                    newName.append('_');
                }
                newName.append(c);
                continue;
            }
            wasLowerCase = true;
            newName.append(Character.toUpperCase(c));
        }
        return newName.toString();
    }

    private CodeAnnotationMirror createExplodeLoop() {
        VariableElement kindValue;
        DeclaredType explodeLoopType = this.types.ExplodeLoop;
        CodeAnnotationMirror explodeLoop = new CodeAnnotationMirror(explodeLoopType);
        DeclaredType loopExplosionKind = this.types.ExplodeLoop_LoopExplosionKind;
        if (loopExplosionKind != null && (kindValue = ElementUtils.findVariableElement(loopExplosionKind, "FULL_EXPLODE_UNTIL_RETURN")) != null) {
            explodeLoop.setElementValue(ElementUtils.findExecutableElement(explodeLoopType, "kind"), new CodeAnnotationValue(kindValue));
        }
        return explodeLoop;
    }

    private CodeExecutableElement createGenericDispatch(List<MessageObjects> methods, CodeTypeElement messageClass) {
        CodeExecutableElement reflectionGenericDispatch = GeneratorUtils.override(this.types.LibraryFactory, "genericDispatch");
        reflectionGenericDispatch.getParameters().set(0, new CodeVariableElement(this.types.Library, "library"));
        reflectionGenericDispatch.renameArguments("originalLib", "receiver", "message", "args", "offset");
        reflectionGenericDispatch.getModifiers().remove((Object)Modifier.ABSTRACT);
        CodeTreeBuilder builder = reflectionGenericDispatch.createBuilder();
        builder.declaration(this.model.getTemplateType().asType(), "lib", builder.create().cast(this.model.getTemplateType().asType()).string("originalLib"));
        builder.declaration(messageClass.asType(), "messageImpl", builder.create().cast(messageClass.asType()).string("message").build());
        builder.startIf().string("messageImpl.getParameterCount() - 1 != args.length - offset").end().startBlock();
        builder.startStatement().startStaticCall(this.types.CompilerDirectives, "transferToInterpreter").end().end();
        builder.startThrow().startNew(this.context.getType(IllegalArgumentException.class)).doubleQuote("Invalid number of arguments.").end().end();
        builder.end();
        boolean uncheckedCast = false;
        builder.startSwitch().string("messageImpl.index").end().startBlock();
        for (MessageObjects message : methods) {
            if (message.model.getName().equals(ACCEPTS)) continue;
            builder.startCase();
            builder.string(String.valueOf(message.messageIndex)).end();
            builder.startIndention();
            if (ElementUtils.isVoid(message.model.getExecutable().getReturnType())) {
                builder.startStatement();
            } else {
                builder.startReturn();
            }
            builder.startCall("lib", message.model.getName());
            builder.startGroup();
            if (!ElementUtils.typeEquals(this.context.getType(Object.class), this.model.getSignatureReceiverType())) {
                if (ElementUtils.hasGenericTypes(this.model.getSignatureReceiverType())) {
                    uncheckedCast = true;
                }
                builder.cast(this.model.getSignatureReceiverType());
            }
            builder.string("receiver");
            builder.end();
            int argumentIndex = 0;
            List<? extends VariableElement> parameters = message.model.getExecutable().getParameters();
            for (VariableElement variableElement : parameters.subList(1, parameters.size())) {
                builder.startGroup();
                TypeMirror type = variableElement.asType();
                if (!ElementUtils.typeEquals(this.context.getType(Object.class), type)) {
                    if (ElementUtils.hasGenericTypes(type)) {
                        uncheckedCast = true;
                    }
                    builder.cast(type);
                }
                if (argumentIndex == 0) {
                    builder.string("args[offset]");
                } else {
                    builder.string("args[offset + ", String.valueOf(argumentIndex), "]");
                }
                builder.end();
                ++argumentIndex;
            }
            builder.end().end();
            if (ElementUtils.isVoid(message.model.getExecutable().getReturnType())) {
                builder.statement("return null");
            }
            builder.end();
        }
        builder.end();
        builder.startStatement().startStaticCall(this.types.CompilerDirectives, "transferToInterpreter").end().end();
        builder.startThrow().startNew(this.context.getType(AbstractMethodError.class)).string("message.toString()").end().end();
        if (uncheckedCast) {
            GeneratorUtils.mergeSupressWarnings(reflectionGenericDispatch, "unchecked");
        }
        return reflectionGenericDispatch;
    }

    static String createGenTypeName(LibraryData type) {
        return ElementUtils.firstLetterUpperCase(type.getTemplateType().getSimpleName().toString()) + "Gen";
    }

    class MessageObjects {
        final LibraryMessage model;
        final int messageIndex;
        int cacheIndex;
        CodeVariableElement messageField;

        MessageObjects(LibraryMessage message, int messageIndex) {
            this.model = message;
            this.messageIndex = messageIndex;
        }
    }
}

