/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.interop;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.interop.ForeignAccessFactoryGenerator;
import com.oracle.truffle.dsl.processor.interop.MessageGenerator;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

final class ReadGenerator
extends MessageGenerator {
    private static final int NUMBER_OF_READ = 2;
    private final String targetablePropReadNode;

    ReadGenerator(ProcessingEnvironment processingEnv, AnnotationMirror resolveAnnotation, AnnotationMirror messageResolutionAnnotation, TypeElement element, ForeignAccessFactoryGenerator containingForeignAccessFactory) {
        super(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
        this.targetablePropReadNode = new StringBuilder(this.messageName).replace(0, 1, this.messageName.substring(0, 1).toUpperCase()).append("Node").insert(0, "Targetable").toString();
    }

    @Override
    void appendRootNode(Writer w) throws IOException {
        w.append(this.indent).append("    private static final class ").append(this.rootNodeName).append(" extends RootNode {\n");
        w.append(this.indent).append("        protected ").append(this.rootNodeName).append("() {\n");
        w.append(this.indent).append("            super(null);\n");
        w.append(this.indent).append("        }\n");
        w.append("\n");
        w.append(this.indent).append("        @Child private ").append(this.clazzName).append(" node = ").append(this.getGeneratedDSLNodeQualifiedName()).append(".create();");
        w.append("\n");
        this.appendGetName(w);
        w.append(this.indent).append("        @Override\n");
        w.append(this.indent).append("        public Object execute(VirtualFrame frame) {\n");
        w.append(this.indent).append("            Object receiver = com.oracle.truffle.api.interop.ForeignAccess.getReceiver(frame);\n");
        w.append(this.indent).append("            Object identifier = frame.getArguments()[1];\n");
        w.append(this.indent).append("            try {\n");
        w.append(this.indent).append("                return node.executeWithTarget(frame, receiver, identifier);\n");
        w.append(this.indent).append("            } catch (UnsupportedSpecializationException e) {\n");
        this.appendHandleUnsupportedTypeException(w);
        w.append(this.indent).append("            }\n");
        w.append(this.indent).append("        }\n");
        w.append("\n");
        w.append(this.indent).append("    }\n");
    }

    @Override
    int getParameterCount() {
        return 2;
    }

    @Override
    String getTargetableNodeName() {
        return this.targetablePropReadNode;
    }

    @Override
    public String checkSignature(ExecutableElement method) {
        int expectedNumberOfArguments;
        List<? extends VariableElement> params = method.getParameters();
        boolean hasFrameArgument = false;
        if (params.size() >= 1) {
            TruffleTypes types = ProcessorContext.getInstance().getTypes();
            hasFrameArgument = ElementUtils.areTypesCompatible(params.get(0).asType(), types.VirtualFrame);
        }
        int n = expectedNumberOfArguments = hasFrameArgument ? this.getParameterCount() + 1 : this.getParameterCount();
        if (params.size() != expectedNumberOfArguments) {
            return "Wrong number of arguments. Expected signature: ([frame: VirtualFrame], receiverObject: TruffleObject, identifier: String)";
        }
        return super.checkSignature(method);
    }
}

