/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.interop;

import com.oracle.truffle.dsl.processor.interop.ExecuteGenerator;
import com.oracle.truffle.dsl.processor.interop.ForeignAccessFactoryGenerator;
import com.oracle.truffle.dsl.processor.interop.GenericGenerator;
import com.oracle.truffle.dsl.processor.interop.InteropDSLProcessor;
import com.oracle.truffle.dsl.processor.interop.InteropNodeGenerator;
import com.oracle.truffle.dsl.processor.interop.KeysGenerator;
import com.oracle.truffle.dsl.processor.interop.ReadGenerator;
import com.oracle.truffle.dsl.processor.interop.UnaryGenerator;
import com.oracle.truffle.dsl.processor.interop.Utils;
import com.oracle.truffle.dsl.processor.interop.WriteGenerator;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;

abstract class MessageGenerator
extends InteropNodeGenerator {
    protected static final String ACCESS_METHOD_NAME = "access";
    protected final String messageName;
    protected final String receiverClassName;
    protected final String rootNodeName;

    MessageGenerator(ProcessingEnvironment processingEnv, AnnotationMirror resolveAnnotation, AnnotationMirror messageResolutionAnnotation, TypeElement element, ForeignAccessFactoryGenerator containingForeignAccessFactory) {
        super(processingEnv, element, containingForeignAccessFactory);
        this.receiverClassName = Utils.getReceiverTypeFullClassName(messageResolutionAnnotation);
        this.messageName = ElementUtils.getAnnotationValue(String.class, resolveAnnotation, "message");
        String mName = this.messageName.substring(this.messageName.lastIndexOf(46) + 1);
        this.rootNodeName = mName + "RootNode";
    }

    public void appendGetName(Writer w) throws IOException {
        w.append(this.indent).append("        @Override\n");
        w.append(this.indent).append("        public String getName() {\n");
        String rootName = "Interop::" + this.messageName + "::";
        w.append(this.indent).append("            return \"").append(rootName).append("\" + " + this.receiverClassName + ".class.getName();\n");
        w.append(this.indent).append("        }\n\n");
    }

    @Override
    public void appendNode(Writer w) throws IOException {
        Utils.appendMessagesGeneratedByInformation(w, this.indent, ElementUtils.getQualifiedName(this.element), null);
        w.append(this.indent);
        Utils.appendVisibilityModifier(w, this.element);
        w.append("abstract static class ").append(this.clazzName).append(" extends ").append(this.userClassName).append(" {\n");
        this.appendExecuteWithTarget(w);
        this.appendSpecializations(w);
        this.appendRootNode(w);
        this.appendRootNodeFactory(w);
        w.append(this.indent).append("}\n");
    }

    public final List<ExecutableElement> getAccessMethods() {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        for (Element element : this.element.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals(ACCESS_METHOD_NAME)) continue;
            ExecutableElement method = (ExecutableElement)element;
            methods.add(method);
        }
        return methods;
    }

    abstract int getParameterCount();

    public String checkSignature(ExecutableElement method) {
        if (method.getThrownTypes().size() > 0) {
            return "Method access must not throw a checked exception. Use an InteropException (e.g. UnknownIdentifierException.raise() ) to report an error to the host language.";
        }
        return null;
    }

    abstract String getTargetableNodeName();

    void appendExecuteWithTarget(Writer w) throws IOException {
        w.append(this.indent).append("    public abstract Object executeWithTarget(VirtualFrame frame");
        for (int i = 0; i < Math.max(1, this.getParameterCount()); ++i) {
            w.append(", ").append("Object ").append("o").append(String.valueOf(i));
        }
        w.append(");\n");
    }

    void appendSpecializations(Writer w) throws IOException {
        String sep = "";
        for (ExecutableElement method : this.getAccessMethods()) {
            List<? extends VariableElement> params = method.getParameters();
            w.append(this.indent).append("    @Specialization\n");
            w.append(this.indent).append("    protected Object ").append(ACCESS_METHOD_NAME).append("WithTarget");
            w.append("(");
            sep = "";
            for (VariableElement variableElement : params) {
                w.append(sep).append(ElementUtils.getUniqueIdentifier(variableElement.asType())).append(" ").append(variableElement.getSimpleName());
                sep = ", ";
            }
            w.append(") {\n");
            w.append(this.indent).append("        return ").append(ACCESS_METHOD_NAME).append("(");
            sep = "";
            for (VariableElement variableElement : params) {
                w.append(sep).append(variableElement.getSimpleName());
                sep = ", ";
            }
            w.append(");\n");
            w.append(this.indent).append("    }\n");
        }
    }

    abstract void appendRootNode(Writer var1) throws IOException;

    void appendRootNodeFactory(Writer w) throws IOException {
        w.append(this.indent).append("    public static RootNode createRoot() {\n");
        w.append(this.indent).append("        return new ").append(this.rootNodeName).append("();\n");
        w.append(this.indent).append("    }\n");
    }

    @Override
    public String toString() {
        return this.clazzName;
    }

    public static MessageGenerator getGenerator(ProcessingEnvironment processingEnv, AnnotationMirror resolveAnnotation, AnnotationMirror messageResolutionAnnotation, TypeElement element, ForeignAccessFactoryGenerator containingForeignAccessFactory) {
        SuppressWarnings suppress;
        String messageName = ElementUtils.getAnnotationValue(String.class, resolveAnnotation, "message");
        if (!(Utils.getMessage(processingEnv, messageName) || (suppress = element.getAnnotation(SuppressWarnings.class)) != null && Arrays.asList(suppress.value()).contains("unknown-message"))) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unknown message " + messageName + " (add @SuppressWarnings(\"unknown-message\") to ignore this warning)", element);
        }
        if ("READ".toString().equalsIgnoreCase(messageName) || "KEY_INFO".toString().equalsIgnoreCase(messageName) || "REMOVE".toString().equalsIgnoreCase(messageName)) {
            return new ReadGenerator(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
        }
        if ("WRITE".toString().equalsIgnoreCase(messageName)) {
            return new WriteGenerator(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
        }
        if ("IS_NULL".toString().equalsIgnoreCase(messageName) || "IS_EXECUTABLE".toString().equalsIgnoreCase(messageName) || "IS_BOXED".toString().equalsIgnoreCase(messageName) || "HAS_SIZE".toString().equalsIgnoreCase(messageName) || "GET_SIZE".toString().equalsIgnoreCase(messageName) || "UNBOX".toString().equalsIgnoreCase(messageName) || "IS_INSTANTIABLE".toString().equalsIgnoreCase(messageName) || "HAS_KEYS".toString().equalsIgnoreCase(messageName) || "IS_POINTER".toString().equalsIgnoreCase(messageName) || "AS_POINTER".toString().equalsIgnoreCase(messageName) || "TO_NATIVE".toString().equalsIgnoreCase(messageName)) {
            return new UnaryGenerator(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
        }
        if ("KEYS".toString().equalsIgnoreCase(messageName)) {
            return new KeysGenerator(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
        }
        if ("EXECUTE".toString().equalsIgnoreCase(messageName) || "INVOKE".toString().equalsIgnoreCase(messageName) || "NEW".toString().equalsIgnoreCase(messageName)) {
            return new ExecuteGenerator(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
        }
        assert (!InteropDSLProcessor.KNOWN_MESSAGES.contains(messageName));
        return new GenericGenerator(processingEnv, resolveAnnotation, messageResolutionAnnotation, element, containingForeignAccessFactory);
    }

    protected void appendHandleUnsupportedTypeException(Writer w) throws IOException {
        w.append(this.indent).append("                if (e.getNode() instanceof ").append(this.clazzName).append(") {\n");
        w.append(this.indent).append("                  throw UnsupportedTypeException.raise(e, e.getSuppliedValues());\n");
        w.append(this.indent).append("                } else {\n");
        w.append(this.indent).append("                  throw e;\n");
        w.append(this.indent).append("                }\n");
    }

    public String getMessageName() {
        return this.messageName;
    }
}

