/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.AnnotationProcessor;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.generator.NodeCodeGenerator;
import com.oracle.truffle.dsl.processor.generator.TypeSystemCodeGenerator;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.library.ExportsData;
import com.oracle.truffle.dsl.processor.library.ExportsGenerator;
import com.oracle.truffle.dsl.processor.library.ExportsParser;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.library.LibraryGenerator;
import com.oracle.truffle.dsl.processor.library.LibraryParser;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import com.oracle.truffle.dsl.processor.parser.AbstractParser;
import com.oracle.truffle.dsl.processor.parser.NodeParser;
import com.oracle.truffle.dsl.processor.parser.TypeSystemParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class TruffleProcessor
extends AbstractProcessor
implements ProcessorContext.ProcessCallback {
    private final ThreadLocal<List<AnnotationProcessor<?>>> currentProcessors = new ThreadLocal();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            this.processImpl(roundEnv);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processImpl(RoundEnvironment env) {
        try {
            ProcessorContext.enter(this.processingEnv, this);
            List<AnnotationProcessor<?>> processors = TruffleProcessor.createGenerators();
            this.currentProcessors.set(processors);
            for (AnnotationProcessor<?> generator : processors) {
                AbstractParser<?> parser = generator.getParser();
                if (parser.getAnnotationType() != null) {
                    for (Element element : env.getElementsAnnotatedWith(ElementUtils.castTypeElement(parser.getAnnotationType()))) {
                        TruffleProcessor.processElement(generator, element, false);
                    }
                    DeclaredType repeat = parser.getRepeatAnnotationType();
                    if (repeat != null) {
                        for (Element e2 : env.getElementsAnnotatedWith(ElementUtils.castTypeElement(repeat))) {
                            TruffleProcessor.processElement(generator, e2, false);
                        }
                    }
                }
                for (DeclaredType declaredType : parser.getTypeDelegatedAnnotationTypes()) {
                    for (Element element : env.getElementsAnnotatedWith(ElementUtils.castTypeElement(declaredType))) {
                        Optional<TypeElement> processedType = parser.isDelegateToRootDeclaredType() ? ElementUtils.findRootEnclosingType(element) : ElementUtils.findParentEnclosingType(element);
                        TruffleProcessor.processElement(generator, processedType.orElseThrow(AssertionError::new), false);
                    }
                }
            }
        }
        finally {
            ProcessorContext.leave();
            this.currentProcessors.set(null);
        }
    }

    private static void processElement(AnnotationProcessor<?> generator, Element e, boolean callback) {
        try {
            generator.process(e, callback);
        }
        catch (Throwable e1) {
            TruffleProcessor.handleThrowable(generator, e1, e);
        }
    }

    static void handleThrowable(AnnotationProcessor<?> generator, Throwable t, Element e) {
        String message = "Uncaught error in " + (generator != null ? generator.getClass().getSimpleName() : null) + " while processing " + e + " ";
        ProcessorContext.getInstance().getEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, message + ": " + ElementUtils.printException(t), e);
    }

    @Override
    public void callback(TypeElement template) {
        for (AnnotationProcessor<?> generator : this.currentProcessors.get()) {
            AnnotationMirror annotation;
            DeclaredType annotationType = generator.getParser().getAnnotationType();
            if (annotationType == null || (annotation = ElementUtils.findAnnotationMirror((Element)template, (TypeMirror)annotationType)) == null) continue;
            TruffleProcessor.processElement(generator, template, true);
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> annotations = new HashSet<String>();
        annotations.add("com.oracle.truffle.api.dsl.Specialization");
        annotations.add("com.oracle.truffle.api.dsl.Fallback");
        annotations.add("com.oracle.truffle.api.dsl.TypeSystemReference");
        annotations.add("com.oracle.truffle.api.dsl.Executed");
        annotations.add("com.oracle.truffle.api.dsl.NodeChild");
        annotations.add("com.oracle.truffle.api.dsl.NodeChildren");
        annotations.add("com.oracle.truffle.api.dsl.TypeSystem");
        annotations.add("com.oracle.truffle.api.library.GenerateLibrary");
        annotations.add("com.oracle.truffle.api.library.ExportLibrary");
        annotations.add("com.oracle.truffle.api.library.ExportMessage");
        annotations.add("com.oracle.truffle.api.library.ExportLibrary.Repeat");
        return annotations;
    }

    private static List<AnnotationProcessor<?>> createGenerators() {
        ArrayList generators = new ArrayList();
        generators.add(new AnnotationProcessor<TypeSystemData>(new TypeSystemParser(), new TypeSystemCodeGenerator()));
        generators.add(new AnnotationProcessor<NodeData>(NodeParser.createDefaultParser(), new NodeCodeGenerator()));
        generators.add(new AnnotationProcessor<LibraryData>(new LibraryParser(), new LibraryGenerator()));
        generators.add(new AnnotationProcessor<ExportsData>(new ExportsParser(), new ExportsGenerator(new LinkedHashMap<String, CodeVariableElement>())));
        return generators;
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        this.processingEnv = env;
        super.init(env);
    }
}

