/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.runtime;

import java.util.Formatter;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.runtime.JVMCIRuntime;
import jdk.vm.ci.services.Services;

public class JVMCI {
    @NativeImageReinitialize
    private static volatile JVMCIRuntime runtime;
    @NativeImageReinitialize
    private static boolean initializing;

    private static native JVMCIRuntime initializeRuntime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JVMCIRuntime getRuntime() {
        JVMCIRuntime result = runtime;
        if (result != null) return result;
        Class<JVMCI> clazz = JVMCI.class;
        synchronized (JVMCI.class) {
            result = runtime;
            if (result != null) return result;
            if (initializing) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            initializing = true;
            try {
                runtime = result = JVMCI.initializeRuntime();
            }
            catch (UnsatisfiedLinkError e) {
                String javaHome = Services.getSavedProperty((String)"java.home");
                String vmName = Services.getSavedProperty((String)"java.vm.name");
                Formatter errorMessage = new Formatter();
                errorMessage.format("The VM does not support the JVMCI API.%n", new Object[0]);
                errorMessage.format("Currently used Java home directory is %s.%n", javaHome);
                errorMessage.format("Currently used VM configuration is: %s", vmName);
                throw new UnsupportedOperationException(errorMessage.toString());
            }
            finally {
                initializing = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }
}

