/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;

public interface Signature {
    public int getParameterCount(boolean var1);

    public JavaType getParameterType(int var1, ResolvedJavaType var2);

    default public JavaKind getParameterKind(int index) {
        return this.getParameterType(index, null).getJavaKind();
    }

    public JavaType getReturnType(ResolvedJavaType var1);

    default public JavaKind getReturnKind() {
        return this.getReturnType(null).getJavaKind();
    }

    default public String toMethodDescriptor() {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < this.getParameterCount(false); ++i) {
            sb.append(this.getParameterType(i, null).getName());
        }
        sb.append(')').append(this.getReturnType(null).getName());
        return sb.toString();
    }

    default public JavaType[] toParameterTypes(JavaType receiverType) {
        JavaType[] result;
        int args = this.getParameterCount(false);
        int i = 0;
        if (receiverType != null) {
            result = new JavaType[args + 1];
            result[0] = receiverType;
            i = 1;
        } else {
            result = new JavaType[args];
        }
        for (int j = 0; j < args; ++j) {
            result[i + j] = this.getParameterType(j, null);
        }
        return result;
    }

    default public JavaKind[] toParameterKinds(boolean receiver) {
        JavaKind[] result;
        int args = this.getParameterCount(false);
        int i = 0;
        if (receiver) {
            result = new JavaKind[args + 1];
            result[0] = JavaKind.Object;
            i = 1;
        } else {
            result = new JavaKind[args];
        }
        for (int j = 0; j < args; ++j) {
            result[i + j] = this.getParameterKind(j);
        }
        return result;
    }
}

