/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import java.util.ArrayList;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.SuppressFBWarnings;

public class LocalVariableTable {
    private final Local[] locals;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="caller transfers ownership of `locals`")
    public LocalVariableTable(Local[] locals) {
        this.locals = locals;
    }

    public Local getLocal(int slot, int bci) {
        Local result = null;
        for (Local local : this.locals) {
            if (local.getSlot() != slot || local.getStartBCI() > bci || local.getEndBCI() < bci) continue;
            if (result == null) {
                result = local;
                continue;
            }
            throw new IllegalStateException("Locals overlap!");
        }
        return result;
    }

    public Local[] getLocals() {
        return (Local[])this.locals.clone();
    }

    public Local[] getLocalsAt(int bci) {
        ArrayList<Local> result = new ArrayList<Local>();
        for (Local l : this.locals) {
            if (l.getStartBCI() > bci || bci > l.getEndBCI()) continue;
            result.add(l);
        }
        return result.toArray(new Local[result.size()]);
    }
}

