/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import jdk.vm.ci.meta.AbstractJavaProfile;
import jdk.vm.ci.meta.AbstractProfiledItem;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;

public final class JavaTypeProfile
extends AbstractJavaProfile<ProfiledType, ResolvedJavaType> {
    private static final ProfiledType[] EMPTY_ARRAY = new ProfiledType[0];
    private final TriState nullSeen;

    public JavaTypeProfile(TriState nullSeen, double notRecordedProbability, ProfiledType[] pitems) {
        super(notRecordedProbability, (AbstractProfiledItem[])pitems);
        this.nullSeen = nullSeen;
    }

    public TriState getNullSeen() {
        return this.nullSeen;
    }

    public ProfiledType[] getTypes() {
        return (ProfiledType[])this.getItems();
    }

    public JavaTypeProfile restrict(JavaTypeProfile otherProfile) {
        if (otherProfile.getNotRecordedProbability() > 0.0) {
            return this;
        }
        if (this.getNotRecordedProbability() > 0.0) {
            return otherProfile;
        }
        ArrayList<ProfiledType> result = new ArrayList<ProfiledType>();
        for (int i = 0; i < ((ProfiledType[])this.getItems()).length; ++i) {
            ProfiledType ptype = ((ProfiledType[])this.getItems())[i];
            ResolvedJavaType type = (ResolvedJavaType)ptype.getItem();
            if (!otherProfile.isIncluded(type)) continue;
            result.add(ptype);
        }
        TriState newNullSeen = otherProfile.getNullSeen() == TriState.FALSE ? TriState.FALSE : this.getNullSeen();
        double newNotRecorded = this.getNotRecordedProbability();
        return this.createAdjustedProfile(result, newNullSeen, newNotRecorded);
    }

    public JavaTypeProfile restrict(ResolvedJavaType declaredType, boolean nonNull) {
        ArrayList<ProfiledType> result = new ArrayList<ProfiledType>();
        for (int i = 0; i < ((ProfiledType[])this.getItems()).length; ++i) {
            ProfiledType ptype = ((ProfiledType[])this.getItems())[i];
            ResolvedJavaType type = (ResolvedJavaType)ptype.getItem();
            if (!declaredType.isAssignableFrom(type)) continue;
            result.add(ptype);
        }
        TriState newNullSeen = nonNull ? TriState.FALSE : this.getNullSeen();
        double newNotRecorded = this.getNotRecordedProbability();
        if (((ProfiledType[])this.getItems()).length != 0) {
            newNotRecorded *= (double)result.size() / (double)((ProfiledType[])this.getItems()).length;
        }
        return this.createAdjustedProfile(result, newNullSeen, newNotRecorded);
    }

    private JavaTypeProfile createAdjustedProfile(ArrayList<ProfiledType> result, TriState newNullSeen, double newNotRecorded) {
        if (result.size() != ((ProfiledType[])this.getItems()).length || newNotRecorded != this.getNotRecordedProbability() || newNullSeen != this.getNullSeen()) {
            double factor;
            if (result.size() == 0) {
                return new JavaTypeProfile(newNullSeen, 1.0, EMPTY_ARRAY);
            }
            if (result.size() == ((ProfiledType[])this.getItems()).length) {
                factor = 1.0;
            } else {
                double probabilitySum = 0.0;
                for (int i = 0; i < result.size(); ++i) {
                    probabilitySum += result.get(i).getProbability();
                }
                factor = 1.0 / (probabilitySum += newNotRecorded);
                assert (factor >= 1.0);
            }
            ProfiledType[] newResult = new ProfiledType[result.size()];
            for (int i = 0; i < newResult.length; ++i) {
                ProfiledType curType = result.get(i);
                newResult[i] = new ProfiledType((ResolvedJavaType)curType.getItem(), Math.min(1.0, curType.getProbability() * factor));
            }
            double newNotRecordedTypeProbability = Math.min(1.0, newNotRecorded * factor);
            return new JavaTypeProfile(newNullSeen, newNotRecordedTypeProbability, newResult);
        }
        return this;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.nullSeen.equals((Object)((JavaTypeProfile)other).nullSeen);
    }

    @Override
    public int hashCode() {
        return this.nullSeen.hashCode() + super.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("JavaTypeProfile<nullSeen=").append((Object)this.getNullSeen()).append(", types=[");
        for (int j = 0; j < this.getTypes().length; ++j) {
            if (j != 0) {
                buf.append(", ");
            }
            ProfiledType ptype = this.getTypes()[j];
            buf.append(String.format("%.6f:%s", ptype.getProbability(), ptype.getType()));
        }
        return buf.append(String.format("], notRecorded:%.6f>", this.getNotRecordedProbability())).toString();
    }

    public boolean allTypesRecorded() {
        return this.getNotRecordedProbability() == 0.0;
    }

    public ResolvedJavaType asSingleType() {
        if (this.allTypesRecorded() && this.getTypes().length == 1) {
            return this.getTypes()[0].getType();
        }
        return null;
    }

    public static class ProfiledType
    extends AbstractProfiledItem<ResolvedJavaType> {
        public ProfiledType(ResolvedJavaType type, double probability) {
            super(type, probability);
            assert (type.isArray() || type.isConcrete()) : type + " " + Modifier.toString(type.getModifiers());
        }

        public ResolvedJavaType getType() {
            return (ResolvedJavaType)this.getItem();
        }

        @Override
        public String toString() {
            return String.format("%.6f#%s", this.probability, this.item);
        }
    }
}

