/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class Assumptions
implements Iterable<Assumption> {
    private final Set<Assumption> assumptions = new HashSet<Assumption>();

    public boolean isEmpty() {
        return this.assumptions.isEmpty();
    }

    public int hashCode() {
        throw new UnsupportedOperationException("hashCode");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Assumptions) {
            Assumptions that = (Assumptions)obj;
            return this.assumptions.equals(that.assumptions);
        }
        return false;
    }

    @Override
    public Iterator<Assumption> iterator() {
        return this.assumptions.iterator();
    }

    public void recordNoFinalizableSubclassAssumption(ResolvedJavaType receiverType) {
        this.record(new NoFinalizableSubclass(receiverType));
    }

    public void recordConcreteSubtype(ResolvedJavaType context, ResolvedJavaType subtype) {
        this.record(new ConcreteSubtype(context, subtype));
    }

    public void recordConcreteMethod(ResolvedJavaMethod method, ResolvedJavaType context, ResolvedJavaMethod impl) {
        this.record(new ConcreteMethod(method, context, impl));
    }

    public void record(Assumption assumption) {
        this.assumptions.add(assumption);
    }

    public Assumption[] toArray() {
        return this.assumptions.toArray(new Assumption[this.assumptions.size()]);
    }

    public void record(Assumptions other) {
        assert (other != this);
        this.assumptions.addAll(other.assumptions);
    }

    public String toString() {
        return "Assumptions[" + this.assumptions + "]";
    }

    public static final class CallSiteTargetValue
    extends Assumption {
        public final JavaConstant callSite;
        public final JavaConstant methodHandle;

        public CallSiteTargetValue(JavaConstant callSite, JavaConstant methodHandle) {
            this.callSite = callSite;
            this.methodHandle = methodHandle;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.callSite.hashCode();
            result = 31 * result + this.methodHandle.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CallSiteTargetValue) {
                CallSiteTargetValue other = (CallSiteTargetValue)obj;
                return this.callSite.equals(other.callSite) && this.methodHandle.equals(other.methodHandle);
            }
            return false;
        }

        public String toString() {
            return "CallSiteTargetValue[callSite=" + this.callSite + ", methodHandle=" + this.methodHandle + "]";
        }
    }

    public static final class ConcreteMethod
    extends Assumption {
        public final ResolvedJavaMethod method;
        public final ResolvedJavaType context;
        public final ResolvedJavaMethod impl;

        public ConcreteMethod(ResolvedJavaMethod method, ResolvedJavaType context, ResolvedJavaMethod impl) {
            this.method = method;
            this.context = context;
            this.impl = impl;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.method.hashCode();
            result = 31 * result + this.context.hashCode();
            result = 31 * result + this.impl.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConcreteMethod) {
                ConcreteMethod other = (ConcreteMethod)obj;
                return other.method.equals(this.method) && other.context.equals(this.context) && other.impl.equals(this.impl);
            }
            return false;
        }

        public String toString() {
            return "ConcreteMethod[method=" + this.method.format("%H.%n(%p)%r") + ", context=" + this.context.toJavaName() + ", impl=" + this.impl.format("%H.%n(%p)%r") + "]";
        }
    }

    public static final class LeafType
    extends Assumption {
        public final ResolvedJavaType context;

        public LeafType(ResolvedJavaType context) {
            assert (!context.isLeaf()) : "assumption isn't required for leaf types";
            this.context = context;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.context.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LeafType) {
                LeafType other = (LeafType)obj;
                return other.context.equals(this.context);
            }
            return false;
        }

        public String toString() {
            return "LeafSubtype[context=" + this.context.toJavaName() + "]";
        }
    }

    public static final class ConcreteSubtype
    extends Assumption {
        public final ResolvedJavaType context;
        public final ResolvedJavaType subtype;

        public ConcreteSubtype(ResolvedJavaType context, ResolvedJavaType subtype) {
            this.context = context;
            this.subtype = subtype;
            assert (context.isAbstract());
            assert (subtype.isConcrete() || context.isInterface()) : subtype.toString() + " : " + context.toString();
            assert (!subtype.isArray() || subtype.getElementalType().isFinalFlagSet()) : subtype.toString() + " : " + context.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.context.hashCode();
            result = 31 * result + this.subtype.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConcreteSubtype) {
                ConcreteSubtype other = (ConcreteSubtype)obj;
                return other.context.equals(this.context) && other.subtype.equals(this.subtype);
            }
            return false;
        }

        public String toString() {
            return "ConcreteSubtype[context=" + this.context.toJavaName() + ", subtype=" + this.subtype.toJavaName() + "]";
        }
    }

    public static final class NoFinalizableSubclass
    extends Assumption {
        private ResolvedJavaType receiverType;

        public NoFinalizableSubclass(ResolvedJavaType receiverType) {
            this.receiverType = receiverType;
        }

        public int hashCode() {
            return 31 + this.receiverType.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof NoFinalizableSubclass) {
                NoFinalizableSubclass other = (NoFinalizableSubclass)obj;
                return other.receiverType.equals(this.receiverType);
            }
            return false;
        }

        public String toString() {
            return "NoFinalizableSubclass[receiverType=" + this.receiverType.toJavaName() + "]";
        }
    }

    public static class AssumptionResult<T> {
        Assumption[] assumptions;
        final T result;
        private static final Assumption[] EMPTY = new Assumption[0];

        public AssumptionResult(T result, Assumption ... assumptions) {
            this.result = result;
            this.assumptions = assumptions;
        }

        public AssumptionResult(T result) {
            this(result, EMPTY);
        }

        public T getResult() {
            return this.result;
        }

        public boolean isAssumptionFree() {
            return this.assumptions.length == 0;
        }

        public void add(AssumptionResult<T> other) {
            Assumption[] newAssumptions = Arrays.copyOf(this.assumptions, this.assumptions.length + other.assumptions.length);
            System.arraycopy(other.assumptions, 0, newAssumptions, this.assumptions.length, other.assumptions.length);
            this.assumptions = newAssumptions;
        }

        public boolean canRecordTo(Assumptions target) {
            return this.assumptions.length == 0 || target != null;
        }

        public void recordTo(Assumptions target) {
            assert (this.canRecordTo(target));
            if (this.assumptions.length > 0) {
                for (Assumption assumption : this.assumptions) {
                    target.record(assumption);
                }
            }
        }
    }

    public static abstract class Assumption {
    }
}

