/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.meta;

import jdk.vm.ci.meta.AbstractProfiledItem;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SuppressFBWarnings;

public abstract class AbstractJavaProfile<T extends AbstractProfiledItem<U>, U> {
    private final double notRecordedProbability;
    private final T[] pitems;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="caller transfers ownership of the `pitems` array parameter")
    public AbstractJavaProfile(double notRecordedProbability, T[] pitems) {
        this.pitems = pitems;
        assert (!Double.isNaN(notRecordedProbability));
        this.notRecordedProbability = notRecordedProbability;
        assert (this.isSorted());
        assert (this.totalProbablility() >= 0.0 && this.totalProbablility() <= 1.0001) : this.totalProbablility() + " " + this;
    }

    private double totalProbablility() {
        double total = this.notRecordedProbability;
        for (T item : this.pitems) {
            total += ((AbstractProfiledItem)item).probability;
        }
        return total;
    }

    private boolean isSorted() {
        for (int i = 1; i < this.pitems.length; ++i) {
            if (!(((AbstractProfiledItem)this.pitems[i - 1]).getProbability() < ((AbstractProfiledItem)this.pitems[i]).getProbability())) continue;
            return false;
        }
        return true;
    }

    public double getNotRecordedProbability() {
        return this.notRecordedProbability;
    }

    protected T[] getItems() {
        return this.pitems;
    }

    public T findEntry(ResolvedJavaType type) {
        if (this.pitems != null) {
            for (T pt : this.pitems) {
                if (!((AbstractProfiledItem)pt).getItem().equals(type)) continue;
                return pt;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        if (this.pitems != null) {
            for (T pt : this.pitems) {
                builder.append(((AbstractProfiledItem)pt).toString());
                builder.append(", ");
            }
        }
        builder.append(this.notRecordedProbability);
        builder.append("]");
        return builder.toString();
    }

    public boolean isIncluded(U item) {
        if (this.getNotRecordedProbability() > 0.0) {
            return true;
        }
        for (int i = 0; i < this.getItems().length; ++i) {
            AbstractProfiledItem pitem = this.getItems()[i];
            Object curType = pitem.getItem();
            if (curType != item) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractJavaProfile)) {
            return false;
        }
        AbstractJavaProfile that = (AbstractJavaProfile)obj;
        if (that.notRecordedProbability != this.notRecordedProbability) {
            return false;
        }
        if (that.pitems.length != this.pitems.length) {
            return false;
        }
        for (int i = 0; i < this.pitems.length; ++i) {
            if (((AbstractProfiledItem)this.pitems[i]).equals(that.pitems[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return (int)Double.doubleToLongBits(this.notRecordedProbability) + this.pitems.length * 13;
    }
}

