/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.code;

import java.nio.ByteOrder;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;

public abstract class Architecture {
    private final PlatformKind wordKind;
    private final String name;
    private final RegisterArray registers;
    private final ByteOrder byteOrder;
    private final boolean unalignedMemoryAccess;
    private final int implicitMemoryBarriers;
    private final int machineCodeCallDisplacementOffset;
    private final int returnAddressSize;

    protected Architecture(String name, PlatformKind wordKind, ByteOrder byteOrder, boolean unalignedMemoryAccess, RegisterArray registers, int implicitMemoryBarriers, int nativeCallDisplacementOffset, int returnAddressSize) {
        this.name = name;
        this.registers = registers;
        this.wordKind = wordKind;
        this.byteOrder = byteOrder;
        this.unalignedMemoryAccess = unalignedMemoryAccess;
        this.implicitMemoryBarriers = implicitMemoryBarriers;
        this.machineCodeCallDisplacementOffset = nativeCallDisplacementOffset;
        this.returnAddressSize = returnAddressSize;
    }

    public final String toString() {
        return this.getName().toLowerCase();
    }

    public int getWordSize() {
        return this.wordKind.getSizeInBytes();
    }

    public PlatformKind getWordKind() {
        return this.wordKind;
    }

    public String getName() {
        return this.name;
    }

    public RegisterArray getRegisters() {
        return this.registers;
    }

    public RegisterArray getAvailableValueRegisters() {
        return this.getRegisters();
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public boolean supportsUnalignedMemoryAccess() {
        return this.unalignedMemoryAccess;
    }

    public int getReturnAddressSize() {
        return this.returnAddressSize;
    }

    public int getMachineCodeCallDisplacementOffset() {
        return this.machineCodeCallDisplacementOffset;
    }

    public final int requiredBarriers(int barriers) {
        return barriers & ~this.implicitMemoryBarriers;
    }

    public abstract boolean canStoreValue(Register.RegisterCategory var1, PlatformKind var2);

    public abstract PlatformKind getLargestStorableKind(Register.RegisterCategory var1);

    public abstract PlatformKind getPlatformKind(JavaKind var1);

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Architecture) {
            Architecture that = (Architecture)obj;
            if (this.name.equals(that.name)) {
                assert (this.byteOrder.equals(that.byteOrder));
                assert (this.implicitMemoryBarriers == that.implicitMemoryBarriers);
                assert (this.machineCodeCallDisplacementOffset == that.machineCodeCallDisplacementOffset);
                assert (this.registers.equals(that.registers));
                assert (this.returnAddressSize == that.returnAddressSize);
                assert (this.unalignedMemoryAccess == that.unalignedMemoryAccess);
                assert (this.wordKind == that.wordKind);
                return true;
            }
        }
        return false;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }
}

