/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.amd64;

import jdk.vm.ci.meta.PlatformKind;

public final class AMD64Kind
extends Enum<AMD64Kind>
implements PlatformKind {
    public static final /* enum */ AMD64Kind BYTE = new AMD64Kind(1);
    public static final /* enum */ AMD64Kind WORD = new AMD64Kind(2);
    public static final /* enum */ AMD64Kind DWORD = new AMD64Kind(4);
    public static final /* enum */ AMD64Kind QWORD = new AMD64Kind(8);
    public static final /* enum */ AMD64Kind SINGLE = new AMD64Kind(4);
    public static final /* enum */ AMD64Kind DOUBLE = new AMD64Kind(8);
    public static final /* enum */ AMD64Kind V32_BYTE = new AMD64Kind(4, BYTE);
    public static final /* enum */ AMD64Kind V32_WORD = new AMD64Kind(4, WORD);
    public static final /* enum */ AMD64Kind V64_BYTE = new AMD64Kind(8, BYTE);
    public static final /* enum */ AMD64Kind V64_WORD = new AMD64Kind(8, WORD);
    public static final /* enum */ AMD64Kind V64_DWORD = new AMD64Kind(8, DWORD);
    public static final /* enum */ AMD64Kind V128_BYTE = new AMD64Kind(16, BYTE);
    public static final /* enum */ AMD64Kind V128_WORD = new AMD64Kind(16, WORD);
    public static final /* enum */ AMD64Kind V128_DWORD = new AMD64Kind(16, DWORD);
    public static final /* enum */ AMD64Kind V128_QWORD = new AMD64Kind(16, QWORD);
    public static final /* enum */ AMD64Kind V128_SINGLE = new AMD64Kind(16, SINGLE);
    public static final /* enum */ AMD64Kind V128_DOUBLE = new AMD64Kind(16, DOUBLE);
    public static final /* enum */ AMD64Kind V256_BYTE = new AMD64Kind(32, BYTE);
    public static final /* enum */ AMD64Kind V256_WORD = new AMD64Kind(32, WORD);
    public static final /* enum */ AMD64Kind V256_DWORD = new AMD64Kind(32, DWORD);
    public static final /* enum */ AMD64Kind V256_QWORD = new AMD64Kind(32, QWORD);
    public static final /* enum */ AMD64Kind V256_SINGLE = new AMD64Kind(32, SINGLE);
    public static final /* enum */ AMD64Kind V256_DOUBLE = new AMD64Kind(32, DOUBLE);
    public static final /* enum */ AMD64Kind V512_BYTE = new AMD64Kind(64, BYTE);
    public static final /* enum */ AMD64Kind V512_WORD = new AMD64Kind(64, WORD);
    public static final /* enum */ AMD64Kind V512_DWORD = new AMD64Kind(64, DWORD);
    public static final /* enum */ AMD64Kind V512_QWORD = new AMD64Kind(64, QWORD);
    public static final /* enum */ AMD64Kind V512_SINGLE = new AMD64Kind(64, SINGLE);
    public static final /* enum */ AMD64Kind V512_DOUBLE = new AMD64Kind(64, DOUBLE);
    public static final /* enum */ AMD64Kind MASK8 = new AMD64Kind(1);
    public static final /* enum */ AMD64Kind MASK16 = new AMD64Kind(2);
    public static final /* enum */ AMD64Kind MASK32 = new AMD64Kind(4);
    public static final /* enum */ AMD64Kind MASK64 = new AMD64Kind(8);
    private final int size;
    private final int vectorLength;
    private final AMD64Kind scalar;
    private final PlatformKind.EnumKey<AMD64Kind> key = new PlatformKind.EnumKey<AMD64Kind>(this);
    private static final /* synthetic */ AMD64Kind[] $VALUES;

    public static AMD64Kind[] values() {
        return (AMD64Kind[])$VALUES.clone();
    }

    public static AMD64Kind valueOf(String name) {
        return Enum.valueOf(AMD64Kind.class, name);
    }

    private AMD64Kind(int size) {
        this.size = size;
        this.scalar = this;
        this.vectorLength = 1;
    }

    private AMD64Kind(int size, AMD64Kind scalar) {
        this.size = size;
        this.scalar = scalar;
        assert (size % scalar.size == 0);
        this.vectorLength = size / scalar.size;
    }

    public AMD64Kind getScalar() {
        return this.scalar;
    }

    @Override
    public int getSizeInBytes() {
        return this.size;
    }

    @Override
    public int getVectorLength() {
        return this.vectorLength;
    }

    @Override
    public PlatformKind.Key getKey() {
        return this.key;
    }

    public boolean isInteger() {
        switch (this) {
            case BYTE: 
            case WORD: 
            case DWORD: 
            case QWORD: {
                return true;
            }
        }
        return false;
    }

    public boolean isXMM() {
        switch (this) {
            case SINGLE: 
            case DOUBLE: 
            case V32_BYTE: 
            case V32_WORD: 
            case V64_BYTE: 
            case V64_WORD: 
            case V64_DWORD: 
            case V128_BYTE: 
            case V128_WORD: 
            case V128_DWORD: 
            case V128_QWORD: 
            case V128_SINGLE: 
            case V128_DOUBLE: 
            case V256_BYTE: 
            case V256_WORD: 
            case V256_DWORD: 
            case V256_QWORD: 
            case V256_SINGLE: 
            case V256_DOUBLE: 
            case V512_BYTE: 
            case V512_WORD: 
            case V512_DWORD: 
            case V512_QWORD: 
            case V512_SINGLE: 
            case V512_DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isMask() {
        switch (this) {
            case MASK8: 
            case MASK16: 
            case MASK32: 
            case MASK64: {
                return true;
            }
        }
        return false;
    }

    @Override
    public char getTypeChar() {
        switch (this) {
            case BYTE: {
                return 'b';
            }
            case WORD: {
                return 'w';
            }
            case DWORD: {
                return 'd';
            }
            case QWORD: {
                return 'q';
            }
            case SINGLE: {
                return 'S';
            }
            case DOUBLE: {
                return 'D';
            }
            case V32_BYTE: 
            case V32_WORD: 
            case V64_BYTE: 
            case V64_WORD: 
            case V64_DWORD: {
                return 'v';
            }
            case V128_BYTE: 
            case V128_WORD: 
            case V128_DWORD: 
            case V128_QWORD: 
            case V128_SINGLE: 
            case V128_DOUBLE: {
                return 'x';
            }
            case V256_BYTE: 
            case V256_WORD: 
            case V256_DWORD: 
            case V256_QWORD: 
            case V256_SINGLE: 
            case V256_DOUBLE: {
                return 'y';
            }
            case V512_BYTE: 
            case V512_WORD: 
            case V512_DWORD: 
            case V512_QWORD: 
            case V512_SINGLE: 
            case V512_DOUBLE: {
                return 'z';
            }
            case MASK8: 
            case MASK16: 
            case MASK32: 
            case MASK64: {
                return 'k';
            }
        }
        return '-';
    }

    static {
        $VALUES = new AMD64Kind[]{BYTE, WORD, DWORD, QWORD, SINGLE, DOUBLE, V32_BYTE, V32_WORD, V64_BYTE, V64_WORD, V64_DWORD, V128_BYTE, V128_WORD, V128_DWORD, V128_QWORD, V128_SINGLE, V128_DOUBLE, V256_BYTE, V256_WORD, V256_DWORD, V256_QWORD, V256_SINGLE, V256_DOUBLE, V512_BYTE, V512_WORD, V512_DWORD, V512_QWORD, V512_SINGLE, V512_DOUBLE, MASK8, MASK16, MASK32, MASK64};
    }
}

