/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.aarch64;

import jdk.vm.ci.meta.PlatformKind;

public final class AArch64Kind
extends Enum<AArch64Kind>
implements PlatformKind {
    public static final /* enum */ AArch64Kind BYTE = new AArch64Kind(1);
    public static final /* enum */ AArch64Kind WORD = new AArch64Kind(2);
    public static final /* enum */ AArch64Kind DWORD = new AArch64Kind(4);
    public static final /* enum */ AArch64Kind QWORD = new AArch64Kind(8);
    public static final /* enum */ AArch64Kind SINGLE = new AArch64Kind(4);
    public static final /* enum */ AArch64Kind DOUBLE = new AArch64Kind(8);
    public static final /* enum */ AArch64Kind V32_BYTE = new AArch64Kind(4, BYTE);
    public static final /* enum */ AArch64Kind V32_WORD = new AArch64Kind(4, WORD);
    public static final /* enum */ AArch64Kind V64_BYTE = new AArch64Kind(8, BYTE);
    public static final /* enum */ AArch64Kind V64_WORD = new AArch64Kind(8, WORD);
    public static final /* enum */ AArch64Kind V64_DWORD = new AArch64Kind(8, DWORD);
    public static final /* enum */ AArch64Kind V128_BYTE = new AArch64Kind(16, BYTE);
    public static final /* enum */ AArch64Kind V128_WORD = new AArch64Kind(16, WORD);
    public static final /* enum */ AArch64Kind V128_DWORD = new AArch64Kind(16, DWORD);
    public static final /* enum */ AArch64Kind V128_QWORD = new AArch64Kind(16, QWORD);
    public static final /* enum */ AArch64Kind V128_SINGLE = new AArch64Kind(16, SINGLE);
    public static final /* enum */ AArch64Kind V128_DOUBLE = new AArch64Kind(16, DOUBLE);
    private final int size;
    private final int vectorLength;
    private final AArch64Kind scalar;
    private final PlatformKind.EnumKey<AArch64Kind> key = new PlatformKind.EnumKey<AArch64Kind>(this);
    private static final /* synthetic */ AArch64Kind[] $VALUES;

    public static AArch64Kind[] values() {
        return (AArch64Kind[])$VALUES.clone();
    }

    public static AArch64Kind valueOf(String name) {
        return Enum.valueOf(AArch64Kind.class, name);
    }

    private AArch64Kind(int size) {
        this.size = size;
        this.scalar = this;
        this.vectorLength = 1;
    }

    private AArch64Kind(int size, AArch64Kind scalar) {
        this.size = size;
        this.scalar = scalar;
        assert (size % scalar.size == 0);
        this.vectorLength = size / scalar.size;
    }

    public AArch64Kind getScalar() {
        return this.scalar;
    }

    @Override
    public int getSizeInBytes() {
        return this.size;
    }

    @Override
    public int getVectorLength() {
        return this.vectorLength;
    }

    @Override
    public PlatformKind.Key getKey() {
        return this.key;
    }

    public boolean isInteger() {
        switch (this) {
            case BYTE: 
            case WORD: 
            case DWORD: 
            case QWORD: {
                return true;
            }
        }
        return false;
    }

    public boolean isSIMD() {
        switch (this) {
            case SINGLE: 
            case DOUBLE: 
            case V32_BYTE: 
            case V32_WORD: 
            case V64_BYTE: 
            case V64_WORD: 
            case V64_DWORD: 
            case V128_BYTE: 
            case V128_WORD: 
            case V128_DWORD: 
            case V128_QWORD: 
            case V128_SINGLE: 
            case V128_DOUBLE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public char getTypeChar() {
        switch (this) {
            case BYTE: {
                return 'b';
            }
            case WORD: {
                return 'w';
            }
            case DWORD: {
                return 'd';
            }
            case QWORD: {
                return 'q';
            }
            case SINGLE: {
                return 'S';
            }
            case DOUBLE: {
                return 'D';
            }
            case V32_BYTE: 
            case V32_WORD: 
            case V64_BYTE: 
            case V64_WORD: 
            case V64_DWORD: 
            case V128_BYTE: 
            case V128_WORD: 
            case V128_DWORD: 
            case V128_QWORD: 
            case V128_SINGLE: 
            case V128_DOUBLE: {
                return 'v';
            }
        }
        return '-';
    }

    static {
        $VALUES = new AArch64Kind[]{BYTE, WORD, DWORD, QWORD, SINGLE, DOUBLE, V32_BYTE, V32_WORD, V64_BYTE, V64_WORD, V64_DWORD, V128_BYTE, V128_WORD, V128_DWORD, V128_QWORD, V128_SINGLE, V128_DOUBLE};
    }
}

