/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode;

import com.oracle.js.parser.ParserException;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.SuspendedCallback;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.ScriptNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.function.ConstructorRootNode;
import com.oracle.truffle.js.parser.GraalJSEvaluator;
import com.oracle.truffle.js.parser.GraalJSParserHelper;
import com.oracle.truffle.js.parser.JSParser;
import com.oracle.truffle.js.parser.JavaScriptTranslator;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.Evaluator;
import com.oracle.truffle.js.runtime.ExitException;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.ImportMetaInitializer;
import com.oracle.truffle.js.runtime.ImportModuleDynamicallyCallback;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSAgentWaiterList;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSParserOptions;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.PrepareStackTraceCallback;
import com.oracle.truffle.js.runtime.PromiseHook;
import com.oracle.truffle.js.runtime.PromiseRejectionTracker;
import com.oracle.truffle.js.runtime.RegexCompilerInterface;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.UserScriptException;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsObject;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSDataView;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespace;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.JSWeakMap;
import com.oracle.truffle.js.runtime.builtins.JSWeakSet;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.PropertyReference;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.BufferUtil;
import com.oracle.truffle.js.runtime.util.JSHashMap;
import com.oracle.truffle.js.runtime.util.Pair;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import com.oracle.truffle.trufflenode.ContextData;
import com.oracle.truffle.trufflenode.Deallocator;
import com.oracle.truffle.trufflenode.JSExternalObject;
import com.oracle.truffle.trufflenode.NativeAccess;
import com.oracle.truffle.trufflenode.NodeJSAgent;
import com.oracle.truffle.trufflenode.Options;
import com.oracle.truffle.trufflenode.RealmData;
import com.oracle.truffle.trufflenode.RunnableInvoker;
import com.oracle.truffle.trufflenode.buffer.NIOBufferObject;
import com.oracle.truffle.trufflenode.info.Accessor;
import com.oracle.truffle.trufflenode.info.FunctionTemplate;
import com.oracle.truffle.trufflenode.info.ObjectTemplate;
import com.oracle.truffle.trufflenode.info.PropertyHandler;
import com.oracle.truffle.trufflenode.info.Script;
import com.oracle.truffle.trufflenode.info.UnboundScript;
import com.oracle.truffle.trufflenode.info.Value;
import com.oracle.truffle.trufflenode.node.ExecuteNativeFunctionNode;
import com.oracle.truffle.trufflenode.node.ExecuteNativePropertyHandlerNode;
import com.oracle.truffle.trufflenode.node.debug.SetBreakPointNode;
import com.oracle.truffle.trufflenode.serialization.Deserializer;
import com.oracle.truffle.trufflenode.serialization.Serializer;
import com.oracle.truffle.trufflenode.threading.JavaMessagePortData;
import com.oracle.truffle.trufflenode.threading.SharedMemMessagingBindings;
import com.oracle.truffle.trufflenode.threading.SharedMemMessagingManager;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;

public final class GraalJSAccess {
    private static final boolean VERBOSE = Boolean.getBoolean("truffle.node.js.verbose");
    private static final boolean USE_NIO_BUFFER = !"false".equals(System.getProperty("node.buffer.nio"));
    private static final boolean USE_SNAPSHOTS = !"false".equalsIgnoreCase(System.getProperty("truffle.node.js.snapshots"));
    private static final HiddenKey PRIVATE_VALUES_KEY = new HiddenKey("PrivateValues");
    private static final HiddenKey FUNCTION_TEMPLATE_DATA_KEY = new HiddenKey("FunctionTemplateData");
    private static final HiddenKey INTERNAL_FIELD_COUNT_KEY = new HiddenKey("InternalFieldCount");
    private static final HiddenKey INTERNAL_FIELD_ZERO_KEY = new HiddenKey("InternalField0");
    private static final Symbol RESOLVER_RESOLVE = Symbol.create((String)"Resolve");
    private static final Symbol RESOLVER_REJECT = Symbol.create((String)"Reject");
    public static final HiddenKey HOLDER_KEY = new HiddenKey("Holder");
    public static final HiddenKey EXTERNALIZED_KEY = new HiddenKey("Externalized");
    private static final Object INT_PLACEHOLDER = new Object();
    private static final Object LARGE_INT_PLACEHOLDER = new Object();
    private static final Object DOUBLE_PLACEHOLDER = new Object();
    private final Context evaluator;
    private final JSContext mainJSContext;
    private final JSRealm mainJSRealm;
    private final NodeJSAgent agent;
    private final Deallocator deallocator;
    private ESModuleLoader moduleLoader;
    private final TruffleLanguage.Env envForInstruments;
    private final ByteBuffer sharedBuffer = ByteBuffer.allocateDirect(128).order(ByteOrder.nativeOrder());
    private final Map<String, Reference<String>> sourceCodeCache = new WeakHashMap<String, Reference<String>>();
    private final Map<com.oracle.truffle.api.source.Source, Object> hostDefinedOptionsMap = new WeakHashMap<com.oracle.truffle.api.source.Source, Object>();
    private final boolean exposeGC;
    private static final ReferenceQueue<JSAgentWaiterList> agentWaiterListQueue = new ReferenceQueue();
    private static final Map<Long, WeakReference<JSAgentWaiterList>> agentWaiterListMap = new HashMap<Long, WeakReference<JSAgentWaiterList>>();
    private static final Pattern SYNTAX_ERROR_PATTERN = Pattern.compile("(.+):(\\d+):(\\d+) ([^\n]+)\n([^\n]+)(?:\n(?:.|\n)*)?");
    private static final int SYNTAX_ERROR_RESOURCE_NAME_GROUP = 1;
    private static final int SYNTAX_ERROR_LINE_NUMBER_GROUP = 2;
    private static final int SYNTAX_ERROR_COLUMN_NUMBER_GROUP = 3;
    private static final int SYNTAX_ERROR_MESSAGE_GROUP = 4;
    private static final int SYNTAX_ERROR_SOURCE_LINE_GROUP = 5;
    private static final HiddenKey HIDDEN_WEAK_CALLBACK = new HiddenKey("WeakCallback");
    private static final HiddenKey HIDDEN_WEAK_CALLBACK_CONTEXT = new HiddenKey("WeakCallbackContext");
    private final ReferenceQueue<Object> weakCallbackQueue = new ReferenceQueue();
    private final Set<WeakCallback> weakCallbacks = new HashSet<WeakCallback>();
    private boolean createChildContext;
    private boolean terminateExecution;
    private static final ThreadLocal<Deque<Pair<Long, Object>>> isolateStack = new ThreadLocal();
    private Map<JSModuleRecord, Map<String, Object>> earlySyntheticModuleExports = new WeakHashMap<JSModuleRecord, Map<String, Object>>();
    private JavaMessagePortData currentMessagePortData = null;

    private GraalJSAccess(String[] args) throws Exception {
        try {
            Options options = Options.parseArguments(GraalJSAccess.prepareArguments(args));
            Context.Builder contextBuilder = options.getContextBuilder();
            contextBuilder.option("js.direct-byte-buffer", "true");
            contextBuilder.option("js.v8-compat", "true");
            contextBuilder.option("js.intl-402", "true");
            contextBuilder.option("js.syntax-extensions", "false");
            contextBuilder.option("js.load", "false");
            contextBuilder.option("js.console", "false");
            this.exposeGC = options.isGCExposed();
            this.evaluator = contextBuilder.build();
            this.mainJSRealm = JavaScriptLanguage.getJSRealm((Context)this.evaluator);
        }
        catch (IllegalArgumentException iaex) {
            System.err.printf("ERROR: %s", iaex.getMessage());
            System.exit(1);
            throw iaex;
        }
        catch (PolyglotException pex) {
            boolean emptyMessage;
            int exitCode = 1;
            String message = pex.getMessage();
            boolean bl = emptyMessage = message == null || message.isEmpty();
            if (pex.isExit()) {
                exitCode = pex.getExitStatus();
                if (exitCode != 0 && !emptyMessage) {
                    System.err.println(message);
                }
            } else if (pex.isInternalError() || emptyMessage) {
                pex.printStackTrace();
            } else {
                System.err.println("ERROR: " + message);
            }
            System.exit(exitCode);
            throw pex;
        }
        this.mainJSContext = this.mainJSRealm.getContext();
        assert (this.mainJSContext != null) : "JSContext initialized";
        this.agent = new NodeJSAgent();
        this.mainJSRealm.setAgent((JSAgent)this.agent);
        this.deallocator = new Deallocator();
        this.envForInstruments = this.mainJSRealm.getEnv();
        this.isolateEnableImportModuleDynamically(false);
    }

    private static String[] prepareArguments(String[] args) {
        String options = System.getenv("NODE_POLYGLOT_OPTIONS");
        if (options == null) {
            return args;
        }
        String[] additionalArgs = options.split(" ");
        String[] mergedArgs = new String[args.length + additionalArgs.length];
        System.arraycopy(args, 0, mergedArgs, 0, args.length);
        System.arraycopy(additionalArgs, 0, mergedArgs, args.length, additionalArgs.length);
        return mergedArgs;
    }

    public static Object create(String[] args) throws Exception {
        return new GraalJSAccess(args);
    }

    public Object undefinedInstance() {
        return Undefined.instance;
    }

    public Object nullInstance() {
        return Null.instance;
    }

    public void resetSharedBuffer() {
        BufferUtil.asBaseBuffer((Buffer)this.sharedBuffer).clear();
    }

    public ByteBuffer getSharedBuffer() {
        return this.sharedBuffer;
    }

    public int valueType(Object value) {
        return this.valueType(value, false);
    }

    @CompilerDirectives.TruffleBoundary
    public int valueType(Object value, boolean useSharedBuffer) {
        if (value == Undefined.instance) {
            return 1;
        }
        if (value == Null.instance) {
            return 2;
        }
        if (value == Boolean.TRUE) {
            return 3;
        }
        if (value == Boolean.FALSE) {
            return 4;
        }
        if (value instanceof String) {
            return 5;
        }
        if (JSRuntime.isNumber((Object)value)) {
            if (useSharedBuffer) {
                this.sharedBuffer.putDouble(((Number)value).doubleValue());
            }
            return 6;
        }
        if (JSObject.isJSObject((Object)value)) {
            return this.valueTypeJSObject((DynamicObject)value, useSharedBuffer);
        }
        if (JSRuntime.isForeignObject((Object)value)) {
            return this.valueTypeForeignObject((TruffleObject)value, useSharedBuffer);
        }
        if (JSRuntime.isString((Object)value)) {
            return 13;
        }
        if (value instanceof Symbol) {
            return 16;
        }
        if (value instanceof BigInt) {
            return 31;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 3 : 4;
        }
        if (value instanceof Throwable) {
            GraalJSAccess.valueTypeError(value);
        }
        return -1;
    }

    private int valueTypeForeignObject(TruffleObject value, boolean useSharedBuffer) {
        InteropLibrary interop = (InteropLibrary)InteropLibrary.getFactory().getUncached((Object)value);
        if (interop.isExecutable((Object)value)) {
            return 8;
        }
        if (interop.isNull((Object)value)) {
            return 2;
        }
        if (interop.isBoolean((Object)value)) {
            try {
                return interop.asBoolean((Object)value) ? 3 : 4;
            }
            catch (UnsupportedMessageException e) {
                GraalJSAccess.valueTypeError(value);
                return -1;
            }
        }
        if (interop.isString((Object)value)) {
            return 5;
        }
        if (interop.isNumber((Object)value)) {
            return this.valueTypeForeignNumber(value, interop, useSharedBuffer);
        }
        return 12;
    }

    public int valueTypeForeignNumber(TruffleObject value, InteropLibrary interop, boolean useSharedBuffer) {
        try {
            return this.valueType(interop.asDouble((Object)value), useSharedBuffer);
        }
        catch (UnsupportedMessageException e) {
            if (interop.fitsInLong((Object)value)) {
                try {
                    return this.valueType(interop.asLong((Object)value), useSharedBuffer);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            GraalJSAccess.valueTypeError(value);
            return -1;
        }
    }

    private int valueTypeJSObject(DynamicObject obj, boolean useSharedBuffer) {
        if (JSExternalObject.isJSExternalObject(obj)) {
            return 7;
        }
        if (JSFunction.isJSFunction((DynamicObject)obj)) {
            return 8;
        }
        if (JSArray.isJSArray((DynamicObject)obj)) {
            return 9;
        }
        if (JSDate.isJSDate((DynamicObject)obj)) {
            return 10;
        }
        if (JSRegExp.isJSRegExp((DynamicObject)obj)) {
            return 11;
        }
        if (JSArrayBufferView.isJSArrayBufferView((DynamicObject)obj)) {
            return this.valueTypeArrayBufferView(obj, useSharedBuffer);
        }
        if (JSArrayBuffer.isJSDirectArrayBuffer((DynamicObject)obj)) {
            return 15;
        }
        if (JSDataView.isJSDataView((DynamicObject)obj)) {
            if (useSharedBuffer) {
                JSContext context = JSObject.getJSContext((DynamicObject)obj);
                this.sharedBuffer.putInt(GraalJSAccess.arrayBufferViewByteLength(context, obj));
                this.sharedBuffer.putInt(GraalJSAccess.arrayBufferViewByteOffset(context, obj));
            }
            return 30;
        }
        if (JSMap.isJSMap((DynamicObject)obj)) {
            return 26;
        }
        if (JSSet.isJSSet((DynamicObject)obj)) {
            return 27;
        }
        if (JSPromise.isJSPromise((DynamicObject)obj)) {
            return 28;
        }
        if (JSProxy.isProxy((DynamicObject)obj)) {
            return 29;
        }
        return 12;
    }

    private int valueTypeArrayBufferView(DynamicObject obj, boolean useSharedBuffer) {
        ScriptArray array;
        if (useSharedBuffer) {
            JSContext context = JSObject.getJSContext((DynamicObject)obj);
            this.sharedBuffer.putInt(GraalJSAccess.arrayBufferViewByteLength(context, obj));
            this.sharedBuffer.putInt(GraalJSAccess.arrayBufferViewByteOffset(context, obj));
        }
        if ((array = JSObject.getArray((DynamicObject)obj)) instanceof TypedArray.DirectUint8Array) {
            return 17;
        }
        if (array instanceof TypedArray.DirectUint8ClampedArray) {
            return 18;
        }
        if (array instanceof TypedArray.DirectInt8Array) {
            return 20;
        }
        if (array instanceof TypedArray.DirectUint16Array) {
            return 21;
        }
        if (array instanceof TypedArray.DirectInt16Array) {
            return 22;
        }
        if (array instanceof TypedArray.DirectUint32Array) {
            return 19;
        }
        if (array instanceof TypedArray.DirectInt32Array) {
            return 23;
        }
        if (array instanceof TypedArray.DirectFloat32Array) {
            return 24;
        }
        if (array instanceof TypedArray.DirectFloat64Array) {
            return 25;
        }
        if (array instanceof TypedArray.DirectBigInt64Array) {
            return 32;
        }
        if (array instanceof TypedArray.DirectBigUint64Array) {
            return 33;
        }
        return 14;
    }

    @CompilerDirectives.TruffleBoundary
    public static void valueTypeError(Object value) {
        System.err.println("unknown type: " + (value == null ? null : value.getClass().getSimpleName()));
    }

    public double valueDouble(Object obj) {
        return JSRuntime.toDouble((Object)obj);
    }

    public long valueExternal(Object obj) {
        return JSExternalObject.getPointer((DynamicObject)obj);
    }

    public String valueUnknown(Object obj) {
        return obj.toString();
    }

    public Object valueToObject(Object context, Object value) {
        return JSRuntime.toObject((JSContext)((JSRealm)context).getContext(), (Object)value);
    }

    public Object valueToInteger(Object value) {
        double doubleValue;
        if (value instanceof Double && ((doubleValue = ((Double)value).doubleValue()) < -9.223372036854776E18 || 9.223372036854776E18 < doubleValue || doubleValue == 0.0)) {
            return value;
        }
        long integer = JSRuntime.toInteger((Object)value);
        if (JSRuntime.longIsRepresentableAsInt((long)integer)) {
            return (int)integer;
        }
        return (double)integer;
    }

    public Object valueToInt32(Object value) {
        return JSRuntime.toInt32((Object)value);
    }

    public Object valueToUint32(Object value) {
        return (double)JSRuntime.toUInt32((Object)value);
    }

    public String valueToString(Object value) {
        return JSRuntime.toString((Object)value);
    }

    public boolean valueToBoolean(Object value) {
        return JSRuntime.toBoolean((Object)value);
    }

    public Object valueToNumber(Object value) {
        return JSRuntime.toNumber((Object)value);
    }

    public Object valueToArrayIndex(Object value) {
        if (JSRuntime.isArrayIndex((Object)value)) {
            double index = JSRuntime.toDouble((Object)value);
            if (index == 0.0) {
                index = 0.0;
            }
            this.resetSharedBuffer();
            this.sharedBuffer.putDouble(index);
            return index;
        }
        return null;
    }

    public int valueInt32Value(Object value) {
        return JSRuntime.toInt32((Object)value);
    }

    public double valueUint32Value(Object value) {
        return JSRuntime.toUInt32((Object)value);
    }

    public long valueIntegerValue(Object value) {
        return JSRuntime.toInteger((Object)value);
    }

    public boolean valueIsNativeError(Object object) {
        return JSError.isJSError((Object)object);
    }

    public boolean valueIsSetIterator(Object object) {
        if (JSRuntime.isObject((Object)object)) {
            DynamicObject dynamicObject = (DynamicObject)object;
            Object iteratedObj = dynamicObject.get((Object)JSRuntime.ITERATED_OBJECT_ID);
            return JSSet.isJSSet((Object)iteratedObj);
        }
        return false;
    }

    public boolean valueIsMapIterator(Object object) {
        if (JSRuntime.isObject((Object)object)) {
            DynamicObject dynamicObject = (DynamicObject)object;
            Object iteratedObj = dynamicObject.get((Object)JSRuntime.ITERATED_OBJECT_ID);
            return JSMap.isJSMap((Object)iteratedObj);
        }
        return false;
    }

    public boolean valueIsSharedArrayBuffer(Object object) {
        return JSSharedArrayBuffer.isJSSharedArrayBuffer((Object)object);
    }

    public boolean valueIsArgumentsObject(Object object) {
        return JSArgumentsObject.isJSArgumentsObject((Object)object);
    }

    public boolean valueIsBooleanObject(Object object) {
        return JSBoolean.isJSBoolean((Object)object);
    }

    public boolean valueIsNumberObject(Object object) {
        return JSNumber.isJSNumber((Object)object);
    }

    public boolean valueIsStringObject(Object object) {
        return JSString.isJSString((Object)object);
    }

    public boolean valueIsSymbolObject(Object object) {
        return JSSymbol.isJSSymbol((Object)object);
    }

    public boolean valueIsBigIntObject(Object object) {
        return JSBigInt.isJSBigInt((Object)object);
    }

    public boolean valueIsWeakMap(Object object) {
        return JSWeakMap.isJSWeakMap((Object)object);
    }

    public boolean valueIsWeakSet(Object object) {
        return JSWeakSet.isJSWeakSet((Object)object);
    }

    public boolean valueIsAsyncFunction(Object object) {
        return JSFunction.isJSFunction((Object)object) ? JSFunction.getFunctionData((DynamicObject)((DynamicObject)object)).isAsync() : false;
    }

    public boolean valueIsGeneratorFunction(Object object) {
        return JSFunction.isJSFunction((Object)object) ? JSFunction.getFunctionData((DynamicObject)((DynamicObject)object)).isGenerator() : false;
    }

    public boolean valueIsGeneratorObject(Object object) {
        return object instanceof DynamicObject && ((DynamicObject)object).containsKey((Object)JSFunction.GENERATOR_STATE_ID);
    }

    public boolean valueIsModuleNamespaceObject(Object object) {
        return JSModuleNamespace.isJSModuleNamespace((Object)object);
    }

    public boolean valueEquals(Object left, Object right) {
        return JSRuntime.equal((Object)left, (Object)right);
    }

    public boolean valueStrictEquals(Object left, Object right) {
        return JSRuntime.identical((Object)left, (Object)right);
    }

    public boolean valueInstanceOf(Object left, Object right) {
        if (left instanceof DynamicObject) {
            DynamicObject function = (DynamicObject)right;
            Object hasInstance = JSObject.get((DynamicObject)function, (Object)Symbol.SYMBOL_HAS_INSTANCE);
            if (hasInstance == Undefined.instance) {
                Object prototype = JSObject.get((DynamicObject)function, (Object)"prototype");
                if (prototype instanceof DynamicObject) {
                    return JSRuntime.isPrototypeOf((DynamicObject)((DynamicObject)left), (DynamicObject)((DynamicObject)prototype));
                }
                throw Errors.createTypeError((String)"prototype is not an Object");
            }
            return JSRuntime.toBoolean((Object)JSRuntime.call((Object)hasInstance, (Object)function, (Object[])new Object[]{left}));
        }
        return false;
    }

    public Object objectNew(Object context) {
        JSRealm jsRealm = (JSRealm)context;
        return JSUserObject.create((JSContext)jsRealm.getContext(), (JSRealm)jsRealm);
    }

    public boolean objectSet(Object object, Object key, Object value) {
        DynamicObject dynamicObject = (DynamicObject)object;
        if (key instanceof HiddenKey) {
            dynamicObject.define(key, value);
        } else {
            JSObject.set((DynamicObject)((DynamicObject)object), (Object)JSRuntime.toPropertyKey((Object)key), (Object)value);
        }
        return true;
    }

    public boolean objectSetIndex(Object object, int index, Object value) {
        JSObject.set((DynamicObject)((DynamicObject)object), (long)index, (Object)value);
        return true;
    }

    public boolean objectForceSet(Object object, Object key, Object value, int attributes) {
        Object propertyKey = JSRuntime.toPropertyKey((Object)key);
        JSObject.delete((DynamicObject)((DynamicObject)object), (Object)propertyKey);
        PropertyDescriptor descriptor = GraalJSAccess.propertyDescriptor(attributes, value);
        return JSObject.defineOwnProperty((DynamicObject)((DynamicObject)object), (Object)propertyKey, (PropertyDescriptor)descriptor);
    }

    public boolean objectSetPrivate(Object context, Object object, Object key, Object value) {
        if (JSRuntime.isObject((Object)object)) {
            DynamicObject dynamicObject = (DynamicObject)object;
            Object privateValues = dynamicObject.get((Object)PRIVATE_VALUES_KEY);
            if (privateValues == null) {
                privateValues = this.objectNew(context);
                dynamicObject.define((Object)PRIVATE_VALUES_KEY, privateValues);
            }
            JSObject.set((DynamicObject)((DynamicObject)privateValues), (Object)key, (Object)value);
        }
        return true;
    }

    public Object objectGetPrivate(Object object, Object key) {
        if (!JSObject.isJSObject((Object)object)) {
            return null;
        }
        DynamicObject dynamicObject = (DynamicObject)object;
        DynamicObject privateValues = (DynamicObject)dynamicObject.get((Object)PRIVATE_VALUES_KEY);
        if (privateValues == null) {
            return null;
        }
        if (JSObject.hasOwnProperty((DynamicObject)privateValues, (Object)key)) {
            return JSObject.get((DynamicObject)privateValues, (Object)key);
        }
        return null;
    }

    public boolean objectDeletePrivate(Object object, Object key) {
        if (!JSObject.isJSObject((Object)object)) {
            return true;
        }
        DynamicObject dynamicObject = (DynamicObject)object;
        Object privateValues = dynamicObject.get((Object)PRIVATE_VALUES_KEY);
        if (privateValues == null) {
            return true;
        }
        return JSObject.delete((DynamicObject)((DynamicObject)privateValues), (Object)key);
    }

    public Object objectGet(Object object, Object key) {
        Object hiddenValue;
        TruffleObject truffleObject = object instanceof TruffleObject ? (TruffleObject)object : JSRuntime.toObject((JSContext)this.mainJSContext, (Object)object);
        Object value = key instanceof HiddenKey ? ((hiddenValue = ((DynamicObject)truffleObject).get(key)) == null ? (JSPromise.isJSPromise((Object)object) ? Integer.valueOf(0) : Undefined.instance) : hiddenValue) : JSObject.get((TruffleObject)truffleObject, (Object)JSRuntime.toPropertyKey((Object)key));
        Object flatten = this.valueFlatten(value);
        this.resetSharedBuffer();
        BufferUtil.asBaseBuffer((Buffer)this.sharedBuffer).position(4);
        this.sharedBuffer.putInt(0, this.valueType(flatten, true));
        return flatten;
    }

    public Object objectGetIndex(Object object, int index) {
        Object value = this.valueFlatten(JSObject.get((DynamicObject)((DynamicObject)object), (long)index));
        this.resetSharedBuffer();
        BufferUtil.asBaseBuffer((Buffer)this.sharedBuffer).position(4);
        this.sharedBuffer.putInt(0, this.valueType(value, true));
        return value;
    }

    public Object objectGetOwnPropertyDescriptor(Object object, Object key) {
        DynamicObject dynamicObject = (DynamicObject)object;
        JSContext context = JSObject.getJSContext((DynamicObject)dynamicObject);
        PropertyDescriptor desc = JSObject.getOwnProperty((DynamicObject)dynamicObject, (Object)key);
        return JSRuntime.fromPropertyDescriptor((PropertyDescriptor)desc, (JSContext)context);
    }

    public boolean objectDefineProperty(Object object, Object key, Object value, Object get, Object set, boolean hasEnumerable, boolean enumerable, boolean hasConfigurable, boolean configurable, boolean hasWritable, boolean writable) {
        DynamicObject dynamicObject = (DynamicObject)object;
        PropertyDescriptor descriptor = PropertyDescriptor.createEmpty();
        if (value != null) {
            descriptor.setValue(value);
        }
        if (get != null) {
            descriptor.setGet((DynamicObject)get);
        }
        if (set != null) {
            descriptor.setSet((DynamicObject)set);
        }
        if (hasEnumerable) {
            descriptor.setEnumerable(enumerable);
        }
        if (hasConfigurable) {
            descriptor.setConfigurable(configurable);
        }
        if (hasWritable) {
            descriptor.setWritable(writable);
        }
        return JSObject.defineOwnProperty((DynamicObject)dynamicObject, (Object)key, (PropertyDescriptor)descriptor);
    }

    public Object valueFlatten(Object value) {
        if (value instanceof String) {
            return value;
        }
        if (value instanceof JSLazyString) {
            return ((JSLazyString)value).toString();
        }
        if (value instanceof PropertyReference) {
            return ((PropertyReference)value).toString();
        }
        if (JSRuntime.isForeignObject((Object)value)) {
            InteropLibrary interop = (InteropLibrary)InteropLibrary.getFactory().getUncached(value);
            if (interop.isString(value)) {
                try {
                    return interop.asString(value);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            return value;
        }
        return value;
    }

    public boolean objectHas(Object object, Object key) {
        return JSObject.hasProperty((DynamicObject)((DynamicObject)object), (Object)JSRuntime.toPropertyKey((Object)key));
    }

    public boolean objectHasOwnProperty(Object object, Object key) {
        return JSObject.hasOwnProperty((DynamicObject)((DynamicObject)object), (Object)key);
    }

    public boolean objectHasRealNamedProperty(Object object, Object key) {
        Object obj = object;
        if (JSProxy.isProxy((Object)obj)) {
            obj = JSProxy.getTarget((DynamicObject)((DynamicObject)obj));
        }
        return this.objectHasOwnProperty(obj, key);
    }

    public boolean objectDelete(Object object, Object key) {
        return JSObject.delete((DynamicObject)((DynamicObject)object), (Object)JSRuntime.toPropertyKey((Object)key));
    }

    public boolean objectDelete(Object object, long index) {
        return JSObject.delete((DynamicObject)((DynamicObject)object), (long)index);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean objectSetAccessor(Object object, Object name, long getterPtr, long setterPtr, Object data, int attributes) {
        DynamicObject dynamicObject = (DynamicObject)object;
        JSContext context = JSObject.getJSContext((DynamicObject)dynamicObject);
        int flags = GraalJSAccess.propertyAttributes(attributes);
        Accessor accessor = new Accessor(this, name, getterPtr, setterPtr, data, null, flags);
        Pair<JSFunctionData, JSFunctionData> accessorFunctions = accessor.getFunctions(context);
        JSRealm realm = context.getRealm();
        DynamicObject getter = GraalJSAccess.functionFromFunctionData(realm, (JSFunctionData)accessorFunctions.getFirst(), dynamicObject);
        DynamicObject setter = GraalJSAccess.functionFromFunctionData(realm, (JSFunctionData)accessorFunctions.getSecond(), dynamicObject);
        JSObjectUtil.putAccessorProperty((JSContext)context, (DynamicObject)dynamicObject, (Object)accessor.getName(), (DynamicObject)getter, (DynamicObject)setter, (int)flags);
        return true;
    }

    public Object objectClone(Object object) {
        DynamicObject dynamicObject = (DynamicObject)object;
        return dynamicObject.copy(dynamicObject.getShape());
    }

    public boolean objectSetPrototype(Object object, Object prototype) {
        return JSObject.setPrototype((DynamicObject)((DynamicObject)object), (DynamicObject)((DynamicObject)prototype));
    }

    public Object objectGetPrototype(Object object) {
        return JSObject.getPrototype((DynamicObject)((DynamicObject)object));
    }

    public String objectGetConstructorName(Object object) {
        DynamicObject dynamicObject;
        Object constructor;
        String name = "Object";
        if (object instanceof DynamicObject && JSFunction.isJSFunction((Object)(constructor = JSObject.get((DynamicObject)(dynamicObject = (DynamicObject)object), (Object)"constructor")))) {
            name = JSFunction.getName((DynamicObject)((DynamicObject)constructor));
        }
        return name;
    }

    public Object objectGetOwnPropertyNames(Object object) {
        DynamicObject dynamicObject = (DynamicObject)object;
        List names = JSObject.enumerableOwnNames((DynamicObject)dynamicObject);
        Object[] namesArray = names.toArray();
        this.convertArrayIndicesToNumbers(namesArray);
        JSContext context = JSObject.getJSContext((DynamicObject)dynamicObject);
        return JSArray.createConstantObjectArray((JSContext)context, (Object[])namesArray);
    }

    public Object objectGetPropertyNames(Object object, boolean ownOnly, boolean enumerableOnly, boolean configurableOnly, boolean writableOnly, boolean skipIndices, boolean skipSymbols, boolean skipStrings, boolean keepNumbers) {
        ArrayList keys = new ArrayList();
        DynamicObject dynamicObject = (DynamicObject)object;
        JSContext context = JSObject.getJSContext((DynamicObject)dynamicObject);
        do {
            JSClass jsclass = JSObject.getJSClass((DynamicObject)dynamicObject);
            List ownKeys = jsclass.ownPropertyKeys(dynamicObject);
            Iterator iterator = ownKeys.iterator();
            while (iterator.hasNext()) {
                Object key;
                Object keyToStore = key = iterator.next();
                if (key instanceof String) {
                    boolean index = JSRuntime.isArrayIndex((String)((String)key));
                    if (index) {
                        if (skipIndices) continue;
                        if (keepNumbers) {
                            keyToStore = JSRuntime.stringToNumber((String)((String)key));
                        }
                    } else if (skipStrings) {
                        continue;
                    }
                } else {
                    assert (key instanceof Symbol);
                    if (skipSymbols) continue;
                }
                PropertyDescriptor desc = jsclass.getOwnProperty(dynamicObject, key);
                if (enumerableOnly && (desc == null || !desc.getEnumerable()) || configurableOnly && (desc == null || !desc.getConfigurable()) || writableOnly && (desc == null || !desc.getWritable())) continue;
                keys.add(keyToStore);
            }
            dynamicObject = JSObject.getPrototype((DynamicObject)dynamicObject);
        } while (!ownOnly && dynamicObject != Null.instance);
        return JSArray.createConstantObjectArray((JSContext)context, (Object[])keys.toArray());
    }

    private void convertArrayIndicesToNumbers(Object[] namesArray) {
        for (int i = 0; i < namesArray.length; ++i) {
            Object name = namesArray[i];
            if (!(name instanceof String) || !JSRuntime.isArrayIndex((String)((String)name))) continue;
            namesArray[i] = JSRuntime.stringToNumber((String)((String)name));
        }
    }

    public Object objectGetRealNamedProperty(Object object, Object key) {
        Object propertyKey = JSRuntime.toPropertyKey((Object)key);
        Object current = object;
        while (JSRuntime.isObject((Object)current)) {
            DynamicObject currentDO = (DynamicObject)current;
            if (JSProxy.isProxy((DynamicObject)currentDO)) {
                current = JSProxy.getTarget((DynamicObject)currentDO);
                continue;
            }
            if (JSObject.hasOwnProperty((DynamicObject)currentDO, (Object)propertyKey)) {
                return JSObject.get((DynamicObject)currentDO, (Object)propertyKey);
            }
            current = JSObject.getPrototype((DynamicObject)currentDO);
        }
        return null;
    }

    public int objectGetRealNamedPropertyAttributes(Object object, Object key) {
        Object propertyKey = JSRuntime.toPropertyKey((Object)key);
        Object current = object;
        while (JSRuntime.isObject((Object)current)) {
            DynamicObject currentDO = (DynamicObject)current;
            if (JSProxy.isProxy((DynamicObject)currentDO)) {
                current = JSProxy.getTarget((DynamicObject)currentDO);
                continue;
            }
            PropertyDescriptor descriptor = JSObject.getOwnProperty((DynamicObject)currentDO, (Object)propertyKey);
            if (descriptor != null) {
                int attributes = 0;
                if (!descriptor.isAccessorDescriptor() && !descriptor.getWritable()) {
                    attributes |= 1;
                }
                if (!descriptor.getEnumerable()) {
                    attributes |= 2;
                }
                if (!descriptor.getConfigurable()) {
                    attributes |= 4;
                }
                return attributes;
            }
            current = JSObject.getPrototype((DynamicObject)currentDO);
        }
        return -1;
    }

    public Object objectCreationContext(Object object) {
        DynamicObject dynamicObject = (DynamicObject)object;
        if (JSFunction.isJSFunction((Object)object)) {
            return JSFunction.getRealm((DynamicObject)dynamicObject);
        }
        return this.objectCreationContextFromConstructor(dynamicObject);
    }

    private Object objectCreationContextFromConstructor(DynamicObject object) {
        if (!JSProxy.isProxy((DynamicObject)object)) {
            Object constructor;
            DynamicObject prototype = JSObject.getPrototype((DynamicObject)object);
            if (prototype != Null.instance && JSFunction.isJSFunction((Object)(constructor = JSRuntime.getDataProperty((DynamicObject)prototype, (Object)"constructor")))) {
                return JSFunction.getRealm((DynamicObject)((DynamicObject)constructor));
            }
        } else if (JSRuntime.isCallableProxy((DynamicObject)object)) {
            return this.objectCreationContext(JSProxy.getTarget((DynamicObject)object));
        }
        throw new IllegalArgumentException("Cannot get creation context for this object");
    }

    public Object arrayNew(Object context, int length) {
        return JSArray.createConstantEmptyArray((JSContext)((JSRealm)context).getContext(), (int)length);
    }

    public long arrayLength(Object object) {
        return JSArray.arrayGetLength((DynamicObject)((DynamicObject)object));
    }

    public Object arrayBufferNew(Object context, Object buffer, long pointer) {
        ByteBuffer byteBuffer = (ByteBuffer)buffer;
        if (pointer != 0L) {
            this.deallocator.register(byteBuffer, pointer);
        }
        DynamicObject arrayBuffer = JSArrayBuffer.createDirectArrayBuffer((JSContext)((JSRealm)context).getContext(), (ByteBuffer)byteBuffer);
        arrayBuffer.define((Object)EXTERNALIZED_KEY, (Object)(pointer == 0L ? 1 : 0));
        return arrayBuffer;
    }

    public Object arrayBufferNew(Object context, int byteLength) {
        return JSArrayBuffer.createDirectArrayBuffer((JSContext)((JSRealm)context).getContext(), (int)byteLength);
    }

    public Object arrayBufferGetContents(Object arrayBuffer) {
        return JSArrayBuffer.getDirectByteBuffer((DynamicObject)((DynamicObject)arrayBuffer));
    }

    public Object arrayBufferViewBuffer(Object arrayBufferView) {
        DynamicObject dynamicObject = (DynamicObject)arrayBufferView;
        if (JSDataView.isJSDataView((Object)arrayBufferView)) {
            return JSDataView.getArrayBuffer((DynamicObject)dynamicObject);
        }
        return JSArrayBufferView.getArrayBuffer((DynamicObject)dynamicObject);
    }

    public int arrayBufferViewByteLength(Object arrayBufferView) {
        DynamicObject dynamicObject = (DynamicObject)arrayBufferView;
        return GraalJSAccess.arrayBufferViewByteLength(JSObject.getJSContext((DynamicObject)dynamicObject), dynamicObject);
    }

    public boolean arrayBufferIsExternal(Object arrayBuffer) {
        return ((DynamicObject)arrayBuffer).get((Object)EXTERNALIZED_KEY) == Boolean.TRUE;
    }

    public void arrayBufferExternalize(Object arrayBuffer) {
        DynamicObject dynamicObject = (DynamicObject)arrayBuffer;
        dynamicObject.define((Object)EXTERNALIZED_KEY, (Object)true);
    }

    public void arrayBufferDetach(Object arrayBuffer) {
        if (JSArrayBuffer.getDirectByteLength((DynamicObject)((DynamicObject)arrayBuffer)) != 0) {
            JSArrayBuffer.setDirectByteBuffer((DynamicObject)((DynamicObject)arrayBuffer), (ByteBuffer)ByteBuffer.allocateDirect(0));
        }
    }

    public static int arrayBufferViewByteLength(JSContext context, DynamicObject arrayBufferView) {
        if (JSDataView.isJSDataView((DynamicObject)arrayBufferView)) {
            return JSDataView.typedArrayGetLength((DynamicObject)arrayBufferView);
        }
        return JSArrayBufferView.getByteLength((DynamicObject)arrayBufferView, (boolean)JSArrayBufferView.isJSArrayBufferView((DynamicObject)arrayBufferView), (JSContext)context);
    }

    public int arrayBufferViewByteOffset(Object arrayBufferView) {
        DynamicObject dynamicObject = (DynamicObject)arrayBufferView;
        return GraalJSAccess.arrayBufferViewByteOffset(JSObject.getJSContext((DynamicObject)dynamicObject), dynamicObject);
    }

    public static int arrayBufferViewByteOffset(JSContext context, DynamicObject arrayBufferView) {
        if (JSDataView.isJSDataView((DynamicObject)arrayBufferView)) {
            return JSDataView.typedArrayGetOffset((DynamicObject)arrayBufferView);
        }
        return JSArrayBufferView.getByteOffset((DynamicObject)arrayBufferView, (boolean)JSArrayBufferView.isJSArrayBufferView((DynamicObject)arrayBufferView), (JSContext)context);
    }

    private static void pollAgentWaiterListQueue() {
        WeakAgentWaiterList ref;
        while ((ref = (WeakAgentWaiterList)agentWaiterListQueue.poll()) != null) {
            if (agentWaiterListMap.get(ref.pointer).get() != null) continue;
            agentWaiterListMap.remove(ref.pointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateWaiterList(DynamicObject sharedArrayBuffer, long pointer) {
        Map<Long, WeakReference<JSAgentWaiterList>> map = agentWaiterListMap;
        synchronized (map) {
            JSAgentWaiterList wl;
            GraalJSAccess.pollAgentWaiterListQueue();
            assert (JSSharedArrayBuffer.isJSSharedArrayBuffer((DynamicObject)sharedArrayBuffer));
            assert (pointer != 0L);
            WeakAgentWaiterList ref = agentWaiterListMap.get(pointer);
            JSAgentWaiterList jSAgentWaiterList = wl = ref == null ? null : (JSAgentWaiterList)ref.get();
            if (wl == null) {
                ref = new WeakAgentWaiterList(JSSharedArrayBuffer.getWaiterList((DynamicObject)sharedArrayBuffer), pointer);
                agentWaiterListMap.put(pointer, ref);
            } else {
                JSSharedArrayBuffer.setWaiterList((DynamicObject)sharedArrayBuffer, (JSAgentWaiterList)wl);
            }
        }
    }

    public Object sharedArrayBufferNew(Object context, Object buffer, long pointer, boolean externalized) {
        ByteBuffer byteBuffer = (ByteBuffer)buffer;
        DynamicObject sharedArrayBuffer = JSSharedArrayBuffer.createSharedArrayBuffer((JSContext)((JSRealm)context).getContext(), (ByteBuffer)byteBuffer);
        sharedArrayBuffer.define((Object)EXTERNALIZED_KEY, (Object)externalized);
        if (externalized) {
            GraalJSAccess.updateWaiterList(sharedArrayBuffer, pointer);
        } else {
            this.deallocator.register(byteBuffer, pointer);
        }
        return sharedArrayBuffer;
    }

    public boolean sharedArrayBufferIsExternal(Object sharedArrayBuffer) {
        return ((DynamicObject)sharedArrayBuffer).get((Object)EXTERNALIZED_KEY) == Boolean.TRUE;
    }

    public Object sharedArrayBufferGetContents(Object sharedArrayBuffer) {
        return JSSharedArrayBuffer.getDirectByteBuffer((DynamicObject)((DynamicObject)sharedArrayBuffer));
    }

    public void sharedArrayBufferExternalize(Object sharedArrayBuffer, long pointer) {
        DynamicObject dynamicObject = (DynamicObject)sharedArrayBuffer;
        dynamicObject.define((Object)EXTERNALIZED_KEY, (Object)true);
        GraalJSAccess.updateWaiterList(dynamicObject, pointer);
    }

    public int typedArrayLength(Object typedArray) {
        return JSArrayBufferView.typedArrayGetLength((DynamicObject)((DynamicObject)typedArray));
    }

    private Object typedArrayNew(Object arrayBuffer, int offset, int length, TypedArrayFactory factory) {
        TypedArray arrayType = factory.createArrayType(true, offset != 0);
        DynamicObject dynamicObject = (DynamicObject)arrayBuffer;
        JSContext context = JSObject.getJSContext((DynamicObject)dynamicObject);
        return JSArrayBufferView.createArrayBufferView((JSContext)context, (DynamicObject)dynamicObject, (TypedArray)arrayType, (int)offset, (int)length);
    }

    public Object uint8ArrayNew(Object arrayBuffer, int offset, int length) {
        return this.typedArrayNew(arrayBuffer, offset, length, TypedArrayFactory.Uint8Array);
    }

    public Object uint8ClampedArrayNew(Object arrayBuffer, int offset, int length) {
        return this.typedArrayNew(arrayBuffer, offset, length, TypedArrayFactory.Uint8ClampedArray);
    }

    public Object int8ArrayNew(Object arrayBuffer, int offset, int length) {
        return this.typedArrayNew(arrayBuffer, offset, length, TypedArrayFactory.Int8Array);
    }

    public Object uint16ArrayNew(Object arrayBuffer, int offset, int length) {
        return this.typedArrayNew(arrayBuffer, offset, length, TypedArrayFactory.Uint16Array);
    }

    public Object int16ArrayNew(Object arrayBuffer, int offset, int length) {
        return this.typedArrayNew(arrayBuffer, offset, length, TypedArrayFactory.Int16Array);
    }

    public Object uint32ArrayNew(Object arrayBuffer, int offset, int length) {
        return this.typedArrayNew(arrayBuffer, offset, length, TypedArrayFactory.Uint32Array);
    }

    public Object int32ArrayNew(Object arrayBuffer, int offset, int length) {
        return this.typedArrayNew(arrayBuffer, offset, length, TypedArrayFactory.Int32Array);
    }

    public Object float32ArrayNew(Object arrayBuffer, int offset, int length) {
        return this.typedArrayNew(arrayBuffer, offset, length, TypedArrayFactory.Float32Array);
    }

    public Object float64ArrayNew(Object arrayBuffer, int offset, int length) {
        return this.typedArrayNew(arrayBuffer, offset, length, TypedArrayFactory.Float64Array);
    }

    public Object bigInt64ArrayNew(Object arrayBuffer, int offset, int length) {
        return this.typedArrayNew(arrayBuffer, offset, length, TypedArrayFactory.BigInt64Array);
    }

    public Object bigUint64ArrayNew(Object arrayBuffer, int offset, int length) {
        return this.typedArrayNew(arrayBuffer, offset, length, TypedArrayFactory.BigUint64Array);
    }

    public Object dataViewNew(Object arrayBuffer, int offset, int length) {
        DynamicObject dynamicObject = (DynamicObject)arrayBuffer;
        JSContext context = JSObject.getJSContext((DynamicObject)dynamicObject);
        return JSDataView.createDataView((JSContext)context, (DynamicObject)dynamicObject, (int)offset, (int)length);
    }

    public Object externalNew(Object context, long pointer) {
        return JSExternalObject.create(((JSRealm)context).getContext(), pointer);
    }

    public Object integerNew(long value) {
        return (double)value;
    }

    public Object numberNew(double value) {
        return value;
    }

    public Object dateNew(Object context, double value) {
        return JSDate.create((JSContext)((JSRealm)context).getContext(), (double)value);
    }

    public double dateValueOf(Object date) {
        return JSDate.getTimeMillisField((DynamicObject)((DynamicObject)date));
    }

    public Object symbolNew(Object name) {
        return Symbol.create((String)((String)name));
    }

    public Object symbolName(Object symbol) {
        return ((Symbol)symbol).getDescription();
    }

    public Object symbolGetIterator() {
        return Symbol.SYMBOL_ITERATOR;
    }

    public Object functionNewInstance(Object function, Object[] arguments) {
        DynamicObject functionObject = (DynamicObject)function;
        JSFunctionData functionData = JSFunction.getFunctionData((DynamicObject)functionObject);
        Object[] callArguments = JSArguments.create(null, (Object)function, (Object[])arguments);
        return functionData.getConstructTarget().call(callArguments);
    }

    public void functionSetName(Object function, String name) {
        DynamicObject functionObject = (DynamicObject)function;
        JSFunctionData functionData = JSFunction.getFunctionData((DynamicObject)functionObject);
        functionData.setName(name);
    }

    public String functionGetName(Object function) {
        DynamicObject functionObject = (DynamicObject)function;
        JSFunctionData functionData = JSFunction.getFunctionData((DynamicObject)functionObject);
        return functionData.getName();
    }

    public Object functionCall(Object function, Object receiver, Object[] arguments) {
        Object value = JSRuntime.call((Object)function, (Object)receiver, (Object[])arguments);
        Object flatten = this.valueFlatten(value);
        this.resetSharedBuffer();
        BufferUtil.asBaseBuffer((Buffer)this.sharedBuffer).position(4);
        this.sharedBuffer.putInt(0, this.valueType(flatten, true));
        return flatten;
    }

    public Object functionCall0(Object function, Object receiver) {
        return this.functionCall(function, receiver, JSArguments.EMPTY_ARGUMENTS_ARRAY);
    }

    public Object functionCall1(Object function, Object receiver, Object arg0) {
        return this.functionCall(function, receiver, new Object[]{arg0});
    }

    public Object functionCall2(Object function, Object receiver, Object arg0, Object arg1) {
        return this.functionCall(function, receiver, new Object[]{arg0, arg1});
    }

    public Object functionCall3(Object function, Object receiver, Object arg0, Object arg1, Object arg2) {
        return this.functionCall(function, receiver, new Object[]{arg0, arg1, arg2});
    }

    public Object functionCall4(Object function, Object receiver, Object arg0, Object arg1, Object arg2, Object arg3) {
        return this.functionCall(function, receiver, new Object[]{arg0, arg1, arg2, arg3});
    }

    public Object functionCall5(Object function, Object receiver, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return this.functionCall(function, receiver, new Object[]{arg0, arg1, arg2, arg3, arg4});
    }

    public Object functionCall6(Object function, Object receiver, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return this.functionCall(function, receiver, new Object[]{arg0, arg1, arg2, arg3, arg4, arg5});
    }

    public Object functionCall7(Object function, Object receiver, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        return this.functionCall(function, receiver, new Object[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6});
    }

    public Object functionCall8(Object function, Object receiver, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        return this.functionCall(function, receiver, new Object[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7});
    }

    public Object functionCall9(Object function, Object receiver, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {
        return this.functionCall(function, receiver, new Object[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8});
    }

    private static SourceSection functionGetSourceSection(Object function) {
        CallTarget callTarget;
        if (JSFunction.isJSFunction((Object)function) && (callTarget = JSFunction.getCallTarget((DynamicObject)((DynamicObject)function))) instanceof RootCallTarget) {
            RootNode rootNode = ((RootCallTarget)callTarget).getRootNode();
            return rootNode.getSourceSection();
        }
        return null;
    }

    public Object functionResourceName(Object function) {
        SourceSection sourceSection = GraalJSAccess.functionGetSourceSection(function);
        if (sourceSection == null) {
            return null;
        }
        com.oracle.truffle.api.source.Source source = sourceSection.getSource();
        return source.getName();
    }

    public int functionGetScriptLineNumber(Object function) {
        SourceSection sourceSection = GraalJSAccess.functionGetSourceSection(function);
        if (sourceSection == null) {
            return -1;
        }
        return sourceSection.getStartLine() - 1;
    }

    public int functionGetScriptColumnNumber(Object function) {
        SourceSection sourceSection = GraalJSAccess.functionGetSourceSection(function);
        if (sourceSection == null) {
            return -1;
        }
        String code = sourceSection.getCharacters().toString();
        int idx = code.indexOf(40);
        int delta = idx == -1 ? 0 : idx;
        return sourceSection.getStartColumn() + delta - 1;
    }

    public Object exceptionError(Object context, Object object) {
        return this.exceptionCreate((JSRealm)context, JSErrorType.Error, object);
    }

    public Object exceptionTypeError(Object context, Object object) {
        return this.exceptionCreate((JSRealm)context, JSErrorType.TypeError, object);
    }

    public Object exceptionSyntaxError(Object context, Object object) {
        return this.exceptionCreate((JSRealm)context, JSErrorType.SyntaxError, object);
    }

    public Object exceptionRangeError(Object context, Object object) {
        return this.exceptionCreate((JSRealm)context, JSErrorType.RangeError, object);
    }

    public Object exceptionReferenceError(Object context, Object object) {
        return this.exceptionCreate((JSRealm)context, JSErrorType.ReferenceError, object);
    }

    private Object exceptionCreate(JSRealm realm, JSErrorType errorType, Object message) {
        DynamicObject error = JSError.create((JSErrorType)errorType, (JSRealm)realm, (Object)message);
        assert (JSError.getException((DynamicObject)error) != null);
        return error;
    }

    public Object exceptionCreateMessage(Object exceptionObject) {
        return this.exceptionObjectToException(exceptionObject);
    }

    private GraalJSException exceptionObjectToException(Object exceptionObject) {
        GraalJSException exception;
        if (JSObject.isDynamicObject((Object)exceptionObject) && (exception = JSError.getException((DynamicObject)((DynamicObject)exceptionObject))) != null) {
            return exception;
        }
        return UserScriptException.create((Object)exceptionObject);
    }

    public void isolateThrowException(Object exceptionObject) {
        throw this.exceptionObjectToException(exceptionObject);
    }

    public void templateSet(Object templateObj, Object name, Object value, int attributes) {
        ObjectTemplate template = templateObj instanceof FunctionTemplate ? ((FunctionTemplate)templateObj).getFunctionObjectTemplate() : (ObjectTemplate)templateObj;
        template.addValue(new Value(name, value, GraalJSAccess.propertyAttributes(attributes)));
    }

    public void templateSetAccessorProperty(Object templateObj, Object name, Object getter, Object setter, int attributes) {
        this.templateSet(templateObj, name, new Pair(getter, setter), attributes);
    }

    public Object functionTemplateNew(int id, long pointer, Object additionalData, Object signature, int length, boolean isConstructor) {
        FunctionTemplate template = new FunctionTemplate(id, pointer, additionalData, (FunctionTemplate)signature, length, isConstructor);
        template.getInstanceTemplate().setParentFunctionTemplate(template);
        return template;
    }

    public void functionTemplateSetCallHandler(Object templateObj, long funcPointer, Object additionalData) {
        FunctionTemplate functionTemplate = (FunctionTemplate)templateObj;
        functionTemplate.setFunctionPointer(funcPointer);
        functionTemplate.setAdditionalData(additionalData);
    }

    public void functionTemplateInherit(Object templateObj, Object parent) {
        FunctionTemplate functionTemplate = (FunctionTemplate)templateObj;
        functionTemplate.setParent((FunctionTemplate)parent);
    }

    public void functionTemplateSetClassName(Object templateObj, Object name) {
        FunctionTemplate functionTemplate = (FunctionTemplate)templateObj;
        functionTemplate.setClassName((String)name);
        ObjectTemplate instanceTemplate = functionTemplate.getInstanceTemplate();
        instanceTemplate.addValue(new Value(Symbol.SYMBOL_TO_STRING_TAG, name, JSAttributes.configurableEnumerableWritable()));
    }

    public Object functionTemplateInstanceTemplate(Object templateObj) {
        FunctionTemplate functionTemplate = (FunctionTemplate)templateObj;
        return functionTemplate.getInstanceTemplate();
    }

    public Object functionTemplatePrototypeTemplate(Object templateObj) {
        FunctionTemplate functionTemplate = (FunctionTemplate)templateObj;
        return functionTemplate.getPrototypeTemplate();
    }

    public Object functionTemplateGetFunction(Object realm, Object templateObj) {
        JSRealm jsRealm = (JSRealm)realm;
        JSContext jsContext = jsRealm.getContext();
        FunctionTemplate template = (FunctionTemplate)templateObj;
        if (template.getFunctionObject() == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            DynamicObject obj = this.functionTemplateCreateCallback(jsContext, jsRealm, template);
            this.objectTemplateInstantiate(jsRealm, template.getFunctionObjectTemplate(), obj);
            ObjectTemplate prototypeTemplate = template.getPrototypeTemplate();
            if (prototypeTemplate != null) {
                DynamicObject proto = JSUserObject.create((JSContext)jsContext);
                this.objectTemplateInstantiate(jsRealm, prototypeTemplate, proto);
                JSObjectUtil.putConstructorProperty((JSContext)jsContext, (DynamicObject)proto, (DynamicObject)obj);
                JSObject.set((DynamicObject)obj, (Object)"prototype", (Object)proto);
                FunctionTemplate parentTemplate = template.getParent();
                if (parentTemplate != null) {
                    DynamicObject parentFunction = (DynamicObject)this.functionTemplateGetFunction(realm, parentTemplate);
                    DynamicObject parentProto = (DynamicObject)JSObject.get((DynamicObject)parentFunction, (Object)"prototype");
                    JSObject.setPrototype((DynamicObject)proto, (DynamicObject)parentProto);
                }
            }
        }
        return template.getFunctionObject();
    }

    private DynamicObject functionTemplateCreateCallback(JSContext context, JSRealm realm, FunctionTemplate template) {
        CompilerAsserts.neverPartOfCompilation((String)"do not create function template in compiled code");
        JSFunctionData functionData = JSFunctionData.create((JSContext)context, (int)template.getLength(), (String)template.getClassName(), (template.getPrototypeTemplate() != null ? 1 : 0) != 0, (boolean)false, (boolean)false, (boolean)false);
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new ExecuteNativeFunctionNode.NativeFunctionRootNode(this, context, template, false, false));
        RootCallTarget newCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new ExecuteNativeFunctionNode.NativeFunctionRootNode(this, context, template, true, false));
        RootCallTarget newTargetCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new ExecuteNativeFunctionNode.NativeFunctionRootNode(this, context, template, true, true));
        RootCallTarget constructTarget = Truffle.getRuntime().createCallTarget((RootNode)ConstructorRootNode.create((JSFunctionData)functionData, (CallTarget)newCallTarget, (boolean)false));
        RootCallTarget constructNewTarget = Truffle.getRuntime().createCallTarget((RootNode)ConstructorRootNode.create((JSFunctionData)functionData, (CallTarget)newTargetCallTarget, (boolean)true));
        functionData.setCallTarget((CallTarget)callTarget);
        functionData.setConstructTarget((CallTarget)constructTarget);
        functionData.setConstructNewTarget((CallTarget)constructNewTarget);
        DynamicObject functionObject = JSFunction.create((JSRealm)realm, (JSFunctionData)functionData);
        template.setFunctionObject(functionObject);
        functionObject.set((Object)FUNCTION_TEMPLATE_DATA_KEY, template.getAdditionalData());
        return functionObject;
    }

    public boolean functionTemplateHasInstance(Object templateObj, Object instance) {
        FunctionTemplate functionTemplate = (FunctionTemplate)templateObj;
        DynamicObject functionObject = functionTemplate.getFunctionObject();
        if (functionObject == null) {
            return false;
        }
        if (instance instanceof DynamicObject) {
            Object constructor = ((DynamicObject)instance).get((Object)FunctionTemplate.CONSTRUCTOR);
            if (constructor == null) {
                return false;
            }
            DynamicObject templatePrototype = (DynamicObject)JSObject.get((DynamicObject)functionObject, (Object)"prototype");
            return JSRuntime.isPrototypeOf((DynamicObject)((DynamicObject)instance), (DynamicObject)templatePrototype);
        }
        return false;
    }

    public Object objectTemplateNew() {
        return new ObjectTemplate();
    }

    @CompilerDirectives.TruffleBoundary
    public Object objectTemplateNewInstance(Object realm, Object templateObj) {
        DynamicObject instance;
        JSRealm jsRealm = (JSRealm)realm;
        JSContext jsContext = jsRealm.getContext();
        ObjectTemplate template = (ObjectTemplate)templateObj;
        FunctionTemplate functionHandler = template.getFunctionHandler();
        if (functionHandler == null) {
            FunctionTemplate parentFunctionTemplate = template.getParentFunctionTemplate();
            if (parentFunctionTemplate == null) {
                instance = JSUserObject.create((JSContext)jsContext, (JSRealm)jsRealm);
            } else {
                DynamicObject function = (DynamicObject)this.functionTemplateGetFunction(realm, parentFunctionTemplate);
                DynamicObject prototype = (DynamicObject)JSObject.get((DynamicObject)function, (Object)"prototype");
                instance = JSUserObject.createWithPrototype((DynamicObject)prototype, (JSContext)jsContext);
                instance.define((Object)FunctionTemplate.CONSTRUCTOR, (Object)parentFunctionTemplate);
            }
        } else {
            instance = this.functionTemplateCreateCallback(jsContext, jsRealm, functionHandler);
        }
        this.objectTemplateInstantiate(jsRealm, templateObj, instance);
        if (template.hasPropertyHandler()) {
            instance = this.propertyHandlerInstantiate(jsContext, jsRealm, template, instance, false);
        }
        return instance;
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject propertyHandlerInstantiate(JSContext context, JSRealm realm, ObjectTemplate template, DynamicObject target, boolean global) {
        DynamicObject handler = JSUserObject.create((JSContext)context, (JSRealm)realm);
        DynamicObject proxy = JSProxy.create((JSContext)context, (TruffleObject)target, (DynamicObject)handler);
        DynamicObject getter = GraalJSAccess.functionFromRootNode(context, realm, new ExecuteNativePropertyHandlerNode(this, context, template, proxy, ExecuteNativePropertyHandlerNode.Mode.GETTER), proxy);
        JSObject.set((DynamicObject)handler, (Object)"get", (Object)getter);
        DynamicObject setter = GraalJSAccess.functionFromRootNode(context, realm, new ExecuteNativePropertyHandlerNode(this, context, template, proxy, ExecuteNativePropertyHandlerNode.Mode.SETTER), proxy);
        JSObject.set((DynamicObject)handler, (Object)"set", (Object)setter);
        DynamicObject query = GraalJSAccess.functionFromRootNode(context, realm, new ExecuteNativePropertyHandlerNode(this, context, template, proxy, ExecuteNativePropertyHandlerNode.Mode.QUERY), proxy);
        JSObject.set((DynamicObject)handler, (Object)"has", (Object)query);
        DynamicObject deleter = GraalJSAccess.functionFromRootNode(context, realm, new ExecuteNativePropertyHandlerNode(this, context, template, proxy, ExecuteNativePropertyHandlerNode.Mode.DELETER), proxy);
        JSObject.set((DynamicObject)handler, (Object)"deleteProperty", (Object)deleter);
        DynamicObject ownKeys = GraalJSAccess.functionFromRootNode(context, realm, new ExecuteNativePropertyHandlerNode(this, context, template, proxy, ExecuteNativePropertyHandlerNode.Mode.OWN_KEYS), proxy);
        JSObject.set((DynamicObject)handler, (Object)"ownKeys", (Object)ownKeys);
        DynamicObject getOwnPropertyDescriptor = GraalJSAccess.functionFromRootNode(context, realm, new ExecuteNativePropertyHandlerNode(this, context, template, proxy, ExecuteNativePropertyHandlerNode.Mode.GET_OWN_PROPERTY_DESCRIPTOR), proxy);
        JSObject.set((DynamicObject)handler, (Object)"getOwnPropertyDescriptor", (Object)getOwnPropertyDescriptor);
        DynamicObject defineProperty = GraalJSAccess.functionFromRootNode(context, realm, new ExecuteNativePropertyHandlerNode(this, context, template, proxy, ExecuteNativePropertyHandlerNode.Mode.DEFINE_PROPERTY), proxy);
        JSObject.set((DynamicObject)handler, (Object)"defineProperty", (Object)defineProperty);
        DynamicObject getPrototypeOf = GraalJSAccess.functionFromRootNode(context, realm, new PropertyHandlerPrototypeNode(global), null);
        JSObject.set((DynamicObject)handler, (Object)"getPrototypeOf", (Object)getPrototypeOf);
        for (Value value : template.getValues()) {
            Object name = value.getName();
            if (!(name instanceof HiddenKey)) continue;
            proxy.define(name, value.getValue());
        }
        return proxy;
    }

    @CompilerDirectives.TruffleBoundary
    public void objectTemplateInstantiate(JSRealm realm, Object templateObj, Object targetObject) {
        JSContext context = realm.getContext();
        ObjectTemplate template = (ObjectTemplate)templateObj;
        DynamicObject obj = (DynamicObject)targetObject;
        for (Accessor accessor : template.getAccessors()) {
            Pair<JSFunctionData, JSFunctionData> accessorFunctions = accessor.getFunctions(context);
            DynamicObject getter = GraalJSAccess.functionFromFunctionData(realm, (JSFunctionData)accessorFunctions.getFirst(), obj);
            DynamicObject setter = GraalJSAccess.functionFromFunctionData(realm, (JSFunctionData)accessorFunctions.getSecond(), obj);
            JSObjectUtil.putAccessorProperty((JSContext)context, (DynamicObject)obj, (Object)accessor.getName(), (DynamicObject)getter, (DynamicObject)setter, (int)accessor.getAttributes());
        }
        for (Value value : template.getValues()) {
            Object name = value.getName();
            Object processedValue = value.getValue();
            int attributes = value.getAttributes();
            if (processedValue instanceof FunctionTemplate) {
                FunctionTemplate functionTempl = (FunctionTemplate)processedValue;
                processedValue = this.functionTemplateGetFunction(realm, functionTempl);
            }
            if (processedValue instanceof Pair) {
                Pair pair = (Pair)processedValue;
                Object getterTemplate = pair.getFirst();
                Object setterTemplate = pair.getSecond();
                DynamicObject getter = getterTemplate == null ? Undefined.instance : this.functionTemplateGetFunction(realm, getterTemplate);
                DynamicObject setter = setterTemplate == null ? Undefined.instance : this.functionTemplateGetFunction(realm, setterTemplate);
                JSObjectUtil.putAccessorProperty((JSContext)context, (DynamicObject)obj, (Object)name, (DynamicObject)getter, (DynamicObject)setter, (int)attributes);
                continue;
            }
            if (name instanceof HiddenKey) {
                if (template.hasPropertyHandler()) continue;
                obj.define(name, processedValue);
                continue;
            }
            if (JSObject.hasOwnProperty((DynamicObject)obj, (Object)name)) {
                JSObject.set((DynamicObject)obj, (Object)name, (Object)processedValue);
                continue;
            }
            JSObjectUtil.putDataProperty((DynamicObject)obj, (Object)name, (Object)processedValue, (int)attributes);
        }
    }

    public void objectTemplateSetAccessor(Object templateObj, Object name, long getterPtr, long setterPtr, Object data, Object signature, int attributes) {
        ObjectTemplate template = (ObjectTemplate)templateObj;
        template.addAccessor(new Accessor(this, name, getterPtr, setterPtr, data, (FunctionTemplate)signature, GraalJSAccess.propertyAttributes(attributes)));
    }

    public void objectTemplateSetHandler(Object templateObj, long getter, long setter, long query, long deleter, long enumerator, long definer, long descriptor, Object data, boolean named, boolean stringKeysOnly) {
        ObjectTemplate template = (ObjectTemplate)templateObj;
        PropertyHandler handler = new PropertyHandler(getter, setter, query, deleter, enumerator, definer, descriptor, data);
        if (named) {
            template.setNamedPropertyHandler(handler, stringKeysOnly);
        } else {
            template.setIndexedPropertyHandler(handler);
        }
    }

    public void objectTemplateSetCallAsFunctionHandler(Object templateObj, int id, long functionPointer, Object additionalData) {
        ObjectTemplate template = (ObjectTemplate)templateObj;
        FunctionTemplate functionHandler = (FunctionTemplate)this.functionTemplateNew(id, functionPointer, additionalData, null, 0, true);
        template.setFunctionHandler(functionHandler);
    }

    public Object scriptCompilerCompileFunctionInContext(Object context, String sourceName, String body, Object[] arguments, Object[] exts, Object hostDefinedOptions) {
        com.oracle.truffle.api.source.Source source;
        int i;
        boolean anyExtension;
        Object[] extensions;
        if (VERBOSE) {
            System.err.println("FUNCTION IN CONTEXT: " + sourceName);
        }
        JSRealm realm = (JSRealm)context;
        JSContext jsContext = realm.getContext();
        Evaluator nodeEvaluator = jsContext.getEvaluator();
        Object extraArgument = this.getExtraArgumentOfInternalScript(sourceName, jsContext);
        ByteBuffer snapshot = null;
        if (extraArgument == null) {
            extensions = exts;
            if (USE_SNAPSHOTS && hostDefinedOptions == null) {
                assert (exts.length == 0 && UnboundScript.isCoreModule(sourceName));
                snapshot = GraalJSAccess.getCoreModuleBinarySnapshot(sourceName);
            }
        } else {
            assert (exts.length == 0);
            DynamicObject graalExtension = JSUserObject.create((JSContext)jsContext);
            JSObject.set((DynamicObject)graalExtension, (Object)"graalExtension", (Object)extraArgument);
            extensions = new Object[]{graalExtension};
        }
        StringBuilder params = new StringBuilder();
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            if (i2 != 0) {
                params.append(", ");
            }
            params.append(arguments[i2]);
        }
        String parameterList = params.toString();
        try {
            GraalJSParserHelper.checkFunctionSyntax((JSContext)jsContext, (JSParserOptions)jsContext.getParserOptions(), (String)parameterList, (String)body, (boolean)false, (boolean)false);
        }
        catch (ParserException ex) {
            nodeEvaluator.parseFunction(jsContext, parameterList, body, false, false, sourceName);
        }
        StringBuilder code = new StringBuilder();
        boolean bl = anyExtension = extensions.length > 0;
        if (anyExtension) {
            code.append("(function () {");
            for (i = 0; i < extensions.length; ++i) {
                code.append("with (arguments[").append(i).append("]) {");
            }
            code.append("return ");
        }
        code.append("(function (");
        code.append(parameterList);
        code.append(") {");
        code.append(body);
        code.append("\n});");
        if (anyExtension) {
            for (i = 0; i < extensions.length; ++i) {
                code.append("}");
            }
            code.append(";})");
        }
        if (hostDefinedOptions == null) {
            source = com.oracle.truffle.api.source.Source.newBuilder((String)"js", (CharSequence)code.toString(), (String)sourceName).build();
        } else {
            TruffleFile truffleFile = realm.getEnv().getPublicTruffleFile(sourceName);
            source = com.oracle.truffle.api.source.Source.newBuilder((String)"js", (TruffleFile)truffleFile).content((CharSequence)code.toString()).name(sourceName).build();
            this.hostDefinedOptionsMap.put(source, hostDefinedOptions);
        }
        if (snapshot == null) {
            DynamicObject fn = (DynamicObject)nodeEvaluator.evaluate(realm, null, source);
            return anyExtension ? JSFunction.call((DynamicObject)fn, (Object)Undefined.instance, (Object[])extensions) : fn;
        }
        ScriptNode scriptNode = this.parseScriptNodeFromSnapshot(jsContext, source, snapshot);
        return scriptNode.run(realm);
    }

    public Object scriptCompile(Object context, Object sourceCode, Object fileName, Object hostDefinedOptions) {
        UnboundScript unboundScript = (UnboundScript)this.unboundScriptCompile(sourceCode, fileName, hostDefinedOptions);
        return this.unboundScriptBindToContext(context, unboundScript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Object scriptRun(Object script) {
        Script boundScript = (Script)script;
        ScriptNode scriptNode = boundScript.getScriptNode();
        if (VERBOSE) {
            com.oracle.truffle.api.source.Source source = scriptNode.getRootNode().getSourceSection().getSource();
            System.err.println("EXECUTING: " + source.getName());
        }
        JSRealm realm = boundScript.getRealm();
        Object[] arguments = scriptNode.argumentsToRun(realm);
        Object prev = realm.getTruffleContext().enter();
        try {
            Object result = boundScript.isGraalInternal() ? this.scriptRunInternal(scriptNode, arguments) : scriptNode.run(arguments);
            Object object = result;
            return object;
        }
        finally {
            realm.getTruffleContext().leave(prev);
        }
    }

    private Object scriptRunInternal(final ScriptNode scriptNode, Object[] arguments) {
        JSContext context = scriptNode.getContext();
        JSRealm realm = context.getRealm();
        final DynamicObject moduleFunction = (DynamicObject)scriptNode.run(arguments);
        JavaScriptRootNode wrapperNode = new JavaScriptRootNode(){

            public Object execute(VirtualFrame frame) {
                Object[] args = frame.getArguments();
                DynamicObject thisObject = (DynamicObject)JSArguments.getThisObject((Object[])args);
                Object result = JSFunction.call((DynamicObject)moduleFunction, (Object)thisObject, (Object[])GraalJSAccess.this.getInternalModuleUserArguments(args, scriptNode));
                return result;
            }
        };
        JSFunctionData functionData = JSFunctionData.createCallOnly((JSContext)context, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)wrapperNode), (int)5, (String)"");
        return JSFunction.create((JSRealm)realm, (JSFunctionData)functionData);
    }

    private Object getExtraArgumentOfInternalScript(String moduleName, JSContext context) {
        Object extraArgument = null;
        if ("internal/graal/buffer.js".equals(moduleName)) {
            extraArgument = USE_NIO_BUFFER ? NIOBufferObject.createInitFunction(context) : Null.instance;
        } else if ("internal/graal/debug.js".equals(moduleName)) {
            DynamicObject setBreakPoint;
            RootCallTarget setBreakPointCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new SetBreakPointNode(this));
            JSFunctionData setBreakPointData = JSFunctionData.createCallOnly((JSContext)context, (CallTarget)setBreakPointCallTarget, (int)3, (String)"setBreakPoint");
            extraArgument = setBreakPoint = JSFunction.create((JSRealm)context.getRealm(), (JSFunctionData)setBreakPointData);
        } else if ("internal/worker/io.js".equals(moduleName) || "internal/main/worker_thread.js".equals(moduleName)) {
            extraArgument = SharedMemMessagingBindings.createInitFunction(this, context);
        } else if ("inspector.js".equals(moduleName)) {
            TruffleObject inspector = this.lookupInstrument("inspect", TruffleObject.class);
            extraArgument = inspector == null ? Null.instance : inspector;
        }
        return extraArgument;
    }

    @CompilerDirectives.TruffleBoundary
    private Object[] getInternalModuleUserArguments(Object[] args, ScriptNode node) {
        Object[] userArgs = JSArguments.extractUserArguments((Object[])args);
        String moduleName = node.getRootNode().getSourceSection().getSource().getName();
        Object extraArgument = this.getExtraArgumentOfInternalScript(moduleName, node.getContext());
        if (extraArgument == null) {
            return userArgs;
        }
        Object[] extendedArgs = new Object[userArgs.length + 1];
        System.arraycopy(userArgs, 0, extendedArgs, 0, userArgs.length);
        extendedArgs[userArgs.length] = extraArgument;
        return extendedArgs;
    }

    public Object scriptGetUnboundScript(Object script) {
        return new UnboundScript((Script)script);
    }

    private static FunctionNode parseSource(com.oracle.truffle.api.source.Source source, JSContext context) {
        ContextData contextData = (ContextData)context.getEmbedderData();
        String content = source.getCharacters().toString();
        FunctionNode parseResult = contextData.getFunctionNodeCache().get(content);
        if (parseResult == null) {
            parseResult = GraalJSParserHelper.parseScript((JSContext)context, (com.oracle.truffle.api.source.Source)source, (JSParserOptions)context.getParserOptions());
            contextData.getFunctionNodeCache().put(content, parseResult);
        }
        return parseResult;
    }

    public Object unboundScriptCompile(Object sourceCode, Object fileName, Object hostDefinedOptions) {
        ByteBuffer snapshotBinary;
        String sourceCodeStr = (String)sourceCode;
        String fileNameStr = (String)fileName;
        com.oracle.truffle.api.source.Source source = UnboundScript.createSource(this.internSourceCode(sourceCodeStr), fileNameStr);
        this.hostDefinedOptionsMap.put(source, hostDefinedOptions);
        if (USE_SNAPSHOTS && fileNameStr != null && UnboundScript.isCoreModule(fileNameStr) && (snapshotBinary = GraalJSAccess.getCoreModuleBinarySnapshot(fileNameStr)) != null) {
            return new UnboundScript(source, snapshotBinary);
        }
        FunctionNode functionNode = GraalJSAccess.parseSource(source, this.mainJSContext);
        return new UnboundScript(source, functionNode);
    }

    private static ByteBuffer getCoreModuleBinarySnapshot(String modulePath) {
        ByteBuffer snapshotBinary = NativeAccess.getCoreModuleBinarySnapshot(modulePath);
        if (VERBOSE) {
            if (snapshotBinary == null) {
                System.err.printf("no snapshot for %s\n", modulePath);
            } else {
                System.err.printf("successfully read snapshot for %s\n", modulePath);
            }
        }
        return snapshotBinary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unboundScriptBindToContext(Object context, Object script) {
        ScriptNode scriptNode;
        JSRealm jsRealm = (JSRealm)context;
        JSContext jsContext = jsRealm.getContext();
        UnboundScript unboundScript = (UnboundScript)script;
        com.oracle.truffle.api.source.Source source = unboundScript.getSource();
        Object parseResult = unboundScript.getParseResult();
        if (parseResult instanceof FunctionNode) {
            ContextData contextData = (ContextData)jsContext.getEmbedderData();
            scriptNode = contextData.getScriptNodeCache().get(source);
            if (scriptNode == null) {
                JSParserOptions options = jsContext.getParserOptions();
                NodeFactory factory = NodeFactory.getInstance((JSContext)jsContext);
                Object prev = jsRealm.getTruffleContext().enter();
                try {
                    scriptNode = JavaScriptTranslator.translateFunction((NodeFactory)factory, (JSContext)jsContext, null, (com.oracle.truffle.api.source.Source)source, (boolean)options.isStrict(), (FunctionNode)((FunctionNode)parseResult));
                }
                finally {
                    jsRealm.getTruffleContext().leave(prev);
                }
                if (!"repl".equals(source.getName())) {
                    contextData.getScriptNodeCache().put(source, scriptNode);
                }
            }
        } else {
            scriptNode = this.parseScriptNodeFromSnapshot(jsContext, source, (ByteBuffer)parseResult);
        }
        return new Script(scriptNode, parseResult, jsRealm, unboundScript.getId());
    }

    public String unboundScriptGetContent(Object script) {
        return ((UnboundScript)script).getSource().getCharacters().toString();
    }

    private String internSourceCode(String sourceCode) {
        Reference<String> cacheEntry = this.sourceCodeCache.get(sourceCode);
        String entry = null;
        if (cacheEntry == null || (entry = cacheEntry.get()) == null) {
            this.sourceCodeCache.put(sourceCode, new WeakReference<String>(sourceCode));
            return sourceCode;
        }
        return entry;
    }

    private ScriptNode parseScriptNodeFromSnapshot(JSContext context, com.oracle.truffle.api.source.Source source, ByteBuffer snapshotBinary) {
        JSParser parser = (JSParser)context.getEvaluator();
        try {
            return parser.parseScriptNode(context, source, snapshotBinary);
        }
        catch (IllegalArgumentException e) {
            if (VERBOSE) {
                String moduleName = source.getName();
                System.err.printf("error when parsing binary snapshot for %s: %s\n", moduleName, e);
                System.err.printf("falling back to parsing %s at runtime\n", moduleName);
            }
            return parser.parseScriptNode(context, source);
        }
    }

    public int unboundScriptGetId(Object script) {
        return ((UnboundScript)script).getId();
    }

    public Object contextGlobal(Object realm) {
        return ((JSRealm)realm).getGlobalObject();
    }

    private static int propertyAttributes(int attributes) {
        int flags = 0;
        if ((attributes & 1) != 0) {
            flags |= 4;
        }
        if ((attributes & 2) != 0) {
            flags |= 1;
        }
        if ((attributes & 4) != 0) {
            flags |= 2;
        }
        return flags;
    }

    public static PropertyDescriptor propertyDescriptor(int v8Attributes, Object value) {
        boolean writable = (v8Attributes & 1) == 0;
        boolean enumerable = (v8Attributes & 2) == 0;
        boolean configurable = (v8Attributes & 4) == 0;
        return PropertyDescriptor.createData((Object)value, (boolean)enumerable, (boolean)writable, (boolean)configurable);
    }

    private static DynamicObject functionFromRootNode(JSContext context, JSRealm realm, JavaScriptRootNode rootNode, Object holder) {
        return GraalJSAccess.functionFromFunctionData(realm, GraalJSAccess.functionDataFromRootNode(context, rootNode), holder);
    }

    public static JSFunctionData functionDataFromRootNode(JSContext context, JavaScriptRootNode rootNode) {
        RootCallTarget callbackCallTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
        return JSFunctionData.create((JSContext)context, (CallTarget)callbackCallTarget, (CallTarget)callbackCallTarget, (int)0, (String)"", (boolean)false, (boolean)false, (boolean)false, (boolean)true);
    }

    private static DynamicObject functionFromFunctionData(JSRealm realm, JSFunctionData functionData, Object holder) {
        if (functionData == null) {
            return null;
        }
        DynamicObject function = JSFunction.create((JSRealm)realm, (JSFunctionData)functionData);
        if (holder != null) {
            function.define((Object)HOLDER_KEY, holder);
        }
        JSObject.preventExtensions((DynamicObject)function);
        return function;
    }

    @CompilerDirectives.TruffleBoundary
    public Object tryCatchException(Object context, Object exception) {
        String stack;
        Matcher matcher;
        GraalJSException truffleException;
        Object exceptionObject;
        Throwable throwable = (Throwable)exception;
        if (exception instanceof ExitException) {
            int exitCode = ((ExitException)exception).getStatus();
            this.exit(exitCode);
        } else if (throwable instanceof OutOfMemoryError) {
            throwable.printStackTrace();
            this.exit(1);
        }
        JSRealm jsRealm = (JSRealm)context;
        JSContext jsContext = jsRealm.getContext();
        if (!(throwable instanceof GraalJSException)) {
            this.isolateInternalErrorCheck(throwable);
            throwable = JSException.create((JSErrorType)JSErrorType.Error, (String)throwable.getMessage(), (Throwable)throwable, null);
        }
        if (JSRuntime.isObject((Object)(exceptionObject = (truffleException = (GraalJSException)throwable).getErrorObjectEager(jsContext))) && JSError.getException((DynamicObject)((DynamicObject)exceptionObject)) == null) {
            ((DynamicObject)exceptionObject).define((Object)JSError.EXCEPTION_PROPERTY_NAME, (Object)truffleException);
        }
        if ((matcher = GraalJSAccess.messageSyntaxErrorMatcher(exception)) != null && (stack = JSRuntime.toString((Object)JSObject.get((DynamicObject)((DynamicObject)exceptionObject), (Object)"stack"))).startsWith(truffleException.getMessage())) {
            String message = matcher.group(4);
            stack = "SyntaxError: " + message + stack.substring(truffleException.getMessage().length());
            JSObject.set((DynamicObject)((DynamicObject)exceptionObject), (Object)"stack", (Object)stack);
        }
        return exceptionObject;
    }

    public boolean tryCatchHasTerminated(Object exception) {
        return exception instanceof GraalJSKillException || exception instanceof TruffleException && ((TruffleException)exception).isCancelled();
    }

    private static GraalJSException.JSStackTraceElement messageGraalJSExceptionStackFrame(Object exception) {
        if (exception instanceof GraalJSException) {
            GraalJSException.JSStackTraceElement stackFrame;
            GraalJSException truffleException = (GraalJSException)exception;
            GraalJSException.JSStackTraceElement[] stackTrace = truffleException.getJSStackTrace();
            int index = 0;
            do {
                if (index != stackTrace.length) continue;
                stackFrame = null;
                break;
            } while ("<builtin>".equals((stackFrame = stackTrace[index++]).getFileName()));
            return stackFrame;
        }
        return null;
    }

    private static Matcher messageSyntaxErrorMatcher(Object exception) {
        String message;
        Matcher matcher;
        JSException jsException;
        if (exception instanceof JSException && (jsException = (JSException)exception).getErrorType() == JSErrorType.SyntaxError && (matcher = SYNTAX_ERROR_PATTERN.matcher(message = jsException.getRawMessage())).matches()) {
            return matcher;
        }
        return null;
    }

    private static String messageSyntaxErrorResourceName(Object exception) {
        Matcher matcher = GraalJSAccess.messageSyntaxErrorMatcher(exception);
        if (matcher != null) {
            return matcher.group(1);
        }
        return null;
    }

    private static int messageSyntaxErrorLineNumber(Object exception) {
        Matcher matcher = GraalJSAccess.messageSyntaxErrorMatcher(exception);
        if (matcher != null) {
            String lineNumber = matcher.group(2);
            return Integer.parseInt(lineNumber);
        }
        return -1;
    }

    private static int messageSyntaxErrorColumnNumber(Object exception) {
        Matcher matcher = GraalJSAccess.messageSyntaxErrorMatcher(exception);
        if (matcher != null) {
            String columnNumber = matcher.group(3);
            return Integer.parseInt(columnNumber);
        }
        return -1;
    }

    private static String messageSyntaxErrorSourceLine(Object exception) {
        Matcher matcher = GraalJSAccess.messageSyntaxErrorMatcher(exception);
        if (matcher != null) {
            return matcher.group(5);
        }
        return null;
    }

    public Object messageGetScriptResourceName(Object exception) {
        String resourceName = GraalJSAccess.messageSyntaxErrorResourceName(exception);
        if (resourceName != null) {
            return resourceName;
        }
        GraalJSException.JSStackTraceElement stackFrame = GraalJSAccess.messageGraalJSExceptionStackFrame(exception);
        if (stackFrame != null) {
            return stackFrame.getFileName();
        }
        return "unknown";
    }

    public int messageGetLineNumber(Object exception) {
        int lineNumber = GraalJSAccess.messageSyntaxErrorLineNumber(exception);
        if (lineNumber != -1) {
            return lineNumber;
        }
        GraalJSException.JSStackTraceElement stackFrame = GraalJSAccess.messageGraalJSExceptionStackFrame(exception);
        if (stackFrame != null) {
            return stackFrame.getLineNumber();
        }
        return 0;
    }

    public int messageGetStartColumn(Object exception) {
        int columnNumber = GraalJSAccess.messageSyntaxErrorColumnNumber(exception);
        if (columnNumber != -1) {
            return columnNumber;
        }
        GraalJSException.JSStackTraceElement stackFrame = GraalJSAccess.messageGraalJSExceptionStackFrame(exception);
        if (stackFrame != null) {
            return stackFrame.getColumnNumber() - 1;
        }
        return 0;
    }

    public Object messageGetSourceLine(Object exception) {
        String sourceLine = GraalJSAccess.messageSyntaxErrorSourceLine(exception);
        if (sourceLine != null) {
            return sourceLine;
        }
        GraalJSException.JSStackTraceElement stackFrame = GraalJSAccess.messageGraalJSExceptionStackFrame(exception);
        if (stackFrame != null) {
            return stackFrame.getLine();
        }
        return "unknown";
    }

    public Object messageGetStackTrace(Object exception) {
        if (exception instanceof GraalJSException) {
            GraalJSException truffleException = (GraalJSException)exception;
            return truffleException.getJSStackTrace();
        }
        return new GraalJSException.JSStackTraceElement[0];
    }

    public Object messageGet(Object exception) {
        return "Uncaught " + ((Throwable)exception).getMessage();
    }

    public Object stackTraceCurrentStackTrace() {
        return GraalJSException.getJSStackTrace(null);
    }

    public int stackFrameGetLineNumber(Object stackFrame) {
        GraalJSException.JSStackTraceElement element = (GraalJSException.JSStackTraceElement)stackFrame;
        return element.getLineNumber();
    }

    public int stackFrameGetColumn(Object stackFrame) {
        GraalJSException.JSStackTraceElement element = (GraalJSException.JSStackTraceElement)stackFrame;
        return element.getColumnNumber();
    }

    public Object stackFrameGetScriptName(Object stackFrame) {
        GraalJSException.JSStackTraceElement element = (GraalJSException.JSStackTraceElement)stackFrame;
        return element.getFileName();
    }

    public Object stackFrameGetFunctionName(Object stackFrame) {
        GraalJSException.JSStackTraceElement element = (GraalJSException.JSStackTraceElement)stackFrame;
        return element.getFunctionName();
    }

    public boolean stackFrameIsEval(Object stackFrame) {
        GraalJSException.JSStackTraceElement element = (GraalJSException.JSStackTraceElement)stackFrame;
        return element.isEval();
    }

    private WeakCallback updateWeakCallback(DynamicObject object, long reference, long data, long callbackPointer, int type, HiddenKey key) {
        WeakCallback weakCallback;
        HashMap<Long, WeakCallback> map = (HashMap<Long, WeakCallback>)object.get((Object)key);
        if (map == null) {
            map = new HashMap<Long, WeakCallback>();
            object.define((Object)key, map);
        }
        if ((weakCallback = (WeakCallback)map.get(reference)) == null) {
            weakCallback = new WeakCallback(object, data, callbackPointer, type, this.weakCallbackQueue);
            map.put(reference, weakCallback);
        } else {
            weakCallback.data = data;
            weakCallback.callback = callbackPointer;
            weakCallback.type = type;
        }
        if (callbackPointer == 0L) {
            this.weakCallbacks.remove(weakCallback);
        } else {
            this.weakCallbacks.add(weakCallback);
        }
        return weakCallback;
    }

    private void pollWeakCallbackQueue(boolean canBlock) {
        WeakCallback callback;
        if (canBlock) {
            try {
                callback = (WeakCallback)this.weakCallbackQueue.remove(10L);
                if (callback != null) {
                    this.processWeakCallback(callback);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        while ((callback = (WeakCallback)this.weakCallbackQueue.poll()) != null) {
            this.processWeakCallback(callback);
        }
    }

    private void processWeakCallback(WeakCallback callback) {
        this.weakCallbacks.remove(callback);
        if (callback.callback != 0L) {
            NativeAccess.weakCallback(callback.callback, callback.data, callback.type);
        }
    }

    public void makeWeak(Object object, long reference, long data, long callbackPointer, int type) {
        HiddenKey key;
        DynamicObject target;
        if (object == null) {
            System.err.println("null object given to makeWeak!");
            return;
        }
        if (object instanceof JSRealm) {
            target = ((JSRealm)object).getGlobalObject();
            key = HIDDEN_WEAK_CALLBACK_CONTEXT;
        } else {
            target = (DynamicObject)object;
            key = HIDDEN_WEAK_CALLBACK;
        }
        this.updateWeakCallback(target, reference, data, callbackPointer, type, key);
        this.pollWeakCallbackQueue(false);
    }

    public long clearWeak(Object object, long reference) {
        HiddenKey key;
        DynamicObject target;
        if (object == null) {
            return 0L;
        }
        if (object instanceof JSRealm) {
            target = ((JSRealm)object).getGlobalObject();
            key = HIDDEN_WEAK_CALLBACK_CONTEXT;
        } else {
            target = (DynamicObject)object;
            key = HIDDEN_WEAK_CALLBACK;
        }
        WeakCallback callback = this.updateWeakCallback(target, reference, 0L, 0L, 0, key);
        return callback.data;
    }

    @CompilerDirectives.TruffleBoundary
    public <T> T lookupInstrument(String instrumentId, Class<T> instrumentClass) {
        TruffleLanguage.Env env = this.envForInstruments;
        InstrumentInfo info = (InstrumentInfo)env.getInstruments().get(instrumentId);
        return (T)(info == null ? null : env.lookup(info, instrumentClass));
    }

    public Object contextNew(Object templateObj) {
        JSContext context;
        JSRealm realm;
        if (this.createChildContext) {
            realm = this.mainJSRealm.createChildRealm();
            context = realm.getContext();
            assert (realm.getAgent() == this.agent);
        } else {
            realm = this.mainJSRealm;
            context = this.mainJSContext;
            context.setEmbedderData((Object)new ContextData(context));
            this.createChildContext = true;
        }
        realm.setEmbedderData((Object)new RealmData());
        DynamicObject global = realm.getGlobalObject();
        global.delete((Object)"arguments");
        if (this.exposeGC) {
            this.contextExposeGC(realm);
        }
        if (templateObj != null) {
            ObjectTemplate template = (ObjectTemplate)templateObj;
            if (template.hasPropertyHandler()) {
                global = this.propertyHandlerInstantiate(context, realm, template, global, true);
                realm.setGlobalObject(global);
            } else {
                DynamicObject prototype = JSUserObject.create((JSContext)context);
                this.objectTemplateInstantiate(realm, template, prototype);
                JSObject.setPrototype((DynamicObject)global, (DynamicObject)prototype);
            }
        }
        return realm;
    }

    public static RealmData getRealmEmbedderData(Object realm) {
        return (RealmData)((JSRealm)realm).getEmbedderData();
    }

    public static ContextData getContextEmbedderData(JSContext context) {
        return (ContextData)context.getEmbedderData();
    }

    private void contextExposeGC(JSRealm realm) {
        DynamicObject global = realm.getGlobalObject();
        JavaScriptRootNode rootNode = new JavaScriptRootNode(){

            public Object execute(VirtualFrame vf) {
                GraalJSAccess.this.isolatePerformGC();
                return Undefined.instance;
            }
        };
        JSFunctionData functionData = JSFunctionData.createCallOnly((JSContext)realm.getContext(), (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)rootNode), (int)0, (String)"gc");
        DynamicObject function = JSFunction.create((JSRealm)realm, (JSFunctionData)functionData);
        JSObject.set((DynamicObject)global, (Object)"gc", (Object)function);
    }

    @CompilerDirectives.TruffleBoundary
    private void isolatePerformGC() {
        NativeAccess.notifyGCCallbacks(true);
        this.pollWeakCallbackQueue(true);
        for (int i = 0; i < 3; ++i) {
            System.gc();
            this.pollWeakCallbackQueue(true);
        }
        NativeAccess.notifyGCCallbacks(false);
    }

    public void contextSetSecurityToken(Object context, Object securityToken) {
        RealmData contextData = GraalJSAccess.getRealmEmbedderData(context);
        contextData.setSecurityToken(securityToken);
    }

    public Object contextGetSecurityToken(Object context) {
        RealmData contextData = GraalJSAccess.getRealmEmbedderData(context);
        Object securityToken = contextData.getSecurityToken();
        return securityToken == null ? Undefined.instance : securityToken;
    }

    public Object contextGetExtrasBindingObject(Object context) {
        RealmData contextData = GraalJSAccess.getRealmEmbedderData(context);
        DynamicObject extras = contextData.getExtrasBindingObject();
        if (extras == null) {
            extras = this.initializeExtrasBindingObject((JSRealm)context);
            contextData.setExtrasBindingObject(extras);
        }
        return extras;
    }

    private DynamicObject initializeExtrasBindingObject(JSRealm realm) {
        DynamicObject extras = JSUserObject.create((JSContext)realm.getContext(), (JSRealm)realm);
        JavaScriptRootNode isEnabledRootNode = new JavaScriptRootNode(){

            public Object execute(VirtualFrame vf) {
                return false;
            }
        };
        JSFunctionData isEnabledFunctionData = JSFunctionData.createCallOnly((JSContext)realm.getContext(), (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)isEnabledRootNode), (int)0, (String)"isTraceCategoryEnabled");
        DynamicObject isEnabledFunction = JSFunction.create((JSRealm)realm, (JSFunctionData)isEnabledFunctionData);
        JSObject.set((DynamicObject)extras, (Object)"isTraceCategoryEnabled", (Object)isEnabledFunction);
        JavaScriptRootNode traceRootNode = new JavaScriptRootNode(){

            public Object execute(VirtualFrame vf) {
                return Undefined.instance;
            }
        };
        JSFunctionData traceFunctionData = JSFunctionData.createCallOnly((JSContext)realm.getContext(), (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)traceRootNode), (int)0, (String)"trace");
        DynamicObject traceFunction = JSFunction.create((JSRealm)realm, (JSFunctionData)traceFunctionData);
        JSObject.set((DynamicObject)extras, (Object)"trace", (Object)traceFunction);
        return extras;
    }

    public void contextSetPointerInEmbedderData(Object context, int index, long pointer) {
        this.contextSetEmbedderData(context, index, pointer);
    }

    public long contextGetPointerInEmbedderData(Object context, int index) {
        Long pointer = (Long)this.contextGetEmbedderData(context, index);
        return pointer == null ? 0L : pointer;
    }

    public void contextSetEmbedderData(Object realm, int index, Object value) {
        RealmData data = GraalJSAccess.getRealmEmbedderData(realm);
        data.setEmbedderData(index, value);
    }

    public Object contextGetEmbedderData(Object realm, int index) {
        RealmData data = GraalJSAccess.getRealmEmbedderData(realm);
        return data.getEmbedderData(index);
    }

    public void isolateRunMicrotasks() {
        this.pollWeakCallbackQueue(false);
        try {
            this.agent.processAllPromises();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Object isolateCreateInternalFieldCountKey() {
        return INTERNAL_FIELD_COUNT_KEY;
    }

    public Object isolateCreateInternalFieldKey(int index) {
        return index == 0 ? INTERNAL_FIELD_ZERO_KEY : new HiddenKey("InternalField" + index);
    }

    public int objectInternalFieldCount(Object target) {
        return GraalJSAccess.internalFieldCount((DynamicObject)target);
    }

    public static int internalFieldCount(DynamicObject target) {
        Object ret = target.get((Object)INTERNAL_FIELD_COUNT_KEY);
        if (ret instanceof Integer) {
            return (Integer)ret;
        }
        if (ret instanceof Double) {
            return ((Double)ret).intValue();
        }
        return 0;
    }

    public long objectSlowGetAlignedPointerFromInternalField(Object target) {
        Object pointer = ((DynamicObject)target).get((Object)INTERNAL_FIELD_ZERO_KEY);
        return pointer == null ? 0L : ((Number)pointer).longValue();
    }

    public void objectSetAlignedPointerInInternalField(Object target, long value) {
        ((DynamicObject)target).define((Object)INTERNAL_FIELD_ZERO_KEY, (Object)value);
    }

    public Object objectPreviewEntries(Object object) {
        DynamicObject dynamicObject = (DynamicObject)object;
        JSContext context = JSObject.getJSContext((DynamicObject)dynamicObject);
        JSHashMap.Cursor cursor = (JSHashMap.Cursor)dynamicObject.get((Object)JSRuntime.ITERATOR_NEXT_INDEX);
        if (cursor != null) {
            boolean isSet;
            Object kindObject = dynamicObject.get((Object)JSMap.MAP_ITERATION_KIND_ID);
            boolean bl = isSet = kindObject == null;
            if (isSet) {
                kindObject = dynamicObject.get((Object)JSSet.SET_ITERATION_KIND_ID);
            }
            int kind = ((Number)kindObject).intValue();
            cursor = cursor.copy();
            ArrayList<Object> entries = new ArrayList<Object>();
            while (cursor.advance()) {
                Object value;
                Object key = cursor.getKey();
                Object object2 = value = isSet ? key : cursor.getValue();
                if (kind == 1) {
                    entries.add(key);
                    continue;
                }
                if (kind == 2) {
                    entries.add(value);
                    continue;
                }
                entries.add(key);
                entries.add(value);
                assert (kind == 3);
            }
            this.resetSharedBuffer();
            this.sharedBuffer.putInt(kind == 3 ? 1 : 0);
            return JSArray.createConstantObjectArray((JSContext)context, (Object[])entries.toArray());
        }
        if (JSWeakMap.isJSWeakMap((Object)object) || JSWeakSet.isJSWeakSet((Object)object)) {
            this.resetSharedBuffer();
            this.sharedBuffer.putInt(0);
            return JSArray.createConstantEmptyArray((JSContext)context);
        }
        return null;
    }

    public void isolateInternalErrorCheck(Object exception) {
        boolean internalError;
        boolean bl = internalError = !(exception instanceof TruffleException) && !(exception instanceof StackOverflowError) && !(exception instanceof OutOfMemoryError) && !(exception instanceof ControlFlowException) && !(exception instanceof GraalJSKillException);
        if (internalError) {
            ((Throwable)exception).printStackTrace();
            this.exit(1);
        }
    }

    public void isolateThrowStackOverflowError() {
        throw Errors.createRangeErrorStackOverflow();
    }

    public void isolateGetHeapStatistics() {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        long max = runtime.maxMemory();
        this.resetSharedBuffer();
        this.sharedBuffer.putLong(total);
        this.sharedBuffer.putLong(max);
        this.sharedBuffer.putLong(total - free);
    }

    public synchronized void isolateCancelTerminateExecution() {
        this.terminateExecution = false;
        if (Thread.currentThread() == this.agent.getThread()) {
            Thread.interrupted();
        }
    }

    public synchronized void isolateTerminateExecution() {
        Debugger debugger;
        if (this.terminateExecution) {
            return;
        }
        this.terminateExecution = true;
        Thread thread = this.agent.getThread();
        if (thread != null) {
            thread.interrupt();
        }
        if ((debugger = this.lookupInstrument("debugger", Debugger.class)) == null) {
            System.err.println("Debugger is not available!");
            return;
        }
        debugger.startSession(new SuspendedCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuspend(SuspendedEvent se) {
                GraalJSAccess graalJSAccess = GraalJSAccess.this;
                synchronized (graalJSAccess) {
                    if (!GraalJSAccess.this.terminateExecution) {
                        return;
                    }
                }
                se.getSession().close();
                throw new GraalJSKillException();
            }
        }).suspendNextExecution();
    }

    public Object isolateGetIntPlaceholder() {
        return INT_PLACEHOLDER;
    }

    public Object isolateGetLargeIntPlaceholder() {
        return LARGE_INT_PLACEHOLDER;
    }

    public Object isolateGetDoublePlaceholder() {
        return DOUBLE_PLACEHOLDER;
    }

    public void isolateDispose(boolean exit, int status) {
        if (exit) {
            this.exit(status);
        }
    }

    public void isolateEnablePromiseHook(boolean enable) {
        PromiseHook hook = enable ? new PromiseHook(){

            public void promiseChanged(int changeType, DynamicObject promise, DynamicObject parentPromise) {
                NativeAccess.notifyPromiseHook(changeType, promise, parentPromise);
            }
        } : null;
        this.mainJSContext.setPromiseHook(hook);
    }

    public void isolateEnablePromiseRejectCallback(boolean enable) {
        PromiseRejectionTracker tracker = enable ? new PromiseRejectionTracker(){

            public void promiseRejected(DynamicObject promise, Object value) {
                NativeAccess.notifyPromiseRejectionTracker(promise, 0, value);
            }

            public void promiseRejectionHandled(DynamicObject promise) {
                NativeAccess.notifyPromiseRejectionTracker(promise, 1, Undefined.instance);
            }

            public void promiseRejectedAfterResolved(DynamicObject promise, Object value) {
                NativeAccess.notifyPromiseRejectionTracker(promise, 2, value);
            }

            public void promiseResolvedAfterResolved(DynamicObject promise, Object value) {
                NativeAccess.notifyPromiseRejectionTracker(promise, 3, value);
            }
        } : null;
        this.mainJSContext.setPromiseRejectionTracker(tracker);
    }

    public void isolateEnableImportMetaInitializer(boolean enable) {
        ImportMetaInitializer initializer = enable ? new ImportMetaInitializer(){

            public void initializeImportMeta(DynamicObject importMeta, JSModuleRecord module) {
                NativeAccess.notifyImportMetaInitializer(importMeta, module);
            }
        } : null;
        this.mainJSContext.setImportMetaInitializer(initializer);
    }

    public void isolateEnableImportModuleDynamically(boolean enable) {
        ImportModuleDynamicallyCallback callback = enable ? new ImportModuleDynamicallyCallback(){

            public DynamicObject importModuleDynamically(JSRealm realm, ScriptOrModule referrer, String specifier) {
                return (DynamicObject)NativeAccess.executeImportModuleDynamicallyCallback(realm, referrer, specifier);
            }
        } : null;
        this.mainJSContext.setImportModuleDynamicallyCallback(callback);
    }

    public void isolateEnablePrepareStackTraceCallback(boolean enable) {
        PrepareStackTraceCallback callback = enable ? new PrepareStackTraceCallback(){

            public Object prepareStackTrace(JSRealm realm, DynamicObject error, DynamicObject structuredStackTrace) {
                return NativeAccess.executePrepareStackTraceCallback(realm, error, structuredStackTrace);
            }
        } : null;
        this.mainJSContext.setPrepareStackTraceCallback(callback);
    }

    private void exit(int status) {
        this.evaluator.close();
        System.exit(status);
    }

    public void isolateEnterPolyglotEngine(final long callback, final long isolate, final long param1, final long param2, final long args, final long execArgs) {
        Source source = Source.newBuilder((String)"js", (CharSequence)"(function(r) { r.run(); })", (String)"polyglotEngineWrapper").internal(true).buildLiteral();
        org.graalvm.polyglot.Value wrapper = this.evaluator.eval(source);
        wrapper.execute(new Object[]{new RunnableInvoker(new Runnable(){

            @Override
            public void run() {
                NativeAccess.polyglotEngineEntered(callback, isolate, param1, param2, args, execArgs);
            }
        })});
    }

    public void isolateEnter(long isolate) {
        Deque<Pair<Long, Object>> list = isolateStack.get();
        if (list == null) {
            list = new LinkedList<Pair<Long, Object>>();
            isolateStack.set(list);
        }
        Object previous = this.mainJSRealm.getTruffleContext().enter();
        if (list.isEmpty()) {
            this.agent.setThread(Thread.currentThread());
        }
        list.push((Pair<Long, Object>)new Pair((Object)isolate, previous));
    }

    public long isolateExit(long isolate) {
        Deque<Pair<Long, Object>> list = isolateStack.get();
        Pair<Long, Object> pair = list.pop();
        assert ((Long)pair.getFirst() == isolate);
        this.mainJSRealm.getTruffleContext().leave(pair.getSecond());
        if (list.isEmpty()) {
            this.agent.setThread(null);
            return 0L;
        }
        return (Long)list.peekLast().getFirst();
    }

    public void isolateEnqueueMicrotask(Object microtask) {
        this.agent.enqueuePromiseJob((DynamicObject)microtask);
    }

    public void isolateSchedulePauseOnNextStatement() {
        Breakpoint breakpoint = Breakpoint.newBuilder((URI)null).oneShot().build();
        Debugger debugger = this.lookupInstrument("debugger", Debugger.class);
        debugger.install(breakpoint);
    }

    public Object correctReturnValue(Object value) {
        if (value == INT_PLACEHOLDER) {
            this.resetSharedBuffer();
            return this.getSharedBuffer().getInt();
        }
        if (value == LARGE_INT_PLACEHOLDER) {
            this.resetSharedBuffer();
            return LargeInteger.valueOf((long)this.getSharedBuffer().getLong());
        }
        if (value == DOUBLE_PLACEHOLDER) {
            this.resetSharedBuffer();
            return this.getSharedBuffer().getDouble();
        }
        return value;
    }

    public void stringExternalResourceCallback(Object object, long data, long callbackPointer) {
        WeakCallback weakCallback = new WeakCallback(object, data, callbackPointer, 1, this.weakCallbackQueue);
        this.weakCallbacks.add(weakCallback);
        this.pollWeakCallbackQueue(false);
    }

    public Object proxyGetTarget(Object proxy) {
        return JSProxy.getTarget((DynamicObject)((DynamicObject)proxy));
    }

    public Object proxyGetHandler(Object proxy) {
        return JSProxy.getHandler((DynamicObject)((DynamicObject)proxy));
    }

    public boolean proxyIsFunction(Object proxy) {
        return JSRuntime.isCallableProxy((DynamicObject)((DynamicObject)proxy));
    }

    public Object booleanObjectNew(Object context, boolean value) {
        return JSBoolean.create((JSContext)((JSRealm)context).getContext(), (boolean)value);
    }

    public boolean booleanObjectValueOf(Object object) {
        return JSBoolean.valueOf((DynamicObject)((DynamicObject)object));
    }

    public Object stringObjectNew(Object context, Object value) {
        return JSString.create((JSContext)((JSRealm)context).getContext(), (CharSequence)((String)value));
    }

    public String stringObjectValueOf(Object object) {
        return JSString.getString((DynamicObject)((DynamicObject)object));
    }

    public Object numberObjectNew(Object context, double value) {
        return JSNumber.create((JSContext)((JSRealm)context).getContext(), (Number)value);
    }

    private static String regexpFlagsToString(int flags) {
        StringBuilder builder = new StringBuilder();
        if ((flags & 1) != 0) {
            builder.append('g');
        } else if ((flags & 2) != 0) {
            builder.append('i');
        } else if ((flags & 4) != 0) {
            builder.append('m');
        } else if ((flags & 8) != 0) {
            builder.append('y');
        } else if ((flags & 0x10) != 0) {
            builder.append('u');
        } else if ((flags & 0x20) != 0) {
            builder.append('s');
        }
        return builder.toString();
    }

    public Object regexpNew(Object context, Object pattern, int flags) {
        JSContext jsContext = ((JSRealm)context).getContext();
        return GraalJSAccess.regexpCreate(jsContext, (String)pattern, flags);
    }

    public static Object regexpCreate(JSContext context, String pattern, int v8Flags) {
        Object compiledRegexp = RegexCompilerInterface.compile((String)pattern, (String)GraalJSAccess.regexpFlagsToString(v8Flags), (JSContext)context, (TRegexUtil.CompileRegexNode)TRegexUtil.CompileRegexNode.getUncached());
        return JSRegExp.create((JSContext)context, (Object)compiledRegexp);
    }

    @CompilerDirectives.TruffleBoundary
    public String regexpGetSource(Object regexp) {
        return GraalJSAccess.regexpPattern((DynamicObject)regexp);
    }

    public static String regexpPattern(DynamicObject regexp) {
        assert (JSRegExp.isJSRegExp((DynamicObject)regexp));
        Object compiledRegex = JSRegExp.getCompiledRegex((DynamicObject)regexp);
        return TRegexUtil.InteropReadStringMemberNode.getUncached().execute(compiledRegex, "pattern");
    }

    @CompilerDirectives.TruffleBoundary
    public int regexpGetFlags(Object regexp) {
        return GraalJSAccess.regexpV8Flags((DynamicObject)regexp);
    }

    public static int regexpV8Flags(DynamicObject regexp) {
        Object compiledRegex = JSRegExp.getCompiledRegex((DynamicObject)regexp);
        Object flagsObj = TRegexUtil.InteropReadMemberNode.getUncached().execute(compiledRegex, "flags");
        int v8Flags = 0;
        if (TRegexUtil.InteropReadBooleanMemberNode.getUncached().execute(flagsObj, "global")) {
            v8Flags |= 1;
        }
        if (TRegexUtil.InteropReadBooleanMemberNode.getUncached().execute(flagsObj, "ignoreCase")) {
            v8Flags |= 2;
        }
        if (TRegexUtil.InteropReadBooleanMemberNode.getUncached().execute(flagsObj, "multiline")) {
            v8Flags |= 4;
        }
        if (TRegexUtil.InteropReadBooleanMemberNode.getUncached().execute(flagsObj, "sticky")) {
            v8Flags |= 8;
        }
        if (TRegexUtil.InteropReadBooleanMemberNode.getUncached().execute(flagsObj, "unicode")) {
            v8Flags |= 0x10;
        }
        return v8Flags;
    }

    public Object[] findDynamicObjectFields(Object context) {
        if (!JSTruffleOptions.SubstrateVM) {
            Object arrayBuffer = this.arrayBufferNew(context, 4);
            Object typedArray = this.uint8ArrayNew(arrayBuffer, 2, 1);
            try {
                String byteBuffer = GraalJSAccess.findObjectFieldName(arrayBuffer, JSArrayBuffer.getDirectByteBuffer((DynamicObject)((DynamicObject)arrayBuffer)));
                String buffer = GraalJSAccess.findObjectFieldName(typedArray, arrayBuffer);
                return new Object[]{arrayBuffer.getClass(), byteBuffer, typedArray.getClass(), buffer};
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String findObjectFieldName(Object object, Object search) throws Exception {
        if (!JSTruffleOptions.SubstrateVM) {
            Field[] declaredFields;
            for (Field field : declaredFields = object.getClass().getDeclaredFields()) {
                if (field.getType() != Object.class) continue;
                field.setAccessible(true);
                if (field.get(object) != search) continue;
                return field.getName();
            }
        }
        return null;
    }

    public Object jsonParse(Object context, Object string) {
        return GraalJSParserHelper.parseJSON((String)((String)string), (JSContext)((JSRealm)context).getContext());
    }

    public String jsonStringify(Object context, Object object, String gap) {
        DynamicObject stringify = ((JSRealm)context).lookupFunction("JSON", "stringify");
        return (String)JSFunction.call((DynamicObject)stringify, (Object)Undefined.instance, (Object[])new Object[]{object, Undefined.instance, gap == null ? Undefined.instance : gap});
    }

    public Object promiseResult(Object promise) {
        return ((DynamicObject)promise).get((Object)JSPromise.PROMISE_RESULT);
    }

    public int promiseState(Object promise) {
        Object state = ((DynamicObject)promise).get((Object)JSPromise.PROMISE_STATE);
        return ((Number)state).intValue();
    }

    public Object promiseResolverNew(Object context) {
        DynamicObject resolverFactory = this.getResolverFactory(context);
        return JSFunction.call((Object[])JSArguments.create((Object)Undefined.instance, (Object)resolverFactory, (Object[])new Object[]{RESOLVER_RESOLVE, RESOLVER_REJECT}));
    }

    private DynamicObject getResolverFactory(Object realm) {
        RealmData data = GraalJSAccess.getRealmEmbedderData(realm);
        DynamicObject resolverFactory = data.getResolverFactory();
        if (resolverFactory == null) {
            resolverFactory = this.createResolverFactory((JSRealm)realm);
            data.setResolverFactory(resolverFactory);
        }
        return resolverFactory;
    }

    private DynamicObject createResolverFactory(JSRealm realm) {
        JSContext context = realm.getContext();
        JSParser parser = (JSParser)context.getEvaluator();
        String code = "(function(resolveKey, rejectKey) {\n    var resolve, reject;\n    var promise = new Promise(function() {\n        resolve = arguments[0];\n        reject = arguments[1];\n    });\n    Object.defineProperty(promise, resolveKey, { value : resolve });\n    Object.defineProperty(promise, rejectKey, { value : reject });\n    return promise;\n})";
        ScriptNode scriptNode = parser.parseScriptNode(context, code);
        return (DynamicObject)scriptNode.run(realm);
    }

    public boolean promiseResolverResolve(Object resolver, Object value) {
        Object resolve = JSObject.get((DynamicObject)((DynamicObject)resolver), (Object)RESOLVER_RESOLVE);
        JSFunction.call((Object[])JSArguments.create((Object)Undefined.instance, (Object)resolve, (Object[])new Object[]{value}));
        return true;
    }

    public boolean promiseResolverReject(Object resolver, Object value) {
        Object reject = JSObject.get((DynamicObject)((DynamicObject)resolver), (Object)RESOLVER_REJECT);
        JSFunction.call((Object[])JSArguments.create((Object)Undefined.instance, (Object)reject, (Object[])new Object[]{value}));
        return true;
    }

    private ESModuleLoader getModuleLoader() {
        if (this.moduleLoader == null) {
            this.moduleLoader = new ESModuleLoader();
        }
        return this.moduleLoader;
    }

    public Object moduleCompile(Object context, Object sourceCode, Object name, Object hostDefinedOptions) {
        JSContext jsContext = ((JSRealm)context).getContext();
        NodeFactory factory = NodeFactory.getInstance((JSContext)jsContext);
        String moduleName = (String)name;
        Source.LiteralBuilder builder = com.oracle.truffle.api.source.Source.newBuilder((String)"js", (CharSequence)((String)sourceCode), (String)moduleName);
        try {
            builder = builder.uri(new URI(moduleName));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        com.oracle.truffle.api.source.Source source = builder.build();
        this.hostDefinedOptionsMap.put(source, hostDefinedOptions);
        return JavaScriptTranslator.translateModule((NodeFactory)factory, (JSContext)jsContext, (com.oracle.truffle.api.source.Source)source, (JSModuleLoader)this.getModuleLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moduleInstantiate(Object context, Object module, long resolveCallback) {
        ESModuleLoader loader = this.getModuleLoader();
        loader.setResolver(resolveCallback);
        JSContext jsContext = ((JSRealm)context).getContext();
        try {
            jsContext.getEvaluator().moduleInstantiation((JSModuleRecord)module);
        }
        finally {
            loader.setResolver(0L);
        }
    }

    public Object moduleEvaluate(Object context, Object module) {
        JSRealm jsRealm = (JSRealm)context;
        JSContext jsContext = jsRealm.getContext();
        JSModuleRecord moduleRecord = (JSModuleRecord)module;
        if (moduleRecord.isEvaluated() && moduleRecord.getEvaluationError() == null) {
            return Undefined.instance;
        }
        return jsContext.getEvaluator().moduleEvaluation(jsRealm, moduleRecord);
    }

    public int moduleGetStatus(Object module) {
        JSModuleRecord record = (JSModuleRecord)module;
        switch (record.getStatus()) {
            case Uninstantiated: {
                return 0;
            }
            case Instantiating: {
                return 1;
            }
            case Instantiated: {
                return 2;
            }
            case Evaluating: {
                return 3;
            }
        }
        assert (record.getStatus() == JSModuleRecord.Status.Evaluated);
        if (record.getEvaluationError() == null) {
            return 4;
        }
        return 5;
    }

    public Object moduleGetException(Object module) {
        JSModuleRecord record = (JSModuleRecord)module;
        TruffleException evaluationError = (TruffleException)record.getEvaluationError();
        return evaluationError.getExceptionObject();
    }

    public int moduleGetRequestsLength(Object module) {
        JSModuleRecord record = (JSModuleRecord)module;
        return ((Module)record.getModule()).getRequestedModules().size();
    }

    public String moduleGetRequest(Object module, int index) {
        JSModuleRecord record = (JSModuleRecord)module;
        return (String)((Module)record.getModule()).getRequestedModules().get(index);
    }

    public Object moduleGetNamespace(Object module) {
        JSModuleRecord record = (JSModuleRecord)module;
        GraalJSEvaluator graalEvaluator = (GraalJSEvaluator)record.getContext().getEvaluator();
        return graalEvaluator.getModuleNamespace(record);
    }

    public int moduleGetIdentityHash(Object module) {
        return System.identityHashCode(module);
    }

    public Object moduleCreateSyntheticModule(String moduleName, Object[] exportNames, final long evaluationStepsCallback) {
        FrameDescriptor frameDescriptor = new FrameDescriptor((Object)Undefined.instance);
        ArrayList<Module.ExportEntry> localExportEntries = new ArrayList<Module.ExportEntry>();
        for (Object exportName : exportNames) {
            frameDescriptor.addFrameSlot(exportName);
            localExportEntries.add(Module.ExportEntry.exportSpecifier((String)((String)exportName)));
        }
        Module module = new Module(Collections.emptyList(), Collections.emptyList(), localExportEntries, Collections.emptyList(), Collections.emptyList(), null, null);
        com.oracle.truffle.api.source.Source source = com.oracle.truffle.api.source.Source.newBuilder((String)"js", (CharSequence)"<unavailable>", (String)moduleName).build();
        final JSModuleRecord moduleRecord = new JSModuleRecord((Object)module, this.mainJSContext, (JSModuleLoader)this.getModuleLoader(), source, () -> {});
        moduleRecord.setFrameDescriptor(frameDescriptor);
        JavaScriptRootNode rootNode = new JavaScriptRootNode(null, null, frameDescriptor){

            public Object execute(VirtualFrame frame) {
                moduleRecord.setEnvironment(frame.materialize());
                return this.invokeEvaluationStepsCallback(GraalJSAccess.this.mainJSContext.getRealm());
            }

            @CompilerDirectives.TruffleBoundary
            private Object invokeEvaluationStepsCallback(JSRealm realm) {
                Map map = (Map)GraalJSAccess.this.earlySyntheticModuleExports.get(moduleRecord);
                if (map != null) {
                    for (Map.Entry entry : map.entrySet()) {
                        GraalJSAccess.this.moduleSetSyntheticModuleExport(moduleRecord, (String)entry.getKey(), entry.getValue());
                    }
                }
                return NativeAccess.syntheticModuleEvaluationSteps(evaluationStepsCallback, realm, moduleRecord);
            }
        };
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
        JSFunctionData functionData = JSFunctionData.createCallOnly((JSContext)this.mainJSContext, (CallTarget)callTarget, (int)0, (String)moduleName);
        moduleRecord.setFunctionData(functionData);
        return moduleRecord;
    }

    public void moduleSetSyntheticModuleExport(Object module, String exportName, Object exportValue) {
        JSModuleRecord moduleRecord = (JSModuleRecord)module;
        FrameDescriptor frameDescriptor = moduleRecord.getFrameDescriptor();
        FrameSlot frameSlot = frameDescriptor.findFrameSlot((Object)exportName);
        MaterializedFrame frame = moduleRecord.getEnvironment();
        if (frame == null) {
            Map<String, Object> map = this.earlySyntheticModuleExports.get(module);
            if (map == null) {
                map = new HashMap<String, Object>();
                this.earlySyntheticModuleExports.put(moduleRecord, map);
            }
            map.put(exportName, exportValue);
        } else {
            frame.setObject(frameSlot, exportValue);
        }
    }

    public String scriptOrModuleGetResourceName(Object scriptOrModule) {
        ScriptOrModule record = (ScriptOrModule)scriptOrModule;
        return record.getSource().getName();
    }

    public Object scriptOrModuleGetHostDefinedOptions(Object scriptOrModule) {
        ScriptOrModule record = (ScriptOrModule)scriptOrModule;
        Object[] hostDefinedOptions = this.hostDefinedOptionsMap.get(record.getSource());
        return hostDefinedOptions == null ? new Object[]{} : hostDefinedOptions;
    }

    public Object valueSerializerNew(long delegatePointer) {
        return new Serializer(this.mainJSContext, this, delegatePointer);
    }

    public int valueSerializerSize(Object serializer) {
        return ((Serializer)serializer).size();
    }

    public void valueSerializerRelease(Object serializer, Object targetBuffer) {
        ((Serializer)serializer).release((ByteBuffer)targetBuffer);
    }

    public void valueSerializerWriteHeader(Object serializer) {
        ((Serializer)serializer).writeHeader();
    }

    public void valueSerializerWriteValue(Object serializer, Object value) {
        ((Serializer)serializer).writeValue(value);
    }

    public void valueSerializerWriteUint32(Object serializer, int value) {
        ((Serializer)serializer).writeVarInt(Integer.toUnsignedLong(value));
    }

    public void valueSerializerWriteUint64(Object serializer, long value) {
        ((Serializer)serializer).writeVarInt(value);
    }

    public void valueSerializerWriteDouble(Object serializer, double value) {
        ((Serializer)serializer).writeDouble(value);
    }

    public void valueSerializerWriteRawBytes(Object serializer, Object bytes) {
        ((Serializer)serializer).writeBytes((ByteBuffer)bytes);
    }

    public void valueSerializerSetTreatArrayBufferViewsAsHostObjects(Object serializer, boolean treatArrayBufferViewsAsHostObjects) {
        ((Serializer)serializer).setTreatArrayBufferViewsAsHostObjects(treatArrayBufferViewsAsHostObjects);
    }

    public void valueSerializerTransferArrayBuffer(Object serializer, int id, Object arrayBuffer) {
        ((Serializer)serializer).transferArrayBuffer(id, arrayBuffer);
    }

    public Object valueDeserializerNew(long delegate, Object buffer) {
        return new Deserializer(delegate, (ByteBuffer)buffer);
    }

    public void valueDeserializerReadHeader(Object deserializer) {
        ((Deserializer)deserializer).readHeader();
    }

    public Object valueDeserializerReadValue(Object context, Object deserializer) {
        return ((Deserializer)deserializer).readValue(((JSRealm)context).getContext());
    }

    public int valueDeserializerReadUint32(Object deserializer) {
        return ((Deserializer)deserializer).readVarInt();
    }

    public long valueDeserializerReadUint64(Object deserializer) {
        return ((Deserializer)deserializer).readVarLong();
    }

    public double valueDeserializerReadDouble(Object deserializer) {
        return ((Deserializer)deserializer).readDouble();
    }

    public int valueDeserializerReadRawBytes(Object deserializer, int length) {
        return ((Deserializer)deserializer).readBytes(length);
    }

    public void valueDeserializerTransferArrayBuffer(Object deserializer, int id, Object arrayBuffer) {
        ((Deserializer)deserializer).transferArrayBuffer(id, (DynamicObject)arrayBuffer);
    }

    public int valueDeserializerGetWireFormatVersion(Object deserializer) {
        return ((Deserializer)deserializer).getWireFormatVersion();
    }

    public Object mapNew(Object context) {
        JSContext jsContext = ((JSRealm)context).getContext();
        return JSMap.create((JSContext)jsContext);
    }

    public void mapSet(Object set, Object key, Object value) {
        DynamicObject object = (DynamicObject)set;
        JSMap.getInternalMap((DynamicObject)object).put(JSSet.normalize((Object)key), value);
    }

    public Object setNew(Object context) {
        JSContext jsContext = ((JSRealm)context).getContext();
        return JSSet.create((JSContext)jsContext);
    }

    public void setAdd(Object set, Object key) {
        DynamicObject object = (DynamicObject)set;
        JSSet.getInternalSet((DynamicObject)object).put(JSSet.normalize((Object)key), new Object());
    }

    public long bigIntInt64Value(Object value) {
        BigInteger bigInt = ((BigInt)value).bigIntegerValue();
        this.resetSharedBuffer();
        this.sharedBuffer.putInt(bigInt.bitLength() <= 63 ? 1 : 0);
        return bigInt.longValue();
    }

    public long bigIntUint64Value(Object value) {
        BigInteger bigInt = ((BigInt)value).bigIntegerValue();
        this.resetSharedBuffer();
        this.sharedBuffer.putInt(bigInt.signum() != -1 && bigInt.bitLength() <= 64 ? 1 : 0);
        return bigInt.longValue();
    }

    public Object bigIntNew(long value) {
        return BigInt.valueOf((long)value);
    }

    public Object bigIntNewFromUnsigned(long value) {
        BigInteger bigInt = BigInteger.valueOf(value & Long.MAX_VALUE);
        if (value < 0L) {
            bigInt = bigInt.setBit(63);
        }
        return new BigInt(bigInt);
    }

    public Object bigIntNewFromWords() {
        this.resetSharedBuffer();
        int sign = this.sharedBuffer.getInt();
        int count = this.sharedBuffer.getInt();
        BigInteger result = BigInteger.ZERO;
        for (int wordIdx = 0; wordIdx < count; ++wordIdx) {
            long word = this.sharedBuffer.getLong();
            for (int bit = 0; bit < 63; ++bit) {
                if ((word & 1L << bit) == 0L) continue;
                result = result.setBit(bit + 64 * wordIdx);
            }
        }
        if (sign != 0) {
            result = result.negate();
        }
        return new BigInt(result);
    }

    public int bigIntWordCount(Object value) {
        BigInteger bigInt = ((BigInt)value).bigIntegerValue();
        return (bigInt.bitLength() + (bigInt.signum() == -1 ? 1 : 0) + 63) / 64;
    }

    public void bigIntToWordsArray(Object value) {
        BigInteger bigInt = ((BigInt)value).bigIntegerValue();
        this.resetSharedBuffer();
        int count = this.bigIntWordCount(value);
        this.sharedBuffer.putInt(count);
        this.sharedBuffer.putInt(bigInt.signum() == -1 ? 1 : 0);
        if (bigInt.signum() == -1) {
            bigInt = bigInt.negate();
        }
        for (int wordIdx = 0; wordIdx < count; ++wordIdx) {
            long word = 0L;
            for (int bit = 63; bit >= 0; --bit) {
                word <<= 1;
                if (!bigInt.testBit(bit + 64 * wordIdx)) continue;
                ++word;
            }
            this.sharedBuffer.putLong(word);
        }
    }

    public void unsetCurrentMessagePortData() {
        this.currentMessagePortData.encodingEnd();
        this.currentMessagePortData = null;
    }

    public void setCurrentMessagePortData(DynamicObject nativeMessagePortData) {
        assert (nativeMessagePortData != null);
        assert (this.currentMessagePortData == null);
        this.currentMessagePortData = SharedMemMessagingManager.getJavaMessagePortDataFor(nativeMessagePortData);
        assert (this.currentMessagePortData != null);
        this.currentMessagePortData.encodingBegin();
    }

    public JavaMessagePortData getCurrentMessagePortData() {
        return this.currentMessagePortData;
    }

    static class ESModuleLoader
    implements JSModuleLoader {
        private final Map<ScriptOrModule, Map<String, JSModuleRecord>> cache = new HashMap<ScriptOrModule, Map<String, JSModuleRecord>>();
        private long resolver;

        ESModuleLoader() {
        }

        void setResolver(long resolver) {
            this.resolver = resolver;
        }

        public JSModuleRecord resolveImportedModule(ScriptOrModule referrer, String specifier) {
            Map<String, JSModuleRecord> referrerCache = this.cache.get(referrer);
            if (referrerCache == null) {
                referrerCache = new HashMap<String, JSModuleRecord>();
                this.cache.put(referrer, referrerCache);
            } else {
                JSModuleRecord cached = referrerCache.get(specifier);
                if (cached != null) {
                    return cached;
                }
            }
            if (this.resolver == 0L) {
                System.err.println("Cannot resolve module outside module instantiation!");
                System.exit(1);
            }
            JSModuleRecord result = (JSModuleRecord)NativeAccess.executeResolveCallback(this.resolver, referrer.getContext().getRealm(), specifier, referrer);
            referrerCache.put(specifier, result);
            return result;
        }

        public JSModuleRecord loadModule(com.oracle.truffle.api.source.Source moduleSource) {
            throw new UnsupportedOperationException();
        }
    }

    static class PropertyHandlerPrototypeNode
    extends JavaScriptRootNode {
        private final boolean global;
        @Node.Child
        private GetPrototypeNode getPrototypeNode;

        PropertyHandlerPrototypeNode(boolean global) {
            this.global = global;
            if (!global) {
                this.getPrototypeNode = GetPrototypeNode.create();
            }
        }

        public Object execute(VirtualFrame vf) {
            Object target = vf.getArguments()[2];
            if (this.global) {
                return target;
            }
            return this.getPrototypeNode.executeJSObject(target);
        }
    }

    private static class WeakCallback
    extends WeakReference<Object> {
        long data;
        long callback;
        int type;

        WeakCallback(Object object, long data, long callback, int type, ReferenceQueue<Object> queue) {
            super(object, queue);
            this.data = data;
            this.callback = callback;
            this.type = type;
        }
    }

    private static final class GraalJSKillException
    extends ThreadDeath {
        private static final long serialVersionUID = 3930431622452607906L;

        private GraalJSKillException() {
        }
    }

    private static class WeakAgentWaiterList
    extends WeakReference<JSAgentWaiterList> {
        long pointer;

        WeakAgentWaiterList(JSAgentWaiterList wl, long pointer) {
            super(wl, agentWaiterListQueue);
            this.pointer = pointer;
        }
    }
}

