/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.RegexSource;

public class RegexSyntaxException
extends RuntimeException
implements TruffleException {
    private static final String template = "Invalid regular expression: /%s/%s: %s";
    private static final String templateNoFlags = "Invalid regular expression: %s: %s";
    private static final String templatePosition = "Invalid regular expression: /%s/%s:%d: %s";
    private String reason;
    private RegexSource regexSrc;
    private int position = -1;
    private static final long serialVersionUID = 1L;

    public RegexSyntaxException(String msg) {
        super(msg);
    }

    @CompilerDirectives.TruffleBoundary
    public RegexSyntaxException(String pattern, String msg) {
        super(String.format(templateNoFlags, pattern, msg));
        this.reason = msg;
        this.regexSrc = new RegexSource(pattern);
    }

    @CompilerDirectives.TruffleBoundary
    public RegexSyntaxException(RegexSource source, String msg) {
        super(String.format(template, source.getPattern(), source.getFlags(), msg));
        this.reason = msg;
        this.regexSrc = source;
    }

    @CompilerDirectives.TruffleBoundary
    public RegexSyntaxException(String pattern, String flags, String msg) {
        super(String.format(template, pattern, flags, msg));
        this.reason = msg;
        this.regexSrc = new RegexSource(pattern, flags);
    }

    @CompilerDirectives.TruffleBoundary
    public RegexSyntaxException(String pattern, String flags, String msg, int position) {
        super(String.format(templatePosition, pattern, flags, position, msg));
        this.reason = msg;
        this.regexSrc = new RegexSource(pattern, flags);
        this.position = position;
    }

    @CompilerDirectives.TruffleBoundary
    public RegexSyntaxException(String pattern, String flags, String msg, Throwable ex) {
        super(String.format(template, pattern, flags, msg), ex);
        this.reason = msg;
        this.regexSrc = new RegexSource(pattern, flags);
    }

    public boolean isSyntaxError() {
        return true;
    }

    public Node getLocation() {
        return null;
    }

    public String getReason() {
        return this.reason;
    }

    public RegexSource getRegex() {
        return this.regexSrc;
    }

    public Integer getPosition() {
        return this.position;
    }
}

