/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.spi;

import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;

@GenerateLibrary(assertions=Asserts.class)
public abstract class ReferenceLibrary
extends Library {
    private static final LibraryFactory<ReferenceLibrary> FACTORY = LibraryFactory.resolve(ReferenceLibrary.class);

    @GenerateLibrary.Abstract
    public boolean isSame(Object receiver, Object other) {
        return receiver == other;
    }

    public static LibraryFactory<ReferenceLibrary> getFactory() {
        return FACTORY;
    }

    static class Asserts
    extends ReferenceLibrary {
        @Node.Child
        private ReferenceLibrary delegate;

        Asserts(ReferenceLibrary delegate) {
            this.delegate = delegate;
        }

        public boolean accepts(Object receiver) {
            return this.delegate.accepts(receiver);
        }

        @Override
        public boolean isSame(Object receiver, Object other) {
            assert (this.delegate.isSame(receiver, receiver)) : "isSame should be reflexive";
            boolean ret = this.delegate.isSame(receiver, other);
            assert (!this.delegate.accepts(other) || ret == this.delegate.isSame(other, receiver)) : "isSame should be symmetric";
            return ret;
        }
    }
}

