/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.spi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.spi.LegacyLibrary;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LegacyLibrary.class)
final class LegacyLibraryGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private LegacyLibraryGen() {
    }

    static {
        LibraryExport.register(LegacyLibrary.class, (LibraryExport[])new LibraryExport[]{new NativeTypeLibraryExports()});
    }

    @GeneratedBy(value=LegacyLibrary.class)
    private static final class NativeTypeLibraryExports
    extends LibraryExport<NativeTypeLibrary> {
        private NativeTypeLibraryExports() {
            super(NativeTypeLibrary.class, TruffleObject.class, true);
        }

        protected NativeTypeLibrary createUncached(Object receiver) {
            assert (receiver instanceof TruffleObject);
            return new Uncached(receiver);
        }

        protected NativeTypeLibrary createCached(Object receiver) {
            assert (receiver instanceof TruffleObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LegacyLibrary.class)
        private static final class Uncached
        extends NativeTypeLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_ && Uncached.accepts_(receiver);
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasNativeType(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return LegacyLibrary.hasNativeType(arg0Value, LegacyLibrary.hasNativeTypeSlowPath(arg0Value));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getNativeType(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return LegacyLibrary.getNativeType(arg0Value, LegacyLibrary.createGetTypeNode());
            }

            @CompilerDirectives.TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                TruffleObject arg0Value = (TruffleObject)arg0Value_;
                return LegacyLibrary.accepts(arg0Value, arg0Value.getClass());
            }
        }

        @GeneratedBy(value=LegacyLibrary.class)
        private static final class Cached
        extends NativeTypeLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private Class<?> acceptsNode__receiverClass_;
            @CompilerDirectives.CompilationFinal
            private boolean hasNativeTypeNode__hasType_;
            @Node.Child
            private Node getNativeTypeNode__getType_;

            Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_ && this.accepts_(receiver);
            }

            private boolean accepts_(Object arg0Value_) {
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 1) != 0) {
                    return LegacyLibrary.accepts(arg0Value, this.acceptsNode__receiverClass_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.acceptsNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean acceptsNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.acceptsNode__receiverClass_ = arg0Value.getClass();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = LegacyLibrary.accepts(arg0Value, this.acceptsNode__receiverClass_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public boolean hasNativeType(Object arg0Value_) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 2) != 0) {
                    return LegacyLibrary.hasNativeType(arg0Value, this.hasNativeTypeNode__hasType_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasNativeTypeNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean hasNativeTypeNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.hasNativeTypeNode__hasType_ = LegacyLibrary.hasNativeTypeSlowPath(arg0Value);
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = LegacyLibrary.hasNativeType(arg0Value, this.hasNativeTypeNode__hasType_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object getNativeType(Object arg0Value_) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                TruffleObject arg0Value = (TruffleObject)this.dynamicDispatch_.cast(arg0Value_);
                int state = this.state_;
                if ((state & 4) != 0) {
                    return LegacyLibrary.getNativeType(arg0Value, this.getNativeTypeNode__getType_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getNativeTypeNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object getNativeTypeNode_AndSpecialize(TruffleObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    this.getNativeTypeNode__getType_ = super.insert(LegacyLibrary.createGetTypeNode());
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = LegacyLibrary.getNativeType(arg0Value, this.getNativeTypeNode__getType_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

