/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.spi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.spi.GetDynamicType;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

@ExportLibrary(value=NativeTypeLibrary.class, receiverType=TruffleObject.class)
class LegacyLibrary {
    LegacyLibrary() {
    }

    @ExportMessage
    static boolean accepts(TruffleObject receiver, @Cached(value="receiver.getClass()") Class<?> receiverClass) {
        return receiver.getClass() == receiverClass;
    }

    @CompilerDirectives.TruffleBoundary
    static boolean hasNativeTypeSlowPath(TruffleObject receiver) {
        try {
            ForeignAccess.send((Node)GetDynamicType.INSTANCE.createNode(), (TruffleObject)receiver, (Object[])new Object[0]);
            return true;
        }
        catch (InteropException ex) {
            return false;
        }
    }

    @ExportMessage
    static boolean hasNativeType(TruffleObject receiver, @Cached(value="hasNativeTypeSlowPath(receiver)", allowUncached=true) boolean hasType) {
        return hasType;
    }

    @ExportMessage
    static Object getNativeType(TruffleObject receiver, @Cached(value="createGetTypeNode()", allowUncached=true) Node getType) {
        try {
            return ForeignAccess.send((Node)getType, (TruffleObject)receiver, (Object[])new Object[0]);
        }
        catch (InteropException ex) {
            CompilerDirectives.transferToInterpreter();
            throw ex.raise();
        }
    }

    static Node createGetTypeNode() {
        return GetDynamicType.INSTANCE.createNode();
    }
}

