/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.utils;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.core.network.utils.HostnameUtils;
import org.netbeans.core.network.utils.IpAddressUtils;
import org.netbeans.core.network.utils.IpAddressUtilsFilter;
import org.netbeans.core.network.utils.NativeException;
import org.openide.util.RequestProcessor;

public class LocalAddressUtils {
    private static final Logger LOG = Logger.getLogger(LocalAddressUtils.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("LocalNetworkAddressFinder", 3);
    private static final byte[] LOOPBACK_IPV4_RAW = new byte[]{127, 0, 0, 1};
    private static final byte[] LOOPBACK_IPV6_RAW = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    private static InetAddress LOOPBACK_IPV4;
    private static InetAddress LOOPBACK_IPV6;
    private static final Object LOCK;
    private static Future<InetAddress> fut1;
    private static Future<InetAddress[]> fut2;
    private static Future<List<InetAddress>> fut3;
    private static final Callable<InetAddress> C1;
    private static final Callable<InetAddress[]> C2;
    private static final Callable<List<InetAddress>> C3;

    private LocalAddressUtils() {
    }

    public static void warmUp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshNetworkInfo(boolean bl) {
        Object object = LOCK;
        synchronized (object) {
            fut1 = RP.submit(C1);
            fut2 = RP.submit(C2);
            fut3 = RP.submit(C3);
            if (bl) {
                try {
                    fut1.get();
                    fut2.get();
                    fut3.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }
        }
    }

    @NonNull
    public static InetAddress getLocalHost() throws UnknownHostException {
        Object object = LOCK;
        synchronized (object) {
            if (fut1 == null) {
                LocalAddressUtils.refreshNetworkInfo(false);
            }
            try {
                return fut1.get();
            }
            catch (ExecutionException executionException) {
                if (executionException.getCause() instanceof UnknownHostException) {
                    throw (UnknownHostException)executionException.getCause();
                }
                throw new RuntimeException(executionException.getCause());
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    @NonNull
    public static InetAddress[] getLocalHostAddresses(IpAddressUtils.IpTypePreference ipTypePreference) throws UnknownHostException {
        Object object = LOCK;
        synchronized (object) {
            if (fut2 == null) {
                LocalAddressUtils.refreshNetworkInfo(false);
            }
            try {
                return fut2.get();
            }
            catch (ExecutionException executionException) {
                if (executionException.getCause() instanceof UnknownHostException) {
                    throw (UnknownHostException)executionException.getCause();
                }
                if (executionException.getCause() instanceof SecurityException) {
                    throw (SecurityException)executionException.getCause();
                }
                throw new RuntimeException(executionException.getCause());
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    @NonNull
    public static List<InetAddress> getPrioritizedLocalHostAddresses(IpAddressUtils.IpTypePreference ipTypePreference) {
        Object object = LOCK;
        synchronized (object) {
            if (fut3 == null) {
                LocalAddressUtils.refreshNetworkInfo(false);
            }
            try {
                return IpAddressUtilsFilter.filterInetAddresses((Iterable<InetAddress>)fut3.get(), ipTypePreference);
            }
            catch (ExecutionException executionException) {
                throw new RuntimeException(executionException.getCause());
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    @NonNull
    public static InetAddress[] getMostLikelyLocalInetAddresses(IpAddressUtils.IpTypePreference ipTypePreference) {
        Object object;
        List<InetAddress> list = LocalAddressUtils.getPrioritizedLocalHostAddresses(ipTypePreference);
        try {
            object = Arrays.asList(LocalAddressUtils.getLocalHostAddresses(ipTypePreference));
            if (object != null && !object.isEmpty()) {
                ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(5);
                for (InetAddress inetAddress : list) {
                    if (!object.contains(inetAddress)) continue;
                    arrayList.add(inetAddress);
                }
                if (!arrayList.isEmpty()) {
                    return arrayList.toArray(new InetAddress[arrayList.size()]);
                }
                return object.toArray(new InetAddress[object.size()]);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (!list.isEmpty()) {
            return list.toArray(new InetAddress[list.size()]);
        }
        try {
            object = IpAddressUtilsFilter.pickInetAddress(Collections.singletonList(LocalAddressUtils.getLocalHost()), ipTypePreference);
            if (object != null) {
                return new InetAddress[]{object};
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return new InetAddress[]{LocalAddressUtils.getLoopbackAddress(ipTypePreference)};
    }

    @NonNull
    public static InetAddress getMostLikelyLocalInetAddress(IpAddressUtils.IpTypePreference ipTypePreference) {
        InetAddress[] inetAddressArray = LocalAddressUtils.getMostLikelyLocalInetAddresses(ipTypePreference);
        return inetAddressArray[0];
    }

    @NonNull
    public static InetAddress getLoopbackAddress(IpAddressUtils.IpTypePreference ipTypePreference) {
        switch (ipTypePreference) {
            case IPV4_ONLY: 
            case ANY_IPV4_PREF: {
                return LOOPBACK_IPV4;
            }
            case IPV6_ONLY: 
            case ANY_IPV6_PREF: {
                return LOOPBACK_IPV6;
            }
        }
        return LOOPBACK_IPV4;
    }

    @NonNull
    private static List<InetAddress> getLocalNetworkInterfaceAddr() {
        Enumeration<NetworkInterface> enumeration;
        final HashMap<InetAddress, Integer> hashMap = new HashMap<InetAddress, Integer>();
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            LOG.log(Level.WARNING, "Cannot get host's network interfaces", socketException);
            return Collections.emptyList();
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface;
            int n;
            block10: {
                n = 0;
                networkInterface = enumeration.nextElement();
                try {
                    if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                    if (networkInterface.isVirtual()) {
                        --n;
                    }
                    if (!networkInterface.supportsMulticast()) {
                        --n;
                    }
                    if (!LocalAddressUtils.isSoftwareVirtualAdapter(networkInterface)) break block10;
                    --n;
                }
                catch (SocketException socketException) {
                    continue;
                }
            }
            List<InterfaceAddress> list = networkInterface.getInterfaceAddresses();
            for (InterfaceAddress interfaceAddress : list) {
                int n2 = 0;
                InetAddress inetAddress = interfaceAddress.getAddress();
                if (interfaceAddress.getBroadcast() == null) {
                    --n2;
                }
                if (inetAddress instanceof Inet6Address) {
                    --n2;
                }
                hashMap.put(inetAddress, n + n2);
            }
        }
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(hashMap.keySet());
        Collections.sort(arrayList, new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress inetAddress, InetAddress inetAddress2) {
                return ((Integer)hashMap.get(inetAddress2)).compareTo((Integer)hashMap.get(inetAddress));
            }
        });
        return arrayList;
    }

    public static boolean isSoftwareVirtualAdapter(NetworkInterface networkInterface) {
        try {
            byte[] byArray = networkInterface.getHardwareAddress();
            return byArray != null && byArray.length >= 3 && (byArray[0] == 10 || byArray[0] == 8) && byArray[1] == 0 && byArray[2] == 39;
        }
        catch (SocketException socketException) {
            return false;
        }
    }

    static {
        try {
            LOOPBACK_IPV4 = InetAddress.getByAddress("local-ipv4-dummy", LOOPBACK_IPV4_RAW);
            LOOPBACK_IPV6 = InetAddress.getByAddress("local-ipv6-dummy", LOOPBACK_IPV6_RAW);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        LOCK = new Object();
        C1 = new Callable(){

            public InetAddress call() throws UnknownHostException {
                return InetAddress.getLocalHost();
            }
        };
        C2 = new Callable(){

            public InetAddress[] call() throws UnknownHostException {
                try {
                    String string = HostnameUtils.getNetworkHostname();
                    return InetAddress.getAllByName(string);
                }
                catch (NativeException nativeException) {
                    throw new UnknownHostException(nativeException.getMessage() + ", error code : " + nativeException.getErrorCode());
                }
            }
        };
        C3 = new Callable(){

            public List<InetAddress> call() {
                return LocalAddressUtils.getLocalNetworkInterfaceAddr();
            }
        };
        LocalAddressUtils.refreshNetworkInfo(false);
    }
}

