/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management.libgraal.runtime;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.management.libgraal.runtime.HotSpotToSVMCalls;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.LibGraalScope;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.util.OptionsEncoder;

@Platforms(value={Platform.HOSTED_ONLY.class})
class SVMHotSpotGraalRuntimeMBean
implements DynamicMBean {
    private static volatile Factory factory;
    private final long handle;

    SVMHotSpotGraalRuntimeMBean(long handle) {
        this.handle = handle;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        AttributeList attributes = this.getAttributes(new String[]{attribute});
        return ((Attribute)attributes.get(0)).getValue();
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        AttributeList list = new AttributeList();
        list.add(attribute);
        this.setAttributes(list);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        try (LibGraalScope scope = new LibGraalScope(HotSpotJVMCIRuntime.runtime());){
            byte[] rawData = HotSpotToSVMCalls.getAttributes(LibGraalScope.getIsolateThread(), this.handle, attributes);
            AttributeList attributeList = SVMHotSpotGraalRuntimeMBean.rawToAttributeList(rawData);
            return attributeList;
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        try (LibGraalScope scope = new LibGraalScope(HotSpotJVMCIRuntime.runtime());){
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Object item : attributes) {
                Attribute attribute = (Attribute)item;
                map.put(attribute.getName(), attribute.getValue());
            }
            byte[] rawData = OptionsEncoder.encode(map);
            rawData = HotSpotToSVMCalls.setAttributes(LibGraalScope.getIsolateThread(), this.handle, rawData);
            AttributeList attributeList = SVMHotSpotGraalRuntimeMBean.rawToAttributeList(rawData);
            return attributeList;
        }
    }

    private static AttributeList rawToAttributeList(byte[] rawData) {
        AttributeList res = new AttributeList();
        Map map = OptionsEncoder.decode((byte[])rawData);
        for (Map.Entry e : map.entrySet()) {
            String attrName = (String)e.getKey();
            Object attrValue = e.getValue();
            res.add(new Attribute(attrName, attrValue));
        }
        return res;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try (LibGraalScope scope = new LibGraalScope(HotSpotJVMCIRuntime.runtime());){
            LinkedHashMap<String, Object> paramsMap = new LinkedHashMap<String, Object>();
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    paramsMap.put(Integer.toString(i), params[i]);
                }
            }
            byte[] rawData = OptionsEncoder.encode(paramsMap);
            rawData = HotSpotToSVMCalls.invoke(LibGraalScope.getIsolateThread(), this.handle, actionName, rawData, signature);
            if (rawData == null) {
                throw new MBeanException(null);
            }
            AttributeList attributesList = SVMHotSpotGraalRuntimeMBean.rawToAttributeList(rawData);
            Object object = attributesList.isEmpty() ? null : ((Attribute)attributesList.get(0)).getValue();
            return object;
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        try (LibGraalScope scope = new LibGraalScope(HotSpotJVMCIRuntime.runtime());){
            byte[] rawData = HotSpotToSVMCalls.getMBeanInfo(LibGraalScope.getIsolateThread(), this.handle);
            Map map = OptionsEncoder.decode((byte[])rawData);
            String className = null;
            String description = null;
            ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
            ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
            PushBackIterator<Map.Entry<String, Object>> it = new PushBackIterator<Map.Entry<String, Object>>(map.entrySet().iterator());
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                if (key.equals("bean.class")) {
                    className = (String)entry.getValue();
                    continue;
                }
                if (key.equals("bean.description")) {
                    description = (String)entry.getValue();
                    continue;
                }
                if (key.startsWith("attr.")) {
                    String attrName = (String)entry.getValue();
                    if (!key.equals("attr." + attrName + ".name")) {
                        throw new IllegalStateException("Invalid order of attribute properties");
                    }
                    MBeanAttributeInfo attr = SVMHotSpotGraalRuntimeMBean.createAttributeInfo(attrName, it);
                    attributes.add(attr);
                    continue;
                }
                if (!key.startsWith("op.")) continue;
                int opId = (Integer)entry.getValue();
                if (!key.equals("op." + opId + ".id")) {
                    throw new IllegalStateException("Invalid order of operation properties");
                }
                MBeanOperationInfo op = SVMHotSpotGraalRuntimeMBean.createOperationInfo(opId, it);
                operations.add(op);
            }
            Objects.requireNonNull(className, "ClassName must be non null.");
            Objects.requireNonNull(description, "Description must be non null.");
            MBeanInfo mBeanInfo = new MBeanInfo(className, description, attributes.toArray(new MBeanAttributeInfo[attributes.size()]), null, operations.toArray(new MBeanOperationInfo[operations.size()]), null);
            return mBeanInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Factory getFactory() {
        Factory res = factory;
        if (res != null) return res;
        Class<SVMHotSpotGraalRuntimeMBean> clazz = SVMHotSpotGraalRuntimeMBean.class;
        synchronized (SVMHotSpotGraalRuntimeMBean.class) {
            res = factory;
            if (res != null) return res;
            res = new Factory();
            res.start();
            factory = res;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return res;
        }
    }

    private static MBeanAttributeInfo createAttributeInfo(String attrName, PushBackIterator<Map.Entry<String, Object>> it) {
        String attrType = null;
        String attrDescription = null;
        boolean isReadable = false;
        boolean isWritable = false;
        boolean isIs = false;
        String prefix = "attr." + attrName + ".";
        block14: while (it.hasNext()) {
            String propertyName;
            Map.Entry<String, Object> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(prefix)) {
                it.pushBack(entry);
                break;
            }
            switch (propertyName = key.substring(key.lastIndexOf(46) + 1)) {
                case "type": {
                    attrType = (String)entry.getValue();
                    continue block14;
                }
                case "description": {
                    attrDescription = (String)entry.getValue();
                    continue block14;
                }
                case "r": {
                    isReadable = (Boolean)entry.getValue();
                    continue block14;
                }
                case "w": {
                    isWritable = (Boolean)entry.getValue();
                    continue block14;
                }
                case "i": {
                    isIs = (Boolean)entry.getValue();
                    continue block14;
                }
            }
            throw new IllegalStateException("Unkown attribute property: " + propertyName);
        }
        if (attrType == null) {
            throw new IllegalStateException("Attribute type must be given.");
        }
        return new MBeanAttributeInfo(attrName, attrType, attrDescription, isReadable, isWritable, isIs);
    }

    private static MBeanOperationInfo createOperationInfo(int opId, PushBackIterator<Map.Entry<String, Object>> it) {
        String opName = null;
        String opType = null;
        String opDescription = null;
        int opImpact = 0;
        ArrayList<MBeanParameterInfo> params = new ArrayList<MBeanParameterInfo>();
        String prefix = "op." + opId + ".";
        block14: while (it.hasNext()) {
            String propertyName;
            Map.Entry<String, Object> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(prefix)) {
                it.pushBack(entry);
                break;
            }
            int nextDotIndex = key.indexOf(46, prefix.length());
            nextDotIndex = nextDotIndex < 0 ? key.length() : nextDotIndex;
            switch (propertyName = key.substring(prefix.length(), nextDotIndex)) {
                case "name": {
                    opName = (String)entry.getValue();
                    continue block14;
                }
                case "type": {
                    opType = (String)entry.getValue();
                    continue block14;
                }
                case "description": {
                    opDescription = (String)entry.getValue();
                    continue block14;
                }
                case "i": {
                    opImpact = (Integer)entry.getValue();
                    continue block14;
                }
                case "arg": {
                    String paramName = (String)entry.getValue();
                    if (!key.equals(prefix + "arg." + paramName + ".name")) {
                        throw new IllegalStateException("Invalid order of parameter properties");
                    }
                    MBeanParameterInfo param = SVMHotSpotGraalRuntimeMBean.createParameterInfo(prefix, paramName, it);
                    params.add(param);
                    continue block14;
                }
            }
            throw new IllegalStateException("Unkown attribute property: " + propertyName);
        }
        if (opName == null) {
            throw new IllegalStateException("Operation name must be given.");
        }
        if (opType == null) {
            throw new IllegalStateException("Operation return type must be given.");
        }
        return new MBeanOperationInfo(opName, opDescription, params.toArray(new MBeanParameterInfo[params.size()]), opType, opImpact);
    }

    private static MBeanParameterInfo createParameterInfo(String owner, String paramName, PushBackIterator<Map.Entry<String, Object>> it) {
        String paramType = null;
        String paramDescription = null;
        String prefix = owner + "arg." + paramName + ".";
        block8: while (it.hasNext()) {
            String propertyName;
            Map.Entry<String, Object> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(prefix)) {
                it.pushBack(entry);
                break;
            }
            switch (propertyName = key.substring(key.lastIndexOf(46) + 1)) {
                case "type": {
                    paramType = (String)entry.getValue();
                    continue block8;
                }
                case "description": {
                    paramDescription = (String)entry.getValue();
                    continue block8;
                }
            }
            throw new IllegalStateException("Unkown parameter property: " + propertyName);
        }
        if (paramType == null) {
            throw new IllegalStateException("Parameter type must be given.");
        }
        return new MBeanParameterInfo(paramName, paramType, paramDescription);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    static final class Factory
    extends Thread {
        private static final int POLL_INTERVAL_MS = 2000;
        private MBeanServer platformMBeanServer;
        private boolean dirty;

        private Factory() {
            super("HotSpotGraalManagement Bean Registration");
            this.setPriority(1);
            this.setDaemon(true);
            LibGraal.registerNativeMethods((HotSpotJVMCIRuntime)HotSpotJVMCIRuntime.runtime(), HotSpotToSVMCalls.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: while (true) {
                try {
                    while (true) {
                        Factory factory = this;
                        synchronized (factory) {
                            while (!this.dirty) {
                                this.wait();
                            }
                            try {
                                this.dirty = !this.poll();
                            }
                            catch (NoClassDefFoundError | SecurityException | UnsatisfiedLinkError | UnsupportedOperationException e) {
                                break block7;
                            }
                        }
                        Thread.sleep(2000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace(TTY.out);
                    continue;
                }
                break;
            }
        }

        synchronized void signal() {
            this.dirty = true;
            this.notify();
        }

        private boolean poll() {
            assert (Thread.holdsLock(this));
            if (this.platformMBeanServer == null) {
                ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
                if (!servers.isEmpty()) {
                    this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                    return this.process();
                }
            } else {
                return this.process();
            }
            return false;
        }

        private boolean process() {
            try (LibGraalScope scope = new LibGraalScope(HotSpotJVMCIRuntime.runtime());){
                long[] svmRegistrations = HotSpotToSVMCalls.pollRegistrations(LibGraalScope.getIsolateThread());
                if (svmRegistrations.length > 0) {
                    for (long svmRegistration : svmRegistrations) {
                        try {
                            SVMHotSpotGraalRuntimeMBean bean = new SVMHotSpotGraalRuntimeMBean(svmRegistration);
                            String name = HotSpotToSVMCalls.getRegistrationName(LibGraalScope.getIsolateThread(), svmRegistration);
                            this.platformMBeanServer.registerMBean(bean, new ObjectName("org.graalvm.compiler.hotspot:type=" + name));
                        }
                        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
                            e.printStackTrace(TTY.out);
                        }
                    }
                    HotSpotToSVMCalls.finishRegistration(LibGraalScope.getIsolateThread(), svmRegistrations);
                }
            }
            return true;
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final class PushBackIterator<T>
    implements Iterator<T> {
        private final Iterator<T> delegate;
        private T pushBack;

        PushBackIterator(Iterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.pushBack != null || this.delegate.hasNext();
        }

        @Override
        public T next() {
            if (this.pushBack != null) {
                T res = this.pushBack;
                this.pushBack = null;
                return res;
            }
            return this.delegate.next();
        }

        void pushBack(T e) {
            if (this.pushBack != null) {
                throw new IllegalStateException("Push back element already exists.");
            }
            this.pushBack = e;
        }
    }
}

