/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.llvm;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.llvm.LLVMGenerator;
import org.graalvm.compiler.core.llvm.LLVMUtils;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.llvm.LLVMCeilNode;
import org.graalvm.compiler.replacements.llvm.LLVMCountLeadingZerosNode;
import org.graalvm.compiler.replacements.llvm.LLVMCountTrailingZerosNode;
import org.graalvm.compiler.replacements.llvm.LLVMFloorNode;
import org.graalvm.compiler.replacements.llvm.LLVMIntrinsicNode;

@NodeInfo
public abstract class LLVMUnaryIntrinsicNode
extends LLVMIntrinsicNode {
    public static final NodeClass<LLVMUnaryIntrinsicNode> TYPE = NodeClass.create(LLVMUnaryIntrinsicNode.class);
    @Node.Input
    private ValueNode arg;

    public LLVMUnaryIntrinsicNode(NodeClass<? extends LLVMIntrinsicNode> c, LLVMUtils.LLVMIntrinsicOperation op, JavaKind kind, ValueNode arg) {
        super(c, op, kind);
        this.arg = arg;
    }

    public static ConstantNode tryFold(LLVMUtils.LLVMIntrinsicOperation op, ValueNode arg) {
        if (arg.isConstant()) {
            JavaConstant constantArg = arg.asJavaConstant();
            switch (op) {
                case CEIL: {
                    return LLVMCeilNode.fold(constantArg);
                }
                case FLOOR: {
                    return LLVMFloorNode.fold(constantArg);
                }
                case CTLZ: {
                    return LLVMCountLeadingZerosNode.fold(constantArg);
                }
                case CTTZ: {
                    return LLVMCountTrailingZerosNode.fold(constantArg);
                }
            }
        }
        return null;
    }

    static LLVMUnaryIntrinsicNode factory(LLVMUtils.LLVMIntrinsicOperation op, JavaKind kind, ValueNode arg) {
        switch (op) {
            case CEIL: {
                return new LLVMCeilNode(kind, arg);
            }
            case FLOOR: {
                return new LLVMFloorNode(kind, arg);
            }
            case CTLZ: {
                return new LLVMCountLeadingZerosNode(kind, arg);
            }
            case CTTZ: {
                return new LLVMCountTrailingZerosNode(kind, arg);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public Node canonical(CanonicalizerTool tool) {
        ConstantNode folded = LLVMUnaryIntrinsicNode.tryFold(this.op, this.arg);
        return folded != null ? folded : this;
    }

    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult((ValueNode)this, this.emitIntrinsic((LLVMGenerator.ArithmeticLLVMGenerator)gen, builder.operand((Node)this.arg)));
    }

    protected abstract Value emitIntrinsic(LLVMGenerator.ArithmeticLLVMGenerator var1, Value var2);
}

