/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.llvm;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.llvm.LLVMGenerator;
import org.graalvm.compiler.core.llvm.LLVMUtils;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.replacements.llvm.LLVMUnaryIntrinsicNode;

@NodeInfo(cycles=NodeCycles.CYCLES_4, size=NodeSize.SIZE_1, nameTemplate="LLVMIntrinsic#{p#op}")
public class LLVMFloorNode
extends LLVMUnaryIntrinsicNode {
    public static final NodeClass<LLVMFloorNode> TYPE = NodeClass.create(LLVMFloorNode.class);

    public LLVMFloorNode(JavaKind kind, ValueNode arg) {
        super(TYPE, LLVMUtils.LLVMIntrinsicOperation.FLOOR, kind, arg);
    }

    @Override
    protected Value emitIntrinsic(LLVMGenerator.ArithmeticLLVMGenerator gen, Value arg) {
        return gen.emitMathFloor(arg);
    }

    public static ConstantNode fold(JavaConstant constant) {
        return ConstantNode.forDouble((double)Math.floor(constant.asDouble()));
    }
}

