/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.llvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.StructuredGraph;

public class LLVMGenerationResult {
    private final Set<AbstractBlockBase<?>> processedBlocks = new HashSet();
    private final ResolvedJavaMethod method;
    private byte[] bitcode;
    private List<Call> directCallTargets = new ArrayList<Call>();
    private List<Call> indirectCallTargets = new ArrayList<Call>();
    private long startPatchpointID = -1L;
    private Map<Constant, String> constants = new HashMap<Constant, String>();
    private Map<Long, Integer> exceptionHandlers = new LinkedHashMap<Long, Integer>();

    public LLVMGenerationResult(ResolvedJavaMethod method) {
        this.method = method;
    }

    public ResolvedJavaMethod getMethod() {
        return this.method;
    }

    public void setBitcode(byte[] bitcode) {
        this.bitcode = bitcode;
    }

    public byte[] getBitcode() {
        return this.bitcode;
    }

    public void setProcessed(AbstractBlockBase<?> b) {
        this.processedBlocks.add(b);
    }

    public boolean isProcessed(AbstractBlockBase<?> b) {
        return this.processedBlocks.contains(b);
    }

    public void setStartPatchpointID(long startPatchpointID) {
        this.startPatchpointID = startPatchpointID;
    }

    public void recordDirectCall(ResolvedJavaMethod targetMethod, long patchpointID, DebugInfo debugInfo) {
        this.directCallTargets.add(new Call((InvokeTarget)targetMethod, NumUtil.safeToInt((long)patchpointID), 0, true, debugInfo));
    }

    public List<Call> getDirectCallTargets() {
        return this.directCallTargets;
    }

    public void recordIndirectCall(ResolvedJavaMethod targetMethod, long patchpointID, DebugInfo debugInfo) {
        this.indirectCallTargets.add(new Call((InvokeTarget)targetMethod, NumUtil.safeToInt((long)patchpointID), 0, false, debugInfo));
    }

    public List<Call> getIndirectCallTargets() {
        return this.indirectCallTargets;
    }

    public void recordConstant(Constant constant, String symbolName) {
        this.constants.put(constant, symbolName);
    }

    public Map<Constant, String> getConstants() {
        return this.constants;
    }

    public String getSymbolNameForConstant(Constant constant) {
        return this.constants.get(constant);
    }

    public void recordExceptionHandler(long patchpointID, long handlerID) {
        this.exceptionHandlers.put(patchpointID, NumUtil.safeToInt((long)handlerID));
    }

    public Map<Long, Integer> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public void populate(CompilationResult compilationResult, StructuredGraph graph) {
        ResolvedJavaMethod rootMethod;
        DebugContext debug = graph.getDebug();
        compilationResult.setTargetCode(this.bitcode, this.bitcode.length);
        compilationResult.recordInfopoint(NumUtil.safeToInt((long)this.startPatchpointID), null, InfopointReason.METHOD_START);
        for (Call call : this.getDirectCallTargets()) {
            compilationResult.addInfopoint((Infopoint)call);
        }
        for (Call call : this.getIndirectCallTargets()) {
            compilationResult.addInfopoint((Infopoint)call);
        }
        this.getExceptionHandlers().forEach((patchpointID, blockID) -> compilationResult.recordExceptionHandler(NumUtil.safeToInt((long)patchpointID), blockID.intValue()));
        Assumptions assumptions = graph.getAssumptions();
        if (assumptions != null && !assumptions.isEmpty()) {
            compilationResult.setAssumptions(assumptions.toArray());
        }
        if ((rootMethod = graph.method()) != null) {
            compilationResult.setMethods(rootMethod, (Collection)graph.getMethods());
            compilationResult.setFields(graph.getFields());
        }
        if (debug.isCountEnabled()) {
            List ldp = compilationResult.getDataPatches();
            JavaKind[] kindValues = JavaKind.values();
            CounterKey[] dms = new CounterKey[kindValues.length];
            for (int i = 0; i < dms.length; ++i) {
                dms[i] = DebugContext.counter((String)"DataPatches-%s", (Object)kindValues[i]);
            }
            for (DataPatch dp : ldp) {
                VMConstant constant;
                JavaKind kind = JavaKind.Illegal;
                if (dp.reference instanceof ConstantReference && (constant = ((ConstantReference)dp.reference).getConstant()) instanceof JavaConstant) {
                    kind = ((JavaConstant)constant).getJavaKind();
                }
                dms[kind.ordinal()].add(debug, 1L);
            }
            DebugContext.counter((CharSequence)"CompilationResults").increment(debug);
            DebugContext.counter((CharSequence)"InfopointsEmitted").add(debug, (long)compilationResult.getInfopoints().size());
            DebugContext.counter((CharSequence)"DataPatches").add(debug, (long)ldp.size());
        }
        debug.dump(1, (Object)compilationResult, "After code generation");
    }
}

