/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.llvm;

import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.llvm.LLVMGenerationProvider;
import org.graalvm.compiler.core.llvm.LLVMGenerationResult;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.nodes.StructuredGraph;

public class LLVMCompilerBackend {
    private static final TimerKey EmitLLVM = DebugContext.timer((CharSequence)"EmitLLVM").doc("Time spent generating LLVM from HIR.");
    private static final TimerKey Populate = DebugContext.timer((CharSequence)"EmitCode").doc("Time spent populating the compilation result.");
    private static final TimerKey BackEnd = DebugContext.timer((CharSequence)"BackEnd").doc("Time spent in EmitLLVM and Populate.");

    public static void emitBackEnd(LLVMGenerationProvider backend, StructuredGraph graph, CompilationResult result) {
        DebugContext debug = graph.getDebug();
        try (DebugContext.Scope s = debug.scope((Object)"BackEnd", (Object)graph.getLastSchedule());
             DebugCloseable a = BackEnd.start(debug);){
            LLVMGenerationResult genRes = LLVMCompilerBackend.emitLLVM(backend, graph);
            result.setHasUnsafeAccess(graph.hasUnsafeAccess());
            try (DebugCloseable p = Populate.start(debug);){
                genRes.populate(result, graph);
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        finally {
            graph.checkCancellation();
        }
    }

    /*
     * Exception decompiling
     */
    private static LLVMGenerationResult emitLLVM(LLVMGenerationProvider backend, StructuredGraph graph) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

