/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.thirdparty.jline;

import com.oracle.svm.core.annotate.AutomaticFeature;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
final class JLineFeature
implements Feature {
    JLineFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class terminalFactoryClass = access.findClassByName("jline.TerminalFactory");
        if (terminalFactoryClass == null) {
            return;
        }
        Object[] createMethods = Arrays.stream(terminalFactoryClass.getDeclaredMethods()).filter(m -> Modifier.isStatic(m.getModifiers()) && m.getName().equals("create")).toArray();
        access.registerReachabilityHandler(JLineFeature::registerTerminalConstructor, createMethods);
    }

    private static void registerTerminalConstructor(Feature.DuringAnalysisAccess access) {
        Class terminalClass = access.findClassByName(Platform.includedIn(Platform.WINDOWS.class) ? "jline.AnsiWindowsTerminal" : "jline.UnixTerminal");
        if (terminalClass != null) {
            RuntimeReflection.register((Class[])new Class[]{terminalClass});
            RuntimeReflection.register((Executable[])terminalClass.getDeclaredConstructors());
        }
    }
}

