/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v1;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.collection.FastAccessNumberMap;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.StructContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.MemberAccessorToolkit;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.ChunkStructure;
import org.openjdk.jmc.flightrecorder.internal.parser.v1.IDataInput;

class ValueReaders {
    ValueReaders() {
    }

    static class ReflectiveReader
    extends AbstractStructReader {
        private static final String RESERVED_IDENTIFIER_PREFIX = "_";
        private final List<Field> fields;
        private final Class<?> klass;
        private final ContentType<?> ct;

        <T> ReflectiveReader(Class<T> klass, int fieldCount, ContentType<? super T> ct) {
            super(fieldCount);
            this.klass = klass;
            this.ct = ct;
            this.fields = new ArrayList<Field>(fieldCount);
        }

        @Override
        public Object read(IDataInput in, boolean allowUnresolvedReference) throws IOException, InvalidJfrFileException {
            try {
                Object thread = this.klass.newInstance();
                for (int i = 0; i < this.valueReaders.size(); ++i) {
                    Object val = ((IValueReader)this.valueReaders.get(i)).read(in, allowUnresolvedReference);
                    Field f = this.fields.get(i);
                    if (f == null) continue;
                    f.set(thread, val);
                }
                return thread;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object resolve(Object value) throws InvalidJfrFileException {
            try {
                for (int i = 0; i < this.valueReaders.size(); ++i) {
                    Field f = this.fields.get(i);
                    if (f == null) continue;
                    Object val = ((IValueReader)this.valueReaders.get(i)).resolve(f.get(value));
                    f.set(value, val);
                }
                return value;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ContentType<?> getContentType() {
            return this.ct;
        }

        @Override
        void addField(String identifier, String name, String description, IValueReader reader) throws InvalidJfrFileException {
            this.valueReaders.add(reader);
            try {
                try {
                    this.fields.add(this.klass.getField(identifier));
                }
                catch (NoSuchFieldException e) {
                    this.fields.add(this.klass.getField(RESERVED_IDENTIFIER_PREFIX + identifier));
                }
            }
            catch (NoSuchFieldException e) {
                Logger.getLogger(ReflectiveReader.class.getName()).log(Level.WARNING, "Could not find field with name '" + identifier + "' in reader for '" + this.ct.getIdentifier() + "'");
                this.fields.add(null);
            }
        }
    }

    static class StructReader
    extends AbstractStructReader {
        private final StructContentType<Object[]> contentType;

        StructReader(StructContentType<Object[]> contentType, int fieldCount) {
            super(fieldCount);
            this.contentType = contentType;
        }

        @Override
        public Object read(IDataInput in, boolean allowUnresolvedReference) throws IOException, InvalidJfrFileException {
            Object[] values = new Object[this.valueReaders.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = ((IValueReader)this.valueReaders.get(i)).read(in, allowUnresolvedReference);
            }
            return values;
        }

        @Override
        public Object resolve(Object value) throws InvalidJfrFileException {
            Object[] valueArray = (Object[])value;
            for (int i = 0; i < valueArray.length; ++i) {
                valueArray[i] = ((IValueReader)this.valueReaders.get(i)).resolve(valueArray[i]);
            }
            return valueArray;
        }

        @Override
        public ContentType<?> getContentType() {
            return this.contentType;
        }

        @Override
        public void addField(String identifier, String name, String description, IValueReader reader) {
            int index = this.valueReaders.size();
            this.valueReaders.add(reader);
            IMemberAccessor ma = MemberAccessorToolkit.arrayElement((int)index);
            ContentType<?> resolveType = reader.getContentType();
            this.contentType.addField(identifier, resolveType, name, description, ma);
        }
    }

    static abstract class AbstractStructReader
    implements IValueReader {
        final List<IValueReader> valueReaders;

        AbstractStructReader(int fieldCount) {
            this.valueReaders = new ArrayList<IValueReader>(fieldCount);
        }

        @Override
        public void skip(IDataInput in) throws IOException, InvalidJfrFileException {
            for (int i = 0; i < this.valueReaders.size(); ++i) {
                this.valueReaders.get(i).skip(in);
            }
        }

        abstract void addField(String var1, String var2, String var3, IValueReader var4) throws InvalidJfrFileException;
    }

    static class PrimitiveReader
    implements IValueReader {
        private static final String DOUBLE = "double";
        private static final String FLOAT = "float";
        private static final String LONG = "long";
        private static final String INT = "int";
        private static final String CHAR = "char";
        private static final String SHORT = "short";
        private static final String BYTE = "byte";
        private static final String BOOLEAN = "boolean";
        private final String typeIdentifier;
        private final ContentType<?> contentType;

        PrimitiveReader(String typeIdentifier) throws InvalidJfrFileException {
            this.typeIdentifier = typeIdentifier;
            switch (typeIdentifier) {
                case "boolean": {
                    this.contentType = UnitLookup.FLAG;
                    break;
                }
                case "byte": 
                case "short": 
                case "char": 
                case "int": 
                case "long": 
                case "float": 
                case "double": {
                    this.contentType = UnitLookup.RAW_NUMBER;
                    break;
                }
                default: {
                    throw new InvalidJfrFileException("Unknown primitive type: " + typeIdentifier);
                }
            }
        }

        @Override
        public Object read(IDataInput in, boolean allowUnresolvedReference) throws IOException, InvalidJfrFileException {
            switch (this.typeIdentifier) {
                case "boolean": {
                    return in.readBoolean();
                }
                case "byte": {
                    return in.readByte();
                }
                case "short": {
                    return in.readShort();
                }
                case "char": {
                    return Character.valueOf(in.readChar());
                }
                case "int": {
                    return in.readInt();
                }
                case "long": {
                    return in.readLong();
                }
                case "float": {
                    return Float.valueOf(in.readFloat());
                }
                case "double": {
                    return in.readDouble();
                }
            }
            throw new InvalidJfrFileException("Unknown primitive type: " + this.typeIdentifier);
        }

        @Override
        public void skip(IDataInput in) throws IOException, InvalidJfrFileException {
            switch (this.typeIdentifier) {
                case "boolean": {
                    in.readBoolean();
                    return;
                }
                case "float": {
                    in.readFloat();
                    return;
                }
                case "double": {
                    in.readDouble();
                    return;
                }
                case "char": {
                    in.readChar();
                    return;
                }
            }
            PrimitiveReader.readLong(in, this.typeIdentifier, false);
        }

        @Override
        public ContentType<?> getContentType() {
            return this.contentType;
        }

        @Override
        public Object resolve(Object value) throws InvalidJfrFileException {
            return value;
        }

        static boolean isFloat(String typeIdentifier) {
            return FLOAT.equals(typeIdentifier);
        }

        static boolean isDouble(String typeIdentifier) {
            return DOUBLE.equals(typeIdentifier);
        }

        static boolean isNumeric(String typeIdentifier) {
            switch (typeIdentifier) {
                case "byte": 
                case "short": 
                case "char": 
                case "int": 
                case "long": 
                case "float": 
                case "double": {
                    return true;
                }
            }
            return false;
        }

        static long readLong(IDataInput in, String typeIdentifier, boolean unsigned) throws IOException, InvalidJfrFileException {
            switch (typeIdentifier) {
                case "byte": {
                    return unsigned ? (long)in.readByte() : (long)in.readUnsignedByte();
                }
                case "short": {
                    return unsigned ? (long)in.readUnsignedShort() : (long)in.readShort();
                }
                case "int": {
                    return unsigned ? in.readUnsignedInt() : (long)in.readInt();
                }
                case "long": {
                    return in.readLong();
                }
            }
            throw new InvalidJfrFileException("Unknown integer type: " + typeIdentifier);
        }

        static double readDouble(IDataInput in, boolean fromFloat) throws IOException {
            return fromFloat ? (double)in.readFloat() : in.readDouble();
        }
    }

    static class StringReader
    implements IValueReader {
        static final String STRING = "java.lang.String";
        private final FastAccessNumberMap<Object> constantPool;

        StringReader(FastAccessNumberMap<Object> constantPool) {
            this.constantPool = constantPool;
        }

        @Override
        public Object read(IDataInput in, boolean allowUnresolvedReference) throws IOException, InvalidJfrFileException {
            byte encoding = in.readByte();
            if (encoding == 2) {
                long constantIndex = in.readLong();
                Object constant = this.constantPool.get(constantIndex);
                return allowUnresolvedReference && constant == null ? new ConstantReference(constantIndex) : constant;
            }
            return in.readRawString(encoding);
        }

        @Override
        public void skip(IDataInput in) throws IOException, InvalidJfrFileException {
            in.skipString();
        }

        @Override
        public Object resolve(Object value) throws InvalidJfrFileException {
            if (value instanceof ConstantReference) {
                return this.constantPool.get(((ConstantReference)value).key);
            }
            return value;
        }

        @Override
        public ContentType<?> getContentType() {
            return UnitLookup.PLAIN_TEXT;
        }
    }

    static class TicksTimestampReader
    extends QuantityReader {
        private final ChunkStructure header;

        TicksTimestampReader(String typeIdentifier, ChunkStructure header, boolean unsigned) throws InvalidJfrFileException {
            super(typeIdentifier, null, unsigned);
            this.header = header;
        }

        @Override
        IQuantity quantity(long numericalValue) {
            return this.header.ticsTimestamp(numericalValue);
        }

        @Override
        IQuantity quantity(Number numericalValue) {
            return this.quantity(numericalValue.longValue());
        }

        @Override
        IQuantity quantity(double numericalValue) {
            return this.quantity((long)numericalValue);
        }

        @Override
        public ContentType<?> getContentType() {
            return UnitLookup.TIMESTAMP;
        }
    }

    static class QuantityReader
    implements IValueReader {
        private final String typeIdentifier;
        private final IUnit unit;
        private final boolean floatingPoint;
        private final boolean unsignedOrFloat;

        QuantityReader(String typeIdentifier, IUnit unit, boolean unsigned) throws InvalidJfrFileException {
            this.typeIdentifier = typeIdentifier;
            this.unit = unit;
            if (PrimitiveReader.isFloat(typeIdentifier)) {
                this.floatingPoint = true;
                this.unsignedOrFloat = true;
            } else if (PrimitiveReader.isDouble(typeIdentifier)) {
                this.floatingPoint = true;
                this.unsignedOrFloat = false;
            } else if (PrimitiveReader.isNumeric(typeIdentifier)) {
                this.floatingPoint = false;
                this.unsignedOrFloat = unsigned;
            } else {
                throw new InvalidJfrFileException("Unknown numeric type: " + typeIdentifier);
            }
        }

        @Override
        public Object read(IDataInput in, boolean allowUnresolvedReference) throws IOException, InvalidJfrFileException {
            if (this.floatingPoint) {
                return this.quantity(PrimitiveReader.readDouble(in, this.unsignedOrFloat));
            }
            return this.quantity(PrimitiveReader.readLong(in, this.typeIdentifier, this.unsignedOrFloat));
        }

        @Override
        public void skip(IDataInput in) throws IOException, InvalidJfrFileException {
            if (this.floatingPoint) {
                PrimitiveReader.readDouble(in, this.unsignedOrFloat);
            } else {
                PrimitiveReader.readLong(in, this.typeIdentifier, this.unsignedOrFloat);
            }
        }

        IQuantity quantity(Number numericalValue) {
            return this.unit.quantity(numericalValue);
        }

        IQuantity quantity(long numericalValue) {
            return this.unit.quantity(numericalValue);
        }

        IQuantity quantity(double numericalValue) {
            return this.unit.quantity(numericalValue);
        }

        @Override
        public Object resolve(Object value) throws InvalidJfrFileException {
            return value;
        }

        @Override
        public ContentType<?> getContentType() {
            return this.unit.getContentType();
        }
    }

    static class ArrayReader
    implements IValueReader {
        private final IValueReader elementReader;

        ArrayReader(IValueReader elementReader) {
            this.elementReader = elementReader;
        }

        @Override
        public Object read(IDataInput in, boolean allowUnresolvedReference) throws IOException, InvalidJfrFileException {
            int size = in.readInt();
            Object[] values = new Object[size];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.elementReader.read(in, allowUnresolvedReference);
            }
            return values;
        }

        @Override
        public void skip(IDataInput in) throws IOException, InvalidJfrFileException {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.elementReader.skip(in);
            }
        }

        @Override
        public Object resolve(Object value) throws InvalidJfrFileException {
            Object[] valueArray = (Object[])value;
            for (int i = 0; i < valueArray.length; ++i) {
                valueArray[i] = this.elementReader.resolve(valueArray[i]);
            }
            return valueArray;
        }

        @Override
        public ContentType<?> getContentType() {
            return UnitLookup.UNKNOWN;
        }
    }

    static class PoolReader
    implements IValueReader {
        private final FastAccessNumberMap<Object> constantPool;
        private final ContentType<?> contentType;

        PoolReader(FastAccessNumberMap<Object> pool, ContentType<?> contentType) {
            this.constantPool = pool;
            this.contentType = contentType;
        }

        @Override
        public Object read(IDataInput in, boolean allowUnresolvedReference) throws IOException, InvalidJfrFileException {
            long constantIndex = in.readLong();
            Object constant = this.constantPool.get(constantIndex);
            return allowUnresolvedReference && constant == null ? new ConstantReference(constantIndex) : constant;
        }

        @Override
        public void skip(IDataInput in) throws IOException, InvalidJfrFileException {
            in.readLong();
        }

        @Override
        public Object resolve(Object value) throws InvalidJfrFileException {
            if (value instanceof ConstantReference) {
                return this.constantPool.get(((ConstantReference)value).key);
            }
            return value;
        }

        @Override
        public ContentType<?> getContentType() {
            return this.contentType;
        }
    }

    private static class ConstantReference {
        final long key;

        ConstantReference(long key) {
            this.key = key;
        }

        public int hashCode() {
            return (int)(this.key >>> 32 ^ this.key);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof ConstantReference && this.key == ((ConstantReference)obj).key;
        }
    }

    static interface IValueReader {
        public Object read(IDataInput var1, boolean var2) throws IOException, InvalidJfrFileException;

        public void skip(IDataInput var1) throws IOException, InvalidJfrFileException;

        public Object resolve(Object var1) throws InvalidJfrFileException;

        public ContentType<?> getContentType();
    }
}

