/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.basic;

import java.util.List;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.StringDecoder;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.basic.ArrayValueView;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public final class StringDetailsProvider
extends DetailsProvider.Basic {
    static final String STRING_MASK = "java.lang.String";
    static final String BUILDERS_MASK = "java.lang.AbstractStringBuilder+";

    public StringDetailsProvider() {
        super(STRING_MASK, BUILDERS_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance, Heap heap) {
        if (STRING_MASK.equals(className)) {
            byte coder = DetailsUtils.getByteFieldValue(instance, "coder", (byte)-1);
            if (coder == -1) {
                int offset = DetailsUtils.getIntFieldValue(instance, "offset", 0);
                int count = DetailsUtils.getIntFieldValue(instance, "count", -1);
                return DetailsUtils.getPrimitiveArrayFieldString(instance, "value", offset, count, null, "...");
            }
            return this.getJDK9String(heap, instance, "value", coder, null, "...");
        }
        if (BUILDERS_MASK.equals(className)) {
            byte coder = DetailsUtils.getByteFieldValue(instance, "coder", (byte)-1);
            if (coder == -1) {
                int count = DetailsUtils.getIntFieldValue(instance, "count", -1);
                return DetailsUtils.getPrimitiveArrayFieldString(instance, "value", 0, count, null, "...");
            }
            return this.getJDK9String(heap, instance, "value", coder, null, "...");
        }
        return null;
    }

    @Override
    public DetailsProvider.View getDetailsView(String className, Instance instance, Heap heap) {
        return new ArrayValueView(className, instance, heap);
    }

    private String getJDK9String(Heap heap, Instance instance, String field, byte coder, String separator, String trailer) {
        List values;
        Object byteArray = instance.getValueOfField(field);
        if (byteArray instanceof PrimitiveArrayInstance && (values = ((PrimitiveArrayInstance)byteArray).getValues()) != null) {
            StringDecoder decoder = new StringDecoder(heap, coder, values);
            int valuesCount = decoder.getStringLength();
            int separatorLength = separator == null ? 0 : separator.length();
            int trailerLength = trailer == null ? 0 : trailer.length();
            int estimatedSize = Math.min(valuesCount * (1 + separatorLength), 160 + trailerLength);
            StringBuilder value = new StringBuilder(estimatedSize);
            int lastValue = valuesCount - 1;
            for (int i = 0; i <= lastValue; ++i) {
                value.append(decoder.getValueAt(i));
                if (value.length() >= 160) {
                    if (trailerLength <= 0) break;
                    value.append(trailer);
                    break;
                }
                if (separator == null || i >= lastValue) continue;
                value.append(separator);
            }
            return value.toString();
        }
        return null;
    }
}

