/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk;

import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.heapwalk.AbstractTopLevelController;
import org.graalvm.visualvm.lib.profiler.heapwalk.ClassesListController;
import org.graalvm.visualvm.lib.profiler.heapwalk.FieldsBrowserController;
import org.graalvm.visualvm.lib.profiler.heapwalk.HeapFragmentWalker;
import org.graalvm.visualvm.lib.profiler.heapwalk.NavigationHistoryManager;
import org.graalvm.visualvm.lib.profiler.heapwalk.ui.ClassesControllerUI;

public class ClassesController
extends AbstractTopLevelController
implements FieldsBrowserController.Handler,
NavigationHistoryManager.NavigationHistoryCapable {
    private ClassesListController classesListController;
    private FieldsBrowserController staticFieldsBrowserController;
    private HeapFragmentWalker heapFragmentWalker;

    public ClassesController(HeapFragmentWalker heapFragmentWalker) {
        this.heapFragmentWalker = heapFragmentWalker;
        this.classesListController = new ClassesListController(this);
        this.staticFieldsBrowserController = new FieldsBrowserController(this, 1);
    }

    public ClassesListController getClassesListController() {
        return this.classesListController;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        long selectedClassID = -1L;
        List expandedStaticFields = null;
        TreePath selectedStaticField = null;
        JavaClass selectedClass = this.getSelectedClass();
        if (selectedClass != null) {
            selectedClassID = selectedClass.getJavaClassId();
            expandedStaticFields = this.staticFieldsBrowserController.getExpandedPaths();
            selectedStaticField = this.staticFieldsBrowserController.getSelectedRow();
        }
        return new Configuration(selectedClassID, expandedStaticFields, selectedStaticField);
    }

    @Override
    public HeapFragmentWalker getHeapFragmentWalker() {
        return this.heapFragmentWalker;
    }

    public JavaClass getSelectedClass() {
        return this.classesListController.getSelectedClass();
    }

    public FieldsBrowserController getStaticFieldsBrowserController() {
        return this.staticFieldsBrowserController;
    }

    public void classSelected() {
        JavaClass selectedClass = this.getSelectedClass();
        this.staticFieldsBrowserController.setJavaClass(selectedClass);
    }

    @Override
    public void configure(NavigationHistoryManager.Configuration configuration) {
        if (configuration instanceof Configuration) {
            Configuration c = (Configuration)configuration;
            this.heapFragmentWalker.switchToHistoryClassesView();
            JavaClass selectedClass = null;
            long selectedClassID = c.getJavaClassID();
            if (selectedClassID != -1L) {
                selectedClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByID(selectedClassID);
            }
            if (selectedClass != null) {
                this.staticFieldsBrowserController.restoreState(c.getExpandedStaticFields(), c.getSelectedStaticField());
                this.classesListController.selectClass(selectedClass);
            }
        } else {
            throw new IllegalArgumentException("Unsupported configuration: " + configuration);
        }
    }

    @Override
    public void showClass(JavaClass javaClass) {
        this.heapFragmentWalker.switchToClassesView();
        if (!this.classesListController.getPanel().isVisible()) {
            this.classesListController.getPanel().setVisible(true);
        }
        this.classesListController.selectClass(javaClass);
    }

    @Override
    public void showInstance(Instance instance) {
        this.heapFragmentWalker.getInstancesController().showInstance(instance);
    }

    @Override
    protected AbstractButton[] createClientPresenters() {
        return new AbstractButton[]{this.classesListController.getPresenter(), this.staticFieldsBrowserController.getPresenter()};
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((ClassesControllerUI)this.getPanel()).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new ClassesControllerUI(this);
    }

    public static class Configuration
    extends NavigationHistoryManager.Configuration {
        private final long javaClassID;
        private final List expandedStaticFields;
        private final TreePath selectedStaticField;

        public Configuration(long javaClassID, List expandedStaticFields, TreePath selectedStaticField) {
            this.javaClassID = javaClassID;
            this.expandedStaticFields = expandedStaticFields;
            this.selectedStaticField = selectedStaticField;
        }

        public long getJavaClassID() {
            return this.javaClassID;
        }

        public List getExpandedStaticFields() {
            return this.expandedStaticFields;
        }

        public TreePath getSelectedStaticField() {
            return this.selectedStaticField;
        }
    }
}

