/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot.amd64;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterAttributes;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public class AMD64HotSpotRegisterConfig
implements RegisterConfig {
    private final TargetDescription target;
    private final RegisterArray allocatable;
    private final RegisterArray callerSaved;
    private final boolean allAllocatableAreCallerSaved;
    private final RegisterAttributes[] attributesMap;
    private final RegisterArray javaGeneralParameterRegisters;
    private final RegisterArray nativeGeneralParameterRegisters;
    private final RegisterArray javaXMMParameterRegisters;
    private final RegisterArray nativeXMMParameterRegisters;
    private final boolean windowsOS;
    private final boolean needsNativeStackHomeSpace;
    private static final RegisterArray reservedRegisters = new RegisterArray(new Register[]{AMD64.rsp, AMD64.r15});

    public RegisterArray getAllocatableRegisters() {
        return this.allocatable;
    }

    public RegisterArray filterAllocatableRegisters(PlatformKind kind, RegisterArray registers) {
        ArrayList<Register> list = new ArrayList<Register>();
        for (Register reg : registers) {
            if (!this.target.arch.canStoreValue(reg.getRegisterCategory(), kind)) continue;
            list.add(reg);
        }
        RegisterArray ret = new RegisterArray(list);
        return ret;
    }

    public RegisterAttributes[] getAttributesMap() {
        return (RegisterAttributes[])this.attributesMap.clone();
    }

    private static RegisterArray initAllocatable(Architecture arch, boolean reserveForHeapBase) {
        RegisterArray allRegisters = arch.getAvailableValueRegisters();
        Register[] registers = new Register[allRegisters.size() - reservedRegisters.size() - (reserveForHeapBase ? 1 : 0)];
        List reservedRegistersList = reservedRegisters.asList();
        int idx = 0;
        for (Register reg : allRegisters) {
            if (reservedRegistersList.contains(reg) || reserveForHeapBase && reg.equals((Object)AMD64.r12)) continue;
            registers[idx++] = reg;
        }
        assert (idx == registers.length);
        return new RegisterArray(registers);
    }

    public AMD64HotSpotRegisterConfig(TargetDescription target, boolean useCompressedOops, boolean windowsOs) {
        this(target, AMD64HotSpotRegisterConfig.initAllocatable(target.arch, useCompressedOops), windowsOs);
        assert (this.callerSaved.size() >= this.allocatable.size());
    }

    public AMD64HotSpotRegisterConfig(TargetDescription target, RegisterArray allocatable, boolean windowsOS) {
        this.target = target;
        this.windowsOS = windowsOS;
        if (windowsOS) {
            this.javaGeneralParameterRegisters = new RegisterArray(new Register[]{AMD64.rdx, AMD64.r8, AMD64.r9, AMD64.rdi, AMD64.rsi, AMD64.rcx});
            this.nativeGeneralParameterRegisters = new RegisterArray(new Register[]{AMD64.rcx, AMD64.rdx, AMD64.r8, AMD64.r9});
            this.nativeXMMParameterRegisters = new RegisterArray(new Register[]{AMD64.xmm0, AMD64.xmm1, AMD64.xmm2, AMD64.xmm3});
            this.needsNativeStackHomeSpace = true;
        } else {
            this.javaGeneralParameterRegisters = new RegisterArray(new Register[]{AMD64.rsi, AMD64.rdx, AMD64.rcx, AMD64.r8, AMD64.r9, AMD64.rdi});
            this.nativeGeneralParameterRegisters = new RegisterArray(new Register[]{AMD64.rdi, AMD64.rsi, AMD64.rdx, AMD64.rcx, AMD64.r8, AMD64.r9});
            this.nativeXMMParameterRegisters = new RegisterArray(new Register[]{AMD64.xmm0, AMD64.xmm1, AMD64.xmm2, AMD64.xmm3, AMD64.xmm4, AMD64.xmm5, AMD64.xmm6, AMD64.xmm7});
            this.needsNativeStackHomeSpace = false;
        }
        this.javaXMMParameterRegisters = new RegisterArray(new Register[]{AMD64.xmm0, AMD64.xmm1, AMD64.xmm2, AMD64.xmm3, AMD64.xmm4, AMD64.xmm5, AMD64.xmm6, AMD64.xmm7});
        this.allocatable = allocatable;
        HashSet callerSaveSet = new HashSet();
        allocatable.addTo(callerSaveSet);
        this.javaXMMParameterRegisters.addTo(callerSaveSet);
        callerSaveSet.addAll(this.javaGeneralParameterRegisters.asList());
        this.nativeGeneralParameterRegisters.addTo(callerSaveSet);
        this.callerSaved = new RegisterArray(callerSaveSet);
        this.allAllocatableAreCallerSaved = true;
        this.attributesMap = RegisterAttributes.createMap((RegisterConfig)this, (RegisterArray)target.arch.getRegisters());
    }

    public RegisterArray getCallerSaveRegisters() {
        return this.callerSaved;
    }

    public RegisterArray getCalleeSaveRegisters() {
        return null;
    }

    public boolean areAllAllocatableRegistersCallerSaved() {
        return this.allAllocatableAreCallerSaved;
    }

    public CallingConvention getCallingConvention(CallingConvention.Type type, JavaType returnType, JavaType[] parameterTypes, ValueKindFactory<?> valueKindFactory) {
        HotSpotCallingConventionType hotspotType = (HotSpotCallingConventionType)type;
        if (type == HotSpotCallingConventionType.NativeCall) {
            return this.callingConvention(this.nativeGeneralParameterRegisters, this.nativeXMMParameterRegisters, this.windowsOS, returnType, parameterTypes, hotspotType, valueKindFactory);
        }
        return this.callingConvention(this.javaGeneralParameterRegisters, this.javaXMMParameterRegisters, false, returnType, parameterTypes, hotspotType, valueKindFactory);
    }

    public RegisterArray getCallingConventionRegisters(CallingConvention.Type type, JavaKind kind) {
        HotSpotCallingConventionType hotspotType = (HotSpotCallingConventionType)type;
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Short: 
            case Char: 
            case Int: 
            case Long: 
            case Object: {
                return hotspotType == HotSpotCallingConventionType.NativeCall ? this.nativeGeneralParameterRegisters : this.javaGeneralParameterRegisters;
            }
            case Float: 
            case Double: {
                return hotspotType == HotSpotCallingConventionType.NativeCall ? this.nativeXMMParameterRegisters : this.javaXMMParameterRegisters;
            }
        }
        throw JVMCIError.shouldNotReachHere();
    }

    private CallingConvention callingConvention(RegisterArray generalParameterRegisters, RegisterArray xmmParameterRegisters, boolean unified, JavaType returnType, JavaType[] parameterTypes, HotSpotCallingConventionType type, ValueKindFactory<?> valueKindFactory) {
        assert (!unified || generalParameterRegisters.size() == xmmParameterRegisters.size()) : "must be same size in unified mode";
        AllocatableValue[] locations = new AllocatableValue[parameterTypes.length];
        int currentGeneral = 0;
        int currentXMM = 0;
        int currentStackOffset = type == HotSpotCallingConventionType.NativeCall && this.needsNativeStackHomeSpace ? generalParameterRegisters.size() * this.target.wordSize : 0;
        for (int i = 0; i < parameterTypes.length; ++i) {
            JavaKind kind = parameterTypes[i].getJavaKind().getStackKind();
            switch (kind) {
                case Boolean: 
                case Byte: 
                case Short: 
                case Char: 
                case Int: 
                case Long: 
                case Object: {
                    if (currentGeneral >= generalParameterRegisters.size()) break;
                    Register register = generalParameterRegisters.get(currentGeneral++);
                    locations[i] = register.asValue(valueKindFactory.getValueKind(kind));
                    break;
                }
                case Float: 
                case Double: {
                    if ((unified ? currentGeneral : currentXMM) >= xmmParameterRegisters.size()) break;
                    Register register = xmmParameterRegisters.get(unified ? currentGeneral++ : currentXMM++);
                    locations[i] = register.asValue(valueKindFactory.getValueKind(kind));
                    break;
                }
                default: {
                    throw JVMCIError.shouldNotReachHere();
                }
            }
            if (locations[i] != null) continue;
            ValueKind valueKind = valueKindFactory.getValueKind(kind);
            locations[i] = StackSlot.get((ValueKind)valueKind, (int)currentStackOffset, (!type.out ? 1 : 0) != 0);
            currentStackOffset += Math.max(valueKind.getPlatformKind().getSizeInBytes(), this.target.wordSize);
        }
        assert (!unified || currentXMM == 0) : "shouldn't be used in unified mode";
        JavaKind returnKind = returnType == null ? JavaKind.Void : returnType.getJavaKind();
        AllocatableValue returnLocation = returnKind == JavaKind.Void ? Value.ILLEGAL : this.getReturnRegister(returnKind).asValue(valueKindFactory.getValueKind(returnKind.getStackKind()));
        return new CallingConvention(currentStackOffset, returnLocation, locations);
    }

    public Register getReturnRegister(JavaKind kind) {
        switch (kind) {
            case Boolean: 
            case Byte: 
            case Short: 
            case Char: 
            case Int: 
            case Long: 
            case Object: {
                return AMD64.rax;
            }
            case Float: 
            case Double: {
                return AMD64.xmm0;
            }
            case Void: 
            case Illegal: {
                return null;
            }
        }
        throw new UnsupportedOperationException("no return register for type " + kind);
    }

    public Register getFrameRegister() {
        return AMD64.rsp;
    }

    public String toString() {
        return String.format("Allocatable: " + this.getAllocatableRegisters() + "%nCallerSave:  " + this.getCallerSaveRegisters() + "%n", new Object[0]);
    }
}

