/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.util.Set;
import java.util.stream.Collectors;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.HotSpotVMConfigStore;
import jdk.vm.ci.hotspot.VMField;
import jdk.vm.ci.hotspot.VMFlag;

public class HotSpotVMConfigAccess {
    private final HotSpotVMConfigStore store;

    public HotSpotVMConfigStore getStore() {
        return this.store;
    }

    public long getAddress(String name, Long notPresent) {
        Long entry = this.store.vmAddresses.get(name);
        if (entry == null) {
            if (notPresent != null) {
                return notPresent;
            }
            throw this.missingEntry("address", name, this.store.vmFlags.keySet());
        }
        return entry;
    }

    public long getAddress(String name) {
        return this.getAddress(name, null);
    }

    public <T> T getConstant(String name, Class<T> type, T notPresent) {
        Long c = this.store.vmConstants.get(name);
        if (c == null) {
            if (notPresent != null) {
                return notPresent;
            }
            throw this.missingEntry("constant", name, this.store.vmConstants.keySet());
        }
        return type.cast(HotSpotVMConfigAccess.convertValue(name, type, c, null));
    }

    public <T> T getConstant(String name, Class<T> type) {
        return this.getConstant(name, type, null);
    }

    public <T> T getFieldOffset(String name, Class<T> type, String cppType, T notPresent) {
        return this.getFieldOffset0(name, type, notPresent, cppType, null);
    }

    public <T> T getFieldOffset(String name, Class<T> type, T notPresent, String[] outCppType) {
        return this.getFieldOffset0(name, type, notPresent, null, outCppType);
    }

    public <T> T getFieldOffset(String name, Class<T> type, String cppType) {
        return this.getFieldOffset0(name, type, null, cppType, null);
    }

    public <T> T getFieldOffset(String name, Class<T> type) {
        return this.getFieldOffset0(name, type, null, null, null);
    }

    private <T> T getFieldOffset0(String name, Class<T> type, T notPresent, String inCppType, String[] outCppType) {
        assert (type == Integer.class || type == Long.class);
        VMField entry = this.getField(name, inCppType, notPresent == null);
        if (entry == null) {
            return notPresent;
        }
        if (entry.address != 0L) {
            throw new JVMCIError("cannot get offset of static field " + name);
        }
        if (outCppType != null) {
            outCppType[0] = entry.type;
        }
        return type.cast(HotSpotVMConfigAccess.convertValue(name, type, entry.offset, inCppType));
    }

    public long getFieldAddress(String name, String cppType, Long notPresent) {
        return this.getFieldAddress0(name, notPresent, cppType, null);
    }

    public long getFieldAddress(String name, Long notPresent, String[] outCppType) {
        return this.getFieldAddress0(name, notPresent, null, outCppType);
    }

    public long getFieldAddress(String name, String cppType) {
        return this.getFieldAddress0(name, null, cppType, null);
    }

    private long getFieldAddress0(String name, Long notPresent, String inCppType, String[] outCppType) {
        VMField entry = this.getField(name, inCppType, notPresent == null);
        if (entry == null) {
            return notPresent;
        }
        if (entry.address == 0L) {
            throw new JVMCIError(name + " is not a static field");
        }
        if (outCppType != null) {
            outCppType[0] = entry.type;
        }
        return entry.address;
    }

    public <T> T getFieldValue(String name, Class<T> type, String cppType, T notPresent) {
        return this.getFieldValue0(name, type, notPresent, cppType, null);
    }

    public <T> T getFieldValue(String name, Class<T> type, String cppType) {
        return this.getFieldValue0(name, type, null, cppType, null);
    }

    public <T> T getFieldValue(String name, Class<T> type, T notPresent, String[] outCppType) {
        return this.getFieldValue0(name, type, notPresent, null, outCppType);
    }

    public <T> T getFieldValue(String name, Class<T> type) {
        return this.getFieldValue0(name, type, null, null, null);
    }

    private <T> T getFieldValue0(String name, Class<T> type, T notPresent, String inCppType, String[] outCppType) {
        VMField entry = this.getField(name, inCppType, notPresent == null);
        if (entry == null) {
            return notPresent;
        }
        if (entry.value == null) {
            throw new JVMCIError(name + " is not a static field ");
        }
        if (outCppType != null) {
            outCppType[0] = entry.type;
        }
        return type.cast(HotSpotVMConfigAccess.convertValue(name, type, entry.value, inCppType));
    }

    private VMField getField(String name, String cppType, boolean required) {
        VMField entry = this.store.vmFields.get(name);
        if (entry == null) {
            if (!required) {
                return null;
            }
            throw this.missingEntry("field", name, this.store.vmFields.keySet());
        }
        if (cppType != null && !cppType.equals(entry.type)) {
            throw new JVMCIError("expected type " + cppType + " but VM field " + name + " is of type " + entry.type);
        }
        return entry;
    }

    public <T> T getFlag(String name, Class<T> type) {
        return this.getFlag(name, type, null);
    }

    public <T> T getFlag(String name, Class<T> type, T notPresent) {
        String cppType;
        Object value;
        VMFlag entry = this.store.vmFlags.get(name);
        if (entry == null) {
            value = this.store.compilerToVm.getFlagValue(name);
            if (value == this.store.compilerToVm) {
                if (notPresent != null) {
                    return notPresent;
                }
                throw this.missingEntry("flag", name, this.store.vmFlags.keySet());
            }
            cppType = null;
        } else {
            value = entry.value;
            cppType = entry.type;
        }
        return type.cast(HotSpotVMConfigAccess.convertValue(name, type, value, cppType));
    }

    private JVMCIError missingEntry(String category, String name, Set<String> keys) {
        throw new JVMCIError("expected VM %s not found in %s: %s%nAvailable values:%n    %s", new Object[]{category, this.store, name, keys.stream().sorted().collect(Collectors.joining(System.lineSeparator() + "    "))});
    }

    private static <T> Object convertValue(String name, Class<T> toType, Object value, String cppType) throws JVMCIError {
        if (toType == Boolean.class) {
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof Long) {
                return (Long)value != 0L;
            }
        } else if (toType == Byte.class) {
            if (value instanceof Long) {
                return (byte)((Long)value).longValue();
            }
        } else if (toType == Integer.class) {
            if (value instanceof Integer) {
                return value;
            }
            if (value instanceof Long) {
                return (int)((Long)value).longValue();
            }
        } else if (toType == String.class ? value == null || value instanceof String : toType == Long.class) {
            return value;
        }
        throw new JVMCIError("cannot convert " + name + " of type " + value.getClass().getSimpleName() + (cppType == null ? "" : " [" + cppType + "]") + " to " + toType.getSimpleName());
    }

    public HotSpotVMConfigAccess(HotSpotVMConfigStore store) {
        this.store = store;
    }
}

