/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotVMConfigAccess;
import jdk.vm.ci.hotspot.HotSpotVMConfigStore;
import jdk.vm.ci.hotspot.UnsafeAccess;
import jdk.vm.ci.services.Services;
import sun.misc.Unsafe;

class HotSpotVMConfig
extends HotSpotVMConfigAccess {
    private final String osArch = this.getHostArchitectureName();
    final boolean useDeferredInitBarriers = this.getFlag("ReduceInitialCardMarks", Boolean.class);
    final boolean useCompressedOops = this.getFlag("UseCompressedOops", Boolean.class);
    final int objectAlignment = this.getFlag("ObjectAlignmentInBytes", Integer.class);
    final int hubOffset = this.getFieldOffset("oopDesc::_metadata._klass", Integer.class, "Klass*");
    final int prototypeMarkWordOffset = this.getFieldOffset("Klass::_prototype_header", Integer.class, "markOop");
    final int subklassOffset = this.getFieldOffset("Klass::_subklass", Integer.class, "Klass*");
    final int superOffset = this.getFieldOffset("Klass::_super", Integer.class, "Klass*");
    final int nextSiblingOffset = this.getFieldOffset("Klass::_next_sibling", Integer.class, "Klass*");
    final int superCheckOffsetOffset = this.getFieldOffset("Klass::_super_check_offset", Integer.class, "juint");
    final int secondarySuperCacheOffset = this.getFieldOffset("Klass::_secondary_super_cache", Integer.class, "Klass*");
    final int classLoaderDataOffset = this.getFieldOffset("Klass::_class_loader_data", Integer.class, "ClassLoaderData*");
    final int javaMirrorOffset = this.getFieldOffset("Klass::_java_mirror", Integer.class, "oop");
    final int klassAccessFlagsOffset = this.getFieldOffset("Klass::_access_flags", Integer.class, "AccessFlags");
    final int klassLayoutHelperOffset = this.getFieldOffset("Klass::_layout_helper", Integer.class, "jint");
    final int klassLayoutHelperNeutralValue = this.getConstant("Klass::_lh_neutral_value", Integer.class);
    final int klassLayoutHelperInstanceSlowPathBit = this.getConstant("Klass::_lh_instance_slow_path_bit", Integer.class);
    final int arrayKlassComponentMirrorOffset = this.getFieldOffset("ArrayKlass::_component_mirror", Integer.class, "oop");
    final int vtableEntrySize = this.getFieldValue("CompilerToVM::Data::sizeof_vtableEntry", Integer.class, "int");
    final int vtableEntryMethodOffset = this.getFieldOffset("vtableEntry::_method", Integer.class, "Method*");
    final int instanceKlassSourceFileNameIndexOffset = this.getFieldOffset("InstanceKlass::_source_file_name_index", Integer.class, "u2");
    final int instanceKlassInitStateOffset = this.getFieldOffset("InstanceKlass::_init_state", Integer.class, "u1");
    final int instanceKlassConstantsOffset = this.getFieldOffset("InstanceKlass::_constants", Integer.class, "ConstantPool*");
    final int instanceKlassFieldsOffset = this.getFieldOffset("InstanceKlass::_fields", Integer.class, "Array<u2>*");
    final int instanceKlassAnnotationsOffset = this.getFieldOffset("InstanceKlass::_annotations", Integer.class, "Annotations*");
    final int klassVtableStartOffset = this.getFieldValue("CompilerToVM::Data::Klass_vtable_start_offset", Integer.class, "int");
    final int klassVtableLengthOffset = this.getFieldValue("CompilerToVM::Data::Klass_vtable_length_offset", Integer.class, "int");
    final int instanceKlassStateLinked = this.getConstant("InstanceKlass::linked", Integer.class);
    final int instanceKlassStateFullyInitialized = this.getConstant("InstanceKlass::fully_initialized", Integer.class);
    final int instanceKlassStateBeingInitialized = this.getConstant("InstanceKlass::being_initialized", Integer.class);
    final int annotationsFieldAnnotationsOffset = this.getFieldOffset("Annotations::_fields_annotations", Integer.class, "Array<AnnotationArray*>*");
    final int fieldsAnnotationsBaseOffset = this.getFieldValue("CompilerToVM::Data::_fields_annotations_base_offset", Integer.class, "int");
    final int arrayU1LengthOffset = this.getFieldOffset("Array<int>::_length", Integer.class, "int");
    final int arrayU1DataOffset = this.getFieldOffset("Array<u1>::_data", Integer.class);
    final int arrayU2DataOffset = this.getFieldOffset("Array<u2>::_data", Integer.class);
    final int fieldInfoAccessFlagsOffset = this.getConstant("FieldInfo::access_flags_offset", Integer.class);
    final int fieldInfoNameIndexOffset = this.getConstant("FieldInfo::name_index_offset", Integer.class);
    final int fieldInfoSignatureIndexOffset = this.getConstant("FieldInfo::signature_index_offset", Integer.class);
    final int fieldInfoLowPackedOffset = this.getConstant("FieldInfo::low_packed_offset", Integer.class);
    final int fieldInfoHighPackedOffset = this.getConstant("FieldInfo::high_packed_offset", Integer.class);
    final int fieldInfoFieldSlots = this.getConstant("FieldInfo::field_slots", Integer.class);
    final int fieldInfoTagSize = this.getConstant("FIELDINFO_TAG_SIZE", Integer.class);
    final int jvmAccHasFinalizer = this.getConstant("JVM_ACC_HAS_FINALIZER", Integer.class);
    final int jvmAccFieldInternal = this.getConstant("JVM_ACC_FIELD_INTERNAL", Integer.class);
    final int jvmAccFieldStable = this.getConstant("JVM_ACC_FIELD_STABLE", Integer.class);
    final int jvmAccFieldHasGenericSignature = this.getConstant("JVM_ACC_FIELD_HAS_GENERIC_SIGNATURE", Integer.class);
    final int jvmAccIsCloneable = this.getConstant("JVM_ACC_IS_CLONEABLE", Integer.class);
    final int jvmAccSynthetic = this.getConstant("JVM_ACC_SYNTHETIC", Integer.class);
    final int jvmAccAnnotation = this.getConstant("JVM_ACC_ANNOTATION", Integer.class);
    final int jvmAccBridge = this.getConstant("JVM_ACC_BRIDGE", Integer.class);
    final int jvmAccVarargs = this.getConstant("JVM_ACC_VARARGS", Integer.class);
    final int jvmAccEnum = this.getConstant("JVM_ACC_ENUM", Integer.class);
    final int jvmAccInterface = this.getConstant("JVM_ACC_INTERFACE", Integer.class);
    final int runtimeCallStackSize = this.getConstant("frame::arg_reg_save_area_bytes", Integer.class, this.osArch.equals("amd64") ? null : Integer.valueOf(0));
    private final int markWordNoHashInPlace = this.getConstant("markOopDesc::no_hash_in_place", Integer.class);
    private final int markWordNoLockInPlace = this.getConstant("markOopDesc::no_lock_in_place", Integer.class);
    final int methodAccessFlagsOffset = this.getFieldOffset("Method::_access_flags", Integer.class, "AccessFlags");
    final int methodConstMethodOffset = this.getFieldOffset("Method::_constMethod", Integer.class, "ConstMethod*");
    final int methodIntrinsicIdOffset = this.getFieldOffset("Method::_intrinsic_id", Integer.class, "u1");
    final int methodFlagsOffset = this.getFieldOffset("Method::_flags", Integer.class, "u1");
    final int methodVtableIndexOffset = this.getFieldOffset("Method::_vtable_index", Integer.class, "int");
    final int methodDataOffset = this.getFieldOffset("Method::_method_data", Integer.class, "MethodData*");
    final int methodCodeOffset = this.getFieldOffset("Method::_code", Integer.class, "nmethod*");
    final int methodFlagsCallerSensitive = this.getConstant("Method::_caller_sensitive", Integer.class);
    final int methodFlagsForceInline = this.getConstant("Method::_force_inline", Integer.class);
    final int methodFlagsDontInline = this.getConstant("Method::_dont_inline", Integer.class);
    final int nonvirtualVtableIndex = this.getConstant("Method::nonvirtual_vtable_index", Integer.class);
    final int invalidVtableIndex = this.getConstant("Method::invalid_vtable_index", Integer.class);
    final int methodDataSize = this.getFieldOffset("MethodData::_size", Integer.class, "int");
    final int methodDataDataSize = this.getFieldOffset("MethodData::_data_size", Integer.class, "int");
    final int methodDataOopDataOffset = this.getFieldOffset("MethodData::_data[0]", Integer.class, "intptr_t");
    final int methodDataOopTrapHistoryOffset = this.getFieldOffset("MethodData::_trap_hist._array[0]", Integer.class, "u1");
    final int methodDataIRSizeOffset = this.getFieldOffset("MethodData::_jvmci_ir_size", Integer.class, "int");
    final int methodDataDecompiles = this.getFieldOffset("MethodData::_nof_decompiles", Integer.class, "uint");
    final int methodDataOverflowRecompiles = this.getFieldOffset("MethodData::_nof_overflow_recompiles", Integer.class, "uint");
    final int methodDataOverflowTraps = this.getFieldOffset("MethodData::_nof_overflow_traps", Integer.class, "uint");
    final int nmethodCompLevelOffset = this.getFieldOffset("nmethod::_comp_level", Integer.class, "int");
    final int compilationLevelNone = this.getConstant("CompLevel_none", Integer.class);
    final int compilationLevelSimple = this.getConstant("CompLevel_simple", Integer.class);
    final int compilationLevelLimitedProfile = this.getConstant("CompLevel_limited_profile", Integer.class);
    final int compilationLevelFullProfile = this.getConstant("CompLevel_full_profile", Integer.class);
    final int compilationLevelFullOptimization = this.getConstant("CompLevel_full_optimization", Integer.class);
    final int compLevelAdjustmentNone = this.getConstant("JVMCIRuntime::none", Integer.class);
    final int compLevelAdjustmentByHolder = this.getConstant("JVMCIRuntime::by_holder", Integer.class);
    final int compLevelAdjustmentByFullSignature = this.getConstant("JVMCIRuntime::by_full_signature", Integer.class);
    final int invocationEntryBci = this.getConstant("InvocationEntryBci", Integer.class);
    final int extraStackEntries = this.getFieldValue("CompilerToVM::Data::Method_extra_stack_entries", Integer.class, "int");
    final int constMethodConstantsOffset = this.getFieldOffset("ConstMethod::_constants", Integer.class, "ConstantPool*");
    final int constMethodFlagsOffset = this.getFieldOffset("ConstMethod::_flags", Integer.class, "u2");
    final int constMethodCodeSizeOffset = this.getFieldOffset("ConstMethod::_code_size", Integer.class, "u2");
    final int constMethodNameIndexOffset = this.getFieldOffset("ConstMethod::_name_index", Integer.class, "u2");
    final int constMethodSignatureIndexOffset = this.getFieldOffset("ConstMethod::_signature_index", Integer.class, "u2");
    final int constMethodMethodIdnumOffset = this.getFieldOffset("ConstMethod::_method_idnum", Integer.class, "u2");
    final int constMethodMaxStackOffset = this.getFieldOffset("ConstMethod::_max_stack", Integer.class, "u2");
    final int methodMaxLocalsOffset = this.getFieldOffset("ConstMethod::_max_locals", Integer.class, "u2");
    final int constMethodHasLineNumberTable = this.getConstant("ConstMethod::_has_linenumber_table", Integer.class);
    final int constMethodHasLocalVariableTable = this.getConstant("ConstMethod::_has_localvariable_table", Integer.class);
    final int constMethodHasMethodAnnotations = this.getConstant("ConstMethod::_has_method_annotations", Integer.class);
    final int constMethodHasParameterAnnotations = this.getConstant("ConstMethod::_has_parameter_annotations", Integer.class);
    final int constMethodHasExceptionTable = this.getConstant("ConstMethod::_has_exception_table", Integer.class);
    final int exceptionTableElementSize = this.getFieldValue("CompilerToVM::Data::sizeof_ExceptionTableElement", Integer.class, "int");
    final int exceptionTableElementStartPcOffset = this.getFieldOffset("ExceptionTableElement::start_pc", Integer.class, "u2");
    final int exceptionTableElementEndPcOffset = this.getFieldOffset("ExceptionTableElement::end_pc", Integer.class, "u2");
    final int exceptionTableElementHandlerPcOffset = this.getFieldOffset("ExceptionTableElement::handler_pc", Integer.class, "u2");
    final int exceptionTableElementCatchTypeIndexOffset = this.getFieldOffset("ExceptionTableElement::catch_type_index", Integer.class, "u2");
    final int localVariableTableElementSize = this.getFieldValue("CompilerToVM::Data::sizeof_LocalVariableTableElement", Integer.class, "int");
    final int localVariableTableElementStartBciOffset = this.getFieldOffset("LocalVariableTableElement::start_bci", Integer.class, "u2");
    final int localVariableTableElementLengthOffset = this.getFieldOffset("LocalVariableTableElement::length", Integer.class, "u2");
    final int localVariableTableElementNameCpIndexOffset = this.getFieldOffset("LocalVariableTableElement::name_cp_index", Integer.class, "u2");
    final int localVariableTableElementDescriptorCpIndexOffset = this.getFieldOffset("LocalVariableTableElement::descriptor_cp_index", Integer.class, "u2");
    final int localVariableTableElementSlotOffset = this.getFieldOffset("LocalVariableTableElement::slot", Integer.class, "u2");
    final int constantPoolSize = this.getFieldValue("CompilerToVM::Data::sizeof_ConstantPool", Integer.class, "int");
    final int constantPoolTagsOffset = this.getFieldOffset("ConstantPool::_tags", Integer.class, "Array<u1>*");
    final int constantPoolHolderOffset = this.getFieldOffset("ConstantPool::_pool_holder", Integer.class, "InstanceKlass*");
    final int constantPoolLengthOffset = this.getFieldOffset("ConstantPool::_length", Integer.class, "int");
    final int constantPoolFlagsOffset = this.getFieldOffset("ConstantPool::_flags", Integer.class, "int");
    final int constantPoolCpCacheIndexTag = this.getConstant("ConstantPool::CPCACHE_INDEX_TAG", Integer.class);
    final int jvmConstantUtf8 = this.getConstant("JVM_CONSTANT_Utf8", Integer.class);
    final int jvmConstantInteger = this.getConstant("JVM_CONSTANT_Integer", Integer.class);
    final int jvmConstantLong = this.getConstant("JVM_CONSTANT_Long", Integer.class);
    final int jvmConstantFloat = this.getConstant("JVM_CONSTANT_Float", Integer.class);
    final int jvmConstantDouble = this.getConstant("JVM_CONSTANT_Double", Integer.class);
    final int jvmConstantClass = this.getConstant("JVM_CONSTANT_Class", Integer.class);
    final int jvmConstantUnresolvedClass = this.getConstant("JVM_CONSTANT_UnresolvedClass", Integer.class);
    final int jvmConstantUnresolvedClassInError = this.getConstant("JVM_CONSTANT_UnresolvedClassInError", Integer.class);
    final int jvmConstantString = this.getConstant("JVM_CONSTANT_String", Integer.class);
    final int jvmConstantFieldref = this.getConstant("JVM_CONSTANT_Fieldref", Integer.class);
    final int jvmConstantMethodref = this.getConstant("JVM_CONSTANT_Methodref", Integer.class);
    final int jvmConstantInterfaceMethodref = this.getConstant("JVM_CONSTANT_InterfaceMethodref", Integer.class);
    final int jvmConstantNameAndType = this.getConstant("JVM_CONSTANT_NameAndType", Integer.class);
    final int jvmConstantMethodHandle = this.getConstant("JVM_CONSTANT_MethodHandle", Integer.class);
    final int jvmConstantMethodHandleInError = this.getConstant("JVM_CONSTANT_MethodHandleInError", Integer.class);
    final int jvmConstantMethodType = this.getConstant("JVM_CONSTANT_MethodType", Integer.class);
    final int jvmConstantMethodTypeInError = this.getConstant("JVM_CONSTANT_MethodTypeInError", Integer.class);
    final int jvmConstantInvokeDynamic = this.getConstant("JVM_CONSTANT_InvokeDynamic", Integer.class);
    final int jvmConstantExternalMax = this.getConstant("JVM_CONSTANT_ExternalMax", Integer.class);
    final int jvmConstantInternalMin = this.getConstant("JVM_CONSTANT_InternalMin", Integer.class);
    final int jvmConstantInternalMax = this.getConstant("JVM_CONSTANT_InternalMax", Integer.class);
    final int heapWordSize = this.getConstant("HeapWordSize", Integer.class);
    final long vmSymbolsSymbols = this.getFieldAddress("vmSymbols::_symbols[0]", "Symbol*");
    final int vmSymbolsFirstSID = this.getConstant("vmSymbols::FIRST_SID", Integer.class);
    final int vmSymbolsSIDLimit = this.getConstant("vmSymbols::SID_LIMIT", Integer.class);
    final long symbolInit = this.getFieldValue("CompilerToVM::Data::symbol_init", Long.class);
    final long symbolClinit = this.getFieldValue("CompilerToVM::Data::symbol_clinit", Long.class);
    final int universeBaseVtableSize = this.getFieldValue("CompilerToVM::Data::Universe_base_vtable_size", Integer.class, "int");
    final int klassOffset = this.getFieldValue("java_lang_Class::_klass_offset", Integer.class, "int");
    final int dataLayoutHeaderSize = this.getConstant("DataLayout::cell_size", Integer.class);
    final int dataLayoutTagOffset = this.getFieldOffset("DataLayout::_header._struct._tag", Integer.class, "u1");
    final int dataLayoutFlagsOffset = this.getFieldOffset("DataLayout::_header._struct._flags", Integer.class, "u1");
    final int dataLayoutBCIOffset = this.getFieldOffset("DataLayout::_header._struct._bci", Integer.class, "u2");
    final int dataLayoutCellSize = this.getConstant("DataLayout::cell_size", Integer.class);
    final int dataLayoutNoTag = this.getConstant("DataLayout::no_tag", Integer.class);
    final int dataLayoutBitDataTag = this.getConstant("DataLayout::bit_data_tag", Integer.class);
    final int dataLayoutCounterDataTag = this.getConstant("DataLayout::counter_data_tag", Integer.class);
    final int dataLayoutJumpDataTag = this.getConstant("DataLayout::jump_data_tag", Integer.class);
    final int dataLayoutReceiverTypeDataTag = this.getConstant("DataLayout::receiver_type_data_tag", Integer.class);
    final int dataLayoutVirtualCallDataTag = this.getConstant("DataLayout::virtual_call_data_tag", Integer.class);
    final int dataLayoutRetDataTag = this.getConstant("DataLayout::ret_data_tag", Integer.class);
    final int dataLayoutBranchDataTag = this.getConstant("DataLayout::branch_data_tag", Integer.class);
    final int dataLayoutMultiBranchDataTag = this.getConstant("DataLayout::multi_branch_data_tag", Integer.class);
    final int dataLayoutArgInfoDataTag = this.getConstant("DataLayout::arg_info_data_tag", Integer.class);
    final int dataLayoutCallTypeDataTag = this.getConstant("DataLayout::call_type_data_tag", Integer.class);
    final int dataLayoutVirtualCallTypeDataTag = this.getConstant("DataLayout::virtual_call_type_data_tag", Integer.class);
    final int dataLayoutParametersTypeDataTag = this.getConstant("DataLayout::parameters_type_data_tag", Integer.class);
    final int dataLayoutSpeculativeTrapDataTag = this.getConstant("DataLayout::speculative_trap_data_tag", Integer.class);
    final int bciProfileWidth = this.getFlag("BciProfileWidth", Integer.class);
    final int typeProfileWidth = this.getFlag("TypeProfileWidth", Integer.class);
    final int methodProfileWidth = this.getFlag("MethodProfileWidth", Integer.class);
    final int deoptReasonNone = this.getConstant("Deoptimization::Reason_none", Integer.class);
    final int deoptReasonNullCheck = this.getConstant("Deoptimization::Reason_null_check", Integer.class);
    final int deoptReasonRangeCheck = this.getConstant("Deoptimization::Reason_range_check", Integer.class);
    final int deoptReasonClassCheck = this.getConstant("Deoptimization::Reason_class_check", Integer.class);
    final int deoptReasonArrayCheck = this.getConstant("Deoptimization::Reason_array_check", Integer.class);
    final int deoptReasonUnreached0 = this.getConstant("Deoptimization::Reason_unreached0", Integer.class);
    final int deoptReasonTypeCheckInlining = this.getConstant("Deoptimization::Reason_type_checked_inlining", Integer.class);
    final int deoptReasonOptimizedTypeCheck = this.getConstant("Deoptimization::Reason_optimized_type_check", Integer.class);
    final int deoptReasonNotCompiledExceptionHandler = this.getConstant("Deoptimization::Reason_not_compiled_exception_handler", Integer.class);
    final int deoptReasonUnresolved = this.getConstant("Deoptimization::Reason_unresolved", Integer.class);
    final int deoptReasonJsrMismatch = this.getConstant("Deoptimization::Reason_jsr_mismatch", Integer.class);
    final int deoptReasonDiv0Check = this.getConstant("Deoptimization::Reason_div0_check", Integer.class);
    final int deoptReasonConstraint = this.getConstant("Deoptimization::Reason_constraint", Integer.class);
    final int deoptReasonLoopLimitCheck = this.getConstant("Deoptimization::Reason_loop_limit_check", Integer.class);
    final int deoptReasonAliasing = this.getConstant("Deoptimization::Reason_aliasing", Integer.class);
    final int deoptReasonTransferToInterpreter = this.getConstant("Deoptimization::Reason_transfer_to_interpreter", Integer.class);
    final int deoptReasonOSROffset = this.getConstant("Deoptimization::Reason_LIMIT", Integer.class);
    final int deoptActionNone = this.getConstant("Deoptimization::Action_none", Integer.class);
    final int deoptActionMaybeRecompile = this.getConstant("Deoptimization::Action_maybe_recompile", Integer.class);
    final int deoptActionReinterpret = this.getConstant("Deoptimization::Action_reinterpret", Integer.class);
    final int deoptActionMakeNotEntrant = this.getConstant("Deoptimization::Action_make_not_entrant", Integer.class);
    final int deoptActionMakeNotCompilable = this.getConstant("Deoptimization::Action_make_not_compilable", Integer.class);
    final int deoptimizationActionBits = this.getConstant("Deoptimization::_action_bits", Integer.class);
    final int deoptimizationReasonBits = this.getConstant("Deoptimization::_reason_bits", Integer.class);
    final int deoptimizationDebugIdBits = this.getConstant("Deoptimization::_debug_id_bits", Integer.class);
    final int deoptimizationActionShift = this.getConstant("Deoptimization::_action_shift", Integer.class);
    final int deoptimizationReasonShift = this.getConstant("Deoptimization::_reason_shift", Integer.class);
    final int deoptimizationDebugIdShift = this.getConstant("Deoptimization::_debug_id_shift", Integer.class);
    final int vmIntrinsicInvokeBasic = this.getConstant("vmIntrinsics::_invokeBasic", Integer.class);
    final int vmIntrinsicLinkToVirtual = this.getConstant("vmIntrinsics::_linkToVirtual", Integer.class);
    final int vmIntrinsicLinkToStatic = this.getConstant("vmIntrinsics::_linkToStatic", Integer.class);
    final int vmIntrinsicLinkToSpecial = this.getConstant("vmIntrinsics::_linkToSpecial", Integer.class);
    final int vmIntrinsicLinkToInterface = this.getConstant("vmIntrinsics::_linkToInterface", Integer.class);
    final int codeInstallResultOk = this.getConstant("JVMCIEnv::ok", Integer.class);
    final int codeInstallResultDependenciesFailed = this.getConstant("JVMCIEnv::dependencies_failed", Integer.class);
    final int codeInstallResultDependenciesInvalid = this.getConstant("JVMCIEnv::dependencies_invalid", Integer.class);
    final int codeInstallResultCacheFull = this.getConstant("JVMCIEnv::cache_full", Integer.class);
    final int codeInstallResultCodeTooLarge = this.getConstant("JVMCIEnv::code_too_large", Integer.class);
    final int bitDataExceptionSeenFlag = this.getConstant("BitData::exception_seen_flag", Integer.class);
    final int bitDataNullSeenFlag = this.getConstant("BitData::null_seen_flag", Integer.class);
    final int methodDataCountOffset = this.getConstant("CounterData::count_off", Integer.class);
    final int jumpDataTakenOffset = this.getConstant("JumpData::taken_off_set", Integer.class);
    final int jumpDataDisplacementOffset = this.getConstant("JumpData::displacement_off_set", Integer.class);
    final int receiverTypeDataNonprofiledCountOffset = this.getConstant("ReceiverTypeData::nonprofiled_count_off_set", Integer.class);
    final int receiverTypeDataReceiverTypeRowCellCount = this.getConstant("ReceiverTypeData::receiver_type_row_cell_count", Integer.class);
    final int receiverTypeDataReceiver0Offset = this.getConstant("ReceiverTypeData::receiver0_offset", Integer.class);
    final int receiverTypeDataCount0Offset = this.getConstant("ReceiverTypeData::count0_offset", Integer.class);
    final int branchDataNotTakenOffset = this.getConstant("BranchData::not_taken_off_set", Integer.class);
    final int arrayDataArrayLenOffset = this.getConstant("ArrayData::array_len_off_set", Integer.class);
    final int arrayDataArrayStartOffset = this.getConstant("ArrayData::array_start_off_set", Integer.class);
    final int multiBranchDataPerCaseCellCount = this.getConstant("MultiBranchData::per_case_cell_count", Integer.class);

    static HotSpotVMConfig config() {
        return HotSpotJVMCIRuntime.runtime().getConfig();
    }

    HotSpotVMConfig(HotSpotVMConfigStore store) {
        super(store);
    }

    String getHostArchitectureName() {
        String arch;
        switch (arch = Services.getSavedProperty((String)"os.arch")) {
            case "x86_64": {
                return "amd64";
            }
            case "sparcv9": {
                return "sparc";
            }
        }
        return arch;
    }

    long arrayPrototypeMarkWord() {
        return this.markWordNoHashInPlace | this.markWordNoLockInPlace;
    }

    String symbolAt(int index) {
        HotSpotJVMCIRuntime runtime = HotSpotJVMCIRuntime.runtime();
        assert (this.vmSymbolsFirstSID <= index && index < this.vmSymbolsSIDLimit) : "index " + index + " is out of bounds";
        int offset = index * Unsafe.ADDRESS_SIZE;
        return runtime.getCompilerToVM().getSymbol(UnsafeAccess.UNSAFE.getAddress(this.vmSymbolsSymbols + (long)offset));
    }

    final int baseVtableLength() {
        return this.universeBaseVtableSize / (this.vtableEntrySize / this.heapWordSize);
    }

    String getCodeInstallResultDescription(int codeInstallResult) {
        if (codeInstallResult == this.codeInstallResultOk) {
            return "ok";
        }
        if (codeInstallResult == this.codeInstallResultDependenciesFailed) {
            return "dependencies failed";
        }
        if (codeInstallResult == this.codeInstallResultDependenciesInvalid) {
            return "dependencies invalid";
        }
        if (codeInstallResult == this.codeInstallResultCacheFull) {
            return "code cache is full";
        }
        if (codeInstallResult == this.codeInstallResultCodeTooLarge) {
            return "code is too large";
        }
        assert (false) : codeInstallResult;
        return "unknown";
    }
}

