/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectTypeImpl;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.UnresolvedJavaType;

public class HotSpotSignature
implements Signature {
    private final List<String> parameters = new ArrayList<String>();
    private final String returnType;
    private final String originalString;
    private ResolvedJavaType[] parameterTypes;
    private ResolvedJavaType returnTypeCache;
    private final HotSpotJVMCIRuntime runtime;

    public HotSpotSignature(HotSpotJVMCIRuntime runtime, String signature) {
        this.runtime = runtime;
        if (signature.length() == 0) {
            throw new IllegalArgumentException("Signature cannot be empty");
        }
        this.originalString = signature;
        if (signature.charAt(0) == '(') {
            int nextCur;
            int cur = 1;
            while (cur < signature.length() && signature.charAt(cur) != ')') {
                nextCur = HotSpotSignature.parseSignature(signature, cur);
                this.parameters.add(signature.substring(cur, nextCur));
                cur = nextCur;
            }
            nextCur = HotSpotSignature.parseSignature(signature, ++cur);
            this.returnType = signature.substring(cur, nextCur);
            if (nextCur != signature.length()) {
                throw new IllegalArgumentException("Extra characters at end of signature: " + signature);
            }
        } else {
            throw new IllegalArgumentException("Signature must start with a '(': " + signature);
        }
    }

    public HotSpotSignature(HotSpotJVMCIRuntime runtime, ResolvedJavaType returnType, ResolvedJavaType ... parameterTypes) {
        this.runtime = runtime;
        this.parameterTypes = (ResolvedJavaType[])parameterTypes.clone();
        this.returnTypeCache = returnType;
        this.returnType = returnType.getName();
        StringBuilder sb = new StringBuilder("(");
        for (ResolvedJavaType type : parameterTypes) {
            this.parameters.add(type.getName());
            sb.append(type.getName());
        }
        sb.append(")").append(returnType.getName());
        this.originalString = sb.toString();
        assert (new HotSpotSignature(runtime, this.originalString).equals(this));
    }

    private static int parseSignature(String signature, int start) {
        try {
            char first;
            int cur = start;
            do {
                first = signature.charAt(cur);
                ++cur;
            } while (first == '[');
            switch (first) {
                case 'L': {
                    while (signature.charAt(cur) != ';') {
                        if (signature.charAt(cur) == '.') {
                            throw new IllegalArgumentException("Class name in signature contains '.' at index " + cur + ": " + signature);
                        }
                        ++cur;
                    }
                    ++cur;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid character '" + signature.charAt(cur - 1) + "' at index " + (cur - 1) + " in signature: " + signature);
                }
            }
            return cur;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Truncated signature: " + signature);
        }
    }

    public int getParameterCount(boolean withReceiver) {
        return this.parameters.size() + (withReceiver ? 1 : 0);
    }

    public JavaKind getParameterKind(int index) {
        return JavaKind.fromTypeString((String)this.parameters.get(index));
    }

    private static boolean checkValidCache(ResolvedJavaType type, ResolvedJavaType accessingClass) {
        assert (accessingClass != null);
        if (type == null) {
            return false;
        }
        if (type instanceof HotSpotResolvedObjectTypeImpl) {
            return ((HotSpotResolvedObjectTypeImpl)type).isDefinitelyResolvedWithRespectTo(accessingClass);
        }
        return true;
    }

    private static JavaType getUnresolvedOrPrimitiveType(HotSpotJVMCIRuntime runtime, String name) {
        if (name.length() == 1) {
            JavaKind kind = JavaKind.fromPrimitiveOrVoidTypeChar((char)name.charAt(0));
            return runtime.getHostJVMCIBackend().getMetaAccess().lookupJavaType(kind.toJavaClass());
        }
        return UnresolvedJavaType.create((String)name);
    }

    public JavaType getParameterType(int index, ResolvedJavaType accessingClass) {
        ResolvedJavaType type;
        if (accessingClass == null) {
            return HotSpotSignature.getUnresolvedOrPrimitiveType(this.runtime, this.parameters.get(index));
        }
        if (this.parameterTypes == null) {
            this.parameterTypes = new ResolvedJavaType[this.parameters.size()];
        }
        if (!HotSpotSignature.checkValidCache(type = this.parameterTypes[index], accessingClass)) {
            JavaType result = this.runtime.lookupType(this.parameters.get(index), (HotSpotResolvedObjectType)accessingClass, false);
            if (result instanceof ResolvedJavaType) {
                this.parameterTypes[index] = type = (ResolvedJavaType)result;
            } else {
                assert (result != null);
                return result;
            }
        }
        assert (type != null);
        return type;
    }

    public String toMethodDescriptor() {
        assert (this.originalString.equals(super.toMethodDescriptor())) : this.originalString + " != " + super.toMethodDescriptor();
        return this.originalString;
    }

    public JavaKind getReturnKind() {
        return JavaKind.fromTypeString((String)this.returnType);
    }

    public JavaType getReturnType(ResolvedJavaType accessingClass) {
        if (accessingClass == null) {
            return HotSpotSignature.getUnresolvedOrPrimitiveType(this.runtime, this.returnType);
        }
        if (!HotSpotSignature.checkValidCache(this.returnTypeCache, accessingClass)) {
            JavaType result = this.runtime.lookupType(this.returnType, (HotSpotResolvedObjectType)accessingClass, false);
            if (result instanceof ResolvedJavaType) {
                this.returnTypeCache = (ResolvedJavaType)result;
            } else {
                return result;
            }
        }
        return this.returnTypeCache;
    }

    public String toString() {
        return "HotSpotSignature<" + this.originalString + ">";
    }

    public boolean equals(Object obj) {
        if (obj instanceof HotSpotSignature) {
            HotSpotSignature other = (HotSpotSignature)obj;
            if (other.originalString.equals(this.originalString)) {
                assert (other.parameters.equals(this.parameters));
                assert (other.returnType.equals(this.returnType));
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.originalString.hashCode();
    }
}

