/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jdk.vm.ci.hotspot.IndirectHotSpotObjectConstantImpl;
import jdk.vm.ci.hotspot.VMEntryPoint;
import jdk.vm.ci.services.Services;

public final class HotSpotObjectConstantScope
implements AutoCloseable {
    static final ThreadLocal<HotSpotObjectConstantScope> CURRENT = new ThreadLocal();
    private final HotSpotObjectConstantScope parent = CURRENT.get();
    private List<IndirectHotSpotObjectConstantImpl> foreignObjects;
    final Object localScopeDescription;

    public static HotSpotObjectConstantScope openLocalScope(Object description) {
        return Services.IS_IN_NATIVE_IMAGE ? new HotSpotObjectConstantScope(Objects.requireNonNull(description)) : null;
    }

    public static HotSpotObjectConstantScope enterGlobalScope() {
        return Services.IS_IN_NATIVE_IMAGE && CURRENT.get() != null ? new HotSpotObjectConstantScope(null) : null;
    }

    private HotSpotObjectConstantScope(Object localScopeDescription) {
        CURRENT.set(this);
        this.localScopeDescription = localScopeDescription;
    }

    boolean isGlobal() {
        return this.localScopeDescription == null;
    }

    void add(IndirectHotSpotObjectConstantImpl obj) {
        assert (!this.isGlobal());
        if (this.foreignObjects == null) {
            this.foreignObjects = new ArrayList<IndirectHotSpotObjectConstantImpl>();
        }
        this.foreignObjects.add(obj);
    }

    @Override
    @VMEntryPoint
    public void close() {
        if (CURRENT.get() != this) {
            throw new IllegalStateException("Cannot close non-active scope");
        }
        if (this.foreignObjects != null) {
            for (IndirectHotSpotObjectConstantImpl obj : this.foreignObjects) {
                obj.clear(this.localScopeDescription);
            }
            this.foreignObjects = null;
        }
        CURRENT.set(this.parent);
    }
}

