/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.util.Formattable;
import java.util.Formatter;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;

abstract class HotSpotMethod
implements JavaMethod,
Formattable {
    public static final boolean FULLY_QUALIFIED_METHOD_NAME = false;

    HotSpotMethod() {
    }

    public static String applyFormattingFlagsAndWidth(String s, int flags, int width) {
        if (flags == 0 && width < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        int len = sb.length();
        if (len < width) {
            for (int i = 0; i < width - len; ++i) {
                if ((flags & 1) == 1) {
                    sb.append(' ');
                    continue;
                }
                sb.insert(0, ' ');
            }
        }
        String res = sb.toString();
        if ((flags & 2) == 2) {
            res = res.toUpperCase();
        }
        return res;
    }

    public final String toString() {
        char h = 'h';
        String suffix = this instanceof ResolvedJavaMethod ? "" : ", unresolved";
        String fmt = String.format("HotSpotMethod<%%%c.%%n(%%p)%s>", Character.valueOf(h), suffix);
        return this.format(fmt);
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        String base = (flags & 4) == 4 ? this.getName() : this.toString();
        formatter.format(HotSpotMethod.applyFormattingFlagsAndWidth(base, flags & 0xFFFFFFFB, width), new Object[0]);
    }
}

