/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.HotSpotSignature;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.hotspot.HotSpotVMConfig;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;

public class HotSpotMetaAccessProvider
implements MetaAccessProvider {
    protected final HotSpotJVMCIRuntime runtime;

    public HotSpotMetaAccessProvider(HotSpotJVMCIRuntime runtime) {
        this.runtime = runtime;
    }

    public ResolvedJavaType lookupJavaType(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class parameter was null");
        }
        return this.runtime.fromClass(clazz);
    }

    public HotSpotResolvedObjectType lookupJavaType(JavaConstant constant) {
        if (constant.isNull() || !(constant instanceof HotSpotObjectConstant)) {
            return null;
        }
        return ((HotSpotObjectConstant)constant).getType();
    }

    public Signature parseMethodDescriptor(String signature) {
        return new HotSpotSignature(this.runtime, signature);
    }

    public ResolvedJavaMethod lookupJavaMethod(Executable reflectionMethod) {
        return this.runtime.getCompilerToVM().asResolvedJavaMethod(Objects.requireNonNull(reflectionMethod));
    }

    public ResolvedJavaField lookupJavaField(Field reflectionField) {
        Class<?> fieldHolder = reflectionField.getDeclaringClass();
        HotSpotResolvedJavaType holder = this.runtime.fromClass(fieldHolder);
        assert (holder != null) : fieldHolder;
        ResolvedJavaField[] fields = Modifier.isStatic(reflectionField.getModifiers()) ? holder.getStaticFields() : holder.getInstanceFields(false);
        ResolvedJavaType fieldType = this.lookupJavaType(reflectionField.getType());
        for (ResolvedJavaField field : fields) {
            if (!reflectionField.getName().equals(field.getName()) || !field.getType().equals(fieldType)) continue;
            assert (Modifier.isStatic(reflectionField.getModifiers()) == field.isStatic());
            return field;
        }
        throw new JVMCIError("unresolved field %s", new Object[]{reflectionField});
    }

    private static int intMaskRight(int n) {
        assert (n <= 32);
        return n == 32 ? -1 : (1 << n) - 1;
    }

    public JavaConstant encodeDeoptActionAndReason(DeoptimizationAction action, DeoptimizationReason reason, int debugId) {
        HotSpotVMConfig config = this.runtime.getConfig();
        int actionValue = this.convertDeoptAction(action);
        int reasonValue = this.convertDeoptReason(reason);
        int debugValue = debugId & HotSpotMetaAccessProvider.intMaskRight(config.deoptimizationDebugIdBits);
        PrimitiveConstant c = JavaConstant.forInt((int)(~(debugValue << config.deoptimizationDebugIdShift | reasonValue << config.deoptimizationReasonShift | actionValue << config.deoptimizationActionShift)));
        assert (c.asInt() < 0);
        return c;
    }

    public DeoptimizationReason decodeDeoptReason(JavaConstant constant) {
        HotSpotVMConfig config = this.runtime.getConfig();
        int reasonValue = ~constant.asInt() >> config.deoptimizationReasonShift & HotSpotMetaAccessProvider.intMaskRight(config.deoptimizationReasonBits);
        DeoptimizationReason reason = this.convertDeoptReason(reasonValue);
        return reason;
    }

    public DeoptimizationAction decodeDeoptAction(JavaConstant constant) {
        HotSpotVMConfig config = this.runtime.getConfig();
        int actionValue = ~constant.asInt() >> config.deoptimizationActionShift & HotSpotMetaAccessProvider.intMaskRight(config.deoptimizationActionBits);
        DeoptimizationAction action = this.convertDeoptAction(actionValue);
        return action;
    }

    public int decodeDebugId(JavaConstant constant) {
        HotSpotVMConfig config = this.runtime.getConfig();
        return ~constant.asInt() >> config.deoptimizationDebugIdShift & HotSpotMetaAccessProvider.intMaskRight(config.deoptimizationDebugIdBits);
    }

    public JavaConstant encodeSpeculation(SpeculationLog.Speculation speculation) {
        if (speculation.getReason() instanceof SpeculationLog.NoSpeculationReason) {
            return JavaConstant.LONG_0;
        }
        return ((HotSpotSpeculationLog.HotSpotSpeculation)speculation).getEncoding();
    }

    public SpeculationLog.Speculation decodeSpeculation(JavaConstant constant, SpeculationLog speculationLog) {
        if (constant.equals(JavaConstant.LONG_0)) {
            return SpeculationLog.NO_SPECULATION;
        }
        if (speculationLog == null) {
            throw new IllegalArgumentException("A speculation log is required to decode the speculation denoted by " + constant);
        }
        return speculationLog.lookupSpeculation(constant);
    }

    public int convertDeoptAction(DeoptimizationAction action) {
        HotSpotVMConfig config = this.runtime.getConfig();
        switch (action) {
            case None: {
                return config.deoptActionNone;
            }
            case RecompileIfTooManyDeopts: {
                return config.deoptActionMaybeRecompile;
            }
            case InvalidateReprofile: {
                return config.deoptActionReinterpret;
            }
            case InvalidateRecompile: {
                return config.deoptActionMakeNotEntrant;
            }
            case InvalidateStopCompiling: {
                return config.deoptActionMakeNotCompilable;
            }
        }
        throw new JVMCIError("%s", new Object[]{action});
    }

    public DeoptimizationAction convertDeoptAction(int action) {
        HotSpotVMConfig config = this.runtime.getConfig();
        if (action == config.deoptActionNone) {
            return DeoptimizationAction.None;
        }
        if (action == config.deoptActionMaybeRecompile) {
            return DeoptimizationAction.RecompileIfTooManyDeopts;
        }
        if (action == config.deoptActionReinterpret) {
            return DeoptimizationAction.InvalidateReprofile;
        }
        if (action == config.deoptActionMakeNotEntrant) {
            return DeoptimizationAction.InvalidateRecompile;
        }
        if (action == config.deoptActionMakeNotCompilable) {
            return DeoptimizationAction.InvalidateStopCompiling;
        }
        throw new JVMCIError("%d", new Object[]{action});
    }

    public int convertDeoptReason(DeoptimizationReason reason) {
        HotSpotVMConfig config = this.runtime.getConfig();
        switch (reason) {
            case None: {
                return config.deoptReasonNone;
            }
            case NullCheckException: {
                return config.deoptReasonNullCheck;
            }
            case BoundsCheckException: {
                return config.deoptReasonRangeCheck;
            }
            case ClassCastException: {
                return config.deoptReasonClassCheck;
            }
            case ArrayStoreException: {
                return config.deoptReasonArrayCheck;
            }
            case UnreachedCode: {
                return config.deoptReasonUnreached0;
            }
            case TypeCheckedInliningViolated: {
                return config.deoptReasonTypeCheckInlining;
            }
            case OptimizedTypeCheckViolated: {
                return config.deoptReasonOptimizedTypeCheck;
            }
            case NotCompiledExceptionHandler: {
                return config.deoptReasonNotCompiledExceptionHandler;
            }
            case Unresolved: {
                return config.deoptReasonUnresolved;
            }
            case JavaSubroutineMismatch: {
                return config.deoptReasonJsrMismatch;
            }
            case ArithmeticException: {
                return config.deoptReasonDiv0Check;
            }
            case RuntimeConstraint: {
                return config.deoptReasonConstraint;
            }
            case LoopLimitCheck: {
                return config.deoptReasonLoopLimitCheck;
            }
            case Aliasing: {
                return config.deoptReasonAliasing;
            }
            case TransferToInterpreter: {
                return config.deoptReasonTransferToInterpreter;
            }
        }
        throw new JVMCIError("%s", new Object[]{reason});
    }

    public DeoptimizationReason convertDeoptReason(int reason) {
        HotSpotVMConfig config = this.runtime.getConfig();
        if (reason == config.deoptReasonNone) {
            return DeoptimizationReason.None;
        }
        if (reason == config.deoptReasonNullCheck) {
            return DeoptimizationReason.NullCheckException;
        }
        if (reason == config.deoptReasonRangeCheck) {
            return DeoptimizationReason.BoundsCheckException;
        }
        if (reason == config.deoptReasonClassCheck) {
            return DeoptimizationReason.ClassCastException;
        }
        if (reason == config.deoptReasonArrayCheck) {
            return DeoptimizationReason.ArrayStoreException;
        }
        if (reason == config.deoptReasonUnreached0) {
            return DeoptimizationReason.UnreachedCode;
        }
        if (reason == config.deoptReasonTypeCheckInlining) {
            return DeoptimizationReason.TypeCheckedInliningViolated;
        }
        if (reason == config.deoptReasonOptimizedTypeCheck) {
            return DeoptimizationReason.OptimizedTypeCheckViolated;
        }
        if (reason == config.deoptReasonNotCompiledExceptionHandler) {
            return DeoptimizationReason.NotCompiledExceptionHandler;
        }
        if (reason == config.deoptReasonUnresolved) {
            return DeoptimizationReason.Unresolved;
        }
        if (reason == config.deoptReasonJsrMismatch) {
            return DeoptimizationReason.JavaSubroutineMismatch;
        }
        if (reason == config.deoptReasonDiv0Check) {
            return DeoptimizationReason.ArithmeticException;
        }
        if (reason == config.deoptReasonConstraint) {
            return DeoptimizationReason.RuntimeConstraint;
        }
        if (reason == config.deoptReasonLoopLimitCheck) {
            return DeoptimizationReason.LoopLimitCheck;
        }
        if (reason == config.deoptReasonAliasing) {
            return DeoptimizationReason.Aliasing;
        }
        if (reason == config.deoptReasonTransferToInterpreter) {
            return DeoptimizationReason.TransferToInterpreter;
        }
        throw new JVMCIError("%x", new Object[]{reason});
    }

    public long getMemorySize(JavaConstant constant) {
        if (constant.getJavaKind() == JavaKind.Object) {
            HotSpotResolvedObjectType lookupJavaType = this.lookupJavaType(constant);
            if (lookupJavaType == null) {
                return 0L;
            }
            if (lookupJavaType.isArray()) {
                int length = this.runtime.getHostJVMCIBackend().getConstantReflection().readArrayLength(constant);
                ResolvedJavaType elementType = lookupJavaType.getComponentType();
                JavaKind elementKind = elementType.getJavaKind();
                int headerSize = this.runtime.getArrayBaseOffset(elementKind);
                int sizeOfElement = this.runtime.getArrayIndexScale(elementKind);
                int log2ElementSize = CodeUtil.log2((int)sizeOfElement);
                return this.computeArrayAllocationSize(length, headerSize, log2ElementSize);
            }
            return lookupJavaType.instanceSize();
        }
        return constant.getJavaKind().getByteCount();
    }

    public int computeArrayAllocationSize(int length, int headerSize, int log2ElementSize) {
        HotSpotVMConfig config = this.runtime.getConfig();
        int alignment = config.objectAlignment;
        int size = (length << log2ElementSize) + headerSize + (alignment - 1);
        int mask = ~(alignment - 1);
        return size & mask;
    }

    public int getArrayBaseOffset(JavaKind kind) {
        return this.runtime.getArrayBaseOffset(kind);
    }

    public int getArrayIndexScale(JavaKind kind) {
        return this.runtime.getArrayIndexScale(kind);
    }
}

