/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.hotspot.CompilerToVM;
import jdk.vm.ci.hotspot.HandleCleaner;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethodImpl;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectTypeImpl;
import jdk.vm.ci.hotspot.HotSpotSignature;
import jdk.vm.ci.hotspot.HotSpotVMConfig;
import jdk.vm.ci.hotspot.MetaspaceHandleObject;
import jdk.vm.ci.hotspot.SuppressFBWarnings;
import jdk.vm.ci.hotspot.UnsafeAccess;
import jdk.vm.ci.hotspot.VMEntryPoint;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.UnresolvedJavaField;
import jdk.vm.ci.meta.UnresolvedJavaMethod;
import jdk.vm.ci.meta.UnresolvedJavaType;

public final class HotSpotConstantPool
implements ConstantPool,
MetaspaceHandleObject {
    private final long metadataHandle;
    private volatile LookupTypeCacheElement lastLookupType;
    private final JvmConstants constants;
    private static volatile String[] signaturePolymorphicHolders;

    @VMEntryPoint
    private static HotSpotConstantPool fromMetaspace(long metaspaceConstantPool) {
        return new HotSpotConstantPool(metaspaceConstantPool);
    }

    private HotSpotConstantPool(long metadataHandle) {
        this.metadataHandle = metadataHandle;
        this.constants = JvmConstants.instance();
        HandleCleaner.create(this, metadataHandle);
    }

    private HotSpotResolvedObjectType getHolder() {
        return CompilerToVM.compilerToVM().getResolvedJavaType(this, (long)HotSpotVMConfig.config().constantPoolHolderOffset, false);
    }

    private static int rawIndexToConstantPoolCacheIndex(int rawIndex, int opcode) {
        int index;
        if (opcode == 186) {
            index = rawIndex;
            assert (index < 0) : "not an invokedynamic constant pool index " + index;
        } else {
            assert (opcode == 180 || opcode == 181 || opcode == 178 || opcode == 179 || opcode == 185 || opcode == 182 || opcode == 183 || opcode == 184) : "unexpected invoke opcode " + opcode;
            index = rawIndex + HotSpotVMConfig.config().constantPoolCpCacheIndexTag;
        }
        return index;
    }

    private static int decodeConstantPoolCacheIndex(int index) {
        if (HotSpotConstantPool.isInvokedynamicIndex(index)) {
            return HotSpotConstantPool.decodeInvokedynamicIndex(index);
        }
        return index - HotSpotVMConfig.config().constantPoolCpCacheIndexTag;
    }

    private static boolean isInvokedynamicIndex(int index) {
        return index < 0;
    }

    private static int decodeInvokedynamicIndex(int i) {
        assert (HotSpotConstantPool.isInvokedynamicIndex(i)) : i;
        return ~i;
    }

    long getMetaspaceConstantPool() {
        return this.getMetaspacePointer();
    }

    @Override
    public long getMetadataHandle() {
        return this.metadataHandle;
    }

    private JvmConstant getTagAt(int index) {
        assert (this.checkBounds(index));
        HotSpotVMConfig config = HotSpotVMConfig.config();
        long metaspaceConstantPoolTags = UnsafeAccess.UNSAFE.getAddress(this.getMetaspaceConstantPool() + (long)config.constantPoolTagsOffset);
        byte tag = UnsafeAccess.UNSAFE.getByteVolatile(null, metaspaceConstantPoolTags + (long)config.arrayU1DataOffset + (long)index);
        if (tag == 0) {
            return null;
        }
        return this.constants.get(tag);
    }

    long getEntryAt(int index) {
        assert (this.checkBounds(index));
        int offset = index * HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().wordSize;
        return UnsafeAccess.UNSAFE.getAddress(this.getMetaspaceConstantPool() + (long)HotSpotVMConfig.config().constantPoolSize + (long)offset);
    }

    private int getIntAt(int index) {
        assert (this.checkTag(index, this.constants.jvmInteger));
        int offset = index * HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().wordSize;
        return UnsafeAccess.UNSAFE.getInt(this.getMetaspaceConstantPool() + (long)HotSpotVMConfig.config().constantPoolSize + (long)offset);
    }

    private long getLongAt(int index) {
        assert (this.checkTag(index, this.constants.jvmLong));
        int offset = index * HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().wordSize;
        return UnsafeAccess.UNSAFE.getLong(this.getMetaspaceConstantPool() + (long)HotSpotVMConfig.config().constantPoolSize + (long)offset);
    }

    private float getFloatAt(int index) {
        assert (this.checkTag(index, this.constants.jvmFloat));
        int offset = index * HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().wordSize;
        return UnsafeAccess.UNSAFE.getFloat(this.getMetaspaceConstantPool() + (long)HotSpotVMConfig.config().constantPoolSize + (long)offset);
    }

    private double getDoubleAt(int index) {
        assert (this.checkTag(index, this.constants.jvmDouble));
        int offset = index * HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().wordSize;
        return UnsafeAccess.UNSAFE.getDouble(this.getMetaspaceConstantPool() + (long)HotSpotVMConfig.config().constantPoolSize + (long)offset);
    }

    private int getNameAndTypeAt(int index) {
        assert (this.checkTag(index, this.constants.jvmNameAndType));
        int offset = index * HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().wordSize;
        return UnsafeAccess.UNSAFE.getInt(this.getMetaspaceConstantPool() + (long)HotSpotVMConfig.config().constantPoolSize + (long)offset);
    }

    private int getNameAndTypeRefIndexAt(int index) {
        return CompilerToVM.compilerToVM().lookupNameAndTypeRefIndexInPool(this, index);
    }

    private String getNameOf(int which) {
        return CompilerToVM.compilerToVM().lookupNameInPool(this, which);
    }

    private int getNameRefIndexAt(int index) {
        int refIndex = this.getNameAndTypeAt(index);
        return refIndex & 0xFFFF;
    }

    private String getSignatureOf(int which) {
        return CompilerToVM.compilerToVM().lookupSignatureInPool(this, which);
    }

    private int getSignatureRefIndexAt(int index) {
        int refIndex = this.getNameAndTypeAt(index);
        return refIndex >>> 16;
    }

    private int getKlassRefIndexAt(int index) {
        return CompilerToVM.compilerToVM().lookupKlassRefIndexInPool(this, index);
    }

    private int getUncachedKlassRefIndexAt(int index) {
        assert (this.checkTagIsFieldOrMethod(index));
        int offset = index * HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().wordSize;
        int refIndex = UnsafeAccess.UNSAFE.getInt(this.getMetaspaceConstantPool() + (long)HotSpotVMConfig.config().constantPoolSize + (long)offset);
        return refIndex & 0xFFFF;
    }

    private boolean checkBounds(int index) {
        assert (0 <= index && index < this.length()) : "index " + index + " not between 0 and " + this.length();
        return true;
    }

    private boolean checkTag(int index, JvmConstant tag) {
        JvmConstant tagAt = this.getTagAt(index);
        assert (tagAt == tag) : "constant pool tag at index " + index + " is " + tagAt + " but expected " + tag;
        return true;
    }

    private boolean checkTagIsFieldOrMethod(int index) {
        JvmConstant tagAt = this.getTagAt(index);
        assert (tagAt == this.constants.jvmFieldref || tagAt == this.constants.jvmMethodref || tagAt == this.constants.jvmInterfaceMethodref) : tagAt;
        return true;
    }

    public int length() {
        return UnsafeAccess.UNSAFE.getInt(this.getMetaspaceConstantPool() + (long)HotSpotVMConfig.config().constantPoolLengthOffset);
    }

    public Object lookupConstant(int cpi) {
        assert (cpi != 0);
        JvmConstant tag = this.getTagAt(cpi);
        switch (tag.name) {
            case "Integer": {
                return JavaConstant.forInt((int)this.getIntAt(cpi));
            }
            case "Long": {
                return JavaConstant.forLong((long)this.getLongAt(cpi));
            }
            case "Float": {
                return JavaConstant.forFloat((float)this.getFloatAt(cpi));
            }
            case "Double": {
                return JavaConstant.forDouble((double)this.getDoubleAt(cpi));
            }
            case "Class": 
            case "UnresolvedClass": 
            case "UnresolvedClassInError": {
                int opcode = -1;
                return this.lookupType(cpi, -1);
            }
            case "String": {
                return CompilerToVM.compilerToVM().resolvePossiblyCachedConstantInPool(this, cpi);
            }
            case "MethodHandle": 
            case "MethodHandleInError": 
            case "MethodType": 
            case "MethodTypeInError": {
                return CompilerToVM.compilerToVM().resolveConstantInPool(this, cpi);
            }
        }
        throw new JVMCIError("Unknown constant pool tag %s", new Object[]{tag});
    }

    public String lookupUtf8(int cpi) {
        assert (this.checkTag(cpi, this.constants.jvmUtf8));
        return CompilerToVM.compilerToVM().getSymbol(this.getEntryAt(cpi));
    }

    public Signature lookupSignature(int cpi) {
        return new HotSpotSignature(HotSpotJVMCIRuntime.runtime(), this.lookupUtf8(cpi));
    }

    public JavaConstant lookupAppendix(int cpi, int opcode) {
        assert (Bytecodes.isInvoke(opcode));
        int index = HotSpotConstantPool.rawIndexToConstantPoolCacheIndex(cpi, opcode);
        return CompilerToVM.compilerToVM().lookupAppendixInPool(this, index);
    }

    private static JavaType getJavaType(Object type) {
        if (type instanceof String) {
            String name = (String)type;
            return UnresolvedJavaType.create((String)("L" + name + ";"));
        }
        return (JavaType)type;
    }

    public JavaMethod lookupMethod(int cpi, int opcode) {
        int index = HotSpotConstantPool.rawIndexToConstantPoolCacheIndex(cpi, opcode);
        HotSpotResolvedJavaMethodImpl method = CompilerToVM.compilerToVM().lookupMethodInPool(this, index, (byte)opcode);
        if (method != null) {
            return method;
        }
        String name = this.getNameOf(index);
        HotSpotSignature signature = new HotSpotSignature(HotSpotJVMCIRuntime.runtime(), this.getSignatureOf(index));
        if (opcode == 186) {
            HotSpotResolvedObjectType holder = HotSpotJVMCIRuntime.runtime().getMethodHandleClass();
            return new UnresolvedJavaMethod(name, (Signature)signature, (JavaType)holder);
        }
        int klassIndex = this.getKlassRefIndexAt(index);
        Object type = CompilerToVM.compilerToVM().lookupKlassInPool(this, klassIndex);
        JavaType holder = HotSpotConstantPool.getJavaType(type);
        return new UnresolvedJavaMethod(name, (Signature)signature, holder);
    }

    public JavaType lookupType(int cpi, int opcode) {
        LookupTypeCacheElement elem = this.lastLookupType;
        if (elem != null && elem.lastCpi == cpi) {
            return elem.javaType;
        }
        Object type = CompilerToVM.compilerToVM().lookupKlassInPool(this, cpi);
        JavaType result = HotSpotConstantPool.getJavaType(type);
        if (result instanceof ResolvedJavaType) {
            this.lastLookupType = new LookupTypeCacheElement(cpi, result);
        }
        return result;
    }

    public JavaField lookupField(int cpi, ResolvedJavaMethod method, int opcode) {
        int index = HotSpotConstantPool.rawIndexToConstantPoolCacheIndex(cpi, opcode);
        int nameAndTypeIndex = this.getNameAndTypeRefIndexAt(index);
        int typeIndex = this.getSignatureRefIndexAt(nameAndTypeIndex);
        String typeName = this.lookupUtf8(typeIndex);
        JavaType type = HotSpotJVMCIRuntime.runtime().lookupType(typeName, this.getHolder(), false);
        int holderIndex = this.getKlassRefIndexAt(index);
        JavaType holder = this.lookupType(holderIndex, opcode);
        if (holder instanceof HotSpotResolvedObjectTypeImpl) {
            HotSpotResolvedObjectTypeImpl resolvedHolder;
            int[] info = new int[3];
            try {
                resolvedHolder = CompilerToVM.compilerToVM().resolveFieldInPool(this, index, (HotSpotResolvedJavaMethodImpl)method, (byte)opcode, info);
            }
            catch (Throwable t) {
                return new UnresolvedJavaField(holder, this.lookupUtf8(this.getNameRefIndexAt(nameAndTypeIndex)), type);
            }
            int flags = info[0];
            int offset = info[1];
            int fieldIndex = info[2];
            HotSpotResolvedJavaField result = resolvedHolder.createField(type, offset, flags, fieldIndex);
            return result;
        }
        return new UnresolvedJavaField(holder, this.lookupUtf8(this.getNameRefIndexAt(nameAndTypeIndex)), type);
    }

    public int rawIndexToConstantPoolIndex(int rawIndex, int opcode) {
        int index;
        if (HotSpotConstantPool.isInvokedynamicIndex(rawIndex)) {
            assert (opcode == 186);
            index = HotSpotConstantPool.decodeInvokedynamicIndex(rawIndex) + HotSpotVMConfig.config().constantPoolCpCacheIndexTag;
        } else {
            assert (opcode != 186);
            index = HotSpotConstantPool.rawIndexToConstantPoolCacheIndex(rawIndex, opcode);
        }
        return CompilerToVM.compilerToVM().constantPoolRemapInstructionOperandFromCache(this, index);
    }

    public void loadReferencedType(int cpi, int opcode) {
        this.loadReferencedType(cpi, opcode, true);
    }

    public void loadReferencedType(int cpi, int opcode, boolean initialize) {
        int index;
        switch (opcode) {
            case 18: 
            case 19: 
            case 20: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 197: {
                index = cpi;
                break;
            }
            case 186: {
                index = HotSpotConstantPool.decodeConstantPoolCacheIndex(cpi) + HotSpotVMConfig.config().constantPoolCpCacheIndexTag;
                index = CompilerToVM.compilerToVM().constantPoolRemapInstructionOperandFromCache(this, index);
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                index = HotSpotConstantPool.rawIndexToConstantPoolCacheIndex(cpi, opcode);
                index = CompilerToVM.compilerToVM().constantPoolRemapInstructionOperandFromCache(this, index);
                break;
            }
            default: {
                throw JVMCIError.shouldNotReachHere((String)("Unexpected opcode " + opcode));
            }
        }
        JvmConstant tag = this.getTagAt(index);
        if (tag == null) {
            assert (this.getTagAt(index - 1) == this.constants.jvmDouble || this.getTagAt(index - 1) == this.constants.jvmLong);
            return;
        }
        switch (tag.name) {
            case "Methodref": 
            case "Fieldref": 
            case "InterfaceMethodref": {
                index = this.getUncachedKlassRefIndexAt(index);
                JvmConstant klassTag = this.getTagAt(index);
                assert (klassTag == this.constants.jvmClass || klassTag == this.constants.jvmUnresolvedClass || klassTag == this.constants.jvmUnresolvedClassInError) : klassTag;
            }
            case "Class": 
            case "UnresolvedClass": 
            case "UnresolvedClassInError": {
                HotSpotResolvedObjectTypeImpl type = CompilerToVM.compilerToVM().resolveTypeInPool(this, index);
                if (initialize && !type.isPrimitive() && !type.isArray()) {
                    type.ensureInitialized();
                }
                if (tag != this.constants.jvmMethodref || !Bytecodes.isInvokeHandleAlias(opcode) || !HotSpotConstantPool.isSignaturePolymorphicHolder(type)) break;
                int methodRefCacheIndex = HotSpotConstantPool.rawIndexToConstantPoolCacheIndex(cpi, opcode);
                assert (this.checkTag(CompilerToVM.compilerToVM().constantPoolRemapInstructionOperandFromCache(this, methodRefCacheIndex), this.constants.jvmMethodref));
                CompilerToVM.compilerToVM().resolveInvokeHandleInPool(this, methodRefCacheIndex);
                break;
            }
            case "InvokeDynamic": {
                if (!HotSpotConstantPool.isInvokedynamicIndex(cpi)) break;
                CompilerToVM.compilerToVM().resolveInvokeDynamicInPool(this, cpi);
                break;
            }
        }
    }

    @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC"}, justification="signaturePolymorphicHolders is a cache, not a singleton that must be constructed exactly onceand compiler re-ordering is not an issue due to the VM call")
    static boolean isSignaturePolymorphicHolder(ResolvedJavaType type) {
        String name = type.getName();
        if (signaturePolymorphicHolders == null) {
            signaturePolymorphicHolders = CompilerToVM.compilerToVM().getSignaturePolymorphicHolders();
        }
        for (String holder : signaturePolymorphicHolders) {
            if (!name.equals(holder)) continue;
            return true;
        }
        return false;
    }

    public boolean isResolvedDynamicInvoke(int cpi, int opcode) {
        if (Bytecodes.isInvokeHandleAlias(opcode)) {
            int methodRefCacheIndex = HotSpotConstantPool.rawIndexToConstantPoolCacheIndex(cpi, opcode);
            assert (this.checkTag(CompilerToVM.compilerToVM().constantPoolRemapInstructionOperandFromCache(this, methodRefCacheIndex), this.constants.jvmMethodref));
            int op = CompilerToVM.compilerToVM().isResolvedInvokeHandleInPool(this, methodRefCacheIndex);
            return op == opcode;
        }
        return false;
    }

    public String toString() {
        HotSpotResolvedObjectType holder = this.getHolder();
        return "HotSpotConstantPool<" + holder.toJavaName() + ">";
    }

    private static class LookupTypeCacheElement {
        int lastCpi = Integer.MIN_VALUE;
        JavaType javaType;

        LookupTypeCacheElement(int lastCpi, JavaType javaType) {
            this.lastCpi = lastCpi;
            this.javaType = javaType;
        }
    }

    static final class JvmConstants {
        private final HotSpotVMConfig c = HotSpotVMConfig.config();
        private final int externalMax;
        private final int internalMax;
        private final int internalMin;
        private final JvmConstant[] table;
        final JvmConstant jvmUtf8;
        final JvmConstant jvmInteger;
        final JvmConstant jvmLong;
        final JvmConstant jvmFloat;
        final JvmConstant jvmDouble;
        final JvmConstant jvmClass;
        final JvmConstant jvmUnresolvedClass;
        final JvmConstant jvmUnresolvedClassInError;
        final JvmConstant jvmString;
        final JvmConstant jvmFieldref;
        final JvmConstant jvmMethodref;
        final JvmConstant jvmInterfaceMethodref;
        final JvmConstant jvmNameAndType;
        final JvmConstant jvmMethodHandle;
        final JvmConstant jvmMethodHandleInError;
        final JvmConstant jvmMethodType;
        final JvmConstant jvmMethodTypeInError;
        final JvmConstant jvmInvokeDynamic;
        @NativeImageReinitialize
        private static volatile JvmConstants instance;

        JvmConstants() {
            this.externalMax = this.c.jvmConstantExternalMax;
            this.internalMax = this.c.jvmConstantInternalMax;
            this.internalMin = this.c.jvmConstantInternalMin;
            this.table = new JvmConstant[this.externalMax + 1 + (this.internalMax - this.internalMin) + 1];
            this.jvmUtf8 = this.add(new JvmConstant(this.c.jvmConstantUtf8, "Utf8"));
            this.jvmInteger = this.add(new JvmConstant(this.c.jvmConstantInteger, "Integer"));
            this.jvmLong = this.add(new JvmConstant(this.c.jvmConstantLong, "Long"));
            this.jvmFloat = this.add(new JvmConstant(this.c.jvmConstantFloat, "Float"));
            this.jvmDouble = this.add(new JvmConstant(this.c.jvmConstantDouble, "Double"));
            this.jvmClass = this.add(new JvmConstant(this.c.jvmConstantClass, "Class"));
            this.jvmUnresolvedClass = this.add(new JvmConstant(this.c.jvmConstantUnresolvedClass, "UnresolvedClass"));
            this.jvmUnresolvedClassInError = this.add(new JvmConstant(this.c.jvmConstantUnresolvedClassInError, "UnresolvedClassInError"));
            this.jvmString = this.add(new JvmConstant(this.c.jvmConstantString, "String"));
            this.jvmFieldref = this.add(new JvmConstant(this.c.jvmConstantFieldref, "Fieldref"));
            this.jvmMethodref = this.add(new JvmConstant(this.c.jvmConstantMethodref, "Methodref"));
            this.jvmInterfaceMethodref = this.add(new JvmConstant(this.c.jvmConstantInterfaceMethodref, "InterfaceMethodref"));
            this.jvmNameAndType = this.add(new JvmConstant(this.c.jvmConstantNameAndType, "NameAndType"));
            this.jvmMethodHandle = this.add(new JvmConstant(this.c.jvmConstantMethodHandle, "MethodHandle"));
            this.jvmMethodHandleInError = this.add(new JvmConstant(this.c.jvmConstantMethodHandleInError, "MethodHandleInError"));
            this.jvmMethodType = this.add(new JvmConstant(this.c.jvmConstantMethodType, "MethodType"));
            this.jvmMethodTypeInError = this.add(new JvmConstant(this.c.jvmConstantMethodTypeInError, "MethodTypeInError"));
            this.jvmInvokeDynamic = this.add(new JvmConstant(this.c.jvmConstantInvokeDynamic, "InvokeDynamic"));
        }

        private JvmConstant add(JvmConstant constant) {
            this.table[this.indexOf((int)((JvmConstant)constant).tag)] = constant;
            return constant;
        }

        private int indexOf(int tag) {
            if (tag >= this.internalMin) {
                return tag - this.internalMin + this.externalMax + 1;
            }
            assert (tag <= this.externalMax);
            return tag;
        }

        JvmConstant get(int tag) {
            JvmConstant res = this.table[this.indexOf(tag)];
            if (res != null) {
                return res;
            }
            throw new JVMCIError("Unknown JvmConstant tag %s", new Object[]{tag});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static JvmConstants instance() {
            JvmConstants result = instance;
            if (result != null) return result;
            Class<JvmConstants> clazz = JvmConstants.class;
            synchronized (JvmConstants.class) {
                result = instance;
                if (result != null) return result;
                instance = result = new JvmConstants();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }
    }

    static final class JvmConstant {
        private final int tag;
        private final String name;

        JvmConstant(int tag, String name) {
            this.tag = tag;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Bytecodes {
        public static final int LDC = 18;
        public static final int LDC_W = 19;
        public static final int LDC2_W = 20;
        public static final int GETSTATIC = 178;
        public static final int PUTSTATIC = 179;
        public static final int GETFIELD = 180;
        public static final int PUTFIELD = 181;
        public static final int INVOKEVIRTUAL = 182;
        public static final int INVOKESPECIAL = 183;
        public static final int INVOKESTATIC = 184;
        public static final int INVOKEINTERFACE = 185;
        public static final int INVOKEDYNAMIC = 186;
        public static final int NEW = 187;
        public static final int NEWARRAY = 188;
        public static final int ANEWARRAY = 189;
        public static final int CHECKCAST = 192;
        public static final int INSTANCEOF = 193;
        public static final int MULTIANEWARRAY = 197;

        static boolean isInvoke(int opcode) {
            switch (opcode) {
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: {
                    return true;
                }
            }
            return false;
        }

        static boolean isInvokeHandleAlias(int opcode) {
            switch (opcode) {
                case 182: 
                case 183: {
                    return true;
                }
            }
            return false;
        }
    }
}

