/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.hotspot;

import jdk.vm.ci.hotspot.Cleaner;
import jdk.vm.ci.hotspot.CompilerToVM;
import jdk.vm.ci.hotspot.IndirectHotSpotObjectConstantImpl;
import jdk.vm.ci.hotspot.MetaspaceHandleObject;
import jdk.vm.ci.hotspot.UnsafeAccess;

final class HandleCleaner
extends Cleaner {
    private final long handle;
    private final boolean isJObject;

    private HandleCleaner(Object wrapper, long handle, boolean isJObject) {
        super(wrapper);
        this.handle = handle;
        this.isJObject = isJObject;
    }

    @Override
    void doCleanup() {
        if (this.isJObject) {
            CompilerToVM.compilerToVM().deleteGlobalHandle(this.handle);
        } else {
            long value = UnsafeAccess.UNSAFE.getLong(null, this.handle);
            UnsafeAccess.UNSAFE.compareAndSwapLong(null, this.handle, value, 0L);
        }
    }

    static void create(Object wrapper, long handle) {
        assert (wrapper instanceof IndirectHotSpotObjectConstantImpl || wrapper instanceof MetaspaceHandleObject);
        new HandleCleaner(wrapper, handle, wrapper instanceof IndirectHotSpotObjectConstantImpl);
    }
}

