/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.pointer.CommonPointerLibraries;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;

@ExportLibrary.Repeat(value={@ExportLibrary(value=LLVMNativeLibrary.class, receiverType=LLVMPointerImpl.class), @ExportLibrary(value=InteropLibrary.class, receiverType=LLVMPointerImpl.class)})
abstract class ManagedPointerLibraries
extends CommonPointerLibraries {
    ManagedPointerLibraries() {
    }

    @ExportMessage
    static boolean isNull(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") InteropLibrary interop) {
        if (receiver.getOffset() == 0L) {
            return interop.isNull(receiver.object);
        }
        return false;
    }

    @ExportMessage
    static boolean isExecutable(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") InteropLibrary interop) {
        if (receiver.getOffset() == 0L) {
            return interop.isExecutable(receiver.object);
        }
        return false;
    }

    @ExportMessage
    static Object execute(LLVMPointerImpl receiver, Object[] args, @CachedLibrary(value="receiver.object") InteropLibrary interop) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        if (receiver.getOffset() == 0L) {
            return interop.execute(receiver.object, args);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage.Repeat(value={@ExportMessage(library=LLVMNativeLibrary.class), @ExportMessage(library=InteropLibrary.class)})
    static boolean isPointer(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") LLVMNativeLibrary natives) {
        return natives.isPointer(receiver.object);
    }

    @ExportMessage.Repeat(value={@ExportMessage(library=LLVMNativeLibrary.class), @ExportMessage(library=InteropLibrary.class)})
    static long asPointer(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") LLVMNativeLibrary natives) throws UnsupportedMessageException {
        return natives.asPointer(receiver.object) + receiver.getOffset();
    }

    @ExportMessage
    static void toNative(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") InteropLibrary interop) {
        interop.toNative(receiver.object);
    }

    @ExportMessage
    static LLVMNativePointer toNativePointer(LLVMPointerImpl receiver, @CachedLibrary(value="receiver.object") LLVMNativeLibrary natives) {
        return natives.toNativePointer(receiver.object).increment(receiver.getOffset());
    }
}

