/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.options;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionStability;

@GeneratedBy(value=SulongEngineOption.class)
final class SulongEngineOptionOptionDescriptors
implements OptionDescriptors {
    SulongEngineOptionOptionDescriptors() {
    }

    public OptionDescriptor get(String optionName) {
        switch (optionName) {
            case "llvm.debugLoader": {
                return OptionDescriptor.newBuilder(SulongEngineOption.LD_DEBUG, (String)"llvm.debugLoader").deprecated(false).help("Turns dynamic loader debugging on/off. Can be 'stdout' or 'stderr'.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "llvm.debugSysCalls": {
                return OptionDescriptor.newBuilder(SulongEngineOption.DEBUG_SYSCALLS, (String)"llvm.debugSysCalls").deprecated(false).help("Turns syscall debugging on/off. Can be 'stdout' or 'stderr'.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "llvm.enableExternalNativeAccess": {
                return OptionDescriptor.newBuilder(SulongEngineOption.ENABLE_NFI, (String)"llvm.enableExternalNativeAccess").deprecated(false).help("Enable Sulongs native interface.").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "llvm.enableLVI": {
                return OptionDescriptor.newBuilder(SulongEngineOption.ENABLE_LVI, (String)"llvm.enableLVI").deprecated(false).help("Enable source-level inspection of local variables.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "llvm.lazyParsing": {
                return OptionDescriptor.newBuilder(SulongEngineOption.LAZY_PARSING, (String)"llvm.lazyParsing").deprecated(false).help("Enable lazy parsing of LLVM bitcode files.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "llvm.libraries": {
                return OptionDescriptor.newBuilder(SulongEngineOption.LIBRARIES, (String)"llvm.libraries").deprecated(false).help("List of libraries (precompiled libraries *.dylib/*.so as well as bitcode libraries *.bc). Files with a relative path will be looked up relative to llvm.libraryPath. Libraries are delimited by : .").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "llvm.libraryPath": {
                return OptionDescriptor.newBuilder(SulongEngineOption.LIBRARY_PATH, (String)"llvm.libraryPath").deprecated(false).help("A list of paths where Sulong will search for relative libraries. Paths are delimited by : .").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "llvm.llDebug": {
                return OptionDescriptor.newBuilder(SulongEngineOption.LL_DEBUG, (String)"llvm.llDebug").deprecated(false).help("Enable IR-level debugging of LLVM bitcode files.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "llvm.llDebug.sources": {
                return OptionDescriptor.newBuilder(SulongEngineOption.LL_DEBUG_SOURCES, (String)"llvm.llDebug.sources").deprecated(false).help("Provide the locations of *.ll files for debugging. The expected format is <bc-path>=<ll-path>{:<bc-path>=<ll-path>}.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "llvm.loadC++Libraries": {
                return OptionDescriptor.newBuilder(SulongEngineOption.LOAD_CXX_LIBRARIES, (String)"llvm.loadC++Libraries").deprecated(false).help("Specifies whether the standard C++ libraries (libc++ and libc++abi) should be loaded. Enabled by default.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "llvm.parseOnly": {
                return OptionDescriptor.newBuilder(SulongEngineOption.PARSE_ONLY, (String)"llvm.parseOnly").deprecated(false).help("Only parses a bc file; execution is not possible.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "llvm.printLifetimeAnalysisStats": {
                return OptionDescriptor.newBuilder(SulongEngineOption.PRINT_LIFE_TIME_ANALYSIS_STATS, (String)"llvm.printLifetimeAnalysisStats").deprecated(false).help("Prints the results of the lifetime analysis. Can be 'stdout' or 'stderr'.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "llvm.printNativeCallStats": {
                return OptionDescriptor.newBuilder(SulongEngineOption.NATIVE_CALL_STATS, (String)"llvm.printNativeCallStats").deprecated(false).help("Outputs stats about native call site frequencies. Can be 'stdout' or 'stderr'.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "llvm.printStackTraceOnAbort": {
                return OptionDescriptor.newBuilder(SulongEngineOption.STACKTRACE_ON_ABORT, (String)"llvm.printStackTraceOnAbort").deprecated(false).help("Prints a C stack trace when abort() is called.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "llvm.printToolchainPath": {
                return OptionDescriptor.newBuilder(SulongEngineOption.PRINT_TOOLCHAIN_PATH, (String)"llvm.printToolchainPath").deprecated(false).help("Enables the intrinisc for printing the toolchain path.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "llvm.sourcePath": {
                return OptionDescriptor.newBuilder(SulongEngineOption.SOURCE_PATH, (String)"llvm.sourcePath").deprecated(true).help("This option is deprecated. Use --inspect.SourcePath instead.").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            }
            case "llvm.stackSize": {
                return OptionDescriptor.newBuilder(SulongEngineOption.STACK_SIZE, (String)"llvm.stackSize").deprecated(false).help("The stack size, please end the input with one of: k, m, g, or t. (Note: the stack size will be in bytes if no appropriate suffix is give.)").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            }
            case "llvm.traceIR": {
                return OptionDescriptor.newBuilder(SulongEngineOption.TRACE_IR, (String)"llvm.traceIR").deprecated(false).help("Prints a trace of the executed bitcode. Requires '--llvm.llDebug=true'. Set value to 'stdout', 'stderr' or 'file://<path to writable file>' to enable.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return Arrays.asList(OptionDescriptor.newBuilder(SulongEngineOption.LD_DEBUG, (String)"llvm.debugLoader").deprecated(false).help("Turns dynamic loader debugging on/off. Can be 'stdout' or 'stderr'.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SulongEngineOption.DEBUG_SYSCALLS, (String)"llvm.debugSysCalls").deprecated(false).help("Turns syscall debugging on/off. Can be 'stdout' or 'stderr'.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SulongEngineOption.ENABLE_NFI, (String)"llvm.enableExternalNativeAccess").deprecated(false).help("Enable Sulongs native interface.").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SulongEngineOption.ENABLE_LVI, (String)"llvm.enableLVI").deprecated(false).help("Enable source-level inspection of local variables.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SulongEngineOption.LAZY_PARSING, (String)"llvm.lazyParsing").deprecated(false).help("Enable lazy parsing of LLVM bitcode files.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SulongEngineOption.LIBRARIES, (String)"llvm.libraries").deprecated(false).help("List of libraries (precompiled libraries *.dylib/*.so as well as bitcode libraries *.bc). Files with a relative path will be looked up relative to llvm.libraryPath. Libraries are delimited by : .").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(SulongEngineOption.LIBRARY_PATH, (String)"llvm.libraryPath").deprecated(false).help("A list of paths where Sulong will search for relative libraries. Paths are delimited by : .").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(SulongEngineOption.LL_DEBUG, (String)"llvm.llDebug").deprecated(false).help("Enable IR-level debugging of LLVM bitcode files.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SulongEngineOption.LL_DEBUG_SOURCES, (String)"llvm.llDebug.sources").deprecated(false).help("Provide the locations of *.ll files for debugging. The expected format is <bc-path>=<ll-path>{:<bc-path>=<ll-path>}.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SulongEngineOption.LOAD_CXX_LIBRARIES, (String)"llvm.loadC++Libraries").deprecated(false).help("Specifies whether the standard C++ libraries (libc++ and libc++abi) should be loaded. Enabled by default.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SulongEngineOption.PARSE_ONLY, (String)"llvm.parseOnly").deprecated(false).help("Only parses a bc file; execution is not possible.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SulongEngineOption.PRINT_LIFE_TIME_ANALYSIS_STATS, (String)"llvm.printLifetimeAnalysisStats").deprecated(false).help("Prints the results of the lifetime analysis. Can be 'stdout' or 'stderr'.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SulongEngineOption.NATIVE_CALL_STATS, (String)"llvm.printNativeCallStats").deprecated(false).help("Outputs stats about native call site frequencies. Can be 'stdout' or 'stderr'.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SulongEngineOption.STACKTRACE_ON_ABORT, (String)"llvm.printStackTraceOnAbort").deprecated(false).help("Prints a C stack trace when abort() is called.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SulongEngineOption.PRINT_TOOLCHAIN_PATH, (String)"llvm.printToolchainPath").deprecated(false).help("Enables the intrinisc for printing the toolchain path.").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SulongEngineOption.SOURCE_PATH, (String)"llvm.sourcePath").deprecated(true).help("This option is deprecated. Use --inspect.SourcePath instead.").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(), OptionDescriptor.newBuilder(SulongEngineOption.STACK_SIZE, (String)"llvm.stackSize").deprecated(false).help("The stack size, please end the input with one of: k, m, g, or t. (Note: the stack size will be in bytes if no appropriate suffix is give.)").category(OptionCategory.USER).stability(OptionStability.STABLE).build(), OptionDescriptor.newBuilder(SulongEngineOption.TRACE_IR, (String)"llvm.traceIR").deprecated(false).help("Prints a trace of the executed bitcode. Requires '--llvm.llDebug=true'. Set value to 'stdout', 'stderr' or 'file://<path to writable file>' to enable.").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build()).iterator();
    }
}

