/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vars;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class StructLiteralNode
extends LLVMExpressionNode {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] offsets;
    @Node.Children
    private final LLVMStoreNode[] elementWriteNodes;
    @Node.Children
    private final LLVMExpressionNode[] values;

    public StructLiteralNode(int[] offsets, LLVMStoreNode[] elementWriteNodes, LLVMExpressionNode[] values) {
        assert (offsets.length == elementWriteNodes.length && elementWriteNodes.length == values.length);
        this.offsets = offsets;
        this.elementWriteNodes = elementWriteNodes;
        this.values = values;
    }

    @ExplodeLoop
    @Specialization
    protected LLVMPointer doLLVMPointer(VirtualFrame frame, LLVMPointer address) {
        for (int i = 0; i < this.offsets.length; ++i) {
            LLVMPointer currentAddr = address.increment(this.offsets[i]);
            Object value = this.values[i] == null ? null : this.values[i].executeGeneric(frame);
            this.elementWriteNodes[i].executeWithTarget(currentAddr, value);
        }
        return address;
    }
}

