/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@NodeChildren(value={@NodeChild(value="conditionNode", type=LLVMExpressionNode.class), @NodeChild(value="trueNode", type=LLVMExpressionNode.class), @NodeChild(value="elseNode", type=LLVMExpressionNode.class)})
@NodeField(name="vectorLength", type=int.class)
public abstract class LLVMVectorSelectNode
extends LLVMExpressionNode {
    protected final ConditionProfile conditionProfile = ConditionProfile.createCountingProfile();

    protected abstract int getVectorLength();

    public static abstract class LLVMDoubleVectorSelectNode
    extends LLVMVectorSelectNode {
        @ExplodeLoop
        @Specialization
        protected LLVMDoubleVector doOp(LLVMI1Vector condition, LLVMDoubleVector trueValue, LLVMDoubleVector elseValue) {
            assert (condition.getLength() == this.getVectorLength());
            double[] values = new double[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                values[i] = this.conditionProfile.profile(condition.getValue(i)) ? trueValue.getValue(i) : elseValue.getValue(i);
            }
            return LLVMDoubleVector.create(values);
        }
    }

    public static abstract class LLVMFloatVectorSelectNode
    extends LLVMVectorSelectNode {
        @ExplodeLoop
        @Specialization
        protected LLVMFloatVector doOp(LLVMI1Vector condition, LLVMFloatVector trueValue, LLVMFloatVector elseValue) {
            assert (condition.getLength() == this.getVectorLength());
            float[] values = new float[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                values[i] = this.conditionProfile.profile(condition.getValue(i)) ? trueValue.getValue(i) : elseValue.getValue(i);
            }
            return LLVMFloatVector.create(values);
        }
    }

    public static abstract class LLVMI64VectorSelectNode
    extends LLVMVectorSelectNode {
        @ExplodeLoop
        @Specialization
        protected LLVMI64Vector doOp(LLVMI1Vector condition, LLVMI64Vector trueValue, LLVMI64Vector elseValue) {
            assert (condition.getLength() == this.getVectorLength());
            long[] values = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                values[i] = this.conditionProfile.profile(condition.getValue(i)) ? trueValue.getValue(i) : elseValue.getValue(i);
            }
            return LLVMI64Vector.create(values);
        }

        @ExplodeLoop
        @Specialization
        protected LLVMPointerVector doOp(LLVMI1Vector condition, LLVMI64Vector trueValue, LLVMPointerVector elseValue) {
            assert (condition.getLength() == this.getVectorLength());
            LLVMPointer[] values = new LLVMPointer[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                values[i] = this.conditionProfile.profile(condition.getValue(i)) ? LLVMNativePointer.create(trueValue.getValue(i)) : elseValue.getValue(i);
            }
            return LLVMPointerVector.create(values);
        }

        @ExplodeLoop
        @Specialization
        protected LLVMPointerVector doOp(LLVMI1Vector condition, LLVMPointerVector trueValue, LLVMI64Vector elseValue) {
            assert (condition.getLength() == this.getVectorLength());
            LLVMPointer[] values = new LLVMPointer[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                values[i] = this.conditionProfile.profile(condition.getValue(i)) ? trueValue.getValue(i) : LLVMNativePointer.create(elseValue.getValue(i));
            }
            return LLVMPointerVector.create(values);
        }

        @ExplodeLoop
        @Specialization
        protected LLVMPointerVector doOp(LLVMI1Vector condition, LLVMPointerVector trueValue, LLVMPointerVector elseValue) {
            assert (condition.getLength() == this.getVectorLength());
            LLVMPointer[] values = new LLVMPointer[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                values[i] = this.conditionProfile.profile(condition.getValue(i)) ? trueValue.getValue(i) : elseValue.getValue(i);
            }
            return LLVMPointerVector.create(values);
        }
    }

    public static abstract class LLVMI32VectorSelectNode
    extends LLVMVectorSelectNode {
        @ExplodeLoop
        @Specialization
        protected LLVMI32Vector doOp(LLVMI1Vector condition, LLVMI32Vector trueValue, LLVMI32Vector elseValue) {
            assert (condition.getLength() == this.getVectorLength());
            int[] values = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                values[i] = this.conditionProfile.profile(condition.getValue(i)) ? trueValue.getValue(i) : elseValue.getValue(i);
            }
            return LLVMI32Vector.create(values);
        }
    }

    public static abstract class LLVMI16VectorSelectNode
    extends LLVMVectorSelectNode {
        @ExplodeLoop
        @Specialization
        protected LLVMI16Vector doOp(LLVMI1Vector condition, LLVMI16Vector trueValue, LLVMI16Vector elseValue) {
            assert (condition.getLength() == this.getVectorLength());
            short[] values = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                values[i] = this.conditionProfile.profile(condition.getValue(i)) ? trueValue.getValue(i) : elseValue.getValue(i);
            }
            return LLVMI16Vector.create(values);
        }
    }

    public static abstract class LLVMI8VectorSelectNode
    extends LLVMVectorSelectNode {
        @ExplodeLoop
        @Specialization
        protected LLVMI8Vector doOp(LLVMI1Vector condition, LLVMI8Vector trueValue, LLVMI8Vector elseValue) {
            assert (condition.getLength() == this.getVectorLength());
            byte[] values = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                values[i] = this.conditionProfile.profile(condition.getValue(i)) ? trueValue.getValue(i) : elseValue.getValue(i);
            }
            return LLVMI8Vector.create(values);
        }
    }

    public static abstract class LLVMI1VectorSelectNode
    extends LLVMVectorSelectNode {
        @ExplodeLoop
        @Specialization
        protected LLVMI1Vector doOp(LLVMI1Vector condition, LLVMI1Vector trueValue, LLVMI1Vector elseValue) {
            assert (condition.getLength() == this.getVectorLength());
            boolean[] values = new boolean[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                values[i] = this.conditionProfile.profile(condition.getValue(i)) ? trueValue.getValue(i) : elseValue.getValue(i);
            }
            return LLVMI1Vector.create(values);
        }
    }
}

