/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMUnsupportedException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;

public final class LLVMUnsupportedInstructionNode
extends LLVMStatementNode {
    private final String message;
    private final LLVMUnsupportedException.UnsupportedReason reason;

    public static LLVMUnsupportedInstructionNode create(LLVMUnsupportedException.UnsupportedReason reason) {
        return new LLVMUnsupportedInstructionNode(reason, null);
    }

    public static LLVMUnsupportedInstructionNode create(LLVMUnsupportedException.UnsupportedReason reason, String message) {
        return new LLVMUnsupportedInstructionNode(reason, message);
    }

    public static LLVMUnsupportedExpressionNode createExpression(LLVMUnsupportedException.UnsupportedReason reason) {
        return new LLVMUnsupportedExpressionNode(LLVMUnsupportedInstructionNode.create(reason));
    }

    public static LLVMUnsupportedExpressionNode createExpression(LLVMUnsupportedException.UnsupportedReason reason, String message) {
        return new LLVMUnsupportedExpressionNode(LLVMUnsupportedInstructionNode.create(reason, message));
    }

    private LLVMUnsupportedInstructionNode(LLVMUnsupportedException.UnsupportedReason reason, String message) {
        this.message = message;
        this.reason = reason;
    }

    @Override
    public void execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        if (this.message == null) {
            throw new LLVMUnsupportedException((Node)this, this.reason);
        }
        throw new LLVMUnsupportedException((Node)this, this.reason, "Unsupported operation: " + this.message);
    }

    public static final class LLVMUnsupportedExpressionNode
    extends LLVMExpressionNode {
        @Node.Child
        private LLVMUnsupportedInstructionNode instruction;

        private LLVMUnsupportedExpressionNode(LLVMUnsupportedInstructionNode instruction) {
            this.instruction = instruction;
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            this.instruction.execute(frame);
            return null;
        }
    }
}

