/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMPointerStoreNode.class)
public final class LLVMPointerStoreNodeGen
extends LLVMPointerStoreNode {
    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);
    @Node.Child
    private LLVMExpressionNode address_;
    @Node.Child
    private LLVMExpressionNode value_;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private LLVMToNativeNode address0_toNative_;
    @Node.Child
    private LLVMToPointerNode derefAddress_toPointer_;
    @Node.Child
    private LLVMManagedWriteLibrary derefAddress_nativeWrite_;
    @Node.Child
    private LLVMToNativeNode address1_toNative_;
    @Node.Child
    private LLVMToPointerNode opDerefHandle_toPointer_;
    @Node.Child
    private LLVMManagedWriteLibrary opDerefHandle_nativeWrite_;
    @Node.Child
    private TruffleObject0Data truffleObject0_cache;
    @Node.Child
    private LLVMToPointerNode truffleObject1_toPointer_;

    private LLVMPointerStoreNodeGen(LLVMExpressionNode address, LLVMExpressionNode value) {
        this.address_ = address;
        this.value_ = value;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public void executeWithTarget(Object addressValue, Object valueValue) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 3) != 0 && addressValue instanceof Long) {
                long addressValue_ = (Long)addressValue;
                if ((state & 1) != 0 && !this.isAutoDerefHandle(addressValue_)) {
                    this.doAddress(addressValue_, valueValue, this.address0_toNative_);
                    return;
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle(addressValue_)) {
                    this.doDerefAddress(addressValue_, valueValue, this.derefAddress_toPointer_, this.derefAddress_nativeWrite_);
                    return;
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state & 4) != 0 && !this.isAutoDerefHandle(addressValue_)) {
                    this.doAddress(addressValue_, valueValue, this.address1_toNative_);
                    return;
                }
                if ((state & 8) != 0 && this.isAutoDerefHandle(addressValue_)) {
                    this.doOpDerefHandle(addressValue_, valueValue, this.opDerefHandle_toPointer_, this.opDerefHandle_nativeWrite_);
                    return;
                }
            }
            if ((state & 0x30) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state & 0x10) != 0) {
                    TruffleObject0Data s5_ = this.truffleObject0_cache;
                    while (s5_ != null) {
                        if (s5_.nativeWrite_.accepts(addressValue_.getObject())) {
                            this.doTruffleObject(addressValue_, valueValue, s5_.toPointer_, s5_.nativeWrite_);
                            return;
                        }
                        s5_ = s5_.next_;
                    }
                }
                if ((state & 0x20) != 0) {
                    this.truffleObject1Boundary(state, addressValue_, valueValue);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue, valueValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void truffleObject1Boundary(int state, LLVMManagedPointer addressValue_, Object valueValue) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            this.doTruffleObject(addressValue_, valueValue, this.truffleObject1_toPointer_, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
            return;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x3C) == 0 && state != 0) {
            this.execute_long0(frameValue, state);
            return;
        }
        this.execute_generic1(frameValue, state);
    }

    private void execute_long0(VirtualFrame frameValue, int state) {
        long addressValue_;
        try {
            addressValue_ = this.address_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object valueValue = this.value_.executeGeneric(frameValue);
            this.executeAndSpecialize(ex.getResult(), valueValue);
            return;
        }
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if ((state & 3) != 0) {
            if ((state & 1) != 0 && !this.isAutoDerefHandle(addressValue_)) {
                this.doAddress(addressValue_, valueValue_, this.address0_toNative_);
                return;
            }
            if ((state & 2) != 0 && this.isAutoDerefHandle(addressValue_)) {
                this.doDerefAddress(addressValue_, valueValue_, this.derefAddress_toPointer_, this.derefAddress_nativeWrite_);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue_, valueValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void truffleObject1Boundary0(int state, LLVMManagedPointer addressValue__, Object valueValue_) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            this.doTruffleObject(addressValue__, valueValue_, this.truffleObject1_toPointer_, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
            return;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    private void execute_generic1(VirtualFrame frameValue, int state) {
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if (state != 0) {
            if ((state & 3) != 0 && addressValue_ instanceof Long) {
                long addressValue__ = (Long)addressValue_;
                if ((state & 1) != 0 && !this.isAutoDerefHandle(addressValue__)) {
                    this.doAddress(addressValue__, valueValue_, this.address0_toNative_);
                    return;
                }
                if ((state & 2) != 0 && this.isAutoDerefHandle(addressValue__)) {
                    this.doDerefAddress(addressValue__, valueValue_, this.derefAddress_toPointer_, this.derefAddress_nativeWrite_);
                    return;
                }
            }
            if ((state & 0xC) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state & 4) != 0 && !this.isAutoDerefHandle(addressValue__)) {
                    this.doAddress(addressValue__, valueValue_, this.address1_toNative_);
                    return;
                }
                if ((state & 8) != 0 && this.isAutoDerefHandle(addressValue__)) {
                    this.doOpDerefHandle(addressValue__, valueValue_, this.opDerefHandle_toPointer_, this.opDerefHandle_nativeWrite_);
                    return;
                }
            }
            if ((state & 0x30) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state & 0x10) != 0) {
                    TruffleObject0Data s5_ = this.truffleObject0_cache;
                    while (s5_ != null) {
                        if (s5_.nativeWrite_.accepts(addressValue__.getObject())) {
                            this.doTruffleObject(addressValue__, valueValue_, s5_.toPointer_, s5_.nativeWrite_);
                            return;
                        }
                        s5_ = s5_.next_;
                    }
                }
                if ((state & 0x20) != 0) {
                    this.truffleObject1Boundary0(state, addressValue__, valueValue_);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue_, valueValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndSpecialize(Object addressValue, Object valueValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (addressValue instanceof Long) {
                long addressValue_ = (Long)addressValue;
                if (!this.isAutoDerefHandle(addressValue_)) {
                    this.address0_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    this.doAddress(addressValue_, valueValue, this.address0_toNative_);
                    return;
                }
                if (this.isAutoDerefHandle(addressValue_)) {
                    this.derefAddress_toPointer_ = (LLVMToPointerNode)super.insert((Node)LLVMToPointerNodeGen.create());
                    this.derefAddress_nativeWrite_ = (LLVMManagedWriteLibrary)super.insert((Node)L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3));
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    this.doDerefAddress(addressValue_, valueValue, this.derefAddress_toPointer_, this.derefAddress_nativeWrite_);
                    return;
                }
            }
            if (LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if (!this.isAutoDerefHandle(addressValue_)) {
                    this.address1_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    this.doAddress(addressValue_, valueValue, this.address1_toNative_);
                    return;
                }
                if (this.isAutoDerefHandle(addressValue_)) {
                    this.opDerefHandle_toPointer_ = (LLVMToPointerNode)super.insert((Node)LLVMToPointerNodeGen.create());
                    this.opDerefHandle_nativeWrite_ = (LLVMManagedWriteLibrary)super.insert((Node)L_L_V_M_MANAGED_WRITE_LIBRARY_.createDispatched(3));
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    this.doOpDerefHandle(addressValue_, valueValue, this.opDerefHandle_toPointer_, this.opDerefHandle_nativeWrite_);
                    return;
                }
            }
            if (LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if (exclude == 0) {
                    int count5_ = 0;
                    TruffleObject0Data s5_ = this.truffleObject0_cache;
                    if ((state & 0x10) != 0) {
                        while (s5_ != null && !s5_.nativeWrite_.accepts(addressValue_.getObject())) {
                            s5_ = s5_.next_;
                            ++count5_;
                        }
                    }
                    if (s5_ == null && count5_ < 3) {
                        s5_ = (TruffleObject0Data)super.insert((Node)new TruffleObject0Data(this.truffleObject0_cache));
                        s5_.toPointer_ = s5_.insertAccessor(LLVMToPointerNodeGen.create());
                        s5_.nativeWrite_ = (LLVMManagedWriteLibrary)s5_.insertAccessor(L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject()));
                        this.truffleObject0_cache = s5_;
                        this.state_ = state |= 0x10;
                    }
                    if (s5_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.doTruffleObject(addressValue_, valueValue, s5_.toPointer_, s5_.nativeWrite_);
                        return;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    this.truffleObject1_toPointer_ = (LLVMToPointerNode)super.insert((Node)LLVMToPointerNodeGen.create());
                    this.exclude_ = exclude |= 1;
                    this.truffleObject0_cache = null;
                    state &= 0xFFFFFFEF;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    this.doTruffleObject(addressValue_, valueValue, this.truffleObject1_toPointer_, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                    return;
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_, this.value_}, new Object[]{addressValue, valueValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        TruffleObject0Data s5_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s5_ = this.truffleObject0_cache) == null || s5_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMPointerStoreNode create(LLVMExpressionNode address, LLVMExpressionNode value) {
        return new LLVMPointerStoreNodeGen(address, value);
    }

    @GeneratedBy(value=LLVMPointerStoreNode.class)
    private static final class TruffleObject0Data
    extends Node {
        @Node.Child
        TruffleObject0Data next_;
        @Node.Child
        LLVMToPointerNode toPointer_;
        @Node.Child
        LLVMManagedWriteLibrary nativeWrite_;

        TruffleObject0Data(TruffleObject0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

