/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStoreNodeCommon;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMPointerStoreNode
extends LLVMStoreNodeCommon {
    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected void doAddress(long addr, Object value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative) {
        this.getLLVMMemoryCached().putPointer(addr, toNative.executeWithTarget(value));
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected void doDerefAddress(long addr, Object value, @Cached LLVMToPointerNode toPointer, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        this.doTruffleObject(this.getDerefHandleGetReceiverNode().execute(addr), value, toPointer, nativeWrite);
    }

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected void doAddress(LLVMNativePointer addr, Object value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative) {
        this.getLLVMMemoryCached().putPointer(addr, toNative.executeWithTarget(value));
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected void doOpDerefHandle(LLVMNativePointer addr, Object value, @Cached LLVMToPointerNode toPointer, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        this.doTruffleObject(this.getDerefHandleGetReceiverNode().execute(addr), value, toPointer, nativeWrite);
    }

    @Specialization(limit="3")
    protected void doTruffleObject(LLVMManagedPointer address, Object value, @Cached LLVMToPointerNode toPointer, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writePointer(address.getObject(), address.getOffset(), toPointer.executeWithTarget(value));
    }
}

