/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMIVarBitStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStoreNodeCommon;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMIVarBitStoreNode
extends LLVMStoreNodeCommon {
    static LLVMIVarBitStoreNode create() {
        return LLVMIVarBitStoreNodeGen.create(null, null);
    }

    protected abstract void executeManaged(LLVMManagedPointer var1, LLVMIVarBit var2);

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected void doOp(LLVMNativePointer addr, LLVMIVarBit value) {
        this.getLLVMMemoryCached().putIVarBit(addr, value);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected void doOpDerefHandle(LLVMNativePointer addr, LLVMIVarBit value, @Cached LLVMIVarBitStoreNode store) {
        store.executeManaged(this.getDerefHandleGetReceiverNode().execute(addr), value);
    }

    @Specialization(limit="3")
    protected void doOpManaged(LLVMManagedPointer address, LLVMIVarBit value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        byte[] bytes = value.getBytes();
        long curOffset = address.getOffset();
        for (int i = bytes.length - 1; i >= 0; --i) {
            nativeWrite.writeI8(address.getObject(), curOffset, bytes[i]);
            ++curOffset;
        }
    }
}

