/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStoreNodeCommon;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMI64StoreNode
extends LLVMStoreNodeCommon {
    @Specialization(guards={"!isAutoDerefHandle(address)"})
    protected void doOp(LLVMNativePointer address, long value) {
        this.getLLVMMemoryCached().putI64(address, value);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected void doOpDerefHandleI64(LLVMNativePointer addr, long value, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        this.doOpManagedI64(this.getDerefHandleGetReceiverNode().execute(addr), value, nativeWrite);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"}, replaces={"doOpDerefHandleI64"})
    protected void doOpDerefHandle(LLVMNativePointer addr, Object value, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        this.doOpManaged(this.getDerefHandleGetReceiverNode().execute(addr), value, nativeWrite);
    }

    @Specialization(guards={"!isAutoDerefHandle(address)"})
    protected void doOpNative(LLVMNativePointer address, LLVMNativePointer value) {
        this.getLLVMMemoryCached().putI64(address, value.asNative());
    }

    @Specialization(replaces={"doOpNative"}, guards={"!isAutoDerefHandle(addr)"})
    protected void doOp(LLVMNativePointer addr, Object value, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toAddress) {
        this.getLLVMMemoryCached().putI64(addr, toAddress.executeWithTarget(value).asNative());
    }

    @Specialization(limit="3")
    protected void doOpManagedI64(LLVMManagedPointer address, long value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writeI64(address.getObject(), address.getOffset(), value);
    }

    @Specialization(limit="3", replaces={"doOpManagedI64"})
    protected void doOpManaged(LLVMManagedPointer address, Object value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writeGenericI64(address.getObject(), address.getOffset(), value);
    }
}

